/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input;

import com.jme3.input.InputManager;
import com.jme3.input.Joystick;
import com.jme3.input.JoystickButton;
import com.jme3.input.controls.JoyButtonTrigger;

public class DefaultJoystickButton
implements JoystickButton {
    private InputManager inputManager;
    private Joystick parent;
    private int buttonIndex;
    private String name;
    private String logicalId;

    public DefaultJoystickButton(InputManager inputManager, Joystick parent, int buttonIndex, String name, String logicalId) {
        this.inputManager = inputManager;
        this.parent = parent;
        this.buttonIndex = buttonIndex;
        this.name = name;
        this.logicalId = logicalId;
    }

    @Override
    public void assignButton(String mappingName) {
        this.inputManager.addMapping(mappingName, new JoyButtonTrigger(this.parent.getJoyId(), this.buttonIndex));
    }

    @Override
    public Joystick getJoystick() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLogicalId() {
        return this.logicalId;
    }

    @Override
    public int getButtonId() {
        return this.buttonIndex;
    }

    public String toString() {
        return "JoystickButton[name=" + this.getName() + ", parent=" + this.parent.getName() + ", id=" + this.getButtonId() + ", logicalId=" + this.getLogicalId() + "]";
    }
}

