/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.font;

import com.jme3.font.BitmapFont;
import com.jme3.font.ColorTags;
import com.jme3.font.LetterQuad;
import com.jme3.font.StringBlock;
import com.jme3.math.ColorRGBA;
import java.util.LinkedList;

class Letters {
    private final LetterQuad head;
    private final LetterQuad tail;
    private final BitmapFont font;
    private LetterQuad current;
    private StringBlock block;
    private float totalWidth;
    private float totalHeight;
    private ColorTags colorTags = new ColorTags();
    private ColorRGBA baseColor = null;
    private float baseAlpha = -1.0f;
    private String plainText;

    Letters(BitmapFont font, StringBlock bound, boolean rightToLeft) {
        String text = bound.getText();
        this.block = bound;
        this.font = font;
        this.head = new LetterQuad(font, rightToLeft);
        this.tail = new LetterQuad(font, rightToLeft);
        this.setText(text);
    }

    void setText(String text) {
        LinkedList<ColorTags.Range> ranges;
        int i;
        this.colorTags.setText(text);
        this.plainText = this.colorTags.getPlainText();
        this.head.setNext(this.tail);
        this.tail.setPrevious(this.head);
        this.current = this.head;
        if (text != null && this.plainText.length() > 0) {
            LetterQuad l = this.head;
            for (i = 0; i < this.plainText.length(); ++i) {
                l = l.addNextCharacter(this.plainText.charAt(i));
                if (this.baseColor == null) continue;
                l.setColor(this.baseColor);
            }
        }
        if (!(ranges = this.colorTags.getTags()).isEmpty()) {
            for (i = 0; i < ranges.size() - 1; ++i) {
                ColorTags.Range start = ranges.get(i);
                ColorTags.Range end = ranges.get(i + 1);
                this.setColor(start.start, end.start, start.color);
            }
            ColorTags.Range end = ranges.getLast();
            this.setColor(end.start, this.plainText.length(), end.color);
        }
        this.invalidate();
    }

    LetterQuad getHead() {
        return this.head;
    }

    LetterQuad getTail() {
        return this.tail;
    }

    /*
     * Unable to fully structure code
     */
    void update() {
        l = this.head;
        lineCount = 1;
        ellipsis = this.font.getCharSet().getCharacter(this.block.getEllipsisChar());
        v0 = ellipsisWidth = ellipsis != null ? (float)ellipsis.getWidth() * this.getScale() : 0.0f;
        while (!l.isTail()) {
            block17: {
                block16: {
                    if (!l.isInvalid()) break block16;
                    l.update(this.block);
                    if (!l.isInvalid(this.block)) break block17;
                    switch (1.$SwitchMap$com$jme3$font$LineWrapMode[this.block.getLineWrapMode().ordinal()]) {
                        case 1: {
                            this.lineWrap(l);
                            ++lineCount;
                            ** break;
                        }
                        case 2: {
                            if (l.isBlank()) ** break;
                            blank = l;
                            while (!blank.isBlank()) {
                                if (blank.isLineStart() || blank.isHead()) {
                                    this.lineWrap(l);
                                    ++lineCount;
                                    blank = null;
                                    break;
                                }
                                blank = blank.getPrevious();
                            }
                            if (blank != null) {
                                blank.setEndOfLine();
                                ++lineCount;
                                while (blank != l) {
                                    blank = blank.getNext();
                                    blank.invalidate();
                                    blank.update(this.block);
                                }
                            }
                            break block17;
                        }
                        case 3: {
                            cursor = l.getPrevious();
                            while (cursor.isInvalid(this.block, ellipsisWidth) && !cursor.isLineStart()) {
                                cursor = cursor.getPrevious();
                            }
                            cursor.setBitmapChar(ellipsis);
                            cursor.update(this.block);
                            cursor = cursor.getNext();
                            while (!cursor.isTail() && !cursor.isLineFeed()) {
                                cursor.setBitmapChar(null);
                                cursor.update(this.block);
                                cursor = cursor.getNext();
                            }
                            ** break;
                        }
                        case 4: {
                            l.clip(this.block);
                            q = l.getNext();
                            while (!q.isTail() && !q.isLineFeed()) {
                                q.setBitmapChar(null);
                                q.update(this.block);
                                q = q.getNext();
                            }
                            ** break;
                        }
                    }
lbl58:
                    // 5 sources

                    break block17;
                }
                if (this.current.isInvalid(this.block)) {
                    this.invalidate(this.current);
                }
            }
            if (l.isEndOfLine()) {
                ++lineCount;
            }
            l = l.getNext();
        }
        this.align();
        this.block.setLineCount(lineCount);
        this.rewind();
    }

    private void align() {
        BitmapFont.Align alignment = this.block.getAlignment();
        BitmapFont.VAlign valignment = this.block.getVerticalAlignment();
        if (this.block.getTextBox() == null || alignment == BitmapFont.Align.Left && valignment == BitmapFont.VAlign.Top) {
            return;
        }
        LetterQuad cursor = this.tail.getPrevious();
        cursor.setEndOfLine();
        float width = this.block.getTextBox().width;
        float height = this.block.getTextBox().height;
        float lineWidth = 0.0f;
        float gapX = 0.0f;
        float gapY = 0.0f;
        this.validateSize();
        if (this.totalHeight < height) {
            switch (valignment) {
                case Top: {
                    gapY = 0.0f;
                    break;
                }
                case Center: {
                    gapY = (height - this.totalHeight) * 0.5f;
                    break;
                }
                case Bottom: {
                    gapY = height - this.totalHeight;
                }
            }
        }
        while (!cursor.isHead()) {
            if (cursor.isEndOfLine()) {
                lineWidth = cursor.getX1() - this.block.getTextBox().x;
                gapX = alignment == BitmapFont.Align.Center ? (width - lineWidth) / 2.0f : (alignment == BitmapFont.Align.Right ? width - lineWidth : 0.0f);
            }
            cursor.setAlignment(gapX, gapY);
            cursor = cursor.getPrevious();
        }
    }

    private void lineWrap(LetterQuad l) {
        if (l.isHead() || l.isBlank()) {
            return;
        }
        l.getPrevious().setEndOfLine();
        l.invalidate();
        l.update(this.block);
    }

    float getCharacterX0() {
        return this.current.getX0();
    }

    float getCharacterY0() {
        return this.current.getY0();
    }

    float getCharacterX1() {
        return this.current.getX1();
    }

    float getCharacterY1() {
        return this.current.getY1();
    }

    float getCharacterAlignX() {
        return this.current.getAlignX();
    }

    float getCharacterAlignY() {
        return this.current.getAlignY();
    }

    float getCharacterWidth() {
        return this.current.getWidth();
    }

    float getCharacterHeight() {
        return this.current.getHeight();
    }

    public boolean nextCharacter() {
        if (this.current.isTail()) {
            return false;
        }
        this.current = this.current.getNext();
        return true;
    }

    public int getCharacterSetPage() {
        return this.current.getBitmapChar().getPage();
    }

    public LetterQuad getQuad() {
        return this.current;
    }

    public void rewind() {
        this.current = this.head;
    }

    public void invalidate() {
        this.invalidate(this.head);
    }

    public void invalidate(LetterQuad cursor) {
        this.totalWidth = -1.0f;
        this.totalHeight = -1.0f;
        while (!cursor.isTail() && !cursor.isInvalid()) {
            cursor.invalidate();
            cursor = cursor.getNext();
        }
    }

    float getScale() {
        return this.block.getSize() / (float)this.font.getCharSet().getRenderedSize();
    }

    public boolean isPrintable() {
        return this.current.getBitmapChar() != null;
    }

    float getTotalWidth() {
        this.validateSize();
        return this.totalWidth;
    }

    float getTotalHeight() {
        this.validateSize();
        return this.totalHeight;
    }

    void validateSize() {
        if (this.totalWidth < 0.0f) {
            LetterQuad l = this.head;
            while (!l.isTail()) {
                this.totalWidth = Math.max(this.totalWidth, l.getX1());
                l = l.getNext();
                this.totalHeight = Math.max(this.totalHeight, -l.getY1());
            }
        }
    }

    void setStyle(int start, int end, int style) {
        LetterQuad cursor = this.head.getNext();
        while (!cursor.isTail()) {
            if (cursor.getIndex() >= start && cursor.getIndex() < end) {
                cursor.setStyle(style);
            }
            cursor = cursor.getNext();
        }
    }

    void setColor(ColorRGBA color) {
        this.baseColor = color;
        this.colorTags.setBaseColor(color);
        this.setColor(0, this.block.getText().length(), color);
    }

    ColorRGBA getBaseColor() {
        return this.baseColor;
    }

    void setColor(int start, int end, ColorRGBA color) {
        LetterQuad cursor = this.head.getNext();
        while (!cursor.isTail()) {
            if (cursor.getIndex() >= start && cursor.getIndex() < end) {
                cursor.setColor(color);
            }
            cursor = cursor.getNext();
        }
    }

    float getBaseAlpha() {
        return this.baseAlpha;
    }

    void setBaseAlpha(float alpha) {
        LinkedList<ColorTags.Range> ranges;
        this.baseAlpha = alpha;
        this.colorTags.setBaseAlpha(alpha);
        if (alpha == -1.0f) {
            alpha = this.baseColor != null ? this.baseColor.a : 1.0f;
        }
        LetterQuad cursor = this.head.getNext();
        while (!cursor.isTail()) {
            cursor.setAlpha(alpha);
            cursor = cursor.getNext();
        }
        if (this.baseAlpha == -1.0f && !(ranges = this.colorTags.getTags()).isEmpty()) {
            for (int i = 0; i < ranges.size() - 1; ++i) {
                ColorTags.Range start = ranges.get(i);
                ColorTags.Range end = ranges.get(i + 1);
                this.setColor(start.start, end.start, start.color);
            }
            ColorTags.Range end = ranges.getLast();
            this.setColor(end.start, this.plainText.length(), end.color);
        }
        this.invalidate();
    }
}

