/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.effect;

import com.jme3.effect.Particle;
import com.jme3.effect.ParticleEmitter;
import com.jme3.effect.ParticleMesh;
import com.jme3.math.Matrix3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public class ParticlePointMesh
extends ParticleMesh {
    private ParticleEmitter emitter;
    private int imagesX = 1;
    private int imagesY = 1;

    @Override
    public void setImagesXY(int imagesX, int imagesY) {
        this.imagesX = imagesX;
        this.imagesY = imagesY;
    }

    @Override
    public void initParticleData(ParticleEmitter emitter, int numParticles) {
        this.setMode(Mesh.Mode.Points);
        this.emitter = emitter;
        FloatBuffer pb = BufferUtils.createVector3Buffer(numParticles);
        VertexBuffer buf = this.getBuffer(VertexBuffer.Type.Position);
        if (buf != null) {
            buf.updateData(pb);
        } else {
            VertexBuffer pvb = new VertexBuffer(VertexBuffer.Type.Position);
            pvb.setupData(VertexBuffer.Usage.Stream, 3, VertexBuffer.Format.Float, pb);
            this.setBuffer(pvb);
        }
        ByteBuffer cb = BufferUtils.createByteBuffer(numParticles * 4);
        buf = this.getBuffer(VertexBuffer.Type.Color);
        if (buf != null) {
            buf.updateData(cb);
        } else {
            VertexBuffer cvb = new VertexBuffer(VertexBuffer.Type.Color);
            cvb.setupData(VertexBuffer.Usage.Stream, 4, VertexBuffer.Format.UnsignedByte, cb);
            cvb.setNormalized(true);
            this.setBuffer(cvb);
        }
        FloatBuffer sb = BufferUtils.createFloatBuffer(numParticles);
        buf = this.getBuffer(VertexBuffer.Type.Size);
        if (buf != null) {
            buf.updateData(sb);
        } else {
            VertexBuffer svb = new VertexBuffer(VertexBuffer.Type.Size);
            svb.setupData(VertexBuffer.Usage.Stream, 1, VertexBuffer.Format.Float, sb);
            this.setBuffer(svb);
        }
        FloatBuffer tb = BufferUtils.createFloatBuffer(numParticles * 4);
        buf = this.getBuffer(VertexBuffer.Type.TexCoord);
        if (buf != null) {
            buf.updateData(tb);
        } else {
            VertexBuffer tvb = new VertexBuffer(VertexBuffer.Type.TexCoord);
            tvb.setupData(VertexBuffer.Usage.Stream, 4, VertexBuffer.Format.Float, tb);
            this.setBuffer(tvb);
        }
        this.updateCounts();
    }

    @Override
    public void updateParticleData(Particle[] particles, Camera cam, Matrix3f inverseRotation) {
        VertexBuffer pvb = this.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer positions = (FloatBuffer)pvb.getData();
        VertexBuffer cvb = this.getBuffer(VertexBuffer.Type.Color);
        ByteBuffer colors = (ByteBuffer)cvb.getData();
        VertexBuffer svb = this.getBuffer(VertexBuffer.Type.Size);
        FloatBuffer sizes = (FloatBuffer)svb.getData();
        VertexBuffer tvb = this.getBuffer(VertexBuffer.Type.TexCoord);
        FloatBuffer texcoords = (FloatBuffer)tvb.getData();
        float sizeScale = this.emitter.getWorldScale().x;
        positions.rewind();
        colors.rewind();
        sizes.rewind();
        texcoords.rewind();
        for (int i = 0; i < particles.length; ++i) {
            Particle p = particles[i];
            positions.put(p.position.x).put(p.position.y).put(p.position.z);
            sizes.put(p.size * sizeScale);
            colors.putInt(p.color.asIntABGR());
            int imgX = p.imageIndex % this.imagesX;
            int imgY = p.imageIndex / this.imagesX;
            float startX = (float)imgX / (float)this.imagesX;
            float startY = (float)imgY / (float)this.imagesY;
            float endX = startX + 1.0f / (float)this.imagesX;
            float endY = startY + 1.0f / (float)this.imagesY;
            texcoords.put(startX).put(startY).put(endX).put(endY);
        }
        positions.flip();
        colors.flip();
        sizes.flip();
        texcoords.flip();
        pvb.updateData(positions);
        cvb.updateData(colors);
        svb.updateData(sizes);
        tvb.updateData(texcoords);
    }
}

