/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.audio.openal;

import com.jme3.audio.openal.AL;

public final class ALUtil {
    private ALUtil() {
    }

    public static String getALErrorMessage(int errorCode) {
        String errorText;
        switch (errorCode) {
            case 0: {
                errorText = "No Error";
                break;
            }
            case 40961: {
                errorText = "Invalid Name";
                break;
            }
            case 40962: {
                errorText = "Invalid Enum";
                break;
            }
            case 40963: {
                errorText = "Invalid Value";
                break;
            }
            case 40964: {
                errorText = "Invalid Operation";
                break;
            }
            case 40965: {
                errorText = "Out of Memory";
                break;
            }
            default: {
                errorText = "Unknown Error Code: " + String.valueOf(errorCode);
            }
        }
        return errorText;
    }

    public static void checkALError(AL al) {
        int err = al.alGetError();
        if (err != 0) {
            throw new RuntimeException("OpenAL Error: " + ALUtil.getALErrorMessage(err));
        }
    }
}

