/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.audio;

import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetProcessor;
import com.jme3.asset.cache.AssetCache;
import com.jme3.asset.cache.WeakRefAssetCache;
import com.jme3.audio.AudioData;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import java.io.IOException;

public class AudioKey
extends AssetKey<AudioData> {
    private boolean stream;
    private boolean streamCache;

    public AudioKey(String name, boolean stream, boolean streamCache) {
        this(name, stream);
        this.streamCache = streamCache;
    }

    public AudioKey(String name, boolean stream) {
        super(name);
        this.stream = stream;
    }

    public AudioKey(String name) {
        super(name);
        this.stream = false;
    }

    public AudioKey() {
    }

    @Override
    public String toString() {
        return this.name + (this.stream ? (this.streamCache ? " (Stream/Cache)" : " (Stream)") : " (Buffer)");
    }

    public boolean isStream() {
        return this.stream;
    }

    public boolean useStreamCache() {
        return this.streamCache;
    }

    @Override
    public Class<? extends AssetCache> getCacheType() {
        if (this.stream && this.streamCache || !this.stream) {
            return WeakRefAssetCache.class;
        }
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AudioKey other = (AudioKey)obj;
        if (!super.equals(other)) {
            return false;
        }
        if (this.stream != other.stream) {
            return false;
        }
        return this.streamCache == other.streamCache;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + super.hashCode();
        hash = 67 * hash + (this.stream ? 1 : 0);
        hash = 67 * hash + (this.streamCache ? 1 : 0);
        return hash;
    }

    @Override
    public Class<? extends AssetProcessor> getProcessorType() {
        return null;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.stream, "do_stream", false);
        oc.write(this.streamCache, "use_stream_cache", false);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.stream = ic.readBoolean("do_stream", false);
        this.streamCache = ic.readBoolean("use_stream_cache", false);
    }
}

