/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app;

import com.jme3.app.Application;
import com.jme3.app.BasicProfiler;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.input.InputManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.VertexBuffer;

public class BasicProfilerState
extends BaseAppState {
    public static final String INPUT_MAPPING_PROFILER_TOGGLE = "BasicProfilerState_Toggle";
    private BasicProfiler profiler;
    private Geometry graph;
    private Geometry background;
    private float scale = 2.0f;
    private final ProfilerKeyListener keyListener = new ProfilerKeyListener();

    public BasicProfilerState() {
        this(false);
    }

    public BasicProfilerState(boolean enabled) {
        this.setEnabled(enabled);
        this.profiler = new BasicProfiler();
    }

    public void toggleProfiler() {
        this.setEnabled(!this.isEnabled());
    }

    public BasicProfiler getProfiler() {
        return this.profiler;
    }

    public void setGraphScale(float scale) {
        if (this.scale == scale) {
            return;
        }
        this.scale = scale;
        if (this.graph != null) {
            this.graph.setLocalScale(1.0f, scale, 1.0f);
        }
    }

    public float getGraphScale() {
        return this.scale;
    }

    public void setFrameCount(int count) {
        if (this.profiler.getFrameCount() == count) {
            return;
        }
        this.profiler.setFrameCount(count);
        this.refreshBackground();
    }

    public int getFrameCount() {
        return this.profiler.getFrameCount();
    }

    protected void refreshBackground() {
        Mesh mesh = this.background.getMesh();
        int size = this.profiler.getFrameCount();
        float frameTime = 16.666666f;
        mesh.setBuffer(VertexBuffer.Type.Position, 3, new float[]{0.0f, 0.0f, 0.0f, size, 0.0f, 0.0f, size, frameTime, 0.0f, 0.0f, frameTime, 0.0f, 0.0f, frameTime, 0.0f, size, frameTime, 0.0f, size, frameTime * 2.0f, 0.0f, 0.0f, frameTime * 2.0f, 0.0f, 0.0f, -2.0f, 0.0f, size, -2.0f, 0.0f, size, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f});
        mesh.setBuffer(VertexBuffer.Type.Color, 4, new float[]{0.0f, 1.0f, 0.0f, 0.25f, 0.0f, 1.0f, 0.0f, 0.25f, 0.0f, 0.25f, 0.0f, 0.25f, 0.0f, 0.25f, 0.0f, 0.25f, 0.25f, 0.0f, 0.0f, 0.25f, 0.25f, 0.0f, 0.0f, 0.25f, 1.0f, 0.0f, 0.0f, 0.25f, 1.0f, 0.0f, 0.0f, 0.25f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.5f});
        mesh.setBuffer(VertexBuffer.Type.Index, 3, new short[]{0, 1, 2, 0, 2, 3, 4, 5, 6, 4, 6, 7, 8, 9, 10, 8, 10, 11});
    }

    @Override
    protected void initialize(Application app) {
        this.graph = new Geometry("profiler", this.profiler.getMesh());
        Material mat = new Material(app.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setBoolean("VertexColor", true);
        this.graph.setMaterial(mat);
        this.graph.setLocalTranslation(0.0f, 300.0f, 0.0f);
        this.graph.setLocalScale(1.0f, this.scale, 1.0f);
        Mesh mesh = new Mesh();
        this.background = new Geometry("profiler.background", mesh);
        mat = new Material(app.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setBoolean("VertexColor", true);
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.background.setMaterial(mat);
        this.background.setLocalTranslation(0.0f, 300.0f, -1.0f);
        this.background.setLocalScale(1.0f, this.scale, 1.0f);
        this.refreshBackground();
        InputManager inputManager = app.getInputManager();
        if (inputManager != null) {
            inputManager.addMapping(INPUT_MAPPING_PROFILER_TOGGLE, new KeyTrigger(64));
            inputManager.addListener(this.keyListener, INPUT_MAPPING_PROFILER_TOGGLE);
        }
    }

    @Override
    protected void cleanup(Application app) {
        InputManager inputManager = app.getInputManager();
        if (inputManager.hasMapping(INPUT_MAPPING_PROFILER_TOGGLE)) {
            inputManager.deleteMapping(INPUT_MAPPING_PROFILER_TOGGLE);
        }
        inputManager.removeListener(this.keyListener);
    }

    @Override
    protected void onEnable() {
        this.setFrameCount(this.getApplication().getCamera().getWidth());
        this.getApplication().setAppProfiler(this.profiler);
        Node gui = ((SimpleApplication)this.getApplication()).getGuiNode();
        gui.attachChild(this.graph);
        gui.attachChild(this.background);
    }

    @Override
    protected void onDisable() {
        this.getApplication().setAppProfiler(null);
        this.graph.removeFromParent();
        this.background.removeFromParent();
    }

    private class ProfilerKeyListener
    implements ActionListener {
        private ProfilerKeyListener() {
        }

        @Override
        public void onAction(String name, boolean value, float tpf) {
            if (!value) {
                return;
            }
            BasicProfilerState.this.toggleProfiler();
        }
    }
}

