/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app;

import com.jme3.profile.AppProfiler;
import com.jme3.profile.AppStep;
import com.jme3.profile.SpStep;
import com.jme3.profile.VpStep;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;

public class BasicProfiler
implements AppProfiler {
    private int size;
    private int frameIndex = 0;
    private long[] frames;
    private long startTime;
    private long renderTime;
    private long previousFrame;
    private long updateInterval = 1000000L;
    private long lastUpdate = 0L;
    private Mesh mesh;

    public BasicProfiler() {
        this(1280);
    }

    public BasicProfiler(int size) {
        this.setFrameCount(size);
    }

    public final void setFrameCount(int size) {
        if (this.size == size) {
            return;
        }
        this.size = size;
        this.frames = new long[size * 2];
        this.createMesh();
        if (this.frameIndex >= size) {
            this.frameIndex = 0;
        }
    }

    public int getFrameCount() {
        return this.size;
    }

    public void setUpdateInterval(long nanos) {
        this.updateInterval = nanos;
    }

    public long getUpdateInterval() {
        return this.updateInterval;
    }

    public Mesh getMesh() {
        return this.mesh;
    }

    protected final void createMesh() {
        if (this.mesh == null) {
            this.mesh = new Mesh();
            this.mesh.setMode(Mesh.Mode.Lines);
        }
        this.mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer(this.size * 4 * 3));
        FloatBuffer cb = BufferUtils.createFloatBuffer(this.size * 4 * 4);
        for (int i = 0; i < this.size; ++i) {
            cb.put(0.5f).put(0.5f).put(0.0f).put(1.0f);
            cb.put(1.0f).put(1.0f).put(0.0f).put(1.0f);
            cb.put(0.0f).put(0.5f).put(0.5f).put(1.0f);
            cb.put(0.0f).put(1.0f).put(1.0f).put(1.0f);
        }
        this.mesh.setBuffer(VertexBuffer.Type.Color, 4, cb);
    }

    protected void updateMesh() {
        FloatBuffer pb = (FloatBuffer)this.mesh.getBuffer(VertexBuffer.Type.Position).getData();
        pb.rewind();
        float scale = 1.0E-6f;
        for (int i = 0; i < this.size; ++i) {
            float t1 = (float)this.frames[i * 2] * scale;
            float t2 = (float)this.frames[i * 2 + 1] * scale;
            pb.put(i).put(0.0f).put(0.0f);
            pb.put(i).put(t1).put(0.0f);
            pb.put(i).put(t1).put(0.0f);
            pb.put(i).put(t2).put(0.0f);
        }
        this.mesh.setBuffer(VertexBuffer.Type.Position, 3, pb);
    }

    @Override
    public void appStep(AppStep step) {
        switch (step) {
            case BeginFrame: {
                this.startTime = System.nanoTime();
                break;
            }
            case RenderFrame: {
                this.renderTime = System.nanoTime();
                this.frames[this.frameIndex * 2] = this.renderTime - this.startTime;
                break;
            }
            case EndFrame: {
                long time = System.nanoTime();
                this.frames[this.frameIndex * 2 + 1] = time - this.renderTime;
                this.previousFrame = this.startTime;
                ++this.frameIndex;
                if (this.frameIndex >= this.size) {
                    this.frameIndex = 0;
                }
                if (this.startTime - this.lastUpdate <= this.updateInterval) break;
                this.updateMesh();
                this.lastUpdate = this.startTime;
            }
        }
    }

    @Override
    public void vpStep(VpStep step, ViewPort vp, RenderQueue.Bucket bucket) {
    }

    @Override
    public void spStep(SpStep step, String ... additionalInfo) {
    }
}

