/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.animation;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimEventListener;
import com.jme3.animation.Animation;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SkeletonControl;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import com.jme3.util.TempVars;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class AnimControl
extends AbstractControl
implements Cloneable,
JmeCloneable {
    Skeleton skeleton;
    @Deprecated
    private SkeletonControl skeletonControl;
    HashMap<String, Animation> animationMap = new HashMap();
    private transient ArrayList<AnimChannel> channels = new ArrayList();
    private transient ArrayList<AnimEventListener> listeners = new ArrayList();

    public AnimControl(Skeleton skeleton) {
        this.skeleton = skeleton;
        this.reset();
    }

    public AnimControl() {
    }

    @Override
    public Control cloneForSpatial(Spatial spatial) {
        try {
            AnimControl clone = (AnimControl)super.clone();
            clone.spatial = spatial;
            clone.channels = new ArrayList();
            clone.listeners = new ArrayList();
            if (this.skeleton != null) {
                clone.skeleton = new Skeleton(this.skeleton);
            }
            for (Map.Entry<String, Animation> animEntry : this.animationMap.entrySet()) {
                clone.animationMap.put(animEntry.getKey(), animEntry.getValue().cloneForSpatial(spatial));
            }
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    @Override
    public Object jmeClone() {
        AnimControl clone = (AnimControl)super.jmeClone();
        clone.channels = new ArrayList();
        clone.listeners = new ArrayList();
        return clone;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.skeleton = cloner.clone(this.skeleton);
        HashMap<String, Animation> newMap = new HashMap<String, Animation>();
        for (Map.Entry<String, Animation> e : this.animationMap.entrySet()) {
            newMap.put(e.getKey(), cloner.clone(e.getValue()));
        }
        this.animationMap = newMap;
    }

    public void setAnimations(HashMap<String, Animation> animations) {
        this.animationMap = animations;
    }

    public Animation getAnim(String name) {
        return this.animationMap.get(name);
    }

    public void addAnim(Animation anim) {
        this.animationMap.put(anim.getName(), anim);
    }

    public void removeAnim(Animation anim) {
        if (!this.animationMap.containsKey(anim.getName())) {
            throw new IllegalArgumentException("Given animation does not exist in this AnimControl");
        }
        this.animationMap.remove(anim.getName());
    }

    public AnimChannel createChannel() {
        AnimChannel channel = new AnimChannel(this);
        this.channels.add(channel);
        return channel;
    }

    public AnimChannel getChannel(int index) {
        return this.channels.get(index);
    }

    public int getNumChannels() {
        return this.channels.size();
    }

    public void clearChannels() {
        for (AnimChannel animChannel : this.channels) {
            for (AnimEventListener list : this.listeners) {
                list.onAnimCycleDone(this, animChannel, animChannel.getAnimationName());
            }
        }
        this.channels.clear();
    }

    public Skeleton getSkeleton() {
        return this.skeleton;
    }

    public void addListener(AnimEventListener listener) {
        if (this.listeners.contains(listener)) {
            throw new IllegalArgumentException("The given listener is already registed at this AnimControl");
        }
        this.listeners.add(listener);
    }

    public void removeListener(AnimEventListener listener) {
        if (!this.listeners.remove(listener)) {
            throw new IllegalArgumentException("The given listener is not registed at this AnimControl");
        }
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    void notifyAnimChange(AnimChannel channel, String name) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onAnimChange(this, channel, name);
        }
    }

    void notifyAnimCycleDone(AnimChannel channel, String name) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onAnimCycleDone(this, channel, name);
        }
    }

    @Override
    public void setSpatial(Spatial spatial) {
        if (spatial == null && this.skeletonControl != null) {
            this.spatial.removeControl(this.skeletonControl);
        }
        super.setSpatial(spatial);
        if (spatial != null && this.skeletonControl != null) {
            spatial.addControl(this.skeletonControl);
        }
    }

    final void reset() {
        if (this.skeleton != null) {
            this.skeleton.resetAndUpdate();
        }
    }

    public Collection<String> getAnimationNames() {
        return this.animationMap.keySet();
    }

    public float getAnimationLength(String name) {
        Animation a = this.animationMap.get(name);
        if (a == null) {
            throw new IllegalArgumentException("The animation " + name + " does not exist in this AnimControl");
        }
        return a.getLength();
    }

    @Override
    protected void controlUpdate(float tpf) {
        if (this.skeleton != null) {
            this.skeleton.reset();
        }
        TempVars vars = TempVars.get();
        for (int i = 0; i < this.channels.size(); ++i) {
            this.channels.get(i).update(tpf, vars);
        }
        vars.release();
        if (this.skeleton != null) {
            this.skeleton.updateWorldVectors();
        }
    }

    @Override
    protected void controlRender(RenderManager rm, ViewPort vp) {
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.skeleton, "skeleton", null);
        oc.writeStringSavableMap(this.animationMap, "animations", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        Savable[] sav;
        super.read(im);
        InputCapsule in = im.getCapsule(this);
        this.skeleton = (Skeleton)in.readSavable("skeleton", null);
        HashMap loadedAnimationMap = (HashMap)in.readStringSavableMap("animations", null);
        if (loadedAnimationMap != null) {
            this.animationMap = loadedAnimationMap;
        }
        if (im.getFormatVersion() == 0 && (sav = in.readSavableArray("targets", null)) != null) {
            this.skeletonControl = new SkeletonControl(this.skeleton);
            this.spatial.addControl(this.skeletonControl);
        }
    }
}

