/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures.generating;

import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.scene.plugins.blender.textures.generating.NoiseGenerator;
import com.jme3.scene.plugins.blender.textures.generating.TextureGeneratorWood;

public class TextureGeneratorMarble
extends TextureGeneratorWood {
    protected static final int TEX_SOFT = 0;
    protected static final int TEX_SHARP = 1;
    protected static final int TEX_SHARPER = 2;
    protected MarbleData marbleData;
    protected int noisebasis;
    protected NoiseGenerator.NoiseFunction noiseFunction;

    public TextureGeneratorMarble(NoiseGenerator noiseGenerator) {
        super(noiseGenerator);
    }

    @Override
    public void readData(Structure tex, BlenderContext blenderContext) {
        super.readData(tex, blenderContext);
        this.marbleData = new MarbleData(tex);
        this.noisebasis = this.marbleData.noisebasis;
        this.noiseFunction = NoiseGenerator.noiseFunctions.get(this.noisebasis);
        if (this.noiseFunction == null) {
            this.noiseFunction = NoiseGenerator.noiseFunctions.get(0);
            this.noisebasis = 0;
        }
    }

    @Override
    public void getPixel(TexturePixel pixel, float x, float y, float z) {
        pixel.intensity = this.marbleInt(this.marbleData, x, y, z);
        if (this.colorBand != null) {
            int colorbandIndex = (int)(pixel.intensity * 1000.0f);
            pixel.red = this.colorBand[colorbandIndex][0];
            pixel.green = this.colorBand[colorbandIndex][1];
            pixel.blue = this.colorBand[colorbandIndex][2];
            this.applyBrightnessAndContrast(this.bacd, pixel);
            pixel.alpha = this.colorBand[colorbandIndex][3];
        } else {
            this.applyBrightnessAndContrast(pixel, this.bacd.contrast, this.bacd.brightness);
        }
    }

    public float marbleInt(MarbleData marbleData, float x, float y, float z) {
        int waveform = marbleData.waveform > 2 || marbleData.waveform < 0 ? 0 : marbleData.waveform;
        float n = 5.0f * (x + y + z);
        if (this.noisebasis == 0) {
            x += 1.0f;
            y += 1.0f;
            z += 1.0f;
        }
        float mi = n + marbleData.turbul * NoiseGenerator.NoiseFunctions.turbulence(x, y, z, marbleData.noisesize, marbleData.noisedepth, this.noiseFunction, marbleData.isHard);
        if (marbleData.stype >= 0) {
            mi = waveformFunctions[waveform].execute(mi);
            if (marbleData.stype == 1) {
                mi = (float)Math.sqrt(mi);
            } else if (marbleData.stype == 2) {
                mi = (float)Math.sqrt(Math.sqrt(mi));
            }
        }
        return mi;
    }

    private static class MarbleData {
        public final float noisesize;
        public final int noisebasis;
        public final int noisedepth;
        public final int stype;
        public final float turbul;
        public final int waveform;
        public final boolean isHard;

        public MarbleData(Structure tex) {
            this.noisesize = ((Number)tex.getFieldValue("noisesize")).floatValue();
            this.noisebasis = ((Number)tex.getFieldValue("noisebasis")).intValue();
            this.noisedepth = ((Number)tex.getFieldValue("noisedepth")).intValue();
            this.stype = ((Number)tex.getFieldValue("stype")).intValue();
            this.turbul = ((Number)tex.getFieldValue("turbul")).floatValue();
            int noisetype = ((Number)tex.getFieldValue("noisetype")).intValue();
            this.waveform = ((Number)tex.getFieldValue("noisebasis2")).intValue();
            this.isHard = noisetype != 0;
        }
    }
}

