/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.blender.textures.DDSTexelData;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.scene.plugins.blender.textures.io.PixelIOFactory;
import com.jme3.scene.plugins.blender.textures.io.PixelInputOutput;
import com.jme3.texture.Image;
import com.jme3.util.BufferUtils;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import jme3tools.converters.ImageToAwt;
import jme3tools.converters.RGB565;

public final class ImageUtils {
    public static Image createEmptyImage(Image.Format format, int width, int height, int depth) {
        int bufferSize = width * height * (format.getBitsPerPixel() >> 3);
        if (depth < 2) {
            return new Image(format, width, height, BufferUtils.createByteBuffer((int)bufferSize), com.jme3.texture.image.ColorSpace.Linear);
        }
        ArrayList<ByteBuffer> data = new ArrayList<ByteBuffer>(depth);
        for (int i = 0; i < depth; ++i) {
            data.add(BufferUtils.createByteBuffer((int)bufferSize));
        }
        return new Image(Image.Format.RGB8, width, height, depth, data, com.jme3.texture.image.ColorSpace.Linear);
    }

    public static TexturePixel color(TexturePixel pixel, ColorRGBA lowIntensityColor, ColorRGBA highIntensityColor) {
        float intensity = pixel.intensity;
        pixel.fromColor(lowIntensityColor);
        pixel.mult(1.0f - pixel.intensity);
        pixel.add(highIntensityColor.mult(intensity));
        return pixel;
    }

    public static void merge(Image targetImage, Image sourceImage) {
        if (sourceImage.getDepth() != targetImage.getDepth()) {
            throw new IllegalArgumentException("The given images should have the same depth to merge them!");
        }
        if (sourceImage.getWidth() != targetImage.getWidth()) {
            throw new IllegalArgumentException("The given images should have the same width to merge them!");
        }
        if (sourceImage.getHeight() != targetImage.getHeight()) {
            throw new IllegalArgumentException("The given images should have the same height to merge them!");
        }
        PixelInputOutput sourceIO = PixelIOFactory.getPixelIO(sourceImage.getFormat());
        PixelInputOutput targetIO = PixelIOFactory.getPixelIO(targetImage.getFormat());
        TexturePixel sourcePixel = new TexturePixel();
        TexturePixel targetPixel = new TexturePixel();
        int depth = targetImage.getDepth() == 0 ? 1 : targetImage.getDepth();
        for (int layerIndex = 0; layerIndex < depth; ++layerIndex) {
            for (int x = 0; x < sourceImage.getWidth(); ++x) {
                for (int y = 0; y < sourceImage.getHeight(); ++y) {
                    sourceIO.read(sourceImage, layerIndex, sourcePixel, x, y);
                    targetIO.read(targetImage, layerIndex, targetPixel, x, y);
                    targetPixel.merge(sourcePixel);
                    targetIO.write(targetImage, layerIndex, targetPixel, x, y);
                }
            }
        }
    }

    public static void mix(Image targetImage, Image sourceImage) {
        if (sourceImage.getDepth() != targetImage.getDepth()) {
            throw new IllegalArgumentException("The given images should have the same depth to merge them!");
        }
        if (sourceImage.getWidth() != targetImage.getWidth()) {
            throw new IllegalArgumentException("The given images should have the same width to merge them!");
        }
        if (sourceImage.getHeight() != targetImage.getHeight()) {
            throw new IllegalArgumentException("The given images should have the same height to merge them!");
        }
        PixelInputOutput sourceIO = PixelIOFactory.getPixelIO(sourceImage.getFormat());
        PixelInputOutput targetIO = PixelIOFactory.getPixelIO(targetImage.getFormat());
        TexturePixel sourcePixel = new TexturePixel();
        TexturePixel targetPixel = new TexturePixel();
        int depth = targetImage.getDepth() == 0 ? 1 : targetImage.getDepth();
        for (int layerIndex = 0; layerIndex < depth; ++layerIndex) {
            for (int x = 0; x < sourceImage.getWidth(); ++x) {
                for (int y = 0; y < sourceImage.getHeight(); ++y) {
                    sourceIO.read(sourceImage, layerIndex, sourcePixel, x, y);
                    targetIO.read(targetImage, layerIndex, targetPixel, x, y);
                    targetPixel.mix(sourcePixel);
                    targetIO.write(targetImage, layerIndex, targetPixel, x, y);
                }
            }
        }
    }

    public static Image resizeTo(Image source, int width, int height) {
        BufferedImage sourceImage = ImageToAwt.convert((Image)source, (boolean)false, (boolean)false, (int)0);
        double scaleX = (double)width / (double)sourceImage.getWidth();
        double scaleY = (double)height / (double)sourceImage.getHeight();
        AffineTransform scaleTransform = AffineTransform.getScaleInstance(scaleX, scaleY);
        AffineTransformOp bilinearScaleOp = new AffineTransformOp(scaleTransform, 2);
        BufferedImage scaledImage = bilinearScaleOp.filter(sourceImage, new BufferedImage(width, height, sourceImage.getType()));
        return ImageUtils.toJmeImage(scaledImage, source.getFormat());
    }

    public static Image convertToNormalMapTexture(Image source, float strengthFactor) {
        BufferedImage sourceImage = ImageToAwt.convert((Image)source, (boolean)false, (boolean)false, (int)0);
        BufferedImage heightMap = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 2);
        BufferedImage bumpMap = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 2);
        ColorConvertOp gscale = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        gscale.filter(sourceImage, heightMap);
        Vector3f S = new Vector3f();
        Vector3f T = new Vector3f();
        Vector3f N = new Vector3f();
        for (int x = 0; x < bumpMap.getWidth(); ++x) {
            for (int y = 0; y < bumpMap.getHeight(); ++y) {
                S.x = 1.0f;
                S.y = 0.0f;
                S.z = strengthFactor * (float)ImageUtils.getHeight(heightMap, x + 1, y) - strengthFactor * (float)ImageUtils.getHeight(heightMap, x - 1, y);
                T.x = 0.0f;
                T.y = 1.0f;
                T.z = strengthFactor * (float)ImageUtils.getHeight(heightMap, x, y + 1) - strengthFactor * (float)ImageUtils.getHeight(heightMap, x, y - 1);
                float den = (float)Math.sqrt(S.z * S.z + T.z * T.z + 1.0f);
                N.x = -S.z;
                N.y = -T.z;
                N.z = 1.0f;
                N.divideLocal(den);
                bumpMap.setRGB(x, y, ImageUtils.vectorToColor(N.x, N.y, N.z));
            }
        }
        return ImageUtils.toJmeImage(bumpMap, source.getFormat());
    }

    public static Image convertToGrayscaleTexture(Image source) {
        BufferedImage sourceImage = ImageToAwt.convert((Image)source, (boolean)false, (boolean)false, (int)0);
        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        op.filter(sourceImage, sourceImage);
        return ImageUtils.toJmeImage(sourceImage, source.getFormat());
    }

    public static Image decompress(Image image) {
        Image result;
        Image.Format format = image.getFormat();
        int depth = image.getDepth();
        if (depth == 0) {
            depth = 1;
        }
        ArrayList<ByteBuffer> dataArray = new ArrayList<ByteBuffer>(depth);
        int[] sizes = image.getMipMapSizes() != null ? image.getMipMapSizes() : new int[1];
        int[] newMipmapSizes = image.getMipMapSizes() != null ? new int[image.getMipMapSizes().length] : null;
        for (int dataLayerIndex = 0; dataLayerIndex < depth; ++dataLayerIndex) {
            ByteBuffer data = image.getData(dataLayerIndex);
            data.rewind();
            if (sizes.length == 1) {
                sizes[0] = data.remaining();
            }
            float widthToHeightRatio = image.getWidth() / image.getHeight();
            ArrayList<DDSTexelData> texelDataList = new ArrayList<DDSTexelData>(sizes.length);
            int maxPosition = 0;
            int resultSize = 0;
            for (int sizeIndex = 0; sizeIndex < sizes.length; ++sizeIndex) {
                maxPosition += sizes[sizeIndex];
                DDSTexelData texelData = new DDSTexelData(sizes[sizeIndex], widthToHeightRatio, format);
                texelDataList.add(texelData);
                switch (format) {
                    case DXT1: 
                    case DXT1A: {
                        TexturePixel[] colors;
                        while (data.position() < maxPosition) {
                            colors = new TexturePixel[]{new TexturePixel(), new TexturePixel(), new TexturePixel(), new TexturePixel()};
                            short c0 = data.getShort();
                            short c1 = data.getShort();
                            int col0 = RGB565.RGB565_to_ARGB8((short)c0);
                            int col1 = RGB565.RGB565_to_ARGB8((short)c1);
                            colors[0].fromARGB8(col0);
                            colors[1].fromARGB8(col1);
                            if (col0 > col1) {
                                colors[2].fromPixel(colors[0]);
                                colors[2].mult(2.0f);
                                colors[2].add(colors[1]);
                                colors[2].divide(3.0f);
                                colors[3].fromPixel(colors[1]);
                                colors[3].mult(2.0f);
                                colors[3].add(colors[0]);
                                colors[3].divide(3.0f);
                            } else {
                                colors[2].fromPixel(colors[0]);
                                colors[2].add(colors[1]);
                                colors[2].mult(0.5f);
                                colors[3].fromARGB8(0);
                            }
                            int indexes = data.getInt();
                            texelData.add(colors, indexes);
                        }
                        break;
                    }
                    case DXT3: {
                        TexturePixel[] colors;
                        while (data.position() < maxPosition) {
                            colors = new TexturePixel[]{new TexturePixel(), new TexturePixel(), new TexturePixel(), new TexturePixel()};
                            long alpha = data.getLong();
                            float[] alphas = new float[16];
                            long alphasIndex = 0L;
                            for (int i = 0; i < 16; ++i) {
                                alphasIndex |= (long)(i << i * 4);
                                byte a = (byte)((alpha >> i * 4 & 0xFL) << 4);
                                alphas[i] = a >= 0 ? (float)a / 255.0f : 1.0f - (float)(~a) / 255.0f;
                            }
                            short c0 = data.getShort();
                            short c1 = data.getShort();
                            int col0 = RGB565.RGB565_to_ARGB8((short)c0);
                            int col1 = RGB565.RGB565_to_ARGB8((short)c1);
                            colors[0].fromARGB8(col0);
                            colors[1].fromARGB8(col1);
                            colors[2].fromPixel(colors[0]);
                            colors[2].mult(2.0f);
                            colors[2].add(colors[1]);
                            colors[2].divide(3.0f);
                            colors[3].fromPixel(colors[1]);
                            colors[3].mult(2.0f);
                            colors[3].add(colors[0]);
                            colors[3].divide(3.0f);
                            int indexes = data.getInt();
                            texelData.add(colors, indexes, alphas, alphasIndex);
                        }
                        break;
                    }
                    case DXT5: {
                        float[] alphas = new float[8];
                        while (data.position() < maxPosition) {
                            TexturePixel[] colors = new TexturePixel[]{new TexturePixel(), new TexturePixel(), new TexturePixel(), new TexturePixel()};
                            alphas[0] = (float)data.get() * 255.0f;
                            alphas[1] = (float)data.get() * 255.0f;
                            long alphaIndices = (long)data.get() | (long)data.get() << 8 | (long)data.get() << 16 | (long)data.get() << 24 | (long)data.get() << 32 | (long)data.get() << 40;
                            if (alphas[0] > alphas[1]) {
                                alphas[2] = (6.0f * alphas[0] + alphas[1]) / 7.0f;
                                alphas[3] = (5.0f * alphas[0] + 2.0f * alphas[1]) / 7.0f;
                                alphas[4] = (4.0f * alphas[0] + 3.0f * alphas[1]) / 7.0f;
                                alphas[5] = (3.0f * alphas[0] + 4.0f * alphas[1]) / 7.0f;
                                alphas[6] = (2.0f * alphas[0] + 5.0f * alphas[1]) / 7.0f;
                                alphas[7] = (alphas[0] + 6.0f * alphas[1]) / 7.0f;
                            } else {
                                alphas[2] = (4.0f * alphas[0] + alphas[1]) * 0.2f;
                                alphas[3] = (3.0f * alphas[0] + 2.0f * alphas[1]) * 0.2f;
                                alphas[4] = (2.0f * alphas[0] + 3.0f * alphas[1]) * 0.2f;
                                alphas[5] = (alphas[0] + 4.0f * alphas[1]) * 0.2f;
                                alphas[6] = 0.0f;
                                alphas[7] = 1.0f;
                            }
                            short c0 = data.getShort();
                            short c1 = data.getShort();
                            int col0 = RGB565.RGB565_to_ARGB8((short)c0);
                            int col1 = RGB565.RGB565_to_ARGB8((short)c1);
                            colors[0].fromARGB8(col0);
                            colors[1].fromARGB8(col1);
                            colors[2].fromPixel(colors[0]);
                            colors[2].mult(2.0f);
                            colors[2].add(colors[1]);
                            colors[2].divide(3.0f);
                            colors[3].fromPixel(colors[1]);
                            colors[3].mult(2.0f);
                            colors[3].add(colors[0]);
                            colors[3].divide(3.0f);
                            int indexes = data.getInt();
                            texelData.add(colors, indexes, alphas, alphaIndices);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown compressed format: " + format);
                    }
                }
                newMipmapSizes[sizeIndex] = texelData.getSizeInBytes();
                resultSize += texelData.getSizeInBytes();
            }
            byte[] bytes = new byte[resultSize];
            int offset = 0;
            byte[] pixelBytes = new byte[4];
            for (DDSTexelData texelData : texelDataList) {
                for (int i = 0; i < texelData.getPixelWidth(); ++i) {
                    for (int j = 0; j < texelData.getPixelHeight() && texelData.getRGBA8(i, j, pixelBytes); ++j) {
                        bytes[offset + (j * texelData.getPixelWidth() + i) * 4] = pixelBytes[0];
                        bytes[offset + (j * texelData.getPixelWidth() + i) * 4 + 1] = pixelBytes[1];
                        bytes[offset + (j * texelData.getPixelWidth() + i) * 4 + 2] = pixelBytes[2];
                        bytes[offset + (j * texelData.getPixelWidth() + i) * 4 + 3] = pixelBytes[3];
                    }
                }
                offset += texelData.getSizeInBytes();
            }
            dataArray.add(BufferUtils.createByteBuffer((byte[])bytes));
        }
        Image image2 = result = depth > 1 ? new Image(Image.Format.RGBA8, image.getWidth(), image.getHeight(), depth, dataArray, com.jme3.texture.image.ColorSpace.Linear) : new Image(Image.Format.RGBA8, image.getWidth(), image.getHeight(), (ByteBuffer)dataArray.get(0), com.jme3.texture.image.ColorSpace.Linear);
        if (newMipmapSizes != null) {
            result.setMipMapSizes(newMipmapSizes);
        }
        return result;
    }

    private static int getHeight(BufferedImage image, int x, int y) {
        if (x < 0) {
            x = 0;
        } else if (x >= image.getWidth()) {
            x = image.getWidth() - 1;
        }
        if (y < 0) {
            y = 0;
        } else if (y >= image.getHeight()) {
            y = image.getHeight() - 1;
        }
        return image.getRGB(x, y) & 0xFF;
    }

    private static int vectorToColor(float x, float y, float z) {
        int r = Math.round(255.0f * (x + 1.0f) / 2.0f);
        int g = Math.round(255.0f * (y + 1.0f) / 2.0f);
        int b = Math.round(255.0f * (z + 1.0f) / 2.0f);
        return -16777216 + (r << 16) + (g << 8) + b;
    }

    private static Image toJmeImage(BufferedImage bufferedImage, Image.Format format) {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)(bufferedImage.getWidth() * bufferedImage.getHeight() * 3));
        ImageToAwt.convert((BufferedImage)bufferedImage, (Image.Format)format, (ByteBuffer)byteBuffer);
        return new Image(format, bufferedImage.getWidth(), bufferedImage.getHeight(), byteBuffer, com.jme3.texture.image.ColorSpace.Linear);
    }
}

