/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.modifiers;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.scene.Node;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.AnimationHelper;
import com.jme3.scene.plugins.blender.animations.BoneContext;
import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.meshes.TemporalMesh;
import com.jme3.scene.plugins.blender.modifiers.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class ArmatureModifier
extends Modifier {
    private static final Logger LOGGER = Logger.getLogger(ArmatureModifier.class.getName());
    private static final int FLAG_VERTEX_GROUPS = 1;
    private static final int FLAG_BONE_ENVELOPES = 2;
    private Skeleton skeleton;

    public ArmatureModifier(Structure objectStructure, Structure modifierStructure, BlenderContext blenderContext) throws BlenderFileException {
        if (this.validate(modifierStructure, blenderContext)) {
            Pointer pArmatureObject = (Pointer)modifierStructure.getFieldValue("object");
            if (pArmatureObject.isNotNull()) {
                int deformflag = ((Number)modifierStructure.getFieldValue("deformflag")).intValue();
                boolean useVertexGroups = (deformflag & 1) != 0;
                boolean useBoneEnvelopes = (deformflag & 2) != 0;
                boolean bl = this.modifying = useBoneEnvelopes || useVertexGroups;
                if (this.modifying) {
                    Structure armatureObject = pArmatureObject.fetchData().get(0);
                    if (blenderContext.getSkeleton(armatureObject.getOldMemoryAddress()) == null) {
                        LOGGER.fine("Creating new skeleton for armature modifier.");
                        Structure armatureStructure = ((Pointer)armatureObject.getFieldValue("data")).fetchData().get(0);
                        List<Structure> bonebase = ((Structure)armatureStructure.getFieldValue("bonebase")).evaluateListBase();
                        ArrayList<Bone> bonesList = new ArrayList<Bone>();
                        for (int i = 0; i < bonebase.size(); ++i) {
                            this.buildBones(armatureObject.getOldMemoryAddress(), bonebase.get(i), null, bonesList, objectStructure.getOldMemoryAddress(), blenderContext);
                        }
                        bonesList.add(0, new Bone(""));
                        Bone[] bones = bonesList.toArray(new Bone[bonesList.size()]);
                        this.skeleton = new Skeleton(bones);
                        blenderContext.setSkeleton(armatureObject.getOldMemoryAddress(), this.skeleton);
                    } else {
                        this.skeleton = blenderContext.getSkeleton(armatureObject.getOldMemoryAddress());
                    }
                }
            } else {
                this.modifying = false;
            }
        }
    }

    private void buildBones(Long armatureObjectOMA, Structure boneStructure, Bone parent, List<Bone> result, Long spatialOMA, BlenderContext blenderContext) throws BlenderFileException {
        BoneContext bc = new BoneContext(armatureObjectOMA, boneStructure, blenderContext);
        bc.buildBone(result, spatialOMA, blenderContext);
    }

    @Override
    public void postMeshCreationApply(Node node, BlenderContext blenderContext) {
        LOGGER.fine("Applying armature modifier after mesh has been created.");
        AnimationHelper animationHelper = (AnimationHelper)blenderContext.getHelper(AnimationHelper.class);
        animationHelper.applyAnimations(node, this.skeleton, blenderContext.getBlenderKey().getAnimationMatchMethod());
        node.updateModelBound();
    }

    @Override
    public void apply(Node node, BlenderContext blenderContext) {
        if (this.invalid) {
            LOGGER.log(Level.WARNING, "Armature modifier is invalid! Cannot be applied to: {0}", node.getName());
        }
        if (this.modifying) {
            TemporalMesh temporalMesh = this.getTemporalMesh(node);
            if (temporalMesh != null) {
                LOGGER.log(Level.FINE, "Applying armature modifier to: {0}", (Object)temporalMesh);
                LOGGER.fine("Creating map between bone name and its index.");
                for (int i = 0; i < this.skeleton.getBoneCount(); ++i) {
                    Bone bone = this.skeleton.getBone(i);
                    temporalMesh.addBoneIndex(bone.getName(), i);
                }
                temporalMesh.applyAfterMeshCreate(this);
            } else {
                LOGGER.log(Level.WARNING, "Cannot find temporal mesh for node: {0}. The modifier will NOT be applied!", node);
            }
        }
    }
}

