/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.meshes;

import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.DynamicArray;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.materials.MaterialHelper;
import com.jme3.scene.plugins.blender.meshes.Face;
import com.jme3.scene.plugins.blender.meshes.TemporalMesh;
import com.jme3.scene.plugins.blender.objects.Properties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MeshHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(MeshHelper.class.getName());
    public static final int UV_DATA_LAYER_TYPE_FMESH = 5;
    public static final int UV_DATA_LAYER_TYPE_BMESH = 16;
    private Material blackUnshadedMaterial;

    public MeshHelper(String blenderVersion, BlenderContext blenderContext) {
        super(blenderVersion, blenderContext);
    }

    public TemporalMesh toTemporalMesh(Structure meshStructure, BlenderContext blenderContext) throws BlenderFileException {
        LOGGER.log(Level.FINE, "Loading temporal mesh named: {0}.", meshStructure.getName());
        TemporalMesh temporalMesh = (TemporalMesh)((Object)blenderContext.getLoadedFeature(meshStructure.getOldMemoryAddress(), BlenderContext.LoadedDataType.TEMPORAL_MESH));
        if (temporalMesh != null) {
            LOGGER.fine("The mesh is already loaded. Returning its clone.");
            return temporalMesh.clone();
        }
        if ("ID".equals(meshStructure.getType())) {
            LOGGER.fine("Loading mesh from external blend file.");
            return (TemporalMesh)((Object)this.loadLibrary(meshStructure));
        }
        String name = meshStructure.getName();
        LOGGER.log(Level.FINE, "Reading mesh: {0}.", name);
        temporalMesh = new TemporalMesh(meshStructure, blenderContext);
        LOGGER.fine("Loading materials.");
        MaterialHelper materialHelper = (MaterialHelper)blenderContext.getHelper(MaterialHelper.class);
        temporalMesh.setMaterials(materialHelper.getMaterials(meshStructure, blenderContext));
        LOGGER.fine("Reading custom properties.");
        Properties properties = this.loadProperties(meshStructure, blenderContext);
        temporalMesh.setProperties(properties);
        blenderContext.addLoadedFeatures(meshStructure.getOldMemoryAddress(), BlenderContext.LoadedDataType.STRUCTURE, meshStructure);
        blenderContext.addLoadedFeatures(meshStructure.getOldMemoryAddress(), BlenderContext.LoadedDataType.TEMPORAL_MESH, (Object)temporalMesh);
        return temporalMesh.clone();
    }

    public boolean isBMeshCompatible(Structure meshStructure) {
        Pointer pMLoop = (Pointer)meshStructure.getFieldValue("mloop");
        Pointer pMPoly = (Pointer)meshStructure.getFieldValue("mpoly");
        return pMLoop != null && pMPoly != null && pMLoop.isNotNull() && pMPoly.isNotNull();
    }

    public void loadVerticesAndNormals(Structure meshStructure, List<Vector3f> vertices, List<Vector3f> normals) throws BlenderFileException {
        LOGGER.log(Level.FINE, "Loading vertices and normals from mesh: {0}.", meshStructure.getName());
        int count = ((Number)meshStructure.getFieldValue("totvert")).intValue();
        if (count > 0) {
            Pointer pMVert = (Pointer)meshStructure.getFieldValue("mvert");
            List<Structure> mVerts = pMVert.fetchData();
            Vector3f co = null;
            Vector3f no = null;
            if (this.fixUpAxis) {
                for (int i = 0; i < count; ++i) {
                    DynamicArray coordinates = (DynamicArray)mVerts.get(i).getFieldValue("co");
                    co = new Vector3f(((Number)coordinates.get(0)).floatValue(), ((Number)coordinates.get(2)).floatValue(), -((Number)coordinates.get(1)).floatValue());
                    vertices.add(co);
                    DynamicArray norm = (DynamicArray)mVerts.get(i).getFieldValue("no");
                    no = new Vector3f((float)((Number)norm.get(0)).shortValue() / 32767.0f, (float)((Number)norm.get(2)).shortValue() / 32767.0f, (float)(-((Number)norm.get(1)).shortValue()) / 32767.0f);
                    normals.add(no);
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    DynamicArray coordinates = (DynamicArray)mVerts.get(i).getFieldValue("co");
                    co = new Vector3f(((Number)coordinates.get(0)).floatValue(), ((Number)coordinates.get(1)).floatValue(), ((Number)coordinates.get(2)).floatValue());
                    vertices.add(co);
                    DynamicArray norm = (DynamicArray)mVerts.get(i).getFieldValue("no");
                    no = new Vector3f((float)((Number)norm.get(0)).shortValue() / 32767.0f, (float)((Number)norm.get(1)).shortValue() / 32767.0f, (float)((Number)norm.get(2)).shortValue() / 32767.0f);
                    normals.add(no);
                }
            }
        }
        LOGGER.log(Level.FINE, "Loaded {0} vertices and normals.", vertices.size());
    }

    public List<byte[]> loadVerticesColors(Structure meshStructure, BlenderContext blenderContext) throws BlenderFileException {
        boolean useBGRA;
        LOGGER.log(Level.FINE, "Loading vertices colors from mesh: {0}.", meshStructure.getName());
        MeshHelper meshHelper = (MeshHelper)blenderContext.getHelper(MeshHelper.class);
        Pointer pMCol = (Pointer)meshStructure.getFieldValue(meshHelper.isBMeshCompatible(meshStructure) ? "mloopcol" : "mcol");
        ArrayList<byte[]> verticesColors = new ArrayList<byte[]>();
        boolean bl = useBGRA = blenderContext.getBlenderVersion() < 263;
        if (pMCol.isNotNull()) {
            List<Structure> mCol = pMCol.fetchData();
            for (Structure color : mCol) {
                byte[] byArray;
                byte r = ((Number)color.getFieldValue("r")).byteValue();
                byte g = ((Number)color.getFieldValue("g")).byteValue();
                byte b = ((Number)color.getFieldValue("b")).byteValue();
                byte a = ((Number)color.getFieldValue("a")).byteValue();
                if (useBGRA) {
                    byte[] byArray2 = new byte[4];
                    byArray2[0] = b;
                    byArray2[1] = g;
                    byArray2[2] = r;
                    byArray = byArray2;
                    byArray2[3] = a;
                } else {
                    byte[] byArray3 = new byte[4];
                    byArray3[0] = r;
                    byArray3[1] = g;
                    byArray3[2] = b;
                    byArray = byArray3;
                    byArray3[3] = a;
                }
                verticesColors.add(byArray);
            }
        }
        return verticesColors;
    }

    public LinkedHashMap<String, List<Vector2f>> loadUVCoordinates(Structure meshStructure) throws BlenderFileException {
        LinkedHashMap<String, List<Vector2f>> result;
        block5: {
            block4: {
                LOGGER.log(Level.FINE, "Loading UV coordinates from mesh: {0}.", meshStructure.getName());
                result = new LinkedHashMap<String, List<Vector2f>>();
                if (!this.isBMeshCompatible(meshStructure)) break block4;
                Structure loopData = (Structure)meshStructure.getFieldValue("ldata");
                Pointer pLoopDataLayers = (Pointer)loopData.getFieldValue("layers");
                List<Structure> loopDataLayers = pLoopDataLayers.fetchData();
                for (Structure structure : loopDataLayers) {
                    Pointer p = (Pointer)structure.getFieldValue("data");
                    if (!p.isNotNull() || ((Number)structure.getFieldValue("type")).intValue() != 16) continue;
                    String uvSetName = structure.getFieldValue("name").toString();
                    List<Structure> uvsStructures = p.fetchData();
                    ArrayList<Vector2f> uvs = new ArrayList<Vector2f>(uvsStructures.size());
                    for (Structure uvStructure : uvsStructures) {
                        DynamicArray loopUVS = (DynamicArray)uvStructure.getFieldValue("uv");
                        uvs.add(new Vector2f(((Number)loopUVS.get(0)).floatValue(), ((Number)loopUVS.get(1)).floatValue()));
                    }
                    result.put(uvSetName, uvs);
                }
                break block5;
            }
            Structure facesData = (Structure)meshStructure.getFieldValue("fdata");
            Pointer pFacesDataLayers = (Pointer)facesData.getFieldValue("layers");
            if (!pFacesDataLayers.isNotNull()) break block5;
            List<Structure> facesDataLayers = pFacesDataLayers.fetchData();
            for (Structure structure : facesDataLayers) {
                Pointer p = (Pointer)structure.getFieldValue("data");
                if (!p.isNotNull() || ((Number)structure.getFieldValue("type")).intValue() != 5) continue;
                String uvSetName = structure.getFieldValue("name").toString();
                List<Structure> uvsStructures = p.fetchData();
                ArrayList<Vector2f> uvs = new ArrayList<Vector2f>(uvsStructures.size());
                for (Structure uvStructure : uvsStructures) {
                    DynamicArray mFaceUVs = (DynamicArray)uvStructure.getFieldValue("uv");
                    uvs.add(new Vector2f(((Number)mFaceUVs.get(0)).floatValue(), ((Number)mFaceUVs.get(1)).floatValue()));
                    uvs.add(new Vector2f(((Number)mFaceUVs.get(2)).floatValue(), ((Number)mFaceUVs.get(3)).floatValue()));
                    uvs.add(new Vector2f(((Number)mFaceUVs.get(4)).floatValue(), ((Number)mFaceUVs.get(5)).floatValue()));
                    uvs.add(new Vector2f(((Number)mFaceUVs.get(6)).floatValue(), ((Number)mFaceUVs.get(7)).floatValue()));
                }
                result.put(uvSetName, uvs);
            }
        }
        return result;
    }

    public List<Map<String, Float>> loadVerticesGroups(Structure meshStructure) throws BlenderFileException {
        LOGGER.log(Level.FINE, "Loading vertices groups from mesh: {0}.", meshStructure.getName());
        ArrayList<Map<String, Float>> result = new ArrayList<Map<String, Float>>();
        Structure parent = this.blenderContext.peekParent();
        if (parent != null) {
            Structure defbase = (Structure)parent.getFieldValue("defbase");
            ArrayList<String> groupNames = new ArrayList<String>();
            List<Structure> defs = defbase.evaluateListBase();
            if (!defs.isEmpty()) {
                for (Structure def : defs) {
                    groupNames.add(def.getFieldValue("name").toString());
                }
                Pointer pDvert = (Pointer)meshStructure.getFieldValue("dvert");
                if (pDvert.isNotNull()) {
                    List<Structure> dverts = pDvert.fetchData();
                    for (Structure dvert : dverts) {
                        HashMap<String, Float> weightsForVertex = new HashMap<String, Float>();
                        Pointer pDW = (Pointer)dvert.getFieldValue("dw");
                        if (pDW.isNotNull()) {
                            List<Structure> dw = pDW.fetchData();
                            for (Structure deformWeight : dw) {
                                int groupIndex = ((Number)deformWeight.getFieldValue("def_nr")).intValue();
                                float weight = ((Number)deformWeight.getFieldValue("weight")).floatValue();
                                String groupName = (String)groupNames.get(groupIndex);
                                weightsForVertex.put(groupName, Float.valueOf(weight));
                            }
                        }
                        result.add(weightsForVertex);
                    }
                }
            }
        }
        return result;
    }

    public Map<String, List<Vector2f>> selectUVSubset(Face face, Integer ... indexesSublist) {
        HashMap result = null;
        if (face.getUvSets() != null) {
            result = new HashMap();
            for (Map.Entry<String, List<Vector2f>> entry : face.getUvSets().entrySet()) {
                ArrayList<Vector2f> uvs = new ArrayList<Vector2f>(indexesSublist.length);
                for (Integer index : indexesSublist) {
                    uvs.add(entry.getValue().get(face.getIndexes().indexOf(index)));
                }
                result.put(entry.getKey(), uvs);
            }
        }
        return result;
    }

    public List<byte[]> selectVertexColorSubset(Face face, Integer ... indexesSublist) {
        ArrayList<byte[]> result = null;
        List<byte[]> vertexColors = face.getVertexColors();
        if (vertexColors != null) {
            result = new ArrayList<byte[]>(indexesSublist.length);
            for (Integer index : indexesSublist) {
                result.add(vertexColors.get(face.getIndexes().indexOf(index)));
            }
        }
        return result;
    }

    public synchronized Material getBlackUnshadedMaterial(BlenderContext blenderContext) {
        if (this.blackUnshadedMaterial == null) {
            this.blackUnshadedMaterial = new Material(blenderContext.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
            this.blackUnshadedMaterial.setColor("Color", ColorRGBA.Black);
        }
        return this.blackUnshadedMaterial;
    }
}

