/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.materials;

import com.jme3.material.MatParam;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.materials.IAlphaMask;
import com.jme3.scene.plugins.blender.materials.MaterialContext;
import com.jme3.shader.VarType;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.image.ColorSpace;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MaterialHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(MaterialHelper.class.getName());
    protected static final float DEFAULT_SHININESS = 20.0f;
    public static final String TEXTURE_TYPE_COLOR = "ColorMap";
    public static final String TEXTURE_TYPE_DIFFUSE = "DiffuseMap";
    public static final String TEXTURE_TYPE_NORMAL = "NormalMap";
    public static final String TEXTURE_TYPE_SPECULAR = "SpecularMap";
    public static final String TEXTURE_TYPE_GLOW = "GlowMap";
    public static final String TEXTURE_TYPE_ALPHA = "AlphaMap";
    public static final String TEXTURE_TYPE_LIGHTMAP = "LightMap";
    public static final Integer ALPHA_MASK_NONE = 0;
    public static final Integer ALPHA_MASK_CIRCLE = 1;
    public static final Integer ALPHA_MASK_CONE = 2;
    public static final Integer ALPHA_MASK_HYPERBOLE = 3;
    protected final Map<Integer, IAlphaMask> alphaMasks = new HashMap<Integer, IAlphaMask>();

    public MaterialHelper(String blenderVersion, BlenderContext blenderContext) {
        super(blenderVersion, blenderContext);
        this.alphaMasks.put(ALPHA_MASK_NONE, new IAlphaMask(){

            @Override
            public void setImageSize(int width, int height) {
            }

            @Override
            public byte getAlpha(float x, float y) {
                return -1;
            }
        });
        this.alphaMasks.put(ALPHA_MASK_CIRCLE, new IAlphaMask(){
            private float r;
            private float[] center;

            @Override
            public void setImageSize(int width, int height) {
                this.r = (float)Math.min(width, height) * 0.5f;
                this.center = new float[]{(float)width * 0.5f, (float)height * 0.5f};
            }

            @Override
            public byte getAlpha(float x, float y) {
                float d = FastMath.abs((float)FastMath.sqrt((float)((x - this.center[0]) * (x - this.center[0]) + (y - this.center[1]) * (y - this.center[1]))));
                return (byte)(d >= this.r ? 0 : 255);
            }
        });
        this.alphaMasks.put(ALPHA_MASK_CONE, new IAlphaMask(){
            private float r;
            private float[] center;

            @Override
            public void setImageSize(int width, int height) {
                this.r = (float)Math.min(width, height) * 0.5f;
                this.center = new float[]{(float)width * 0.5f, (float)height * 0.5f};
            }

            @Override
            public byte getAlpha(float x, float y) {
                float d = FastMath.abs((float)FastMath.sqrt((float)((x - this.center[0]) * (x - this.center[0]) + (y - this.center[1]) * (y - this.center[1]))));
                return (byte)(d >= this.r ? 0.0f : -255.0f * d / this.r + 255.0f);
            }
        });
        this.alphaMasks.put(ALPHA_MASK_HYPERBOLE, new IAlphaMask(){
            private float r;
            private float[] center;

            @Override
            public void setImageSize(int width, int height) {
                this.r = (float)Math.min(width, height) * 0.5f;
                this.center = new float[]{(float)width * 0.5f, (float)height * 0.5f};
            }

            @Override
            public byte getAlpha(float x, float y) {
                float d = FastMath.abs((float)FastMath.sqrt((float)((x - this.center[0]) * (x - this.center[0]) + (y - this.center[1]) * (y - this.center[1])))) / this.r;
                return d >= 1.0f ? (byte)0 : (byte)((-FastMath.sqrt((float)((2.0f - d) * d)) + 1.0f) * 255.0f);
            }
        });
    }

    public MaterialContext toMaterialContext(Structure structure, BlenderContext blenderContext) throws BlenderFileException {
        MaterialContext result = (MaterialContext)blenderContext.getLoadedFeature(structure.getOldMemoryAddress(), BlenderContext.LoadedDataType.FEATURE);
        if (result != null) {
            return result;
        }
        if ("ID".equals(structure.getType())) {
            LOGGER.fine("Loading material from external blend file.");
            return (MaterialContext)this.loadLibrary(structure);
        }
        LOGGER.fine("Loading material.");
        result = new MaterialContext(structure, blenderContext);
        LOGGER.log(Level.FINE, "Material''s name: {0}", result.name);
        Long oma = structure.getOldMemoryAddress();
        blenderContext.addLoadedFeatures(oma, BlenderContext.LoadedDataType.STRUCTURE, structure);
        blenderContext.addLoadedFeatures(oma, BlenderContext.LoadedDataType.FEATURE, result);
        return result;
    }

    public Material getParticlesMaterial(Material material, Integer alphaMaskIndex, BlenderContext blenderContext) {
        MatParam glowColor;
        Material result = new Material(blenderContext.getAssetManager(), "Common/MatDefs/Misc/Particle.j3md");
        MatParam diffuseMap = material.getParam(TEXTURE_TYPE_DIFFUSE);
        if (diffuseMap != null) {
            Texture texture = ((Texture)diffuseMap.getValue()).clone();
            Image image = texture.getImage();
            ByteBuffer sourceBB = image.getData(0);
            sourceBB.rewind();
            int w = image.getWidth();
            int h = image.getHeight();
            ByteBuffer bb = BufferUtils.createByteBuffer((int)(w * h * 4));
            IAlphaMask iAlphaMask = this.alphaMasks.get(alphaMaskIndex);
            iAlphaMask.setImageSize(w, h);
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    bb.put(sourceBB.get());
                    bb.put(sourceBB.get());
                    bb.put(sourceBB.get());
                    bb.put(iAlphaMask.getAlpha(x, y));
                }
            }
            image = new Image(Image.Format.RGBA8, w, h, bb, ColorSpace.Linear);
            texture.setImage(image);
            result.setTextureParam("Texture", VarType.Texture2D, texture);
        }
        if ((glowColor = material.getParam("GlowColor")) != null) {
            ColorRGBA color = (ColorRGBA)glowColor.getValue();
            result.setParam("GlowColor", VarType.Vector3, (Object)color);
        }
        return result;
    }

    public MaterialContext[] getMaterials(Structure structureWithMaterials, BlenderContext blenderContext) throws BlenderFileException {
        List<Structure> materialStructures;
        Pointer ppMaterials = (Pointer)structureWithMaterials.getFieldValue("mat");
        MaterialContext[] materials = null;
        if (ppMaterials.isNotNull() && (materialStructures = ppMaterials.fetchData()) != null && materialStructures.size() > 0) {
            MaterialHelper materialHelper = (MaterialHelper)blenderContext.getHelper(MaterialHelper.class);
            materials = new MaterialContext[materialStructures.size()];
            int i = 0;
            for (Structure s : materialStructures) {
                materials[i++] = s == null ? null : materialHelper.toMaterialContext(s, blenderContext);
            }
        }
        return materials;
    }

    public void rgbToHsv(float r, float g, float b, float[] hsv) {
        float cmax = r;
        float cmin = r;
        cmax = g > cmax ? g : cmax;
        cmin = g < cmin ? g : cmin;
        cmax = b > cmax ? b : cmax;
        cmin = b < cmin ? b : cmin;
        hsv[2] = cmax;
        if ((double)cmax != 0.0) {
            hsv[1] = (cmax - cmin) / cmax;
        } else {
            hsv[1] = 0.0f;
            hsv[0] = 0.0f;
        }
        if ((double)hsv[1] == 0.0) {
            hsv[0] = -1.0f;
        } else {
            float cdelta = cmax - cmin;
            float rc = (cmax - r) / cdelta;
            float gc = (cmax - g) / cdelta;
            float bc = (cmax - b) / cdelta;
            hsv[0] = r == cmax ? bc - gc : (g == cmax ? 2.0f + rc - bc : 4.0f + gc - rc);
            hsv[0] = hsv[0] * 60.0f;
            if (hsv[0] < 0.0f) {
                hsv[0] = hsv[0] + 360.0f;
            }
        }
        hsv[0] = hsv[0] / 360.0f;
        if (hsv[0] < 0.0f) {
            hsv[0] = 0.0f;
        }
    }

    public void hsvToRgb(float h, float s, float v, float[] rgb) {
        h *= 360.0f;
        if ((double)s == 0.0) {
            rgb[1] = rgb[2] = v;
            rgb[0] = rgb[2];
        } else {
            h = h == 360.0f ? 0.0f : (h /= 60.0f);
            int i = (int)Math.floor(h);
            float f = h - (float)i;
            float p = v * (1.0f - s);
            float q = v * (1.0f - s * f);
            float t = v * (1.0f - s * (1.0f - f));
            switch (i) {
                case 0: {
                    rgb[0] = v;
                    rgb[1] = t;
                    rgb[2] = p;
                    break;
                }
                case 1: {
                    rgb[0] = q;
                    rgb[1] = v;
                    rgb[2] = p;
                    break;
                }
                case 2: {
                    rgb[0] = p;
                    rgb[1] = v;
                    rgb[2] = t;
                    break;
                }
                case 3: {
                    rgb[0] = p;
                    rgb[1] = q;
                    rgb[2] = v;
                    break;
                }
                case 4: {
                    rgb[0] = t;
                    rgb[1] = p;
                    rgb[2] = v;
                    break;
                }
                case 5: {
                    rgb[0] = v;
                    rgb[1] = p;
                    rgb[2] = q;
                }
            }
        }
    }

    public static enum SpecularShader {
        COOKTORRENCE,
        PHONG,
        BLINN,
        TOON,
        WARDISO;

    }

    public static enum DiffuseShader {
        LAMBERT,
        ORENNAYAR,
        TOON,
        MINNAERT,
        FRESNEL;

    }
}

