/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints.definitions;

import com.jme3.animation.Bone;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.constraints.ConstraintHelper;
import com.jme3.scene.plugins.blender.constraints.definitions.ConstraintDefinition;
import com.jme3.scene.plugins.blender.file.Structure;

class ConstraintDefinitionLocLimit
extends ConstraintDefinition {
    private static final int LIMIT_XMIN = 1;
    private static final int LIMIT_XMAX = 2;
    private static final int LIMIT_YMIN = 4;
    private static final int LIMIT_YMAX = 8;
    private static final int LIMIT_ZMIN = 16;
    private static final int LIMIT_ZMAX = 32;
    protected float[][] limits = new float[3][2];

    public ConstraintDefinitionLocLimit(Structure constraintData, Long ownerOMA, BlenderContext blenderContext) {
        super(constraintData, ownerOMA, blenderContext);
        if (blenderContext.getBlenderKey().isFixUpAxis()) {
            this.limits[0][0] = ((Number)constraintData.getFieldValue("xmin")).floatValue();
            this.limits[0][1] = ((Number)constraintData.getFieldValue("xmax")).floatValue();
            this.limits[2][0] = -((Number)constraintData.getFieldValue("ymin")).floatValue();
            this.limits[2][1] = -((Number)constraintData.getFieldValue("ymax")).floatValue();
            this.limits[1][0] = ((Number)constraintData.getFieldValue("zmin")).floatValue();
            this.limits[1][1] = ((Number)constraintData.getFieldValue("zmax")).floatValue();
            int ymin = this.flag & 4;
            int ymax = this.flag & 8;
            int zmin = this.flag & 0x10;
            int zmax = this.flag & 0x20;
            this.flag &= 3;
            this.flag |= ymin << 2;
            this.flag |= ymax << 2;
            this.flag |= zmin >> 2;
            this.flag |= zmax >> 2;
        } else {
            this.limits[0][0] = ((Number)constraintData.getFieldValue("xmin")).floatValue();
            this.limits[0][1] = ((Number)constraintData.getFieldValue("xmax")).floatValue();
            this.limits[1][0] = ((Number)constraintData.getFieldValue("ymin")).floatValue();
            this.limits[1][1] = ((Number)constraintData.getFieldValue("ymax")).floatValue();
            this.limits[2][0] = ((Number)constraintData.getFieldValue("zmin")).floatValue();
            this.limits[2][1] = ((Number)constraintData.getFieldValue("zmax")).floatValue();
        }
        this.trackToBeChanged = (this.flag & 0x3F) != 0;
    }

    @Override
    public boolean isTrackToBeChanged() {
        return this.trackToBeChanged && (!(this.getOwner() instanceof Bone) || ((Bone)this.getOwner()).getParent() == null || !this.blenderContext.getBoneContext(this.ownerOMA).is(16));
    }

    @Override
    public void bake(ConstraintHelper.Space ownerSpace, ConstraintHelper.Space targetSpace, Transform targetTransform, float influence) {
        if (influence == 0.0f || !this.isTrackToBeChanged()) {
            return;
        }
        Transform ownerTransform = this.getOwnerTransform(ownerSpace);
        Vector3f translation = ownerTransform.getTranslation();
        if ((this.flag & 1) != 0 && translation.x < this.limits[0][0]) {
            translation.x -= (translation.x - this.limits[0][0]) * influence;
        }
        if ((this.flag & 2) != 0 && translation.x > this.limits[0][1]) {
            translation.x -= (translation.x - this.limits[0][1]) * influence;
        }
        if ((this.flag & 4) != 0 && translation.y < this.limits[1][0]) {
            translation.y -= (translation.y - this.limits[1][0]) * influence;
        }
        if ((this.flag & 8) != 0 && translation.y > this.limits[1][1]) {
            translation.y -= (translation.y - this.limits[1][1]) * influence;
        }
        if ((this.flag & 0x10) != 0 && translation.z < this.limits[2][0]) {
            translation.z -= (translation.z - this.limits[2][0]) * influence;
        }
        if ((this.flag & 0x20) != 0 && translation.z > this.limits[2][1]) {
            translation.z -= (translation.z - this.limits[2][1]) * influence;
        }
        this.applyOwnerTransform(ownerTransform, ownerSpace);
    }

    @Override
    public String getConstraintTypeName() {
        return "Limit location";
    }

    @Override
    public boolean isTargetRequired() {
        return false;
    }
}

