/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.Animation;
import com.jme3.animation.Bone;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SpatialTrack;
import com.jme3.animation.Track;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.BoneContext;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.constraints.VirtualTrack;
import com.jme3.util.TempVars;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;

public class SimulationNode {
    private static final Logger LOGGER = Logger.getLogger(SimulationNode.class.getName());
    private Long featureOMA;
    private BlenderContext blenderContext;
    private String name;
    private List<SimulationNode> children = new ArrayList<SimulationNode>();
    private List<Animation> animations;
    private Spatial spatial;
    private Skeleton skeleton;
    private AnimControl animControl;
    private Transform spatialStartTransform;
    private Map<Bone, Transform> boneStartTransforms;

    public SimulationNode(Long featureOMA, BlenderContext blenderContext) {
        this(featureOMA, blenderContext, true);
    }

    private SimulationNode(Long featureOMA, BlenderContext blenderContext, boolean rootNode) {
        this.featureOMA = featureOMA;
        this.blenderContext = blenderContext;
        Node spatial = (Node)blenderContext.getLoadedFeature(featureOMA, BlenderContext.LoadedDataType.FEATURE);
        if (blenderContext.getMarkerValue("armature-node", spatial) != null) {
            this.skeleton = blenderContext.getSkeleton(featureOMA);
            Node nodeWithAnimationControl = blenderContext.getControlledNode(this.skeleton);
            this.animControl = (AnimControl)nodeWithAnimationControl.getControl(AnimControl.class);
            this.boneStartTransforms = new HashMap<Bone, Transform>();
            for (int i = 0; i < this.skeleton.getBoneCount(); ++i) {
                Bone bone = this.skeleton.getBone(i);
                this.boneStartTransforms.put(bone, new Transform(bone.getBindPosition(), bone.getBindRotation(), bone.getBindScale()));
            }
        } else {
            if (rootNode && spatial.getParent() != null) {
                throw new IllegalStateException("Given spatial must be a root node!");
            }
            this.spatial = spatial;
            this.spatialStartTransform = spatial.getLocalTransform().clone();
        }
        this.name = '>' + spatial.getName() + '<';
        if (this.skeleton != null) {
            Node node = blenderContext.getControlledNode(this.skeleton);
            Long animatedNodeOMA = ((Number)blenderContext.getMarkerValue("oma", node)).longValue();
            this.animations = blenderContext.getAnimations(animatedNodeOMA);
        } else {
            this.animations = blenderContext.getAnimations(featureOMA);
            for (Spatial child : spatial.getChildren()) {
                if (!(child instanceof Node)) continue;
                this.children.add(new SimulationNode((Long)blenderContext.getMarkerValue("oma", child), blenderContext, false));
            }
        }
    }

    private void reset() {
        if (this.spatial != null) {
            this.spatial.setLocalTransform(this.spatialStartTransform);
            for (SimulationNode child : this.children) {
                child.reset();
            }
        } else if (this.skeleton != null) {
            for (Map.Entry<Bone, Transform> entry : this.boneStartTransforms.entrySet()) {
                Transform t = entry.getValue();
                entry.getKey().setBindTransforms(t.getTranslation(), t.getRotation(), t.getScale());
                entry.getKey().updateModelTransforms();
            }
            this.skeleton.reset();
        }
    }

    private void simulateSpatial() {
        List<Constraint> constraints = this.blenderContext.getConstraints(this.featureOMA);
        if (constraints != null && constraints.size() > 0) {
            LOGGER.fine("Simulating spatial.");
            boolean applyStaticConstraints = true;
            if (this.animations != null) {
                for (Animation animation : this.animations) {
                    float[] animationTimeBoundaries = this.computeAnimationTimeBoundaries(animation);
                    int maxFrame = (int)animationTimeBoundaries[0];
                    float maxTime = animationTimeBoundaries[1];
                    VirtualTrack vTrack = new VirtualTrack(this.spatial.getName(), maxFrame, maxTime);
                    for (Track track : animation.getTracks()) {
                        for (int frame = 0; frame < maxFrame; ++frame) {
                            this.spatial.setLocalTranslation(((SpatialTrack)track).getTranslations()[frame]);
                            this.spatial.setLocalRotation(((SpatialTrack)track).getRotations()[frame]);
                            this.spatial.setLocalScale(((SpatialTrack)track).getScales()[frame]);
                            for (Constraint constraint : constraints) {
                                constraint.apply(frame);
                                vTrack.setTransform(frame, this.spatial.getLocalTransform());
                            }
                        }
                        SpatialTrack newTrack = vTrack.getAsSpatialTrack();
                        if (newTrack != null) {
                            animation.removeTrack(track);
                            animation.addTrack((Track)newTrack);
                        }
                        applyStaticConstraints = false;
                    }
                }
            }
            if (applyStaticConstraints) {
                for (Constraint constraint : constraints) {
                    constraint.apply(0);
                }
            }
        }
        for (SimulationNode child : this.children) {
            child.simulate();
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void simulateSkeleton() {
        LOGGER.fine("Simulating skeleton.");
        HashSet<Long> alteredOmas = new HashSet<Long>();
        if (this.animations != null) {
            TempVars vars = TempVars.get();
            AnimChannel animChannel = this.animControl.createChannel();
            for (Animation animation : this.animations) {
                float[] animationTimeBoundaries = this.computeAnimationTimeBoundaries(animation);
                int maxFrame = (int)animationTimeBoundaries[0];
                float maxTime = animationTimeBoundaries[1];
                HashMap<Integer, VirtualTrack> tracks = new HashMap<Integer, VirtualTrack>();
                for (int frame = 0; frame < maxFrame; ++frame) {
                    this.reset();
                    for (Track track : animation.getTracks()) {
                        float time = ((BoneTrack)track).getTimes()[frame];
                        track.setTime(time, 1.0f, this.animControl, animChannel, vars);
                        this.skeleton.updateWorldVectors();
                    }
                    HashSet<Long> applied = new HashSet<Long>();
                    for (Bone rootBone : this.skeleton.getRoots()) {
                        if (this.skeleton.getBoneIndex(rootBone) <= 0) continue;
                        this.applyConstraints(rootBone, alteredOmas, applied, frame, new Stack<Bone>());
                    }
                    for (Long boneOMA : alteredOmas) {
                        BoneContext boneContext = this.blenderContext.getBoneContext(boneOMA);
                        int boneIndex = this.skeleton.getBoneIndex(boneContext.getBone());
                        if (tracks.containsKey(boneIndex)) continue;
                        tracks.put(boneIndex, new VirtualTrack(boneContext.getBone().getName(), maxFrame, maxTime));
                    }
                    alteredOmas.clear();
                    for (Map.Entry trackEntry : tracks.entrySet()) {
                        Bone bone = this.skeleton.getBone(((Integer)trackEntry.getKey()).intValue());
                        Transform startTransform = this.boneStartTransforms.get(bone);
                        Vector3f bonePositionDifference = bone.getLocalPosition().subtract(startTransform.getTranslation());
                        Quaternion boneRotationDifference = startTransform.getRotation().inverse().mult(bone.getLocalRotation()).normalizeLocal();
                        Vector3f boneScaleDifference = bone.getLocalScale().divide(startTransform.getScale());
                        ((VirtualTrack)trackEntry.getValue()).setTransform(frame, new Transform(bonePositionDifference, boneRotationDifference, boneScaleDifference));
                    }
                }
                for (Map.Entry trackEntry : tracks.entrySet()) {
                    BoneTrack newTrack = ((VirtualTrack)trackEntry.getValue()).getAsBoneTrack((Integer)trackEntry.getKey());
                    if (newTrack == null) continue;
                    boolean trackReplaced = false;
                    for (Track track : animation.getTracks()) {
                        if (((BoneTrack)track).getTargetBoneIndex() != ((Integer)trackEntry.getKey()).intValue()) continue;
                        animation.removeTrack(track);
                        animation.addTrack((Track)newTrack);
                        trackReplaced = true;
                        break;
                    }
                    if (trackReplaced) continue;
                    animation.addTrack((Track)newTrack);
                }
            }
            vars.release();
            this.animControl.clearChannels();
            this.reset();
        }
    }

    private void applyConstraints(Bone bone, Set<Long> alteredOmas, Set<Long> applied, int frame, Stack<Bone> bonesStack) {
        if (!bonesStack.contains(bone)) {
            ArrayList children;
            bonesStack.push(bone);
            BoneContext boneContext = this.blenderContext.getBoneContext(bone);
            if (!applied.contains(boneContext.getBoneOma())) {
                List<Constraint> constraints = this.findConstraints(boneContext.getBoneOma(), this.blenderContext);
                if (constraints != null && constraints.size() > 0) {
                    for (Constraint constraint : constraints) {
                        if (constraint.getTargetOMA() != null && constraint.getTargetOMA() > 0L) {
                            BoneContext targetBone = this.blenderContext.getBoneContext(constraint.getTargetOMA());
                            this.applyConstraints(targetBone.getBone(), alteredOmas, applied, frame, bonesStack);
                        }
                        constraint.apply(frame);
                        if (constraint.getAlteredOmas() != null) {
                            alteredOmas.addAll(constraint.getAlteredOmas());
                        }
                        alteredOmas.add(boneContext.getBoneOma());
                    }
                }
                applied.add(boneContext.getBoneOma());
            }
            if ((children = bone.getChildren()) != null && children.size() > 0) {
                for (Bone child : bone.getChildren()) {
                    this.applyConstraints(child, alteredOmas, applied, frame, bonesStack);
                }
            }
            bonesStack.pop();
        }
    }

    public void simulate() {
        this.reset();
        if (this.spatial != null) {
            this.simulateSpatial();
        } else {
            this.simulateSkeleton();
        }
    }

    private float[] computeAnimationTimeBoundaries(Animation animation) {
        int maxFrame = Integer.MIN_VALUE;
        float maxTime = -3.4028235E38f;
        for (Track track : animation.getTracks()) {
            if (track instanceof BoneTrack) {
                maxFrame = Math.max(maxFrame, ((BoneTrack)track).getTranslations().length);
                maxTime = Math.max(maxTime, ((BoneTrack)track).getTimes()[((BoneTrack)track).getTimes().length - 1]);
                continue;
            }
            if (track instanceof SpatialTrack) {
                maxFrame = Math.max(maxFrame, ((SpatialTrack)track).getTranslations().length);
                maxTime = Math.max(maxTime, ((SpatialTrack)track).getTimes()[((SpatialTrack)track).getTimes().length - 1]);
                continue;
            }
            throw new IllegalStateException("Unsupported track type for simuation: " + track);
        }
        return new float[]{maxFrame, maxTime};
    }

    private List<Constraint> findConstraints(Long ownerOMA, BlenderContext blenderContext) {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        List<Constraint> constraints = blenderContext.getConstraints(ownerOMA);
        if (constraints != null) {
            for (Constraint constraint : constraints) {
                if (!constraint.isImplemented() || !constraint.validate() || !constraint.isTrackToBeChanged()) continue;
                result.add(constraint);
            }
        }
        return result.size() > 0 ? result : null;
    }

    public String toString() {
        return this.name;
    }
}

