/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl.lwjgl;

import com.jme3.opencl.Device;
import com.jme3.opencl.lwjgl.LwjglPlatform;
import com.jme3.opencl.lwjgl.Utils;
import java.util.Arrays;
import java.util.Collection;
import org.lwjgl.opencl.CLDevice;

public final class LwjglDevice
implements Device {
    final CLDevice device;
    final LwjglPlatform platform;

    public LwjglDevice(CLDevice device, LwjglPlatform platform) {
        this.device = device;
        this.platform = platform;
    }

    public CLDevice getDevice() {
        return this.device;
    }

    public LwjglPlatform getPlatform() {
        return this.platform;
    }

    public Device.DeviceType getDeviceType() {
        int type = this.device.getInfoInt(4096);
        switch (type) {
            case 8: {
                return Device.DeviceType.ACCELEARTOR;
            }
            case 2: {
                return Device.DeviceType.CPU;
            }
            case 4: {
                return Device.DeviceType.GPU;
            }
        }
        return Device.DeviceType.DEFAULT;
    }

    public int getVendorId() {
        return this.device.getInfoInt(4097);
    }

    public boolean isAvailable() {
        return this.device.getInfoBoolean(4135);
    }

    public boolean hasCompiler() {
        return this.device.getInfoBoolean(4136);
    }

    public boolean hasDouble() {
        return this.hasExtension("cl_khr_fp64");
    }

    public boolean hasHalfFloat() {
        return this.hasExtension("cl_khr_fp16");
    }

    public boolean hasErrorCorrectingMemory() {
        return this.device.getInfoBoolean(4132);
    }

    public boolean hasUnifiedMemory() {
        return this.device.getInfoBoolean(4149);
    }

    public boolean hasImageSupport() {
        return this.device.getInfoBoolean(4118);
    }

    public boolean hasWritableImage3D() {
        return this.hasExtension("cl_khr_3d_image_writes");
    }

    public boolean hasOpenGLInterop() {
        return this.hasExtension("cl_khr_gl_sharing");
    }

    public boolean hasExtension(String extension) {
        return this.getExtensions().contains(extension);
    }

    public Collection<? extends String> getExtensions() {
        return Arrays.asList(this.device.getInfoString(4144).split(" "));
    }

    public int getComputeUnits() {
        return this.device.getInfoInt(4098);
    }

    public int getClockFrequency() {
        return this.device.getInfoInt(4108);
    }

    public int getAddressBits() {
        return this.device.getInfoInt(4109);
    }

    public boolean isLittleEndian() {
        return this.device.getInfoBoolean(4134);
    }

    public long getMaximumWorkItemDimensions() {
        return this.device.getInfoSize(4099);
    }

    public long[] getMaximumWorkItemSizes() {
        return this.device.getInfoSizeArray(4101);
    }

    public long getMaxiumWorkItemsPerGroup() {
        return this.device.getInfoSize(4100);
    }

    public int getMaximumSamplers() {
        return this.device.getInfoInt(4120);
    }

    public int getMaximumReadImages() {
        return this.device.getInfoInt(4110);
    }

    public int getMaximumWriteImages() {
        return this.device.getInfoInt(4111);
    }

    public long[] getMaximumImage2DSize() {
        return new long[]{this.device.getInfoSize(4113), this.device.getInfoSize(4114)};
    }

    public long[] getMaximumImage3DSize() {
        return new long[]{this.device.getInfoSize(4115), this.device.getInfoSize(4116), this.device.getInfoSize(4117)};
    }

    public long getMaximumAllocationSize() {
        return this.device.getInfoLong(4112);
    }

    public long getGlobalMemorySize() {
        return this.device.getInfoLong(4127);
    }

    public long getLocalMemorySize() {
        return this.device.getInfoLong(4131);
    }

    public long getMaximumConstantBufferSize() {
        return this.device.getInfoLong(4128);
    }

    public int getMaximumConstantArguments() {
        return this.device.getInfoInt(4129);
    }

    public String getProfile() {
        return this.device.getInfoString(4142);
    }

    public String getVersion() {
        return this.device.getInfoString(4143);
    }

    public int getVersionMajor() {
        return Utils.getMajorVersion(this.getVersion(), "OpenCL ");
    }

    public int getVersionMinor() {
        return Utils.getMinorVersion(this.getVersion(), "OpenCL ");
    }

    public String getCompilerVersion() {
        return this.device.getInfoString(4157);
    }

    public int getCompilerVersionMajor() {
        return Utils.getMajorVersion(this.getCompilerVersion(), "OpenCL C ");
    }

    public int getCompilerVersionMinor() {
        return Utils.getMinorVersion(this.getCompilerVersion(), "OpenCL C ");
    }

    public String getDriverVersion() {
        return this.device.getInfoString(4141);
    }

    public int getDriverVersionMajor() {
        return Utils.getMajorVersion(this.getDriverVersion(), "");
    }

    public int getDriverVersionMinor() {
        return Utils.getMinorVersion(this.getDriverVersion(), "");
    }

    public String getName() {
        return this.device.getInfoString(4139);
    }

    public String getVendor() {
        return this.device.getInfoString(4140);
    }

    public String toString() {
        return this.getName();
    }
}

