/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.cli;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JLabel;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.modules.autoupdate.cli.Bundle;
import org.netbeans.modules.autoupdate.cli.PrintTable;
import org.netbeans.modules.autoupdate.cli.Status;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionGroups;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.util.NbPreferences;

public class ModuleOptions
extends OptionProcessor {
    private static final Logger LOG = Logger.getLogger(ModuleOptions.class.getName());
    private Option list;
    private Option install;
    private Option disable;
    private Option enable;
    private Option update;
    private Option refresh;
    private Option updateAll;
    private Option both;
    private Option extraUC;
    private Collection<UpdateUnitProvider> ownUUP = new HashSet<UpdateUnitProvider>();
    private static final String PLUGIN_MANAGER_FIRST_CLASS_MODULES = "plugin.manager.first.class.modules";

    private Option init() {
        if (this.both != null) {
            return this.both;
        }
        String b = "org.netbeans.modules.autoupdate.cli.Bundle";
        this.list = Option.shortDescription((Option)Option.withoutArgument((char)'\uffff', (String)"list"), (String)b, (String)"MSG_ListModules");
        this.install = Option.shortDescription((Option)Option.additionalArguments((char)'\uffff', (String)"install"), (String)b, (String)"MSG_InstallModules");
        this.disable = Option.shortDescription((Option)Option.additionalArguments((char)'\uffff', (String)"disable"), (String)b, (String)"MSG_DisableModules");
        this.enable = Option.shortDescription((Option)Option.additionalArguments((char)'\uffff', (String)"enable"), (String)b, (String)"MSG_EnableModules");
        this.update = Option.shortDescription((Option)Option.additionalArguments((char)'\uffff', (String)"update"), (String)b, (String)"MSG_UpdateModules");
        this.refresh = Option.shortDescription((Option)Option.withoutArgument((char)'\uffff', (String)"refresh"), (String)b, (String)"MSG_Refresh");
        this.updateAll = Option.shortDescription((Option)Option.withoutArgument((char)'\uffff', (String)"update-all"), (String)b, (String)"MSG_UpdateAll");
        this.extraUC = Option.shortDescription((Option)Option.requiredArgument((char)'\uffff', (String)"extra-uc"), (String)b, (String)"MSG_ExtraUC");
        Option oper = OptionGroups.someOf((Option[])new Option[]{this.refresh, this.list, this.install, this.disable, this.enable, this.update, this.updateAll, this.extraUC});
        Option modules = Option.withoutArgument((char)'\uffff', (String)"modules");
        this.both = OptionGroups.allOf((Option[])new Option[]{modules, oper});
        return this.both;
    }

    public Set<Option> getOptions() {
        return Collections.singleton(this.init());
    }

    private void refresh(Env env) throws CommandException {
        for (UpdateUnitProvider p : UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(true)) {
            try {
                env.getOutputStream().println("Refreshing " + p.getDisplayName());
                p.refresh(null, true);
            }
            catch (IOException ex) {
                throw (CommandException)new CommandException(31, ex.getMessage()).initCause((Throwable)ex);
            }
        }
    }

    private void listAllModules(PrintStream out) {
        List modules = UpdateManager.getDefault().getUpdateUnits();
        PrintTable table = new PrintTable(Bundle.MSG_ListHeader_CodeName(), Bundle.MSG_ListHeader_Version(), Bundle.MSG_ListHeader_State());
        table.setLimits(50, -1, -1);
        for (UpdateUnit uu : modules) {
            table.addRow(Status.toArray(uu));
        }
        table.write(out);
        out.flush();
    }

    private static <T extends Throwable> T initCause(T t, Throwable cause) {
        t.initCause(cause);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(Env env, Map<Option, String[]> optionValues) throws CommandException {
        try {
            if (optionValues.containsKey(this.extraUC)) {
                this.extraUC(env, optionValues.get(this.extraUC));
            }
            if (optionValues.containsKey(this.refresh)) {
                this.refresh(env);
            }
            if (optionValues.containsKey(this.list)) {
                this.listAllModules(env.getOutputStream());
            }
            if (optionValues.containsKey(this.install)) {
                this.install(env, optionValues.get(this.install));
            }
            try {
                if (optionValues.containsKey(this.disable)) {
                    this.changeModuleState(optionValues.get(this.disable), false);
                }
                if (optionValues.containsKey(this.enable)) {
                    this.changeModuleState(optionValues.get(this.enable), true);
                }
            }
            catch (InterruptedException ex) {
                throw ModuleOptions.initCause(new CommandException(4), ex);
            }
            catch (IOException ex) {
                throw ModuleOptions.initCause(new CommandException(4), ex);
            }
            catch (OperationException ex) {
                throw ModuleOptions.initCause(new CommandException(4), ex);
            }
            if (optionValues.containsKey(this.updateAll)) {
                this.updateAll(env);
            }
            if (optionValues.containsKey(this.update)) {
                this.updateModules(env, optionValues.get(this.update));
            }
        }
        finally {
            for (UpdateUnitProvider uuc : this.ownUUP) {
                UpdateUnitProviderFactory.getDefault().remove(uuc);
            }
        }
    }

    private void changeModuleState(String[] cnbs, boolean enable) throws IOException, CommandException, InterruptedException, OperationException {
        for (String cnb : cnbs) {
            int slash = cnb.indexOf(47);
            if (slash < 0) continue;
            cnb = cnb.substring(0, slash);
        }
        HashSet<String> all = new HashSet<String>(Arrays.asList(cnbs));
        List units = UpdateManager.getDefault().getUpdateUnits();
        OperationContainer operate = enable ? OperationContainer.createForEnable() : OperationContainer.createForDisable();
        for (UpdateUnit updateUnit : units) {
            if (!all.contains(updateUnit.getCodeName())) continue;
            if (enable) {
                operate.add(updateUnit, updateUnit.getInstalled());
                continue;
            }
            operate.add(updateUnit, updateUnit.getInstalled());
        }
        OperationSupport support = (OperationSupport)operate.getSupport();
        support.doOperation(null);
    }

    private void updateModules(final Env env, String ... pattern) throws CommandException {
        InstallSupport support;
        Set requiredElements;
        OperationContainer.OperationInfo info;
        UpdateElement ue;
        List updates;
        if (!this.initialized()) {
            this.refresh(env);
        }
        Pattern[] pats = ModuleOptions.findMatcher(env, pattern);
        List units = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
        Collection<String> firstClass = this.getFirstClassModules();
        boolean firstClassHasUpdates = false;
        OperationContainer operate = OperationContainer.createForUpdate();
        if (!firstClass.isEmpty() && pattern.length == 0) {
            for (UpdateUnit uu : units) {
                if (uu.getInstalled() == null || (updates = uu.getAvailableUpdates()).isEmpty() || !firstClass.contains(uu.getCodeName())) continue;
                ue = (UpdateElement)updates.get(0);
                env.getOutputStream().println(Bundle.MSG_Update(uu.getCodeName(), uu.getInstalled().getSpecificationVersion(), ue.getSpecificationVersion()));
                if (!operate.canBeAdded(uu, ue)) continue;
                LOG.fine("  ... update " + uu.getInstalled() + " -> " + ue);
                firstClassHasUpdates = true;
                info = operate.add(ue);
                if (info == null) continue;
                requiredElements = info.getRequiredElements();
                LOG.fine("      ... add required elements: " + requiredElements);
                operate.add((Collection)requiredElements);
            }
        }
        if (!firstClassHasUpdates) {
            for (UpdateUnit uu : units) {
                if (uu.getInstalled() == null || (updates = uu.getAvailableUpdates()).isEmpty() || pattern.length > 0 && !ModuleOptions.matches(uu.getCodeName(), pats)) continue;
                ue = (UpdateElement)updates.get(0);
                env.getOutputStream().println(Bundle.MSG_Update(uu.getCodeName(), uu.getInstalled().getSpecificationVersion(), ue.getSpecificationVersion()));
                if (!operate.canBeAdded(uu, ue)) continue;
                LOG.fine("  ... update " + uu.getInstalled() + " -> " + ue);
                info = operate.add(ue);
                if (info == null) continue;
                requiredElements = info.getRequiredElements();
                LOG.fine("      ... add required elements: " + requiredElements);
                operate.add((Collection)requiredElements);
            }
        }
        if ((support = (InstallSupport)operate.getSupport()) == null) {
            env.getOutputStream().println(pats == null || pats.length == 0 ? Bundle.MSG_UpdateNotFound() : Bundle.MSG_UpdateNoMatchPattern(Arrays.asList(pats)));
            env.getOutputStream().println("updates=0");
            return;
        }
        env.getOutputStream().println("updates=" + operate.listAll().size());
        ProgressHandle downloadHandle = ProgressHandleFactory.createHandle((String)"downloading-updates");
        downloadHandle.setInitialDelay(0);
        JLabel downloadDetailLabel = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)downloadHandle);
        downloadDetailLabel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("text".equals(evt.getPropertyName())) {
                    env.getOutputStream().println(Bundle.MSG_Download(evt.getNewValue()));
                    LOG.fine("  ... downloading update " + evt.getNewValue());
                }
            }
        });
        try {
            InstallSupport.Validator res1 = support.doDownload(downloadHandle, null, false);
            InstallSupport.Installer res2 = support.doValidate(res1, null);
            ProgressHandle installHandle = ProgressHandleFactory.createHandle((String)"installing-updates");
            installHandle.setInitialDelay(0);
            JLabel installDetailLabel = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)installHandle);
            installDetailLabel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("text".equals(evt.getPropertyName())) {
                        env.getOutputStream().println(evt.getNewValue());
                        LOG.fine("  ... installing update " + evt.getNewValue());
                    }
                }
            });
            OperationSupport.Restarter res3 = support.doInstall(res2, installHandle);
            if (res3 != null) {
                support.doRestart(res3, null);
            }
        }
        catch (OperationException ex) {
            try {
                support.doCancel();
                throw (CommandException)new CommandException(33, ex.getMessage()).initCause((Throwable)ex);
            }
            catch (OperationException ex1) {
                throw (CommandException)new CommandException(33, ex1.getMessage()).initCause((Throwable)ex1);
            }
        }
    }

    private static Pattern[] findMatcher(Env env, String[] pattern) {
        Pattern[] arr = new Pattern[pattern.length];
        for (int i = 0; i < arr.length; ++i) {
            try {
                arr[i] = Pattern.compile(pattern[i]);
                continue;
            }
            catch (PatternSyntaxException e) {
                env.getErrorStream().println(Bundle.MSG_CantCompileRegex(pattern[i]));
            }
        }
        return arr;
    }

    private static boolean matches(String txt, Pattern[] pats) {
        for (Pattern p : pats) {
            if (p == null || !p.matcher(txt).matches()) continue;
            return true;
        }
        return false;
    }

    private void install(final Env env, String ... pattern) throws CommandException {
        if (!this.initialized()) {
            this.refresh(env);
        }
        Pattern[] pats = ModuleOptions.findMatcher(env, pattern);
        List units = UpdateManager.getDefault().getUpdateUnits();
        OperationContainer operate = OperationContainer.createForInstall();
        for (UpdateUnit uu : units) {
            if (uu.getInstalled() != null || !ModuleOptions.matches(uu.getCodeName(), pats) || uu.getAvailableUpdates().isEmpty()) continue;
            UpdateElement ue = (UpdateElement)uu.getAvailableUpdates().get(0);
            env.getOutputStream().println(Bundle.MSG_Installing(uu.getCodeName(), ue.getSpecificationVersion()));
            operate.add(ue);
        }
        InstallSupport support = (InstallSupport)operate.getSupport();
        if (support == null) {
            env.getOutputStream().println(Bundle.MSG_InstallNoMatch(Arrays.asList(pats)));
            return;
        }
        try {
            env.getOutputStream().println("modules=" + operate.listAll().size());
            ProgressHandle downloadHandle = ProgressHandleFactory.createHandle((String)"downloading-modules");
            downloadHandle.setInitialDelay(0);
            JLabel downloadDetailLabel = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)downloadHandle);
            downloadDetailLabel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("text".equals(evt.getPropertyName())) {
                        env.getOutputStream().println(Bundle.MSG_Download(evt.getNewValue()));
                        LOG.fine("  ... downloading module " + evt.getNewValue());
                    }
                }
            });
            InstallSupport.Validator res1 = support.doDownload(downloadHandle, null, false);
            InstallSupport.Installer res2 = support.doValidate(res1, null);
            ProgressHandle installHandle = ProgressHandleFactory.createHandle((String)"installing-modules");
            installHandle.setInitialDelay(0);
            JLabel installDetailLabel = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)installHandle);
            installDetailLabel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("text".equals(evt.getPropertyName())) {
                        env.getOutputStream().println(evt.getNewValue());
                        LOG.fine("  ... installing module " + evt.getNewValue());
                    }
                }
            });
            OperationSupport.Restarter res3 = support.doInstall(res2, installHandle);
            if (res3 != null) {
                support.doRestart(res3, null);
            }
        }
        catch (OperationException ex) {
            if (OperationException.ERROR_TYPE.INSTALL.equals((Object)ex.getErrorType())) {
                env.getErrorStream().println(ex.getLocalizedMessage());
                throw (CommandException)new CommandException(34, ex.getMessage()).initCause((Throwable)ex);
            }
            try {
                support.doCancel();
                throw (CommandException)new CommandException(32, ex.getMessage()).initCause((Throwable)ex);
            }
            catch (OperationException ex1) {
                throw (CommandException)new CommandException(32, ex1.getMessage()).initCause((Throwable)ex1);
            }
        }
    }

    private void updateAll(Env env) throws CommandException {
        this.updateModules(env, new String[0]);
    }

    private void extraUC(Env env, String ... urls) throws CommandException {
        ArrayList<URL> url2UC = new ArrayList<URL>(urls.length);
        for (String spec : urls) {
            try {
                url2UC.add(new URL(spec));
            }
            catch (MalformedURLException ex) {
                throw ModuleOptions.initCause(new CommandException(4), ex);
            }
        }
        for (URL url : url2UC) {
            this.ownUUP.add(UpdateUnitProviderFactory.getDefault().create(Long.toString(System.currentTimeMillis()), url.toExternalForm(), url));
        }
        this.refresh(env);
    }

    private boolean initialized() {
        Preferences pref = NbPreferences.root().node("/org/netbeans/modules/autoupdate");
        long last = pref.getLong("lastCheckTime", -1L);
        return last != -1L;
    }

    private Collection<String> getFirstClassModules() {
        Preferences p = NbPreferences.root().node("/org/netbeans/modules/autoupdate");
        String names = p.get(PLUGIN_MANAGER_FIRST_CLASS_MODULES, "");
        HashSet<String> res = new HashSet<String>();
        StringTokenizer en = new StringTokenizer(names, ",");
        while (en.hasMoreTokens()) {
            res.add(en.nextToken().trim());
        }
        return res;
    }
}

