/*
 * Decompiled with CFR 0.152.
 */
package jme3tools.navigation;

import jme3tools.navigation.Coordinate;
import jme3tools.navigation.InvalidPositionException;

public class Position {
    private Coordinate lat;
    private Coordinate lng;
    private String utcTimeStamp;
    private double degree;

    public Position(double dblLat, double dblLng) throws InvalidPositionException {
        this.lat = new Coordinate(dblLat, 0);
        this.lng = new Coordinate(dblLng, 1);
    }

    public Position(int latDeg, float latMin, int latQuad, int lngDeg, float lngMin, int lngQuad) throws InvalidPositionException {
        this.lat = new Coordinate(latDeg, latMin, 0, latQuad);
        this.lng = new Coordinate(lngDeg, lngMin, 1, lngQuad);
    }

    public Position(String lat, String lng) throws InvalidPositionException {
        this.lat = new Coordinate(lat);
        this.lng = new Coordinate(lng);
    }

    public Position(String latNMEAGPS, String latQuad, String lngNMEAGPS, String lngQuad, String utcTimeStamp) {
        int quad = latQuad.compareTo("N") == 0 ? 3 : 1;
        try {
            this.lat = new Coordinate(Integer.valueOf(latNMEAGPS.substring(0, 2)), Float.valueOf(latNMEAGPS.substring(2)).floatValue(), 0, quad);
        }
        catch (InvalidPositionException e) {
            e.printStackTrace();
        }
        quad = lngQuad.compareTo("E") == 0 ? 0 : 2;
        try {
            this.lng = new Coordinate(Integer.valueOf(lngNMEAGPS.substring(0, 3)), Float.valueOf(lngNMEAGPS.substring(3)).floatValue(), 1, quad);
        }
        catch (InvalidPositionException e) {
            e.printStackTrace();
        }
        this.associateUTCTime(utcTimeStamp);
    }

    public void associateUTCTime(String data) {
        this.utcTimeStamp = data;
    }

    public String utcTimeStamp() {
        return this.utcTimeStamp;
    }

    public String toStringDec() {
        return this.lat.toStringDec() + " " + this.lng.toStringDec();
    }

    public double getLatitude() {
        return this.lat.decVal();
    }

    public double getLongitude() {
        return this.lng.decVal();
    }

    public String toStringDegMin() {
        String output = "";
        output = output + this.lat.toStringDegMin();
        output = output + "   " + this.lng.toStringDegMin();
        return output;
    }

    public String toStringDegMinLat() {
        return this.lat.toStringDegMin();
    }

    public String toStringDegMinLng() {
        return this.lng.toStringDegMin();
    }

    public String toStringDecLat() {
        return this.lat.toStringDec();
    }

    public String toStringDecLng() {
        return this.lng.toStringDec();
    }

    public static void main(String[] argsc) {
        Position p = new Position("4807.038", "N", "01131.000", "W", "123519");
        System.out.println(p.toStringDegMinLat());
        System.out.println(p.getLatitude());
        System.out.println(p.getLongitude());
        System.out.println(p.toStringDegMinLng());
        System.out.println(p.utcTimeStamp());
    }
}

