/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.vis.threed.gfx.hollywood;

import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import java.io.IOException;

public class RemoteCameraControl
implements Control {
    private final Vector3f cPos = new Vector3f();
    private Spatial camera;
    private float curr = 0.0f;
    private float distance;
    private float duration;
    private Spatial spatial;
    private float startDistance;
    private Vector3f startLocation = new Vector3f();
    private Quaternion startRotation;
    private final Quaternion tRot = new Quaternion();
    private Spatial target;
    private final Quaternion targetRotation = new Quaternion();

    public Control cloneForSpatial(Spatial spatial) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void flyTo(Node target, float rx, float ry, float rz, float duration, float distance) {
        this.camera = ((Node)this.spatial).getChild(0);
        this.startLocation = this.spatial.getLocalTranslation().clone();
        this.startRotation = this.spatial.getLocalRotation().clone();
        this.target = target;
        this.duration = duration;
        this.distance = distance == -1.0f ? this.camera.getLocalTranslation().y : distance;
        this.curr = 0.0f;
        this.targetRotation.set(this.startRotation);
        Quaternion xx = new Quaternion().fromAngleAxis(rx * ((float)Math.PI / 180), Vector3f.UNIT_X);
        Quaternion yy = new Quaternion().fromAngleAxis(ry * ((float)Math.PI / 180), Vector3f.UNIT_Y);
        Quaternion zz = new Quaternion().fromAngleAxis(rz * ((float)Math.PI / 180), Vector3f.UNIT_Z);
        this.targetRotation.multLocal(xx).multLocal(yy).multLocal(zz);
        this.startDistance = this.camera.getLocalTranslation().y;
    }

    public void setSpatial(Spatial spatial) {
        this.spatial = spatial;
    }

    public void read(JmeImporter im) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void render(RenderManager rm, ViewPort vp) {
    }

    public void update(float tpf) {
        if (this.target != null) {
            this.curr += tpf;
            float pct = this.curr / this.duration;
            if (pct > 1.0f) {
                this.target = null;
            } else {
                FastMath.interpolateLinear((float)pct, (Vector3f)this.startLocation, (Vector3f)this.target.getLocalTranslation(), (Vector3f)this.cPos);
                this.spatial.setLocalTranslation(this.cPos);
                float cDistance = FastMath.interpolateLinear((float)pct, (float)this.startDistance, (float)this.distance);
                this.camera.setLocalTranslation(0.0f, cDistance, 0.0f);
                this.tRot.set(this.startRotation);
                this.tRot.slerp(this.targetRotation, pct);
                this.spatial.setLocalRotation(this.tRot);
            }
        }
    }

    public void write(JmeExporter ex) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

