/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.vis.threed.gfx.hollywood;

import com.jme3.math.ColorRGBA;
import java.util.Map;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.ColorString;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.Renderer;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.hollywood.FloatFromJS;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.hollywood.Step;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.hollywood.Target;

public class ObjectGlowStep
extends Step {
    private final ColorRGBA color;
    private final Target target;

    public static Step fromJsonMap(Map obj) {
        Map target = (Map)obj.get("target");
        Object start = obj.get("start");
        Object duration = obj.get("duration");
        String color = (String)obj.get("color");
        if (target == null) {
            throw new IllegalArgumentException("target missing");
        }
        if (start == null) {
            throw new IllegalArgumentException("start time missing");
        }
        return new ObjectGlowStep(Target.fromJsonMap(target), FloatFromJS.get(start), duration != null ? FloatFromJS.get(duration) : 1.0f, color);
    }

    public ObjectGlowStep(Target target, float start, float duration, String color) {
        super(start, duration);
        this.target = target;
        this.color = new ColorString(color).color();
    }

    @Override
    public void trigger(Renderer renderer) {
        renderer.objectGlow(this.target.id(), 0.0f, this.duration, new ColorRGBA[]{this.color});
    }
}

