/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.vis.threed.gfx;

import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Cylinder;
import java.util.ArrayList;
import java.util.List;
import jme3tools.optimize.GeometryBatchFactory;

class WorkstationMesh {
    private final Mesh mesh;
    private final float r;
    private final int s;

    public WorkstationMesh(int samples, float radius) {
        this.s = samples;
        this.r = radius;
        this.mesh = new Mesh();
        List<Geometry> geoms = this.makeGeometry();
        GeometryBatchFactory.mergeGeometries(geoms, (Mesh)this.mesh);
    }

    private List<Geometry> makeGeometry() {
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        Geometry screen = new Geometry("screen", (Mesh)new Box(0.48f * this.r, 0.024f * this.r, 0.32f * this.r));
        geoms.add(screen);
        Geometry case_ = new Geometry("case", (Mesh)new Box(0.16f * this.r, 0.52f * this.r, 0.52f * this.r));
        case_.setLocalTranslation(0.696f * this.r, 0.0f, 0.0f);
        geoms.add(case_);
        Geometry stub = new Geometry("stub", (Mesh)new Cylinder(this.s, this.s, 0.04f * this.r, 0.12f * this.r));
        stub.setLocalTranslation(0.0f, 0.0f, -0.38f * this.r);
        geoms.add(stub);
        Geometry base = new Geometry("base", (Mesh)new Box(0.16f * this.r, 0.16f * this.r, 0.008f * this.r));
        base.setLocalTranslation(0.0f, 0.0f, -0.456f * this.r);
        geoms.add(base);
        return geoms;
    }

    Mesh get() {
        return this.mesh;
    }
}

