/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.vis.threed.gfx;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.app.state.VideoRecorderAppState;
import com.jme3.asset.AssetManager;
import com.jme3.audio.AudioData;
import com.jme3.audio.AudioNode;
import com.jme3.bounding.BoundingBox;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.post.Filter;
import com.jme3.post.FilterPostProcessor;
import com.jme3.post.SceneProcessor;
import com.jme3.post.filters.BloomFilter;
import com.jme3.renderer.Camera;
import com.jme3.scene.CameraNode;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.BillboardControl;
import com.jme3.scene.control.Control;
import com.jme3.system.AppSettings;
import com.jme3.util.SkyFactory;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import rs.co.ast.aspen.core.module.visengine.graph.Attributed;
import rs.co.ast.aspen.core.module.visengine.graph.Edge;
import rs.co.ast.aspen.core.module.visengine.graph.Node;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.ColorString;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.EdgesLayout;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.FontStyle;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.GeometryCache;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.HUDLabel;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.MouseSelectorAppState;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.RendererProperties;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.SelectedListener;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.SpatialAppState;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.ThreeDSpatialState;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.TwoDSpatialState;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.hollywood.DirectorAppState;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.hollywood.GlowControl;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.hollywood.LabelControl;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.hollywood.RemoteCameraControl;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.hollywood.Step;
import rs.co.ast.aspen.gui.module.vis.threed.phys.FieldMatrix;
import rs.co.ast.aspen.gui.module.vis.threed.phys.PhysicsBody;
import rs.co.ast.aspen.gui.module.vis.threed.phys.PhysicsConstants;
import rs.co.ast.aspen.gui.module.vis.threed.phys.PhysicsSimulator;

public class Renderer
extends SimpleApplication {
    private static final ExecutorService EXEC = Executors.newSingleThreadExecutor();
    private static final int TTL_DEFAULT = -1;
    private Material MATERIAL;
    private AmbientLight ambient;
    private final BillboardControl billboard = new BillboardControl();
    private final Map<String, List<PhysicsBody>> bodies = new HashMap<String, List<PhysicsBody>>();
    private PhysicsConstants c;
    private CameraNode camNode;
    private com.jme3.scene.Node camTarget;
    private final Map<String, com.jme3.scene.Node> edges = new HashMap<String, com.jme3.scene.Node>();
    private FieldMatrix fieldMatrix;
    private FilterPostProcessor fpp;
    private GeometryCache geometries;
    private final Map<String, HUDLabel> hudLabels = new HashMap<String, HUDLabel>();
    private long loopCount = 1L;
    private final SelectedListener mouseOverInfo = (obj, dist, mouseButton, pos) -> {
        if ("NMB".equals(mouseButton)) {
            this.handleMouseOver(obj, pos);
        }
    };
    private AppState mouseSelectorAppState;
    private final Quaternion nodeOrientation = new Quaternion();
    private final Set<Node> nodesToInit = new HashSet<Node>();
    private RendererProperties props;
    private final RemoteCameraControl rCam = new RemoteCameraControl();
    private final Map<SelectedListener, SelectedListener> selectedListeners = new WeakHashMap<SelectedListener, SelectedListener>();
    private Future<Boolean> simUpdate;
    private final Map<String, PhysicsSimulator> sims = new HashMap<String, PhysicsSimulator>();
    private SpatialAppState spatialAppState;
    private SpatialMode spatialMode;
    private DirectionalLight sun;
    private boolean physicsSimulationPaused = false;
    private static Font appfnt = null;
    private static boolean bNeedFonts = true;
    private final Map<String, com.jme3.scene.Node> nodesCache = new HashMap<String, com.jme3.scene.Node>();
    private final Map<String, com.jme3.scene.Node> edgesCache = new HashMap<String, com.jme3.scene.Node>();

    public Renderer() {
        this(new RendererProperties(), SpatialMode._3D, new PhysicsConstants(), new FieldMatrix(1, -1));
    }

    public Renderer(RendererProperties props, SpatialMode sm, PhysicsConstants c, FieldMatrix fm) {
        this.c = c;
        this.fieldMatrix = fm;
        this.billboard.setAlignment(BillboardControl.Alignment.Screen);
        this.spatialMode = sm;
        this.props = props;
        this.nodeOrientation.lookAt(Vector3f.UNIT_Y, Vector3f.UNIT_Z);
    }

    public void addKeyboardListener(int keyInput, ActionListener actionListener) throws InterruptedException, ExecutionException {
        this.enqueue(() -> {
            String mappingName = String.valueOf(keyInput);
            if (this.inputManager.hasMapping(mappingName)) {
                this.inputManager.removeListener((InputListener)actionListener);
                this.inputManager.deleteMapping(mappingName);
            }
            this.inputManager.addMapping(mappingName, new Trigger[]{new KeyTrigger(keyInput)});
            this.inputManager.addListener((InputListener)actionListener, new String[]{mappingName});
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodes(Collection<Node> nodes) {
        Set<Node> set = this.nodesToInit;
        synchronized (set) {
            this.nodesToInit.addAll(nodes);
            for (Node n : nodes) {
                int ttl = Integer.valueOf(n.get("%ttl", String.valueOf(-1)));
                if (ttl == -1) continue;
                ttl = ttl > 0 ? --ttl : ttl;
                n.set("%ttl", String.valueOf(ttl));
                if (ttl != 0) continue;
                n.set("%space", "z");
                n.set("%visible", "false");
            }
        }
        this.enqueue(() -> {
            Set<Node> set = this.nodesToInit;
            synchronized (set) {
                this.createNodes(this.nodesToInit);
                this.nodesToInit.clear();
            }
            return null;
        });
    }

    public void addSelectedListener(SelectedListener l) {
        this.selectedListeners.put(l, l);
    }

    public void cameraFlyTo(String id, float duration, float rotX, float rotY, float rotZ, float distance) {
        this.enqueue(() -> {
            com.jme3.scene.Node n = (com.jme3.scene.Node)this.rootNode.getChild(id);
            if (n != null) {
                this.rCam.flyTo(n, rotX, rotY, rotZ, duration, distance);
            }
            return null;
        });
    }

    public HUDLabel createHudLabel(String text, String fontName, String fontStyle, int fontSize, ColorRGBA color, float scale, Vector2f position) throws InterruptedException, ExecutionException {
        return (HUDLabel)this.enqueue(() -> this.createHudLabelImpl(text, fontName, fontStyle, fontSize, color, scale, position)).get();
    }

    public com.jme3.scene.Node getCameraNode() {
        return this.camNode;
    }

    public com.jme3.scene.Node getCameraTarget() {
        return this.camTarget;
    }

    public void hideStats() {
        this.enqueue(() -> {
            this.setDisplayFps(false);
            this.setDisplayStatView(false);
            return null;
        });
    }

    public boolean isPaused() throws InterruptedException, ExecutionException {
        return (Boolean)this.enqueue(() -> this.paused).get();
    }

    public void setPaused(boolean paused) {
        this.enqueue(() -> {
            this.paused = paused;
            return null;
        });
    }

    public void objectGlow(String id, float start, float duration, ColorRGBA[] colors) {
        this.enqueue(() -> {
            com.jme3.scene.Node n = (com.jme3.scene.Node)this.rootNode.getChild(id);
            if (n != null) {
                Edge obj;
                ColorRGBA currentColor = null;
                PhysicsBody b = this.findBody(id);
                if (b != null) {
                    currentColor = new ColorString(b.node.get("%color")).color();
                    obj = b.node;
                } else {
                    obj = this.findEdge(id);
                    if (obj != null) {
                        currentColor = new ColorString(obj.get("%color", "brown")).color();
                    }
                }
                AudioNode audio = this.setupSound((Attributed)obj, n);
                n.getChild(id).addControl((Control)new GlowControl(this.props, start, duration, colors, currentColor, audio));
            }
            return null;
        });
    }

    public void objectLabel(String id, int level, float start, float duration, String fontName, String fontStyle, int fontSize, ColorRGBA fontColor, String label, float minDistance, float maxDistance, float scale, Vector3f offset, Vector3f shadowOffset, ColorRGBA shadowColor) {
        this.enqueue(() -> {
            com.jme3.scene.Node n = (com.jme3.scene.Node)this.rootNode.getChild(id);
            if (n != null) {
                PhysicsBody b = this.findBody(id);
                Object obj = b != null ? b.node : this.findEdge(id);
                String text = label != null ? label : obj.toString();
                this.addLabel((Spatial)n, level, this.guiNode, this.cam, text, fontName, fontStyle, fontSize, fontColor, start, duration, minDistance, maxDistance, null, scale, offset, shadowOffset, shadowColor);
            }
            return null;
        });
    }

    public void reset(RendererProperties props, SpatialMode sm, PhysicsConstants c, FieldMatrix fm) throws InterruptedException, ExecutionException {
        Future f = this.enqueue(() -> {
            this.resetInEDT(props, sm, c, fm);
            return null;
        });
        f.get();
    }

    public void resetInEDT(RendererProperties props, SpatialMode sm, PhysicsConstants c, FieldMatrix fm) {
        this.paused = true;
        this.rootNode.removeLight((Light)this.sun);
        this.rootNode.removeLight((Light)this.ambient);
        this.rootNode.detachAllChildren();
        this.rootNode.updateGeometricState();
        this.guiNode.detachAllChildren();
        this.guiNode.updateGeometricState();
        this.viewPort.removeProcessor((SceneProcessor)this.fpp);
        this.bodies.clear();
        this.edges.clear();
        this.geometries.clear();
        this.nodesToInit.clear();
        this.hudLabels.clear();
        this.selectedListeners.clear();
        this.sims.clear();
        this.nodesCache.clear();
        this.edgesCache.clear();
        this.getRenderer().cleanup();
        this.c = c;
        this.fieldMatrix = fm;
        this.spatialMode = sm;
        this.props = props;
        this.simpleInitApp();
        this.paused = false;
        this.restart();
    }

    public void resetCameraPosition() {
        this.enqueue(() -> {
            this.camTarget.setLocalTranslation(0.0f, 0.0f, 0.0f);
            this.camTarget.setLocalRotation(Quaternion.DIRECTION_Z);
            Vector3f camPos = this.camTarget.getLocalTranslation().clone().setY(this.props.INITIAL_CAMERA_DISTANCE);
            this.camNode.setLocalTranslation(camPos);
            this.camNode.lookAt(this.camTarget.getLocalTranslation(), Vector3f.UNIT_Z);
            return null;
        });
    }

    public void runScript(Collection<Step> steps) {
        this.enqueue(() -> {
            this.stateManager.attach((AppState)new DirectorAppState(steps));
            return null;
        });
    }

    public void simpleInitApp() {
        this.initFonts();
        this.MATERIAL = this.props.LIGHTING ? new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md") : new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.geometries = new GeometryCache(this.assetManager, this.MATERIAL, this.props.LIGHTING);
        this.inputManager.setCursorVisible(true);
        this.flyCam.setEnabled(false);
        if (this.camNode == null) {
            this.camNode = new CameraNode("cam", this.cam);
        }
        if (this.camTarget == null) {
            this.camTarget = new com.jme3.scene.Node();
            this.camTarget.attachChild((Spatial)this.camNode);
            this.camTarget.addControl((Control)this.rCam);
        }
        this.rootNode.attachChild((Spatial)this.camTarget);
        this.resetCameraPosition();
        this.cam.setFrustumFar(this.props.VIEW_FRUSTUM_FAR_PLANE);
        if (this.spatialAppState != null) {
            this.stateManager.detach((AppState)this.spatialAppState);
        }
        if (this.mouseSelectorAppState != null) {
            this.stateManager.detach(this.mouseSelectorAppState);
        }
        this.spatialAppState = this.spatialMode == SpatialMode._2D ? new TwoDSpatialState(this.props) : new ThreeDSpatialState(this.props);
        this.stateManager.attach((AppState)this.spatialAppState);
        this.mouseSelectorAppState = new MouseSelectorAppState(true, true, true, true);
        this.stateManager.attach(this.mouseSelectorAppState);
        if (this.props.SHOW_LABELS_ON_MOUSE_OVER) {
            this.addSelectedListener(this.mouseOverInfo);
        }
        try {
            if (this.props.BACKGROUND_COLOR != null) {
                this.viewPort.setBackgroundColor(this.props.BACKGROUND_COLOR);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (this.props.SKYBOX_FILENAME != null && !this.props.SKYBOX_FILENAME.isEmpty()) {
            try {
                this.rootNode.attachChild(SkyFactory.createSky((AssetManager)this.assetManager, (String)this.props.SKYBOX_FILENAME, (SkyFactory.EnvMapType)SkyFactory.EnvMapType.SphereMap));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.fpp = new FilterPostProcessor(this.assetManager);
        BloomFilter bloom = new BloomFilter(BloomFilter.GlowMode.Objects);
        this.fpp.addFilter((Filter)bloom);
        this.viewPort.addProcessor((SceneProcessor)this.fpp);
        this.setupLighting();
    }

    public void simpleUpdate(float tpf) {
        this.listener.setLocation(this.cam.getLocation());
        this.listener.setRotation(this.cam.getRotation());
        if (this.props.LIGHTING) {
            this.sun.setDirection(this.cam.getDirection());
        }
        if (this.simUpdate == null) {
            this.simUpdate = EXEC.submit(() -> {
                float tpff = tpf;
                if (tpf > this.props.MAX_TPF) {
                    tpff = this.props.MAX_TPF;
                }
                if (this.loopCount < (long)this.props.FRAMES_RAMP_UP) {
                    tpff = tpff / (float)this.props.FRAMES_RAMP_UP * (float)this.loopCount;
                }
                for (String space : this.bodies.keySet()) {
                    List<PhysicsBody> n = this.bodies.get(space);
                    PhysicsSimulator sim = this.sims.get(space);
                    if (sim == null) {
                        sim = new PhysicsSimulator(this.c, this.fieldMatrix);
                        this.sims.put(space, sim);
                    }
                    List<PhysicsBody> list = n;
                    synchronized (list) {
                        sim.update(tpff, n, false);
                    }
                }
                return true;
            });
        } else if (this.simUpdate.isDone()) {
            try {
                ++this.loopCount;
                this.simUpdate.get();
                if (!this.physicsSimulationPaused) {
                    this.simUpdate = null;
                }
                this.bodies().stream().forEach(body -> {
                    this.updateNode((PhysicsBody)body);
                    this.updateEdges((PhysicsBody)body);
                });
            }
            catch (InterruptedException | ExecutionException ex) {
                Logger.getLogger(Renderer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void pausePhysicsSimulation() {
        this.physicsSimulationPaused = true;
    }

    public void unpausePhysicsSimulation() {
        this.physicsSimulationPaused = false;
    }

    public boolean isPhysicsSimulationPaused() {
        return this.physicsSimulationPaused;
    }

    public void startRecording(File destination) {
        this.startRecording(destination, 0.8f);
    }

    public void startRecording(File destination, float quality) {
        this.enqueue(() -> {
            this.stateManager.attach((AppState)new VideoRecorderAppState(destination, quality));
            return null;
        });
    }

    public void stopRecording() {
        this.enqueue(() -> {
            this.stateManager.detach(this.stateManager.getState(VideoRecorderAppState.class));
            return null;
        });
    }

    private void addLabel(Spatial s, int level, com.jme3.scene.Node guiNode, Camera cam, String text, String fontName, String fontStyle, int fontSize, ColorRGBA fontColor, float start, float duration, float minDistance, float maxDistance, Vector3f coords, float scale, Vector3f offset, Vector3f shadowOffset, ColorRGBA shadowColor) {
        for (int i = 0; i < s.getNumControls(); ++i) {
            LabelControl l;
            Control ctrl = s.getControl(i);
            if (!(ctrl instanceof LabelControl) || (l = (LabelControl)ctrl).getLevel() != level) continue;
            s.removeControl(ctrl);
        }
        s.addControl((Control)new LabelControl(this, level, guiNode, cam, text, fontName, fontStyle, fontSize, fontColor, start, duration, minDistance, maxDistance, coords, scale, offset, shadowOffset, shadowColor));
    }

    private List<PhysicsBody> bodies() {
        ArrayList<PhysicsBody> ret = new ArrayList<PhysicsBody>();
        this.bodies.values().stream().forEach(l -> ret.addAll((Collection<PhysicsBody>)l));
        return ret;
    }

    private void checkForGlow(String id, Attributed obj) {
        String glowDuration = obj.get("%glow_duration");
        if (glowDuration != null) {
            try {
                float gd = Float.parseFloat(glowDuration);
                float gs = Float.parseFloat(obj.get("%glow_start", "0"));
                ColorRGBA[] gc = this.getGlowColors(obj);
                obj.remove("%glow_duration", false);
                this.objectGlow(id, gs, gd, gc);
            }
            catch (NumberFormatException ex) {
                Logger.getLogger(Renderer.class.getName()).log(Level.WARNING, String.format("Check glow node '%s'", id), ex);
            }
        }
    }

    private void checkForLabels(String id, Attributed obj) {
        for (int i = 0; i < 9; ++i) {
            String l = "%label" + i;
            String label = obj.get(l);
            if (label == null || !obj.isDirty()) continue;
            try {
                float start = Float.parseFloat(obj.get(l + "_start", "0"));
                float duration = Float.parseFloat(obj.get(l + "_duration", "1"));
                ColorRGBA color = new ColorString(obj.get(l + "_color", "yellow")).color();
                float maxDistance = Float.parseFloat(obj.get(l + "_max_distance", String.valueOf(this.props.MAX_LABEL_DRAW_DISTANCE)));
                float minDistance = Float.parseFloat(obj.get(l + "_min_distance", String.valueOf(this.props.MIN_LABEL_DRAW_DISTANCE)));
                float scale = Float.parseFloat(obj.get(l + "_scale", "1"));
                Vector3f offset = new Vector3f();
                String[] o = obj.get(l + "_offset", "0,0").split(",");
                offset.x = Float.parseFloat(o[0]);
                offset.y = Float.parseFloat(o[1]);
                Vector3f shadowOffset = new Vector3f();
                o = obj.get(l + "_shadow_offset", "2,2").split(",");
                shadowOffset.x = Float.parseFloat(o[0]);
                shadowOffset.y = Float.parseFloat(o[1]);
                ColorRGBA shadowColor = new ColorString(obj.get(l + "_shadow_color", "black")).color();
                o = obj.get(l + "_font", "appfnt-md").split(",");
                String fontName = o[0];
                String fontStyle = o.length > 1 ? o[1] : null;
                int fontSize = o.length > 2 ? Integer.parseInt(o[2]) : -1;
                this.objectLabel(id, i, start, duration, fontName, fontStyle, fontSize, color, label.isEmpty() ? null : label, minDistance, maxDistance, scale, offset, shadowOffset, shadowColor);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException ex) {
                Logger.getLogger(Renderer.class.getName()).log(Level.WARNING, String.format("Check label id '%s'", id), ex);
            }
        }
        obj.setDirty(false);
    }

    private com.jme3.scene.Node createEdge(Edge edge) {
        com.jme3.scene.Node g2;
        com.jme3.scene.Node g1 = (com.jme3.scene.Node)this.rootNode.getChild(((Node)edge.nodes.get((int)0)).id);
        if (g1 == null) {
            g1 = this.edgesCache.get(((Node)edge.nodes.get((int)0)).id);
        }
        if ((g2 = (com.jme3.scene.Node)this.rootNode.getChild(((Node)edge.nodes.get((int)1)).id)) == null) {
            g2 = this.edgesCache.get(((Node)edge.nodes.get((int)1)).id);
        }
        com.jme3.scene.Node node = null;
        if (g1 != null && g2 != null && ((Node)edge.nodes.get(0)).get("%visible", "true").equalsIgnoreCase("true") && ((Node)edge.nodes.get(1)).get("%visible", "true").equalsIgnoreCase("true")) {
            Spatial geom = this.geometries.get(edge);
            geom.setLocalTranslation(new Vector3f(Float.valueOf(edge.get("%offset_x", "0")).floatValue(), Float.valueOf(edge.get("%offset_y", "0")).floatValue(), 0.0f));
            node = new com.jme3.scene.Node(geom.getName());
            Quaternion q = new Quaternion();
            q.lookAt(g1.getLocalTranslation().subtract(g2.getLocalTranslation()).normalize(), Vector3f.UNIT_Z);
            node.setLocalTranslation(FastMath.interpolateLinear((float)0.5f, (Vector3f)g1.getLocalTranslation(), (Vector3f)g2.getLocalTranslation()));
            node.setLocalRotation(q);
            node.attachChild(geom);
            this.edgesCache.put(((Node)edge.nodes.get((int)0)).id, g1);
            this.edgesCache.put(((Node)edge.nodes.get((int)1)).id, g2);
            this.rootNode.attachChild((Spatial)node);
        }
        return node;
    }

    private void createEdges(Node node) {
        Iterator es = node.edges();
        while (es.hasNext()) {
            com.jme3.scene.Node ng;
            Edge e = (Edge)es.next();
            Collection commonEdges = ((Node)e.nodes.get(0)).commonEdges((Node)e.nodes.get(1));
            EdgesLayout.layout(this.spatialMode, commonEdges);
            if (this.edges.containsKey(e.id) || e.get("%visible", "true").equalsIgnoreCase("false") || (ng = this.createEdge(e)) == null) continue;
            this.edges.put(e.id, ng);
        }
    }

    private HUDLabel createHudLabelImpl(String text, String fontName, String fontStyle, int fontSize, ColorRGBA fontColor, float scale, Vector2f position) {
        HUDLabel l = new HUDLabel(this, text, fontName, fontStyle, fontSize, fontColor, scale, position);
        this.guiNode.attachChild((Spatial)l.getLabel());
        return l;
    }

    private com.jme3.scene.Node createNode(PhysicsBody body, com.jme3.scene.Node prevNode) {
        Spatial geom = this.geometries.get(body);
        com.jme3.scene.Node n = new com.jme3.scene.Node(geom.getName());
        n.setLocalTranslation(body.position);
        n.attachChild(geom);
        if (this.props.FIXED_NODE_ORIENTATION) {
            geom.rotate(this.nodeOrientation);
            Control bb = this.billboard.cloneForSpatial((Spatial)n);
            n.addControl(bb);
        }
        n.setUserData("hash_code", (Object)body.node.getAttrHashCode());
        if (prevNode != null) {
            this.moveControls(n, prevNode);
        }
        this.nodesCache.put(body.node.id, n);
        this.rootNode.attachChild((Spatial)n);
        return n;
    }

    private com.jme3.scene.Node reCreateNode(PhysicsBody body, com.jme3.scene.Node prevNode) {
        Spatial geom = this.geometries.get(body);
        com.jme3.scene.Node n = new com.jme3.scene.Node(geom.getName());
        n.setLocalTranslation(body.position);
        n.attachChild(geom);
        if (this.props.FIXED_NODE_ORIENTATION) {
            geom.rotate(this.nodeOrientation);
            Control bb = this.billboard.cloneForSpatial((Spatial)n);
            n.addControl(bb);
        }
        n.setUserData("hash_code", (Object)body.node.getPrevAttrHashCode());
        if (prevNode != null) {
            this.moveControls(n, prevNode);
        }
        this.nodesCache.put(body.node.id, n);
        this.rootNode.attachChild((Spatial)n);
        return n;
    }

    private void createNodes(Set<Node> graphNodes) throws InterruptedException, ExecutionException {
        HashSet bodyIds = new HashSet();
        this.bodies().stream().forEach(body -> bodyIds.add(body.node.id));
        graphNodes.forEach(node -> {
            if (node.get("isHudLabel", "false").equals("true")) {
                String text = node.get("%text");
                HUDLabel l = this.hudLabels.get(node.id);
                ColorRGBA color = new ColorString(node.get("%color", "lightgray")).color();
                float scale = Float.parseFloat(node.get("%scale", "1"));
                Vector2f pos = new Vector2f();
                String[] o = node.get("%pos", "0,0").split(",");
                pos.x = Float.parseFloat(o[0]);
                pos.y = Float.parseFloat(o[1]);
                o = node.get(l + "%font", "appfnt-md,plain,16").split(",");
                String fontName = o[0];
                String fontStyle = o[1];
                int fontSize = Integer.parseInt(o[2]);
                if (l == null && text != null) {
                    this.hudLabels.put(node.id, this.createHudLabelImpl(text, fontName, fontStyle, fontSize, color, scale, pos));
                } else if (l != null) {
                    if (text == null) {
                        this.guiNode.detachChild((Spatial)l.getLabel());
                        this.hudLabels.remove(node.id);
                    } else {
                        l.update(text, fontName, fontStyle, fontSize, color, scale, pos);
                    }
                }
            } else if (!bodyIds.contains(node.id)) {
                Vector3f pos = this.spatialAppState.createPos((Node)node);
                while (this.isInCollision(pos, node.get("%radius", this.c.DEFAULT_RADIUS))) {
                    pos = this.spatialAppState.createPos((Node)node, true);
                }
                PhysicsBody n3d = new PhysicsBody((Node)node, pos, this.c);
                String space = node.get("%space", "1");
                List<PhysicsBody> ns = this.bodies.get(space);
                if (ns == null) {
                    ns = new ArrayList<PhysicsBody>();
                    this.bodies.put(space, ns);
                }
                List<PhysicsBody> list = ns;
                synchronized (list) {
                    ns.add(n3d);
                }
                this.createNode(n3d, null);
            } else {
                PhysicsBody n3d = this.findBody(node.id);
                String space = n3d.node.get("%space", "1");
                List<PhysicsBody> ns = this.bodies.get(space);
                if (ns == null) {
                    ns = new ArrayList<PhysicsBody>();
                }
                List<PhysicsBody> list = ns;
                synchronized (list) {
                    this.bodies.keySet().stream().map(sp -> this.bodies.get(sp)).forEachOrdered(pbs -> pbs.remove(n3d));
                    ns.add(n3d);
                }
                this.bodies.put(space, ns);
            }
        });
        graphNodes.stream().forEach(node -> this.createEdges((Node)node));
    }

    private PhysicsBody findBody(String id) {
        PhysicsBody ret = null;
        for (PhysicsBody body : this.bodies()) {
            if (!body.node.id.equals(id)) continue;
            ret = body;
            break;
        }
        return ret;
    }

    private Edge findEdge(String id) {
        Edge ret = null;
        block0: for (PhysicsBody body : this.bodies()) {
            Iterator it = body.node.edges();
            while (it.hasNext()) {
                Edge e = (Edge)it.next();
                if (!e.id.equals(id)) continue;
                ret = e;
                continue block0;
            }
        }
        return ret;
    }

    private ColorRGBA[] getGlowColors(Attributed obj) {
        ColorRGBA[] ret = null;
        String colors = obj.get("%glow_color", null);
        if (colors != null) {
            String[] cols = colors.split(",");
            ret = new ColorRGBA[cols.length];
            for (int i = 0; i < cols.length; ++i) {
                ret[i] = new ColorString(cols[i]).color();
            }
        }
        return ret;
    }

    private void handleMouseOver(Object obj, Vector2f pos) {
        Spatial s;
        String desc = null;
        String id = null;
        if (obj instanceof PhysicsBody) {
            desc = ((PhysicsBody)obj).node.toString();
            id = ((PhysicsBody)obj).node.id;
        } else if (obj instanceof Edge) {
            desc = obj.toString();
            id = ((Edge)obj).id;
        }
        if (desc != null && id != null && (s = this.rootNode.getChild(id)) != null && s.getControl(LabelControl.class) == null) {
            this.addLabel(s, 9, this.guiNode, this.cam, desc, this.props.LABEL_FONT_NAME, this.props.LABEL_FONT_STYLE, this.props.LABEL_FONT_SIZE, this.props.LABEL_COLOR, 0.0f, 0.5f, 0.0f, Float.MAX_VALUE, new Vector3f(pos.x, pos.y, 0.0f), 1.0f, Vector3f.ZERO, Vector3f.ZERO, ColorRGBA.Black);
        }
    }

    private boolean isInCollision(Vector3f pos, float radius) {
        boolean ret = false;
        for (PhysicsBody other : this.bodies()) {
            ret = pos.subtract(other.position).length() < radius + other.radius;
            if (!ret) continue;
            break;
        }
        return ret;
    }

    private void moveControls(com.jme3.scene.Node dst, com.jme3.scene.Node src) {
        while (src.getNumControls() > 0) {
            Control ctrl = src.getControl(0);
            src.removeControl(ctrl);
            dst.addControl(ctrl);
        }
    }

    private void setupLighting() {
        if (this.props.LIGHTING) {
            this.sun = new DirectionalLight();
            this.sun.setColor(this.props.DIRECTIONAL_LIGHT_COLOR);
            this.sun.setDirection(this.cam.getDirection());
            this.rootNode.addLight((Light)this.sun);
            this.ambient = new AmbientLight();
            this.ambient.setColor(this.props.AMBIENT_LIGHT_COLOR.mult(this.props.AMBIENT_LIGHT_INTENSITY));
            this.rootNode.addLight((Light)this.ambient);
        }
    }

    private AudioNode setupSound(Attributed obj, com.jme3.scene.Node parent) {
        AudioNode audio = null;
        String sound = obj.get("%glow_sound");
        if (sound != null) {
            audio = new AudioNode(this.assetManager, sound + ".wav", AudioData.DataType.Buffer);
            audio.setPositional(Boolean.parseBoolean(obj.get("%sound_positional", "true")));
            audio.setMaxDistance(Float.parseFloat(obj.get("%sound_max_distance", "10000")));
            audio.setRefDistance(Float.parseFloat(obj.get("%sound_ref_distance", "50")));
            audio.setVolume(Float.parseFloat(obj.get("%sound_volume", "0.5")));
            audio.setLocalTranslation(0.0f, 0.0f, 0.0f);
            parent.attachChild((Spatial)audio);
        }
        return audio;
    }

    private void initFonts() {
        if (bNeedFonts) {
            bNeedFonts = false;
            try {
                appfnt = Font.createFont(0, ((Object)((Object)this)).getClass().getResource("/appfnt.ttf").openStream());
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                ge.registerFont(appfnt);
            }
            catch (FontFormatException | IOException e) {
                Logger.getLogger(Renderer.class.getName()).log(Level.SEVERE, null, e);
            }
        }
    }

    public static Font getFont(String name, int size, String style) {
        Font font = null;
        if (style == null) {
            style = "normal";
        }
        int fontStyle = new FontStyle(style).getFontStyle();
        switch (name) {
            case "appfnt-lg": {
                if (appfnt == null) break;
                if (size == -1) {
                    size = 22;
                }
                font = appfnt.deriveFont(fontStyle, size);
                break;
            }
            case "appfnt-md": {
                if (appfnt == null) break;
                if (size == -1) {
                    size = 14;
                }
                font = appfnt.deriveFont(fontStyle, size);
                break;
            }
            case "appfnt-sm": {
                if (appfnt == null) break;
                if (size == -1) {
                    size = 12;
                }
                font = appfnt.deriveFont(fontStyle, size);
            }
        }
        if (font == null) {
            if (size == -1) {
                size = 14;
            }
            font = new Font(name != null && !name.isEmpty() ? name : "Dialog", fontStyle, size);
        }
        return font;
    }

    private void updateBodyCachedAttrs(PhysicsBody body) {
        body.charge = PhysicsBody.getCharge(body.node, this.c);
        body.mass = PhysicsBody.getMass(body.node, this.c);
        body.radius = PhysicsBody.getRadius(body.node, this.c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEdges(PhysicsBody body) {
        Object object = body.node.edgesLock;
        synchronized (object) {
            Iterator it = body.node.edges();
            while (it.hasNext()) {
                com.jme3.scene.Node g2;
                Edge edge = (Edge)it.next();
                if (!((Node)edge.nodes.get((int)0)).id.equals(body.node.id)) continue;
                com.jme3.scene.Node g1 = (com.jme3.scene.Node)this.rootNode.getChild(body.node.id);
                if (g1 == null) {
                    g1 = this.nodesCache.get(body.node.id);
                }
                if ((g2 = (com.jme3.scene.Node)this.rootNode.getChild(edge.other((Node)body.node).id)) == null) {
                    g2 = this.edgesCache.get(edge.other((Node)body.node).id);
                }
                com.jme3.scene.Node g = this.edges.get(edge.id);
                if (g1 == null || g2 == null || g == null || !((Node)edge.nodes.get(0)).get("%visible", "true").equalsIgnoreCase("true") || !((Node)edge.nodes.get(1)).get("%visible", "true").equalsIgnoreCase("true") || body.node.get("%visible", "true").equalsIgnoreCase("false") || edge.other(body.node).get("%visible", "true").equalsIgnoreCase("false")) continue;
                Vector3f dir = g1.getLocalTranslation().subtract(g2.getLocalTranslation());
                g.getLocalRotation().negate();
                Geometry geom = (Geometry)g.getChild(edge.id);
                float oldh = ((BoundingBox)geom.getModelBound()).getZExtent() * 2.0f;
                float scale = dir.length() / oldh;
                g.setLocalScale(1.0f, 1.0f, scale);
                Quaternion q = new Quaternion();
                q.lookAt(dir.normalize(), Vector3f.UNIT_Z);
                g.setLocalRotation(q);
                Vector3f trans = FastMath.interpolateLinear((float)0.5f, (Vector3f)g1.getLocalTranslation(), (Vector3f)g2.getLocalTranslation());
                g.setLocalTranslation(trans);
                this.checkForGlow(edge.id, (Attributed)edge);
                this.checkForLabels(edge.id, (Attributed)edge);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNode(PhysicsBody body) {
        com.jme3.scene.Node node = (com.jme3.scene.Node)this.rootNode.getChild(body.node.id);
        if (node == null) {
            node = this.nodesCache.get(body.node.id);
        }
        if (node.getUserData("hash_code") != null) {
            int code = (Integer)node.getUserData("hash_code");
            if (body.node.getAttrHashCode() != code && body.node.getPrevAttrHashCode() != body.node.getAttrHashCode()) {
                this.updateBodyCachedAttrs(body);
                node.detachAllChildren();
                this.rootNode.detachChild((Spatial)node);
                if (!body.node.get("%visible", "true").equalsIgnoreCase("false")) {
                    node = this.reCreateNode(body, node);
                    this.createEdges(body.node);
                } else {
                    Object object = body.node.edgesLock;
                    synchronized (object) {
                        Iterator it = body.node.edges();
                        while (it.hasNext()) {
                            Edge edge = (Edge)it.next();
                            com.jme3.scene.Node n = this.edges.get(edge.id);
                            if (n != null) {
                                this.hideLabelsForNode(n);
                                n.removeFromParent();
                            }
                            this.edges.remove(edge.id);
                        }
                        this.hideLabelsForNode(node);
                    }
                }
                node.setUserData("hash_code", (Object)body.node.getAttrHashCode());
            }
            this.checkForGlow(body.node.id, (Attributed)body.node);
            this.checkForLabels(body.node.id, (Attributed)body.node);
        }
        node.setLocalTranslation(body.position);
    }

    private void hideLabelsForNode(com.jme3.scene.Node node) {
        ArrayList<LabelControl> labels = new ArrayList<LabelControl>();
        for (int i = 0; i < node.getNumControls(); ++i) {
            Control ctrl = node.getControl(i);
            if (!(ctrl instanceof LabelControl)) continue;
            LabelControl label = (LabelControl)ctrl;
            labels.add(label);
        }
        labels.forEach(LabelControl::hide);
    }

    protected void fireSelectionEvent(String name, float dist, String mouseButton, Vector2f cursorPos) {
        SwingUtilities.invokeLater(() -> {
            PhysicsBody o = this.findBody(name);
            if (o == null) {
                o = this.findEdge(name);
            }
            if (o != null) {
                for (SelectedListener l : this.selectedListeners.keySet()) {
                    l.selected(o, dist, mouseButton, cursorPos);
                }
            }
        });
    }

    protected com.jme3.scene.Node getChild(String id) {
        Spatial s = this.rootNode.getChild(id);
        return s instanceof com.jme3.scene.Node ? (com.jme3.scene.Node)s : null;
    }

    AppSettings getSettings() {
        return this.settings;
    }

    public static enum SpatialMode {
        _2D,
        _3D;

    }
}

