/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.vis.threed.gfx;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Limits;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.ui.Picture;
import java.awt.Dimension;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.RenderedText;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.Renderer;

public class HUDLabel {
    private ColorRGBA fontColor;
    private String fontName;
    private int fontSize;
    private String fontStyle;
    private final Node label = new Node();
    private Vector2f pos;
    private final Renderer renderer;
    private float scale;
    private String text;

    HUDLabel(Renderer renderer, String text, String fontName, String fontStyle, int fontSize, ColorRGBA fontColor, float scale, Vector2f pos) {
        this.fontColor = fontColor;
        this.fontName = fontName;
        this.fontSize = fontSize;
        this.fontStyle = fontStyle;
        this.text = text;
        this.scale = scale;
        this.fontColor = fontColor;
        this.pos = pos;
        this.renderer = renderer;
        this.updateGeometry();
    }

    public Node getLabel() {
        return this.label;
    }

    public void update(String text, String fontName, String fontStyle, int fontSize, ColorRGBA fontColor, float scale, Vector2f pos) {
        this.fontColor = fontColor;
        this.fontName = fontName;
        this.fontSize = fontSize;
        this.fontStyle = fontStyle;
        this.text = text;
        this.scale = scale;
        this.pos = pos;
        this.updateGeometry();
    }

    public void updateFont(String name, String style, int size, ColorRGBA color) {
        this.fontColor = color;
        this.fontName = name;
        this.fontSize = size;
        this.fontStyle = style;
        this.updateGeometry();
    }

    public void updatePosition(Vector2f pos) {
        this.pos = pos;
        this.updateGeometry();
    }

    public void updateScale(float scale) {
        this.scale = scale;
        this.updateGeometry();
    }

    public void updateText(String text) {
        this.text = text;
        this.updateGeometry();
    }

    private Vector3f calculatePosition(Dimension d) {
        float sw = this.renderer.getSettings().getWidth();
        float sh = this.renderer.getSettings().getHeight();
        float x = this.pos.x * (sw - (float)d.width);
        float y = sh - (float)d.height - this.pos.y * (sh - (float)d.height);
        return new Vector3f((float)((int)x), (float)((int)y), 0.0f);
    }

    private void updateGeometry() {
        this.renderer.enqueue(() -> {
            RenderedText rt = new RenderedText(this.renderer.getAssetManager(), this.text, this.fontName, this.fontStyle, this.fontSize, this.fontColor, (Integer)this.renderer.getRenderer().getLimits().get(Limits.TextureSize));
            Picture p = rt.getPicture();
            p.setLocalTranslation(this.calculatePosition(rt.getImageDimensions()));
            this.label.detachAllChildren();
            this.label.attachChild((Spatial)p);
            return null;
        });
    }
}

