/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.vis.threed.gfx;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.control.LodControl;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Cylinder;
import com.jme3.scene.shape.Sphere;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import jme3tools.optimize.LodGenerator;
import rs.co.ast.aspen.core.module.visengine.graph.Edge;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.ColorString;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.HumanMesh;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.ModelMesh;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.WorkstationMesh;
import rs.co.ast.aspen.gui.module.vis.threed.phys.PhysicsBody;

public class GeometryCache {
    private static final LodGenerator.TriangleReductionMethod LOD_METHOD = LodGenerator.TriangleReductionMethod.PROPORTIONAL;
    private static final float[] LOD_PARAM = new float[]{0.25f, 0.5f, 0.75f};
    private static final int SAMPLES = 18;
    private final Material MATERIAL;
    private final AssetManager assetManager;
    private final Map<CacheKey, Spatial> geometries = new HashMap<CacheKey, Spatial>();
    private final boolean lighting;

    public GeometryCache(AssetManager am, Material m, boolean lighting) {
        this.MATERIAL = m;
        this.lighting = lighting;
        this.assetManager = am;
    }

    public void clear() {
        this.geometries.clear();
    }

    public Spatial get(Edge edge) {
        float radius;
        try {
            radius = Float.parseFloat(edge.get("%radius", "1"));
        }
        catch (NumberFormatException ex) {
            radius = 1.0f;
        }
        Spatial g = this.getGeometry(this.shape("cylinder"), radius);
        g.setName(edge.id);
        Material m = this.MATERIAL.clone();
        this.setColor(m, new ColorString(edge.get("%color", "brown")).color());
        g.setMaterial(m);
        return g;
    }

    public Spatial get(PhysicsBody body) {
        String shp = body.node.get("%shape", "sphere");
        Spatial g = this.getGeometry(this.shape(shp), body.radius);
        g.setName(body.node.id);
        Material m = this.MATERIAL.clone();
        this.setColor(m, new ColorString(body.node.get("%color", "white")).color());
        g.setMaterial(m);
        return g;
    }

    public Spatial getGeometry(Shape shape, float radius) {
        CacheKey key = new CacheKey(shape, radius);
        Spatial s = this.geometries.get(key);
        if (s == null) {
            Geometry g = new Geometry(null, this.makeMesh(shape, radius));
            if (shape.type == Type.MODEL) {
                g.setLocalScale(radius * 2.0f);
            }
            LodGenerator lod = new LodGenerator(g);
            lod.bakeLods(LOD_METHOD, LOD_PARAM);
            g.addControl((Control)new LodControl());
            this.geometries.put(key, (Spatial)g);
            s = g;
        }
        return s.clone();
    }

    private Mesh makeMesh(Shape shape, float radius) {
        switch (shape.type) {
            case BOX: {
                return new Box(radius / 2.0f, radius / 2.0f, radius / 2.0f);
            }
            case CYLINDER: {
                return new Cylinder(18, 18, radius, radius, true);
            }
            case HUMAN: {
                return new HumanMesh(18, radius).get();
            }
            case WORKSTATION: {
                return new WorkstationMesh(18, radius).get();
            }
            case MODEL: {
                return new ModelMesh(this.assetManager, shape, radius).get();
            }
        }
        return new Sphere(18, 18, radius);
    }

    private void setColor(Material m, ColorRGBA color) {
        if (this.lighting) {
            m.setBoolean("UseMaterialColors", true);
            m.setColor("Diffuse", color);
            m.setColor("Specular", color);
            m.setFloat("Shininess", 64.0f);
        } else {
            m.setColor("Color", color);
        }
    }

    private Shape shape(String s) {
        if ((s = s.toLowerCase()).startsWith("m_")) {
            return new Shape(Type.MODEL, s.substring(2));
        }
        switch (s) {
            case "box": {
                return new Shape(Type.BOX, s);
            }
            case "cylinder": {
                return new Shape(Type.CYLINDER, s);
            }
            case "human": {
                return new Shape(Type.HUMAN, s);
            }
            case "workstation": {
                return new Shape(Type.WORKSTATION, s);
            }
        }
        return new Shape(Type.SPHERE, "sphere");
    }

    private static class CacheKey {
        public final Shape shape;
        public final float radius;

        public CacheKey(Shape shape, float radius) {
            this.shape = shape;
            this.radius = radius;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (!Objects.equals(this.shape, other.shape)) {
                return false;
            }
            return Float.floatToIntBits(this.radius) == Float.floatToIntBits(other.radius);
        }

        public int hashCode() {
            int hash = 7;
            hash = 61 * hash + Objects.hashCode(this.shape);
            hash = 61 * hash + Float.floatToIntBits(this.radius);
            return hash;
        }
    }

    public static class Shape {
        public final String model;
        public final Type type;

        public Shape(Type type, String model) {
            this.type = type;
            this.model = model;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Shape other = (Shape)obj;
            if (this.type != other.type) {
                return false;
            }
            return Objects.equals(this.model, other.model);
        }

        public int hashCode() {
            int hash = 5;
            hash = 67 * hash + Objects.hashCode((Object)this.type);
            hash = 67 * hash + Objects.hashCode(this.model);
            return hash;
        }
    }

    public static enum Type {
        BOX,
        SPHERE,
        CYLINDER,
        HUMAN,
        WORKSTATION,
        MODEL;

    }
}

