/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.visualization.properties;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.calendar.SingleDaySelectionModel;
import org.joda.time.DateTime;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.ModuleVersionUtils;
import rs.co.ast.aspen.api.service.Script;
import rs.co.ast.aspen.core.module.visengine.graph.Node;
import rs.co.ast.aspen.gui.module.visualization.VisualizationTopComponent;
import rs.co.ast.aspen.gui.module.visualization.properties.NodeHighlightEvaluator;
import rs.co.ast.aspen.gui.module.visualization.properties.Producer;
import rs.co.ast.aspen.gui.module.visualization.properties.VisualizationManager;

@TopComponent.Description(preferredID="VisualizationPropertiesTopComponent", iconBase="cog.png", persistenceType=2)
public final class VisualizationPropertiesTopComponent
extends TopComponent
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(VisualizationPropertiesTopComponent.class.getName());
    private VisualizationManager visManager = (VisualizationManager)Lookup.getDefault().lookup(VisualizationManager.class);
    private List<Script> configScripts = new ArrayList<Script>();
    private String galaxyVideoFilePath;
    private int range = 3600000;
    private ActionListener cbRulesetActionListener;
    private boolean isFirstClickOnSearch = true;
    private String query;
    private JButton bApplySettings;
    private JButton bEnableDisablePhysics;
    private JButton bRecordVideo;
    private JButton bShowLogs;
    private JButton bStopRecordVideo;
    private JButton btnNextStep;
    private JButton btnPlay;
    private JButton btnResetCamera;
    private JButton btnStop;
    private JComboBox<String> cbRange;
    private JCheckBox cbRealtime;
    private JComboBox<String> cbRuleset;
    private JXDatePicker dpFinishDate;
    private JXDatePicker dpStartDate;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel2;
    private JScrollPane jScrollPane2;
    private JLabel lEventsDrawn;
    private JLabel lStatus;
    private JPanel pGalaxyDrawingControls;
    private JPanel pGraphAnalyses;
    private JPanel pGraphInfo;
    private JPanel pNodeInfo;
    private JPanel pRulesetData;
    private JPanel pWrapper;
    private JSpinner spEventsPerStep;
    private JSpinner spStepDelay;
    private JScrollPane spWrapper;
    private JTextArea taNodeInfo;
    private JTextField tfHighlightText;
    private JTextField tfNewAttrValuePair;
    private JTextField tfQueryAddition;

    public VisualizationPropertiesTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"CTL_VisualizationPropertiesTopComponent"));
        this.bStopRecordVideo.setEnabled(false);
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (String scriptName : this.visManager.getSettings().getScriptNames()) {
            model.addElement(scriptName);
        }
        this.cbRuleset.setModel(model);
        this.cbRulesetActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualizationTopComponent tc = (VisualizationTopComponent)WindowManager.getDefault().findTopComponent("VisualizationTopComponent");
                tc.setScriptName((String)VisualizationPropertiesTopComponent.this.cbRuleset.getSelectedItem());
                tc.init(false);
                tc.setDisplayName(NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"Visualization") + " - " + (String)VisualizationPropertiesTopComponent.this.cbRuleset.getSelectedItem());
                VisualizationPropertiesTopComponent.this.lStatus.setText("");
                VisualizationPropertiesTopComponent.this.lEventsDrawn.setText("");
            }
        };
        this.tfQueryAddition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualizationPropertiesTopComponent.this.applySettings();
            }
        });
        this.tfQueryAddition.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.fireEvent();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.fireEvent();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.fireEvent();
            }

            private void fireEvent() {
                VisualizationPropertiesTopComponent.this.visManager.getSettings().setQueryAddition(VisualizationPropertiesTopComponent.this.tfQueryAddition.getText());
            }
        });
        this.dpStartDate.setFormats(new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSXXX"});
        this.dpStartDate.getMonthView().setSelectionModel((DateSelectionModel)new SingleDaySelectionModel());
        this.dpStartDate.setTimeZone(TimeZone.getDefault());
        this.dpStartDate.setDate(new Date(this.visManager.getSettings().getStartDate()));
        this.dpStartDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualizationPropertiesTopComponent.this.visManager.getSettings().setStartDate(VisualizationPropertiesTopComponent.this.dpStartDate.getDate().getTime());
                VisualizationPropertiesTopComponent.this.dpFinishDate.setDate(new Date(VisualizationPropertiesTopComponent.this.dpStartDate.getDate().getTime() + (long)VisualizationPropertiesTopComponent.this.range));
                VisualizationPropertiesTopComponent.this.visManager.getSettings().setFinishDate(VisualizationPropertiesTopComponent.this.dpFinishDate.getDate().getTime());
            }
        });
        this.dpStartDate.getEditor().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    VisualizationPropertiesTopComponent.this.applySettings();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.dpFinishDate.setFormats(new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSXXX"});
        this.dpFinishDate.getMonthView().setSelectionModel((DateSelectionModel)new SingleDaySelectionModel());
        this.dpFinishDate.setTimeZone(TimeZone.getDefault());
        this.dpFinishDate.setDate(new Date(this.visManager.getSettings().getFinishDate()));
        this.dpFinishDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualizationPropertiesTopComponent.this.visManager.getSettings().setFinishDate(VisualizationPropertiesTopComponent.this.dpFinishDate.getDate().getTime());
                VisualizationPropertiesTopComponent.this.dpStartDate.setDate(new Date(VisualizationPropertiesTopComponent.this.dpFinishDate.getDate().getTime() - (long)VisualizationPropertiesTopComponent.this.range));
                VisualizationPropertiesTopComponent.this.visManager.getSettings().setStartDate(VisualizationPropertiesTopComponent.this.dpStartDate.getDate().getTime());
            }
        });
        this.dpFinishDate.getEditor().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    VisualizationPropertiesTopComponent.this.applySettings();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.spStepDelay.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                VisualizationPropertiesTopComponent.this.visManager.getSettings().setStepDelay((Long)VisualizationPropertiesTopComponent.this.spStepDelay.getValue());
            }
        });
        ((JSpinner.DefaultEditor)this.spStepDelay.getEditor()).getTextField().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    VisualizationPropertiesTopComponent.this.visManager.getSettings().setStepDelay((Long)VisualizationPropertiesTopComponent.this.spStepDelay.getValue());
                    VisualizationPropertiesTopComponent.this.bApplySettings.requestFocus();
                }
            }
        });
        this.spEventsPerStep.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                VisualizationPropertiesTopComponent.this.visManager.getSettings().setEventsPerStep((Integer)VisualizationPropertiesTopComponent.this.spEventsPerStep.getValue());
            }
        });
        ((JSpinner.DefaultEditor)this.spEventsPerStep.getEditor()).getTextField().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    VisualizationPropertiesTopComponent.this.visManager.getSettings().setEventsPerStep((Integer)VisualizationPropertiesTopComponent.this.spEventsPerStep.getValue());
                    VisualizationPropertiesTopComponent.this.bApplySettings.requestFocus();
                }
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualizationPropertiesTopComponent.this.visManager.getApp().enqueue((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        List allNodesList = VisualizationPropertiesTopComponent.this.visManager.getConfig().getVisEngine().allNodesList();
                        NodeHighlightEvaluator nhe = new NodeHighlightEvaluator();
                        nhe.evalWithRegexp(allNodesList, VisualizationPropertiesTopComponent.this.tfHighlightText.getText(), VisualizationPropertiesTopComponent.this.tfNewAttrValuePair.getText());
                        return null;
                    }
                });
            }
        };
        this.tfHighlightText.addActionListener(actionListener);
        this.tfNewAttrValuePair.addActionListener(actionListener);
        this.cbRealtime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VisualizationPropertiesTopComponent.this.updateEventsDrawnLabel(" ");
                        VisualizationPropertiesTopComponent.this.updateStatusLabel(" ");
                    }
                });
                VisualizationPropertiesTopComponent.this.dpStartDate.setEnabled(!VisualizationPropertiesTopComponent.this.cbRealtime.isSelected());
                VisualizationPropertiesTopComponent.this.dpFinishDate.setEnabled(!VisualizationPropertiesTopComponent.this.cbRealtime.isSelected());
                VisualizationPropertiesTopComponent.this.cbRange.setEnabled(!VisualizationPropertiesTopComponent.this.cbRealtime.isSelected());
                VisualizationPropertiesTopComponent.this.visManager.getSettings().firePropertyChange("property_realtime", !VisualizationPropertiesTopComponent.this.cbRealtime.isSelected(), VisualizationPropertiesTopComponent.this.cbRealtime.isSelected());
            }
        });
    }

    private void applySettings() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VisualizationPropertiesTopComponent.this.updateEventsDrawnLabel(NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"Producer.status.searching.title"));
            }
        });
        try {
            Thread.sleep(100L);
            VisualizationTopComponent visTC = (VisualizationTopComponent)WindowManager.getDefault().findTopComponent("VisualizationTopComponent");
            if (visTC.isOpened()) {
                this.visManager.getSettings().setQueryAddition(this.tfQueryAddition.getText());
                this.visManager.getSettings().setStepDelay((Long)this.spStepDelay.getValue());
                this.visManager.getSettings().setStartDate(this.dpStartDate.getDate().getTime());
                this.visManager.getSettings().setFinishDate(this.dpFinishDate.getDate().getTime());
                this.visManager.getSettings().setTextHighlight(this.tfHighlightText.getText());
                this.visManager.applyResolution();
                if (!this.isFirstClickOnSearch) {
                    visTC.init(true);
                }
                this.isFirstClickOnSearch = false;
                this.visManager.getNodeManager().start();
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this), NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.settings.warning.message"), NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.settings.warning.title"), 2);
                this.visManager.stopNodeWorker();
                this.visManager.pause();
                this.updateEventsDrawnLabel(String.format("%d / %d", 0, 0));
                this.updateStatusLabel(NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"Producer.status.finished.title"));
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void initComponents() {
        this.spWrapper = new JScrollPane();
        this.pWrapper = new JPanel();
        this.pRulesetData = new JPanel();
        this.jLabel7 = new JLabel();
        this.cbRuleset = new JComboBox();
        this.jLabel6 = new JLabel();
        this.tfQueryAddition = new JTextField();
        this.bApplySettings = new JButton();
        this.jLabel1 = new JLabel();
        this.dpStartDate = new JXDatePicker();
        this.dpFinishDate = new JXDatePicker();
        this.jLabel10 = new JLabel();
        this.jLabel12 = new JLabel();
        this.cbRange = new JComboBox();
        this.jLabel13 = new JLabel();
        this.cbRealtime = new JCheckBox();
        this.pGalaxyDrawingControls = new JPanel();
        this.jLabel3 = new JLabel();
        this.spStepDelay = new JSpinner();
        this.jLabel2 = new JLabel();
        this.spEventsPerStep = new JSpinner();
        this.jPanel2 = new JPanel();
        this.bEnableDisablePhysics = new JButton();
        this.btnStop = new JButton();
        this.btnPlay = new JButton();
        this.btnNextStep = new JButton();
        this.btnResetCamera = new JButton();
        this.bRecordVideo = new JButton();
        this.bStopRecordVideo = new JButton();
        this.pGraphAnalyses = new JPanel();
        this.jLabel4 = new JLabel();
        this.tfHighlightText = new JTextField();
        this.tfNewAttrValuePair = new JTextField();
        this.jLabel11 = new JLabel();
        this.pGraphInfo = new JPanel();
        this.jLabel5 = new JLabel();
        this.jLabel8 = new JLabel();
        this.lStatus = new JLabel();
        this.lEventsDrawn = new JLabel();
        this.bShowLogs = new JButton();
        this.pNodeInfo = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.taNodeInfo = new JTextArea();
        this.pRulesetData.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.pRulesetData.border.title")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.jLabel7.text"));
        this.cbRuleset.setToolTipText(NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.cbRuleset.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.jLabel6.text"));
        this.tfQueryAddition.setText(NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.tfQueryAddition.text"));
        this.tfQueryAddition.setToolTipText(NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.tfQueryAddition.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.bApplySettings, (String)NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.bApplySettings.text"));
        this.bApplySettings.setToolTipText(NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.bApplySettings.toolTipText"));
        this.bApplySettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisualizationPropertiesTopComponent.this.bApplySettingsActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.jLabel1.text"));
        this.dpStartDate.setToolTipText(NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.dpStartDate.toolTipText"));
        this.dpFinishDate.setToolTipText(NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.dpFinishDate.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.jLabel10.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel12, (String)NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.jLabel12.text"));
        this.cbRange.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "4", "8", "12", "24", "48"}));
        this.cbRange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisualizationPropertiesTopComponent.this.cbRangeActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel13, (String)NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.jLabel13.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbRealtime, (String)NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.cbRealtime.text"));
        GroupLayout pRulesetDataLayout = new GroupLayout(this.pRulesetData);
        this.pRulesetData.setLayout(pRulesetDataLayout);
        pRulesetDataLayout.setHorizontalGroup(pRulesetDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pRulesetDataLayout.createSequentialGroup().addContainerGap().addGroup(pRulesetDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbRuleset, 0, -1, Short.MAX_VALUE).addComponent(this.tfQueryAddition).addGroup(pRulesetDataLayout.createSequentialGroup().addGroup(pRulesetDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.dpStartDate, -1, -1, Short.MAX_VALUE).addComponent((Component)this.dpFinishDate, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pRulesetDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bApplySettings).addComponent(this.jLabel12).addGroup(pRulesetDataLayout.createSequentialGroup().addComponent(this.cbRange, -2, -1, -2).addGap(4, 4, 4).addComponent(this.jLabel13)))).addGroup(pRulesetDataLayout.createSequentialGroup().addGroup(pRulesetDataLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel10, GroupLayout.Alignment.LEADING).addComponent(this.jLabel7, GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING)).addGap(0, 0, Short.MAX_VALUE)).addGroup(pRulesetDataLayout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.cbRealtime))).addContainerGap()));
        pRulesetDataLayout.setVerticalGroup(pRulesetDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pRulesetDataLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbRuleset, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pRulesetDataLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.cbRealtime)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfQueryAddition, -2, 24, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pRulesetDataLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel12)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pRulesetDataLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.dpStartDate, -2, -1, -2).addComponent(this.cbRange, -2, -1, -2).addComponent(this.jLabel13)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pRulesetDataLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.dpFinishDate, -2, -1, -2).addComponent(this.bApplySettings)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pGalaxyDrawingControls.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.pGalaxyDrawingControls.border.title")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.jLabel3.text"));
        this.spStepDelay.setModel(new SpinnerNumberModel((Number)100L, Long.valueOf(100L), Long.valueOf(5000L), (Number)1L));
        this.spStepDelay.setToolTipText(NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.spStepDelay.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.jLabel2.text"));
        this.spEventsPerStep.setModel(new SpinnerNumberModel(1, 1, 5, 1));
        this.spEventsPerStep.setToolTipText(NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.spEventsPerStep.toolTipText"));
        this.bEnableDisablePhysics.setIcon(new ImageIcon(this.getClass().getResource("/bullet_black.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bEnableDisablePhysics, (String)NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.bEnableDisablePhysics.text"));
        this.bEnableDisablePhysics.setToolTipText(NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.bEnableDisablePhysics.toolTipText"));
        this.bEnableDisablePhysics.setMaximumSize(new Dimension(32, 32));
        this.bEnableDisablePhysics.setMinimumSize(new Dimension(32, 32));
        this.bEnableDisablePhysics.setPreferredSize(new Dimension(32, 32));
        this.bEnableDisablePhysics.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisualizationPropertiesTopComponent.this.bEnableDisablePhysicsActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.bEnableDisablePhysics);
        this.btnStop.setIcon(new ImageIcon(this.getClass().getResource("/control_stop_blue.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnStop, (String)NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.btnStop.text"));
        this.btnStop.setToolTipText(NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.btnStop.toolTipText"));
        this.btnStop.setMaximumSize(new Dimension(32, 32));
        this.btnStop.setMinimumSize(new Dimension(32, 32));
        this.btnStop.setPreferredSize(new Dimension(32, 32));
        this.btnStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisualizationPropertiesTopComponent.this.btnStopActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnStop);
        this.btnPlay.setIcon(new ImageIcon(this.getClass().getResource("/control_play_blue.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnPlay, (String)NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.btnPlay.text"));
        this.btnPlay.setToolTipText(NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.btnPlay.toolTipText"));
        this.btnPlay.setMaximumSize(new Dimension(32, 32));
        this.btnPlay.setMinimumSize(new Dimension(32, 32));
        this.btnPlay.setPreferredSize(new Dimension(32, 32));
        this.btnPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisualizationPropertiesTopComponent.this.btnPlayActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnPlay);
        this.btnNextStep.setIcon(new ImageIcon(this.getClass().getResource("/next_step.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnNextStep, (String)NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.btnNextStep.text"));
        this.btnNextStep.setToolTipText(NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.btnNextStep.toolTipText"));
        this.btnNextStep.setMaximumSize(new Dimension(32, 32));
        this.btnNextStep.setMinimumSize(new Dimension(32, 32));
        this.btnNextStep.setPreferredSize(new Dimension(32, 32));
        this.btnNextStep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisualizationPropertiesTopComponent.this.btnNextStepActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnNextStep);
        this.btnResetCamera.setIcon(new ImageIcon(this.getClass().getResource("/arrow_in_blue.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnResetCamera, (String)NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.btnResetCamera.text"));
        this.btnResetCamera.setToolTipText(NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.btnResetCamera.toolTipText"));
        this.btnResetCamera.setMaximumSize(new Dimension(32, 32));
        this.btnResetCamera.setMinimumSize(new Dimension(32, 32));
        this.btnResetCamera.setPreferredSize(new Dimension(32, 32));
        this.btnResetCamera.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisualizationPropertiesTopComponent.this.btnResetCameraActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnResetCamera);
        this.bRecordVideo.setIcon(new ImageIcon(this.getClass().getResource("/bullet_red.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bRecordVideo, (String)NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.bRecordVideo.text"));
        this.bRecordVideo.setToolTipText(NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.bRecordVideo.toolTipText"));
        this.bRecordVideo.setMaximumSize(new Dimension(32, 32));
        this.bRecordVideo.setMinimumSize(new Dimension(32, 32));
        this.bRecordVideo.setPreferredSize(new Dimension(32, 32));
        this.bRecordVideo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisualizationPropertiesTopComponent.this.bRecordVideoActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.bRecordVideo);
        this.bStopRecordVideo.setIcon(new ImageIcon(this.getClass().getResource("/bullet_black.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bStopRecordVideo, (String)NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.bStopRecordVideo.text"));
        this.bStopRecordVideo.setToolTipText(NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.bStopRecordVideo.toolTipText"));
        this.bStopRecordVideo.setMaximumSize(new Dimension(32, 32));
        this.bStopRecordVideo.setMinimumSize(new Dimension(32, 32));
        this.bStopRecordVideo.setPreferredSize(new Dimension(32, 32));
        this.bStopRecordVideo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisualizationPropertiesTopComponent.this.bStopRecordVideoActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.bStopRecordVideo);
        GroupLayout pGalaxyDrawingControlsLayout = new GroupLayout(this.pGalaxyDrawingControls);
        this.pGalaxyDrawingControls.setLayout(pGalaxyDrawingControlsLayout);
        pGalaxyDrawingControlsLayout.setHorizontalGroup(pGalaxyDrawingControlsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pGalaxyDrawingControlsLayout.createSequentialGroup().addContainerGap().addGroup(pGalaxyDrawingControlsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addGroup(pGalaxyDrawingControlsLayout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spStepDelay, -2, 76, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spEventsPerStep, -2, 76, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        pGalaxyDrawingControlsLayout.setVerticalGroup(pGalaxyDrawingControlsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pGalaxyDrawingControlsLayout.createSequentialGroup().addContainerGap().addGroup(pGalaxyDrawingControlsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.spStepDelay, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.spEventsPerStep, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        this.pGraphAnalyses.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.pGraphAnalyses.border.title")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.jLabel4.text"));
        this.tfHighlightText.setText(NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.tfHighlightText.text"));
        this.tfHighlightText.setToolTipText(NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.tfHighlightText.toolTipText"));
        this.tfNewAttrValuePair.setText(NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.tfNewAttrValuePair.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel11, (String)NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.jLabel11.text"));
        GroupLayout pGraphAnalysesLayout = new GroupLayout(this.pGraphAnalyses);
        this.pGraphAnalyses.setLayout(pGraphAnalysesLayout);
        pGraphAnalysesLayout.setHorizontalGroup(pGraphAnalysesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pGraphAnalysesLayout.createSequentialGroup().addContainerGap().addGroup(pGraphAnalysesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfHighlightText, -2, 210, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pGraphAnalysesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pGraphAnalysesLayout.createSequentialGroup().addComponent(this.jLabel11).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.tfNewAttrValuePair)).addContainerGap()));
        pGraphAnalysesLayout.setVerticalGroup(pGraphAnalysesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pGraphAnalysesLayout.createSequentialGroup().addContainerGap().addGroup(pGraphAnalysesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jLabel11)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pGraphAnalysesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfHighlightText, -2, -1, -2).addComponent(this.tfNewAttrValuePair, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pGraphInfo.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.pGraphInfo.border.title")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.jLabel5.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.jLabel8.text"));
        Mnemonics.setLocalizedText((JLabel)this.lStatus, (String)NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.lStatus.text"));
        Mnemonics.setLocalizedText((JLabel)this.lEventsDrawn, (String)NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.lEventsDrawn.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.bShowLogs, (String)NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.bShowLogs.text"));
        this.bShowLogs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisualizationPropertiesTopComponent.this.bShowLogsActionPerformed(evt);
            }
        });
        GroupLayout pGraphInfoLayout = new GroupLayout(this.pGraphInfo);
        this.pGraphInfo.setLayout(pGraphInfoLayout);
        pGraphInfoLayout.setHorizontalGroup(pGraphInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pGraphInfoLayout.createSequentialGroup().addContainerGap().addGroup(pGraphInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pGraphInfoLayout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lStatus, -1, -1, Short.MAX_VALUE)).addGroup(pGraphInfoLayout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lEventsDrawn, -1, -1, Short.MAX_VALUE)).addGroup(pGraphInfoLayout.createSequentialGroup().addComponent(this.bShowLogs, -2, 161, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        pGraphInfoLayout.setVerticalGroup(pGraphInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pGraphInfoLayout.createSequentialGroup().addContainerGap().addGroup(pGraphInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE).addComponent(this.lStatus, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pGraphInfoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.lEventsDrawn, -2, 15, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bShowLogs).addContainerGap(-1, Short.MAX_VALUE)));
        this.pNodeInfo.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.pNodeInfo.border.title")));
        this.taNodeInfo.setEditable(false);
        this.taNodeInfo.setColumns(20);
        this.taNodeInfo.setRows(5);
        this.jScrollPane2.setViewportView(this.taNodeInfo);
        GroupLayout pNodeInfoLayout = new GroupLayout(this.pNodeInfo);
        this.pNodeInfo.setLayout(pNodeInfoLayout);
        pNodeInfoLayout.setHorizontalGroup(pNodeInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pNodeInfoLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2).addContainerGap()));
        pNodeInfoLayout.setVerticalGroup(pNodeInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 148, Short.MAX_VALUE));
        GroupLayout pWrapperLayout = new GroupLayout(this.pWrapper);
        this.pWrapper.setLayout(pWrapperLayout);
        pWrapperLayout.setHorizontalGroup(pWrapperLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pRulesetData, -1, -1, Short.MAX_VALUE).addComponent(this.pGalaxyDrawingControls, -1, -1, Short.MAX_VALUE).addComponent(this.pGraphAnalyses, -1, -1, Short.MAX_VALUE).addComponent(this.pGraphInfo, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.pNodeInfo, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        pWrapperLayout.setVerticalGroup(pWrapperLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pWrapperLayout.createSequentialGroup().addComponent(this.pRulesetData, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pGalaxyDrawingControls, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pGraphAnalyses, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pGraphInfo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.pNodeInfo, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        this.spWrapper.setViewportView(this.pWrapper);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spWrapper));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spWrapper));
    }

    private void btnPlayActionPerformed(ActionEvent evt) {
        this.visManager.getSettings().firePropertyChange("property_play", false, true);
    }

    private void bApplySettingsActionPerformed(ActionEvent evt) {
        this.applySettings();
    }

    private void btnStopActionPerformed(ActionEvent evt) {
    }

    private void btnNextStepActionPerformed(ActionEvent evt) {
        this.visManager.getSettings().firePropertyChange("property_mode", (Object)Producer.Mode.NORMAL, (Object)Producer.Mode.STEPPING);
    }

    private void btnResetCameraActionPerformed(ActionEvent evt) {
        this.visManager.getApp().resetCameraPosition();
    }

    private void bRecordVideoActionPerformed(ActionEvent evt) {
        this.bRecordVideo.setEnabled(false);
        this.bStopRecordVideo.setEnabled(true);
        this.galaxyVideoFilePath = this.generateVideoFileName();
        File file = new File(this.galaxyVideoFilePath);
        if (!file.exists()) {
            this.visManager.getApp().startRecording(file, 1.0f);
        } else {
            NotifyDescriptor d = new NotifyDescriptor((Object)NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.recordVideo.error.message"), NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.recordVideo.error.title"), 2, 2, null, null);
            DialogDisplayer.getDefault().notify(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bStopRecordVideoActionPerformed(ActionEvent evt) {
        try {
            this.bRecordVideo.setEnabled(true);
            this.bStopRecordVideo.setEnabled(false);
            this.visManager.getApp().stopRecording();
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle(NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"VisualizationPropertiesTopComponent.record.save.dialog.title"));
            int userSelection = fileChooser.showSaveDialog(WindowManager.getDefault().getMainWindow());
            if (userSelection == 0) {
                File source = new File(this.galaxyVideoFilePath);
                File target = fileChooser.getSelectedFile();
                if (!target.getAbsolutePath().endsWith(".avi")) {
                    target = new File(Paths.get(target.getAbsolutePath() + ".avi", new String[0]).toString());
                }
                Files.move(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            this.bRecordVideo.setEnabled(true);
        }
    }

    private void bEnableDisablePhysicsActionPerformed(ActionEvent evt) {
        if (this.visManager.isPhysicsSimulationPaused()) {
            this.visManager.unpausePhysicsSimulation();
        } else {
            this.visManager.pausePhysicsSimulation();
        }
    }

    private void cbRangeActionPerformed(ActionEvent evt) {
        this.setRange((String)this.cbRange.getSelectedItem());
        if (this.dpStartDate.getDate().getTime() + (long)this.range > System.currentTimeMillis()) {
            this.visManager.getSettings().setFinishDate(System.currentTimeMillis());
            this.visManager.getSettings().setStartDate(this.dpFinishDate.getDate().getTime() - (long)this.range);
            this.dpFinishDate.setDate(new Date(this.visManager.getSettings().getFinishDate()));
            this.dpStartDate.setDate(new Date(this.visManager.getSettings().getStartDate()));
        } else {
            this.visManager.getSettings().setFinishDate(this.dpStartDate.getDate().getTime() + (long)this.range);
            this.dpFinishDate.setDate(new Date(this.visManager.getSettings().getFinishDate()));
        }
    }

    private void bShowLogsActionPerformed(ActionEvent evt) {
        if (ModuleVersionUtils.isInstalled((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.SECURITYEVENTS)) {
            try {
                FileSystem fs = FileUtil.createMemoryFileSystem();
                FileObject root = fs.getRoot();
                FileObject testFolder = root.createFolder("SecurityEventFolder");
                FileObject fileData = testFolder.createData("SecurityEventID", "securityevent");
                fileData.setAttribute("query", (Object)this.query);
                fileData.setAttribute("start", (Object)this.visManager.getSettings().getStartDate());
                fileData.setAttribute("finish", (Object)this.visManager.getSettings().getFinishDate());
                fileData.setAttribute("lastNHours", (Object)false);
                fileData.setAttribute("lastNHoursSelectedIndex", (Object)0);
                fileData.setAttribute("ASC", (Object)true);
                fileData.setAttribute("now", (Object)false);
                DataObject sedo = DataObject.find((FileObject)fileData);
                ((OpenCookie)sedo.getLookup().lookup(OpenCookie.class)).open();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"NoModulesInstalled.message"), NbBundle.getMessage(VisualizationPropertiesTopComponent.class, (String)"NoModulesInstalled.title"), 1);
        }
    }

    private void setRange(String range) {
        this.range = Integer.valueOf(range) * 60 * 60 * 1000;
    }

    private String generateVideoFileName() {
        String tmp = System.getProperty("java.io.tmpdir");
        long now = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        DateTime dt = new DateTime(now);
        sb.append(tmp);
        sb.append("/GalaxyVideo_");
        sb.append(dt.getYear());
        sb.append(dt.getMonthOfYear());
        sb.append(dt.getDayOfMonth());
        sb.append("-");
        sb.append(dt.getHourOfDay());
        sb.append(dt.getMinuteOfHour());
        sb.append(".avi");
        return sb.toString();
    }

    public void componentOpened() {
        super.componentOpened();
        this.lStatus.setText("");
        this.lEventsDrawn.setText("");
        this.cbRange.setSelectedIndex(0);
    }

    public void open() {
        WindowManager.getDefault().setTopComponentMinimized((TopComponent)this, true);
        Mode mode = WindowManager.getDefault().findMode("properties");
        if (mode != null) {
            mode.dockInto((TopComponent)this);
            super.open();
        }
    }

    public void componentClosed() {
        VisualizationTopComponent tc = (VisualizationTopComponent)WindowManager.getDefault().findTopComponent("VisualizationTopComponent");
        if (tc.isOpened()) {
            tc.close();
        }
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "property_step_delay": {
                SpinnerNumberModel model = (SpinnerNumberModel)this.spStepDelay.getModel();
                long max = (Long)model.getMaximum();
                long min = (Long)model.getMinimum();
                long stepDelay = (Long)evt.getNewValue();
                stepDelay = stepDelay > max ? max : stepDelay;
                stepDelay = stepDelay < min ? min : stepDelay;
                this.spStepDelay.setValue(stepDelay);
                break;
            }
            case "property_events_per_step": {
                SpinnerNumberModel epsModel = (SpinnerNumberModel)this.spEventsPerStep.getModel();
                int epsMax = (Integer)epsModel.getMaximum();
                int epsMin = (Integer)epsModel.getMinimum();
                int eps = (Integer)evt.getNewValue();
                eps = eps > epsMax ? epsMax : eps;
                eps = eps < epsMin ? epsMin : eps;
                this.spEventsPerStep.setValue(eps);
                break;
            }
            case "property_queryAddition": {
                this.tfQueryAddition.setText((String)evt.getNewValue());
                break;
            }
            case "property_startDate": {
                this.dpStartDate.setDate(new Date((Long)evt.getNewValue()));
                break;
            }
            case "property_finishDate": {
                this.dpFinishDate.setDate(new Date((Long)evt.getNewValue()));
                break;
            }
            case "property_script_name": {
                this.cbRuleset.setSelectedItem(this.visManager.getSettings().getScriptName());
            }
        }
    }

    public void addComboBoxRuleSetActionListener() {
        this.cbRuleset.addActionListener(this.cbRulesetActionListener);
    }

    public void removeComboBoxRuleSetActionListener() {
        this.cbRuleset.removeActionListener(this.cbRulesetActionListener);
    }

    public void updateDataQuery(String query) {
        this.query = query = query.replace("  ", "").replace("\n", "").replace("\r", "");
    }

    public void updateEventsDrawnLabel(String data) {
        this.lEventsDrawn.setText(data);
    }

    public void updateStatusLabel(String status) {
        this.lStatus.setText(status);
    }

    public void setScriptName(String scriptName) {
        this.cbRuleset.setSelectedItem(this.visManager.getSettings().getScriptName());
    }

    public void updateNodeInfo(Node node) {
        StringBuilder sb = new StringBuilder();
        TreeSet ts = new TreeSet();
        ts.addAll(node.attributes());
        for (Object e : ts) {
            sb.append(e.toString()).append(": ").append(node.get(e.toString()));
            sb.append(System.lineSeparator());
        }
        this.taNodeInfo.setText(sb.toString());
    }

    public boolean isRealtime() {
        return this.cbRealtime.isSelected();
    }
}

