/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.core.module.visengine.scripting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.ScriptType;
import rs.co.ast.aspen.api.service.SecurityEvent;
import rs.co.ast.aspen.core.module.visengine.graph.Graph;
import rs.co.ast.aspen.core.module.visengine.graph.Node;
import rs.co.ast.aspen.core.module.visengine.scripting.ListManager;
import rs.co.ast.aspen.core.module.visengine.scripting.NumberTools;
import rs.co.ast.aspen.core.module.visengine.scripting.SecurityEventNodeBindings;
import rs.co.ast.aspen.core.module.visengine.scripting.SetManager;
import rs.co.ast.aspen.core.module.visengine.scripting.TimestampFormatter;

public class ExpressionEvaluator<T> {
    private final ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private static ScriptEngine ENGINE = null;
    private static final Map<String, CompiledScript> SCRIPTS_CACHE = new HashMap<String, CompiledScript>();
    private static String util = null;
    private final Graph graph;

    private static ScriptEngine getEngine() {
        if (ENGINE == null) {
            ENGINE = new ScriptEngineManager().getEngineByName("JavaScript");
        }
        return ENGINE;
    }

    public ExpressionEvaluator(Graph graph) throws ScriptException {
        this.graph = graph;
        if (util == null) {
            try {
                List utilityFunctions = this.apiService.getScriptsByType(ScriptType.UTILITY_FUNCTIONS);
                StringBuilder sb = new StringBuilder();
                utilityFunctions.forEach(s -> {
                    if (s.getName().toLowerCase().startsWith("vis")) {
                        sb.append(s.getScript());
                    }
                });
                util = sb.toString();
            }
            catch (ApiServiceException_Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public T eval(String expression, SecurityEvent event, Node node) throws ScriptException {
        return this.eval(expression, event, node, null);
    }

    public T eval(String expression, SecurityEvent event, Node node, String curAttrVal) throws ScriptException {
        Object v = this.tryAsLong(expression);
        if (v != null) {
            return (T)v;
        }
        v = this.tryAsFloat(expression);
        if (v != null) {
            return (T)v;
        }
        v = this.tryAsQuotedString(expression);
        if (v != null) {
            return (T)v;
        }
        v = this.tryAsBoolean(expression);
        if (v != null) {
            return (T)v;
        }
        ScriptContext ctx = new SecurityEventNodeBindings(event, node, this.graph, curAttrVal).getContext();
        CompiledScript c = this.getScript(expression);
        Object res = c.eval(ctx);
        return (T)res;
    }

    private String buildScript(String expression) {
        ArrayList<String> scripts = new ArrayList<String>();
        scripts.add("var findNodeByIndexKey = function(attrs, create) {\n    var HashMap = Java.type(\"java.util.HashMap\");\n    var m = new HashMap();\n    for (i in attrs) {\n        m.put(i, attrs[i]);\n    }\n    return _graph_.findNodeByIndexKey(m, create !== undefined ? create : true);\n};");
        scripts.add("var findNodeByAttributes = function(attrs, create) {\n    var HashMap = Java.type(\"java.util.HashMap\");\n    var m = new HashMap();\n    for (i in attrs) {\n        m.put(i, attrs[i]);\n    }\n    return _graph_.findNodeByAttributes(m);\n};");
        scripts.add("var formatTimestamp = function(ts) { var cnv = Java.type(\"" + TimestampFormatter.class.getName() + "\");" + " return cnv.convert(ts);" + "};");
        scripts.add("var add = function(val) { var set = Java.type(\"" + SetManager.class.getName() + "\");" + " return set.add(_curr_attr_val_, val);" + "};");
        scripts.add("var del = function(val) { var set = Java.type(\"" + SetManager.class.getName() + "\");" + " return set.del(_curr_attr_val_, val);" + "};");
        scripts.add("var has = function(val) { var set = Java.type(\"" + SetManager.class.getName() + "\");" + " return set.has(_curr_attr_val_, val);" + "};");
        scripts.add("var addToList = function(val) { var list = Java.type(\"" + ListManager.class.getName() + "\");" + " return list.add(_curr_attr_val_, val);" + "};");
        scripts.add("var delFromList = function(val) { var list = Java.type(\"" + ListManager.class.getName() + "\");" + " return list.del(_curr_attr_val_, val);" + "};");
        scripts.add("var hasInList = function(val) { var list = Java.type(\"" + ListManager.class.getName() + "\");" + " return list.has(_curr_attr_val_, val);" + "};");
        scripts.add("var inc = function() { var nt = Java.type(\"" + NumberTools.class.getName() + "\");" + " var val = arguments[0];" + " var p = arguments[1] !== undefined ? arguments[1] : '0';" + " return nt.inc(_curr_attr_val_, val, p);" + "};");
        scripts.add("var slowInc = function() { var nt = Java.type(\"" + NumberTools.class.getName() + "\");" + " var val = arguments[0];" + " var p = arguments[1] !== undefined ? arguments[1] : '2';" + " return nt.slowInc(_curr_attr_val_, val, p);" + "};");
        scripts.add("var dec = function(val) { var nt = Java.type(\"" + NumberTools.class.getName() + "\");" + " var val = arguments[0];" + " var p = arguments[1] !== undefined ? arguments[1] : '0';" + " return nt.dec(_curr_attr_val_, val, p);" + "};");
        if (util != null) {
            scripts.add(util);
        }
        scripts.add(expression);
        return String.join((CharSequence)"\n", scripts);
    }

    private CompiledScript getScript(String expression) throws ScriptException {
        CompiledScript r = SCRIPTS_CACHE.get(expression);
        if (r == null) {
            r = ((Compilable)((Object)ExpressionEvaluator.getEngine())).compile(this.buildScript(expression));
            SCRIPTS_CACHE.put(expression, r);
        }
        return r;
    }

    private Boolean tryAsBoolean(String expression) {
        if (expression.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (expression.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        return null;
    }

    private Float tryAsFloat(String expression) {
        Float r = null;
        try {
            r = Float.valueOf(Float.parseFloat(expression));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return r;
    }

    private Long tryAsLong(String expression) {
        Long r = null;
        try {
            r = Long.parseLong(expression);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return r;
    }

    private String tryAsQuotedString(String expression) {
        if (expression.startsWith("'") && expression.endsWith("'")) {
            return expression.substring(1, expression.length() - 1);
        }
        return null;
    }
}

