/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.core.module.visengine.rs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.script.ScriptException;
import rs.co.ast.aspen.api.service.SecurityEvent;
import rs.co.ast.aspen.core.module.visengine.actions.Action;
import rs.co.ast.aspen.core.module.visengine.graph.Graph;
import rs.co.ast.aspen.core.module.visengine.graph.Node;
import rs.co.ast.aspen.core.module.visengine.rs.Ruleset;
import rs.co.ast.aspen.core.module.visengine.scripting.ExpressionEvaluator;

public class Check {
    public final List<Action> actions = new ArrayList<Action>();
    public final String expression;

    public static Check fromMap(Map map, Ruleset rs) {
        String expr = (String)map.get("expression");
        Check check = new Check(expr);
        Map actions = (Map)map.get("actions");
        for (Object action : actions.values()) {
            check.addAction(Action.actionFromMap((Map)action, rs));
        }
        return check;
    }

    public Check(String expression) {
        this.expression = expression;
    }

    public void addAction(Action action) {
        this.actions.add(action);
    }

    public Status perform(Graph graph, SecurityEvent event, Node node) throws ScriptException {
        Status status;
        block3: {
            status = Status.NO_MATCH;
            boolean r = (Boolean)new ExpressionEvaluator(graph).eval(this.expression, event, node);
            if (!r) break block3;
            status = Status.MATCHED;
            for (Action action : this.actions) {
                Status s = action.execute(graph, event, node);
                if (s == Status.MATCHED) continue;
                status = s;
                break;
            }
        }
        return status;
    }

    public static enum Status {
        BREAK,
        CONTINUE,
        NO_MATCH,
        MATCHED;

    }
}

