/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.alertevents;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import org.apache.commons.codec.digest.DigestUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.painter.BusyPainter;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.DateRange;
import rs.co.ast.aspen.api.service.ModuleVersionUtils;
import rs.co.ast.aspen.api.service.SavedQueryData;
import rs.co.ast.aspen.api.service.SavedQueryDataType;
import rs.co.ast.aspen.api.service.SearchState;
import rs.co.ast.aspen.api.service.SecurityEvent;
import rs.co.ast.aspen.gui.module.alertevents.AlertEventDetailsTopComponent;
import rs.co.ast.aspen.gui.module.alertevents.AlertEventSearchQueryUpdate;
import rs.co.ast.aspen.gui.module.alertevents.AlertEventWrapper;
import rs.co.ast.aspen.gui.module.alertevents.AlertEventsTableModel;
import rs.co.ast.aspen.gui.module.alertevents.AlertEventsTableRenderer;
import rs.co.ast.aspen.gui.module.alertevents.AnalysisTopComponent;
import rs.co.ast.aspen.gui.module.alertevents.AutoCompleteDecorator;
import rs.co.ast.aspen.gui.module.alertevents.DisplayOptions;
import rs.co.ast.aspen.gui.module.alertevents.DisplayOptionsDisplayer;
import rs.co.ast.aspen.gui.module.alertevents.OverviewPanel;
import rs.co.ast.aspen.gui.module.alertevents.QuerySetNamePanel;
import rs.co.ast.aspen.gui.module.alertevents.SavedQueryDataDialog;
import rs.co.ast.aspen.gui.module.alertevents.query.AlertEventQueryHistory;
import rs.co.ast.aspen.gui.module.alertevents.query.QueryManager;
import rs.co.ast.aspen.gui.module.alertevents.query.TopComponentTitleShortener;
import rs.co.ast.aspen.gui.module.alertevents.search.SearchExecutor;
import rs.co.ast.aspen.gui.module.alertevents.search.SkippedTaskInfo;
import rs.co.ast.aspen.gui.module.alertevents.search.TaskMonitor;
import rs.co.ast.chart.FrontCountBarChart;
import rs.co.ast.chart.MyStackedXYBarRenderer;

@TopComponent.Description(preferredID="AlertEventsTopComponent", iconBase="alert_16.png", persistenceType=1)
public final class AlertEventsTopComponent
extends TopComponent
implements PropertyChangeListener {
    private ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private AlertEventQueryHistory queryHistory = (AlertEventQueryHistory)Lookup.getDefault().lookup(AlertEventQueryHistory.class);
    private SearchExecutor searchExecutor;
    private AlertEventsTableModel tableModel = new AlertEventsTableModel();
    private static final Logger LOGGER = Logger.getLogger(AlertEventsTopComponent.class.getName());
    private InstanceContent instanceContent = new InstanceContent();
    private Lookup selectedEvent = new AbstractLookup((AbstractLookup.Content)this.instanceContent);
    private DisplayOptions displayOptions = new DisplayOptions();
    private final Timer autoRefreshTimer;
    private final OverviewPanel overviewPanel = new OverviewPanel();
    private SavedQueryData queryData;
    private boolean selectLast = false;
    private AutoCompleteDecorator autoCompleteDecorator = new AutoCompleteDecorator();
    private Lookup.Result<AlertEventSearchQueryUpdate> lr = Utilities.actionsGlobalContext().lookupResult(AlertEventSearchQueryUpdate.class);
    private DateTimeFormatter isoTimeFormat = ISODateTimeFormat.dateTime().withZone(DateTimeZone.getDefault());
    private String undoQuery = "";
    private String previousQuery = "previousQuery";
    private String tag = UUID.randomUUID().toString();
    private FrontCountBarChart countChart;
    private ChartMouseListener chartMouseListener;
    private JPopupMenu popupMenu = new JPopupMenu();
    private JMenuItem miPaste = new JMenuItem(NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.miPaste.text"));
    private long startTimeOfCreatingATable = 0L;
    private final List<String> listOfCharactersToEscape = Arrays.asList("\\", "+", "-", "&&", "||", "!", "(", ")", "{", "}", "[", "]", "^", "\"", "~", "*", "?", ":");
    public static final String PROP_QUERY_CHANGED = "queryChanged";
    private JButton bBottom;
    private JButton bDisplayOptions;
    private JButton bOpenAnalysis;
    private JButton bPageDown;
    private JButton bPageUp;
    private JButton bQueryBookmarks;
    private JButton bSearch;
    private JButton bTop;
    private JToggleButton btQueryBookmarked;
    private JXCollapsiblePane cpChart;
    private JScrollPane jScrollPane;
    private JTabbedPane jTabbedPane1;
    private JXBusyLabel lLoading;
    private JLabel lQueryTime;
    private JLabel lSearchStatus;
    private JPanel pChart;
    private JPanel pResults;
    private JTable tAlertEvents;
    private JToggleButton tbDesc;
    private JTextField tfSearch;
    private ListSelectionListener lSL = new ListSelectionListener(){
        private RequestProcessor rp = new RequestProcessor("TransmitFromSERawLogSimWrapper");
        private AlertEventWrapper prevEvent = null;
        private TopComponent alertEventDetails = WindowManager.getDefault().findTopComponent("AlertEventDetailsTopComponent");

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                final SecurityEvent event = (SecurityEvent)AlertEventsTopComponent.this.tableModel.getValueAt(AlertEventsTopComponent.this.tAlertEvents.getSelectedRow(), 0);
                this.rp.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (event != null) {
                            AlertEventWrapper sew = new AlertEventWrapper(event, AlertEventsTopComponent.this.displayOptions, AlertEventsTopComponent.this.tag);
                            sew.setQuery(AlertEventsTopComponent.this.tfSearch.getText());
                            if (prevEvent != null) {
                                AlertEventsTopComponent.this.instanceContent.remove((Object)prevEvent);
                            }
                            AlertEventsTopComponent.this.instanceContent.add((Object)sew);
                            prevEvent = sew;
                        }
                    }
                });
            }
        }
    };

    public AlertEventsTopComponent() {
        LOGGER.info(String.format("%s version: %s", ModuleVersionUtils.getModuleDisplayName((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.SECURITYEVENTS), ModuleVersionUtils.getModuleVersion((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.SECURITYEVENTS)));
        this.displayOptions.load();
        this.displayOptions.setAutoRefresh(0);
        this.displayOptions.setDescOrder(true);
        this.displayOptions.setIsDescToggleButtonVisible(true);
        this.initComponents();
        this.setName(NbBundle.getMessage(AlertEventsTopComponent.class, (String)"CTL_AlertEventsTopComponent"));
        this.setToolTipText(NbBundle.getMessage(AlertEventsTopComponent.class, (String)"HINT_AlertEventsTopComponent"));
        this.bSearch.setForeground(Color.red);
        ProxyLookup mainLookup = new ProxyLookup(new Lookup[]{this.selectedEvent, this.overviewPanel.getByPriorityPanel().getSecurityEventQueryUpdateLookup()});
        this.associateLookup((Lookup)mainLookup);
        this.lr.allInstances();
        this.lr.addLookupListener(new LookupListener(){
            AlertEventSearchQueryUpdate prev = null;

            public void resultChanged(LookupEvent ev) {
                Lookup.Result lr = (Lookup.Result)ev.getSource();
                Collection instances = lr.allInstances();
                for (Object o : instances) {
                    if (!(o instanceof AlertEventSearchQueryUpdate) || !AlertEventsTopComponent.this.isVisible()) continue;
                    final AlertEventSearchQueryUpdate squ = (AlertEventSearchQueryUpdate)o;
                    if (!AlertEventsTopComponent.this.tag.equals(squ.getTag())) continue;
                    final StringBuilder query = new StringBuilder();
                    if (squ.isOverride()) {
                        query.append(squ.getQuery());
                    } else {
                        if (AlertEventsTopComponent.this.tfSearch.getText().contains("AND") && squ.getQuery().contains("OR") || AlertEventsTopComponent.this.tfSearch.getText().contains("OR") && squ.getQuery().contains("AND")) {
                            query.append("(");
                            query.append(AlertEventsTopComponent.this.tfSearch.getText());
                            query.append(")");
                        } else {
                            query.append(AlertEventsTopComponent.this.tfSearch.getText());
                        }
                        query.append(squ.getQuery());
                    }
                    if (this.prev != null && this.prev.equals(squ)) continue;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AlertEventsTopComponent.this.tfSearch.setText(query.toString());
                            prev = squ;
                        }
                    });
                }
            }
        });
        this.lQueryTime.setCursor(new Cursor(12));
        this.lQueryTime.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String query = QueryManager.makeQueryTimeQuery(AlertEventsTopComponent.this.displayOptions.getTimeStart(), AlertEventsTopComponent.this.displayOptions.getTimeFinish(), AlertEventsTopComponent.this.isoTimeFormat);
                AlertEventsTopComponent.this.tfSearch.setText(query);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.tfSearch.setColumns(1);
        this.tfSearch.addMouseListener(new MouseListener(){
            private String text = NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.tfSearch.text");

            @Override
            public void mouseClicked(MouseEvent e) {
                if (this.text.equals(AlertEventsTopComponent.this.tfSearch.getText())) {
                    AlertEventsTopComponent.this.tfSearch.setText("");
                    AlertEventsTopComponent.this.normal();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.tfSearch.addFocusListener(new FocusListener(){
            private String text = NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.tfSearch.text");

            @Override
            public void focusGained(FocusEvent e) {
                if (this.text.equals(AlertEventsTopComponent.this.tfSearch.getText())) {
                    AlertEventsTopComponent.this.tfSearch.setText("");
                    AlertEventsTopComponent.this.normal();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.tfSearch.getDocument().addDocumentListener(new DocumentListener(){
            private AlertEventWrapper prevAlertEventWrapper;

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.fireQueryChanged(e);
                this.changeButtonColor();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.fireQueryChanged(e);
                this.changeButtonColor();
                AlertEventsTopComponent.this.normal();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.fireQueryChanged(e);
                this.changeButtonColor();
            }

            private void changeButtonColor() {
                if (AlertEventsTopComponent.this.previousQuery.equals(AlertEventsTopComponent.this.tfSearch.getText())) {
                    AlertEventsTopComponent.this.bSearch.setForeground(Color.black);
                } else {
                    AlertEventsTopComponent.this.bSearch.setForeground(Color.red);
                }
            }

            private void fireQueryChanged(DocumentEvent e) {
                AlertEventsTopComponent.this.displayOptions.setQuery(AlertEventsTopComponent.this.tfSearch.getText());
                final SecurityEvent event = (SecurityEvent)AlertEventsTopComponent.this.tableModel.getValueAt(AlertEventsTopComponent.this.tAlertEvents.getSelectedRow(), 0);
                if (event != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AlertEventWrapper sew = new AlertEventWrapper(event, AlertEventsTopComponent.this.displayOptions, AlertEventsTopComponent.this.tag);
                            sew.setQuery(AlertEventsTopComponent.this.tfSearch.getText());
                            if (prevAlertEventWrapper != null) {
                                AlertEventsTopComponent.this.instanceContent.remove((Object)prevAlertEventWrapper);
                            }
                            prevAlertEventWrapper = sew;
                            AlertEventsTopComponent.this.instanceContent.add((Object)prevAlertEventWrapper);
                        }
                    });
                }
            }
        });
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SecurityEvent event = (SecurityEvent)AlertEventsTopComponent.this.tableModel.getValueAt(AlertEventsTopComponent.this.tAlertEvents.getSelectedRow(), AlertEventsTopComponent.this.tAlertEvents.getSelectedColumn());
                String category = AlertEventsTopComponent.this.tableModel.getColumnName(AlertEventsTopComponent.this.tAlertEvents.getSelectedColumn()).replace("<html><b>", "").replace("</b></html>", "");
                String query = QueryManager.copyAlertEventColumn(event, category);
                StringSelection selection = new StringSelection(query);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(selection, selection);
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(67, 2, false);
        this.tAlertEvents.registerKeyboardAction(listener, "Copy", stroke, 0);
        this.tAlertEvents.getTableHeader().setReorderingAllowed(false);
        this.tAlertEvents.setDefaultRenderer(SecurityEvent.class, new AlertEventsTableRenderer());
        this.tAlertEvents.setSelectionMode(0);
        this.tAlertEvents.setRowSelectionAllowed(true);
        this.tAlertEvents.addKeyListener(new KeyListener(){
            private RequestProcessor rp = new RequestProcessor("TransmitFromSERawLogSimWrapper");
            private AlertEventWrapper prevEvent = null;
            private TopComponent alertEventDetails = WindowManager.getDefault().findTopComponent("AlertEventDetailsTopComponent");

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int row = AlertEventsTopComponent.this.tAlertEvents.getSelectedRow();
                if (row != -1) {
                    final SecurityEvent event = (SecurityEvent)AlertEventsTopComponent.this.tableModel.getValueAt(row, 0);
                    this.rp.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (event != null) {
                                AlertEventWrapper sew = new AlertEventWrapper(event, AlertEventsTopComponent.this.displayOptions, AlertEventsTopComponent.this.tag);
                                sew.setQuery(AlertEventsTopComponent.this.tfSearch.getText());
                                if (prevEvent != null) {
                                    AlertEventsTopComponent.this.instanceContent.remove((Object)prevEvent);
                                }
                                AlertEventsTopComponent.this.instanceContent.add((Object)sew);
                                prevEvent = sew;
                            }
                        }
                    });
                }
            }
        });
        this.tAlertEvents.addMouseListener(new MouseListener(){
            private RequestProcessor rp = new RequestProcessor("TransmitFromSERawLogSimWrapper");
            private AlertEventWrapper prevEvent = null;

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = AlertEventsTopComponent.this.tAlertEvents.rowAtPoint(e.getPoint());
                if (row != -1) {
                    final SecurityEvent event = (SecurityEvent)AlertEventsTopComponent.this.tableModel.getValueAt(row, 0);
                    this.rp.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (event != null) {
                                AlertEventWrapper sew = new AlertEventWrapper(event, AlertEventsTopComponent.this.displayOptions, AlertEventsTopComponent.this.tag);
                                sew.setQuery(AlertEventsTopComponent.this.tfSearch.getText());
                                if (prevEvent != null) {
                                    AlertEventsTopComponent.this.instanceContent.remove((Object)prevEvent);
                                }
                                AlertEventsTopComponent.this.instanceContent.add((Object)sew);
                                prevEvent = sew;
                            }
                        }
                    });
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TopComponent[] openedTopComponents;
                    Mode mode = WindowManager.getDefault().findMode("properties");
                    for (TopComponent tc : openedTopComponents = WindowManager.getDefault().getOpenedTopComponents(mode)) {
                        if (!(tc instanceof AlertEventDetailsTopComponent)) continue;
                        tc.requestActive();
                        return;
                    }
                    AlertEventDetailsTopComponent details = (AlertEventDetailsTopComponent)WindowManager.getDefault().findTopComponent("AlertEventDetailsTopComponent");
                    mode.dockInto((TopComponent)details);
                    SecurityEvent event = (SecurityEvent)AlertEventsTopComponent.this.tableModel.getValueAt(AlertEventsTopComponent.this.tAlertEvents.getSelectedRow(), 0);
                    AlertEventWrapper sew = new AlertEventWrapper(event, AlertEventsTopComponent.this.displayOptions, AlertEventsTopComponent.this.tag);
                    details.setSecurityEvent(sew);
                    details.open();
                    details.requestActive();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.tfSearch.addKeyListener(new KeyAdapter(){
            KeyStroke controlV = KeyStroke.getKeyStroke(86, 2);

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == this.controlV.getKeyCode()) {
                    AlertEventsTopComponent.this.reformatQueryInClipboard();
                }
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AlertEventsTopComponent.this.startSearch();
                        }
                    });
                } else {
                    AlertEventsTopComponent.this.btQueryBookmarked.setSelected(false);
                }
            }
        });
        ActionListener undoListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlertEventsTopComponent.this.tfSearch.setText(AlertEventsTopComponent.this.undoQuery);
            }
        };
        KeyStroke strokeUndo = KeyStroke.getKeyStroke(90, 2, false);
        this.tfSearch.registerKeyboardAction(undoListener, "Undo", strokeUndo, 0);
        KeyListener undoKeyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyChar()) {
                    case ' ': 
                    case '\"': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case '-': 
                    case ':': 
                    case '[': 
                    case ']': {
                        AlertEventsTopComponent.this.updateUndoQuery();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        };
        this.tfSearch.addKeyListener(undoKeyListener);
        this.displayOptions.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AlertEventsTopComponent.this.displayOptions.save();
                AlertEventsTopComponent.this.toggleButtonDescSetSelected(AlertEventsTopComponent.this.displayOptions.isDescOrder());
                if (AlertEventsTopComponent.this.displayOptions.getAutoRefresh() == 0) {
                    AlertEventsTopComponent.this.stopAutoRefreshTimer();
                } else {
                    AlertEventsTopComponent.this.startAutoRefreshTimer();
                }
                AlertEventsTopComponent.this.startSearch();
            }
        });
        this.overviewPanel.addPropertyChangeListener(this);
        this.autoRefreshTimer = new Timer(this.displayOptions.getAutoRefresh(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlertEventsTopComponent.this.startSearch();
            }
        });
        this.tbDesc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!AlertEventsTopComponent.this.tbDesc.isSelected()) {
                    AlertEventsTopComponent.this.displayOptions.setDescOrder(false);
                    AlertEventsTopComponent.this.tbDesc.setText(NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.asc"));
                } else {
                    AlertEventsTopComponent.this.displayOptions.setDescOrder(true);
                    AlertEventsTopComponent.this.tbDesc.setText(NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.desc"));
                }
            }
        });
        this.jTabbedPane1.insertTab(NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.pOverview.TabConstraints.tabTitle", (Object[])new Object[0]), null, this.overviewPanel, "", 0);
        this.cpChart.setLayout((LayoutManager)new BorderLayout());
        this.cpChart.add((Component)this.pChart, (Object)"Center");
        this.cpChart.setCollapsed(true);
        this.chartMouseListener = new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent event) {
                ChartEntity entity = event.getEntity();
                if (entity instanceof XYItemEntity) {
                    XYItemEntity item = (XYItemEntity)event.getEntity();
                    AlertEventsTopComponent.this.countChart.getMyBarRenderer().resetSelectedItems();
                    AlertEventsTopComponent.this.countChart.getMyBarRenderer().addSelectedItem(item.getItem());
                    List<DateRange> ranges = AlertEventsTopComponent.this.searchExecutor.getSearchContext().getDateRanges();
                    DateRange dateRange = ranges.get(item.getItem());
                    AlertEventsTopComponent.this.searchExecutor.setSelectedDateRange(dateRange);
                    AlertEventsTopComponent.this.searchExecutor.getSearchContext().getSearchResults().getEvents().clear();
                    AlertEventsTopComponent.this.fetch(dateRange);
                }
            }

            public void chartMouseMoved(ChartMouseEvent event) {
            }
        };
        this.lSearchStatus.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    if (AlertEventsTopComponent.this.cpChart.isCollapsed()) {
                        AlertEventsTopComponent.this.cpChart.setCollapsed(false);
                        AlertEventsTopComponent.this.displayOptions.setChartManuallyOpened(true);
                    } else {
                        AlertEventsTopComponent.this.cpChart.setCollapsed(true);
                        AlertEventsTopComponent.this.displayOptions.setChartManuallyOpened(false);
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.tfSearch.add(this.popupMenu);
        this.tfSearch.setComponentPopupMenu(this.popupMenu);
        this.miPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlertEventsTopComponent.this.reformatQueryInClipboard();
                AlertEventsTopComponent.this.tfSearch.paste();
            }
        });
        this.popupMenu.add(this.miPaste);
        AbstractAction searchAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlertEventsTopComponent.this.startSearch();
            }
        };
        this.bSearch.setAction(searchAction);
        searchAction.putValue("AcceleratorKey", 116);
        this.bSearch.setText(NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.bSearch.text"));
        this.bSearch.getActionMap().put("searchAction", searchAction);
        KeyStroke keyStrokeForSearch = KeyStroke.getKeyStroke(116, 0);
        this.bSearch.getInputMap(2).put(keyStrokeForSearch, "searchAction");
    }

    private void reformatQueryInClipboard() {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            String s = (String)cb.getData(DataFlavor.stringFlavor);
            s = s.replaceAll("\\n|\\t|\\r", "");
            s = s.replaceAll(" \\\\", " ");
            s = s.replaceAll("\\\\\"", "\"");
            StringSelection stringSelection = new StringSelection(s);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        }
        catch (UnsupportedFlavorException | IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "PROP_TOTAL_HITS": {
                this.updateCountSearchStatus();
                break;
            }
            case "PROP_EVENTS": {
                List events = (List)evt.getNewValue();
                this.tableModel.setData(events);
                LOGGER.info(String.format("CREATION OF A TABLE IS FINISHED IN %d ms", System.currentTimeMillis() - this.startTimeOfCreatingATable));
                this.selectItemInTable();
                break;
            }
            case "PROP_COUNT_TASK_FINISHED": {
                this.updateCountSearchStatus();
                this.pChart.removeAll();
                if (this.searchExecutor.getSearchContext().getDateRanges().size() > 1) {
                    this.pChart.add((Component)this.createChart(this.createDataset()));
                    if (this.cpChart.isCollapsed() && this.displayOptions.isChartManuallyOpened()) {
                        this.cpChart.setCollapsed(false);
                    }
                } else {
                    List<DateRange> ranges = this.searchExecutor.getSearchContext().getDateRanges();
                    this.searchExecutor.setSelectedDateRange(ranges.get(0));
                }
                this.fetch((DateRange)evt.getNewValue());
                break;
            }
            case "PROP_FETCH_TASK_FINISHED": {
                this.updateCountSearchStatus();
                try {
                    this.searchExecutor.count();
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                break;
            }
            case "PROP_COUNT_TASK_FINISHED_SUCCESS": {
                if (!this.searchExecutor.getSearchContext().getTaskMonitor().isAllCountTasksCompleted() || this.countChart == null) break;
                List<DateRange> dateRanges = this.searchExecutor.getSearchContext().getDateRanges();
                DateRange dt = (DateRange)evt.getNewValue();
                this.countChart.getMyBarRenderer().removeFailedItem(dateRanges.indexOf(dt));
                break;
            }
            case "PROP_COUNT_TASK_SKIPPED": {
                SkippedTaskInfo sti = (SkippedTaskInfo)evt.getNewValue();
                LOGGER.info(String.format("Date Range skipped: s: %s, f: %s", new DateTime(sti.getStartTimeStamp()), new DateTime(sti.getFinishTimeStamp())));
                if (this.searchExecutor.getSearchContext().getTaskMonitor().isAllCountTasksCompleted()) {
                    this.searchExecutor.submitSkippedTaskWithBackoff(TaskMonitor.BaseTaskName.COUNT.getBaseTaskName(), sti);
                } else {
                    this.searchExecutor.addTaskToSkippedTask(sti);
                }
                if (this.countChart == null) break;
                List<DateRange> dateRanges = this.searchExecutor.getSearchContext().getDateRanges();
                DateRange dt = sti.getDateRange();
                this.countChart.getMyBarRenderer().addFailedItem(dateRanges.indexOf(dt));
                break;
            }
            case "PROP_ALL_COUNT_TASKS_FINISHED": {
                LOGGER.info("PROP_ALL_COUNT_TASKS_FINISHED");
                List<SkippedTaskInfo> tasks = this.searchExecutor.getSearchContext().getSkippedTasks();
                for (SkippedTaskInfo ski : tasks) {
                    this.searchExecutor.submitSkippedTaskWithBackoff(TaskMonitor.BaseTaskName.COUNT.getBaseTaskName(), ski);
                }
                this.searchExecutor.getSearchContext().getSkippedTasks().clear();
                break;
            }
            case "PROP_ALL_SKIPPED_COUNT_TASKS_FINISHED": {
                LOGGER.info("PROP_ALL_SKIPPED_COUNT_TASKS_FINISHED");
            }
            case "PROP_ALL_FETCH_TASKS_FINISHED": {
                LOGGER.info("PROP_ALL_FETCH_TASKS_FINISHED");
                break;
            }
            case "PROP_ALL_TASKS_FINISHED": {
                this.updateCountSearchStatus();
                if (this.countChart != null) {
                    this.countChart.getChartPanel().addChartMouseListener(this.chartMouseListener);
                }
                this.lLoading.setBusy(false);
                LOGGER.info("ALL TASKS ARE COMPLETED");
                this.searchExecutor.getSearchContext().getSearchResults().setAccumulateTotalDuration(false);
                this.bPageUp.setEnabled(true);
                this.bPageDown.setEnabled(true);
                this.bTop.setEnabled(true);
                this.bBottom.setEnabled(true);
                if (this.displayOptions.isShowOverview()) {
                    this.setMappingsInOverviewPanel();
                }
                this.queryHistory.put(this.tfSearch.getText());
                break;
            }
            case "PROP_FETCH_TASK_FAILED": 
            case "PROP_COUNT_TASK_FAILED": {
                this.updateCountSearchStatus();
                List errors = (List)evt.getNewValue();
                LOGGER.info(String.format("TASK FAILED: %s", errors));
                this.lLoading.setBusy(false);
                this.searchExecutor.shutdown();
                this.bPageUp.setEnabled(true);
                this.bPageDown.setEnabled(true);
                this.bTop.setEnabled(true);
                this.bBottom.setEnabled(true);
                break;
            }
            case "PROP_FETCH_TASK_FINISHED_SUCCESS": {
                if (this.countChart == null || this.searchExecutor.getSearchContext().getTaskMonitor().isAllTasksCompleted()) break;
                LOGGER.info("PROP_FETCH_TASK_FINISHED_SUCCESS");
                DateRange dateRange = (DateRange)evt.getNewValue();
                List<DateRange> ranges = this.searchExecutor.getSearchContext().getDateRanges();
                int index = ranges.indexOf(dateRange);
                this.searchExecutor.setSelectedDateRange(ranges.get(index));
                this.countChart.getMyBarRenderer().addSelectedItem(index);
                this.countChart.updateChart(this.createDataset());
                this.countChart.getChartPanel().repaint();
                this.pChart.invalidate();
                this.pChart.repaint();
                break;
            }
            case "PROP_NEXT_PREV_MESSAGE": {
                JOptionPane.showMessageDialog((Component)((Object)this), evt.getNewValue());
                break;
            }
            case "PROP_FIRST_LAST_MESSAGE": {
                JOptionPane.showMessageDialog((Component)((Object)this), evt.getNewValue());
                break;
            }
            case "FILTER_OUT_QUERY": {
                StringBuilder query = new StringBuilder();
                if ((OverviewPanel.FilterOutParameters)evt.getNewValue() == null) break;
                OverviewPanel.FilterOutParameters parameters = (OverviewPanel.FilterOutParameters)evt.getNewValue();
                if (!this.tfSearch.getText().isEmpty()) {
                    query.append(this.appendFilterOutQuery(parameters.getEvents(), parameters.getField()));
                } else {
                    query.append(this.makeFilterOutQuery(parameters.getEvents(), parameters.getField()));
                }
                this.tfSearch.setText(query.toString());
            }
        }
    }

    private String escapeSpecialCharacters(String text) {
        for (String escape : this.listOfCharactersToEscape) {
            text = text.replace(escape, "\\" + escape);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\"").append(text).append("\"");
        text = sb.toString();
        return text;
    }

    private String appendFilterOutQuery(List<String> values, String field) {
        int i;
        String actualQuery = this.tfSearch.getText();
        if (actualQuery.length() >= 6000) {
            JOptionPane.showMessageDialog(null, "Query reached a maximum length value. It's not possible to append a new query.", "Query length exceeded", 2);
            return actualQuery;
        }
        StringBuilder sb = new StringBuilder();
        int startIndex = -1;
        int endIndex = -1;
        String[] split = field.split("\\.");
        Pattern pattern = Pattern.compile(split[0] + "\\." + split[1] + ":\\(");
        Matcher matcher = pattern.matcher(actualQuery);
        while (matcher.find()) {
            startIndex = matcher.end();
        }
        if (startIndex != -1) {
            for (i = startIndex; i < actualQuery.length(); ++i) {
                if (actualQuery.charAt(i) != ')') continue;
                endIndex = i;
            }
        }
        if (endIndex != -1) {
            sb.append(actualQuery.substring(0, endIndex));
            sb.append(", ");
            for (i = 0; i < values.size(); ++i) {
                String value = this.escapeSpecialCharacters(values.get(i));
                sb.append(value);
                if (i == values.size() - 1) continue;
                sb.append(", ");
            }
            sb.append(actualQuery.substring(endIndex));
        } else {
            sb.append(actualQuery);
            sb.append(" AND ");
            sb.append(this.makeFilterOutQuery(values, field));
        }
        return sb.toString();
    }

    private String makeFilterOutQuery(List<String> values, String field) {
        if (this.tfSearch.getText().length() >= 6000) {
            JOptionPane.showMessageDialog(null, "Query reached a maximum length. It's not possible to append a new query.", "Query length exceeded", 2);
            return this.tfSearch.getText();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("NOT ");
        sb.append(field);
        sb.append(":(");
        for (int i = 0; i < values.size(); ++i) {
            String value = this.escapeSpecialCharacters(values.get(i));
            sb.append(value);
            if (i == values.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    private void setMappingsInOverviewPanel() {
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        TreeSet what = new TreeSet((a, b) -> {
            int insensitive = String.CASE_INSENSITIVE_ORDER.compare(a, b);
            return insensitive == 0 ? a.compareTo((String)b) : insensitive;
        });
        TreeSet who = new TreeSet((a, b) -> {
            int insensitive = String.CASE_INSENSITIVE_ORDER.compare(a, b);
            return insensitive == 0 ? a.compareTo((String)b) : insensitive;
        });
        TreeSet where = new TreeSet((a, b) -> {
            int insensitive = String.CASE_INSENSITIVE_ORDER.compare(a, b);
            return insensitive == 0 ? a.compareTo((String)b) : insensitive;
        });
        TreeSet when = new TreeSet((a, b) -> {
            int insensitive = String.CASE_INSENSITIVE_ORDER.compare(a, b);
            return insensitive == 0 ? a.compareTo((String)b) : insensitive;
        });
        TreeSet extra = new TreeSet((a, b) -> {
            int insensitive = String.CASE_INSENSITIVE_ORDER.compare(a, b);
            return insensitive == 0 ? a.compareTo((String)b) : insensitive;
        });
        List<SecurityEvent> events = this.searchExecutor.getSearchContext().getSearchResults().getEvents();
        events.forEach(e -> {
            e.getWhat().getEntry().forEach(w -> what.add("what." + w.getKey()));
            e.getExtra().getEntry().forEach(w -> extra.add("extra." + w.getKey()));
            e.getWhen().getEntry().forEach(w -> when.add("when." + w.getKey()));
            e.getWhere().getEntry().forEach(w -> where.add("where." + w.getKey()));
            e.getWho().getEntry().forEach(w -> who.add("who." + w.getKey()));
        });
        fields.addAll(what);
        fields.addAll(who);
        fields.addAll(where);
        fields.addAll(when);
        fields.addAll(extra);
        this.overviewPanel.setMappingsInWidgetSettigsPanels(fields);
    }

    private void startAutoRefreshTimer() {
        if (this.displayOptions.getAutoRefresh() > 0) {
            this.autoRefreshTimer.setInitialDelay(this.displayOptions.getAutoRefresh() * 1000 * 60);
            this.autoRefreshTimer.setDelay(this.displayOptions.getAutoRefresh() * 1000 * 60);
            this.autoRefreshTimer.setRepeats(true);
            this.autoRefreshTimer.start();
        }
    }

    private void stopAutoRefreshTimer() {
        this.autoRefreshTimer.stop();
    }

    private void updateUndoQuery() {
        this.undoQuery = this.tfSearch.getText();
    }

    public void italic() {
        Font font = new Font("Dialog", 2, 12);
        this.tfSearch.setFont(font);
        this.tfSearch.setForeground(new Color(204, 204, 204));
    }

    public void normal() {
        Font font = new Font("Dialog", 0, 12);
        this.tfSearch.setFont(font);
        this.tfSearch.setForeground(Color.BLACK);
    }

    public void setAsc() {
        this.tbDesc.setSelected(false);
    }

    public boolean isAsc() {
        return this.tbDesc.isSelected();
    }

    private void initComponents() {
        this.pChart = new JPanel();
        this.tfSearch = new JTextField();
        this.bSearch = new JButton();
        this.bDisplayOptions = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.pResults = new JPanel();
        this.jScrollPane = new JScrollPane();
        this.tAlertEvents = new JTable();
        this.bTop = new JButton();
        this.bPageUp = new JButton();
        this.bBottom = new JButton();
        this.bPageDown = new JButton();
        this.bQueryBookmarks = new JButton();
        this.btQueryBookmarked = new JToggleButton();
        this.lQueryTime = new JLabel();
        this.lSearchStatus = new JLabel();
        this.tbDesc = new JToggleButton();
        this.lLoading = new JXBusyLabel();
        this.cpChart = new JXCollapsiblePane();
        this.bOpenAnalysis = new JButton();
        this.pChart.setFont(new Font("Dialog", 0, 8));
        this.pChart.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
        this.pChart.setMinimumSize(new Dimension(0, 100));
        this.pChart.setPreferredSize(new Dimension(0, 100));
        this.pChart.setLayout(new BorderLayout());
        this.tfSearch.setFont(new Font("Dialog", 2, 12));
        this.tfSearch.setForeground(new Color(204, 204, 204));
        this.tfSearch.setText(NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.tfSearch.text", (Object[])new Object[0]));
        this.bSearch.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.bSearch, (String)NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.bSearch.text"));
        this.bDisplayOptions.setIcon(new ImageIcon(this.getClass().getResource("/wrench_orange.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bDisplayOptions, (String)NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.bDisplayOptions.text"));
        this.bDisplayOptions.setToolTipText(NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.bDisplayOptions.toolTipText"));
        this.bDisplayOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlertEventsTopComponent.this.bDisplayOptionsActionPerformed(evt);
            }
        });
        this.jTabbedPane1.setFont(new Font("Dialog", 0, 12));
        this.tAlertEvents.setModel(this.tableModel);
        this.jScrollPane.setViewportView(this.tAlertEvents);
        this.bTop.setIcon(new ImageIcon(this.getClass().getResource("/bullet_arrow_top.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bTop, (String)NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.bTop.text", (Object[])new Object[0]));
        this.bTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlertEventsTopComponent.this.bTopActionPerformed(evt);
            }
        });
        this.bPageUp.setIcon(new ImageIcon(this.getClass().getResource("/bullet_arrow_up.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bPageUp, (String)NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.bPageUp.text", (Object[])new Object[0]));
        this.bPageUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlertEventsTopComponent.this.bPageUpActionPerformed(evt);
            }
        });
        this.bBottom.setIcon(new ImageIcon(this.getClass().getResource("/bullet_arrow_bottom.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bBottom, (String)NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.bBottom.text", (Object[])new Object[0]));
        this.bBottom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlertEventsTopComponent.this.bBottomActionPerformed(evt);
            }
        });
        this.bPageDown.setIcon(new ImageIcon(this.getClass().getResource("/bullet_arrow_down.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bPageDown, (String)NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.bPageDown.text", (Object[])new Object[0]));
        this.bPageDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlertEventsTopComponent.this.bPageDownActionPerformed(evt);
            }
        });
        GroupLayout pResultsLayout = new GroupLayout(this.pResults);
        this.pResults.setLayout(pResultsLayout);
        pResultsLayout.setHorizontalGroup(pResultsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pResultsLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane, -1, 898, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pResultsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bBottom, GroupLayout.Alignment.TRAILING, -2, 30, -2).addComponent(this.bPageDown, GroupLayout.Alignment.TRAILING, -2, 30, -2).addComponent(this.bPageUp, GroupLayout.Alignment.TRAILING, -2, 30, -2).addComponent(this.bTop, GroupLayout.Alignment.TRAILING, -2, 30, -2)).addContainerGap()));
        pResultsLayout.setVerticalGroup(pResultsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pResultsLayout.createSequentialGroup().addContainerGap().addGroup(pResultsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pResultsLayout.createSequentialGroup().addComponent(this.bTop).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bPageUp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.bPageDown).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bBottom)).addComponent(this.jScrollPane, -1, 392, Short.MAX_VALUE)).addContainerGap()));
        this.jTabbedPane1.addTab(NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.pResults.TabConstraints.tabTitle", (Object[])new Object[0]), this.pResults);
        this.bQueryBookmarks.setIcon(new ImageIcon(this.getClass().getResource("/folder_star.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bQueryBookmarks, (String)NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.bQueryBookmarks.text"));
        this.bQueryBookmarks.setToolTipText(NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.bQueryBookmarks.toolTipText"));
        this.bQueryBookmarks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlertEventsTopComponent.this.bQueryBookmarksActionPerformed(evt);
            }
        });
        this.btQueryBookmarked.setIcon(new ImageIcon(this.getClass().getResource("/star.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btQueryBookmarked, (String)NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.btQueryBookmarked.text"));
        this.btQueryBookmarked.setToolTipText(NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.btQueryBookmarked.toolTipText"));
        this.btQueryBookmarked.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlertEventsTopComponent.this.btQueryBookmarkedActionPerformed(evt);
            }
        });
        this.lQueryTime.setFont(new Font("Dialog", 0, 12));
        this.lQueryTime.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.lQueryTime, (String)NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.lQueryTime.text"));
        this.lSearchStatus.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.lSearchStatus, (String)NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.lSearchStatus.text", (Object[])new Object[]{0, 0}));
        this.tbDesc.setFont(new Font("Dialog", 0, 12));
        this.tbDesc.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.tbDesc, (String)NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.tbDesc.text"));
        this.tbDesc.setMargin(new Insets(2, 2, 2, 2));
        Mnemonics.setLocalizedText((JLabel)this.lLoading, (String)NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.lLoading.text"));
        this.lLoading.setDirection(BusyPainter.Direction.RIGHT);
        this.cpChart.setCollapsed(true);
        this.bOpenAnalysis.setIcon(new ImageIcon(this.getClass().getResource("/bar_chart.png")));
        this.bOpenAnalysis.setToolTipText(NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.bOpenAnalysis.toolTipText"));
        this.bOpenAnalysis.setEnabled(false);
        this.bOpenAnalysis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlertEventsTopComponent.this.bOpenAnalysisActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.cpChart, -1, -1, Short.MAX_VALUE).addComponent(this.jTabbedPane1).addGroup(layout.createSequentialGroup().addComponent((Component)this.lLoading, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfSearch, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tbDesc).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bSearch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bOpenAnalysis, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bQueryBookmarks, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btQueryBookmarked, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bDisplayOptions, -2, 30, -2)).addGroup(layout.createSequentialGroup().addComponent(this.lSearchStatus, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lQueryTime, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bSearch).addComponent(this.tbDesc)).addComponent(this.bDisplayOptions, -1, -1, Short.MAX_VALUE).addComponent(this.bQueryBookmarks, -1, -1, Short.MAX_VALUE).addComponent(this.btQueryBookmarked, -1, -1, Short.MAX_VALUE).addComponent(this.tfSearch)).addComponent((Component)this.lLoading, -2, -1, -2).addComponent(this.bOpenAnalysis)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lSearchStatus, -1, -1, Short.MAX_VALUE).addComponent(this.lQueryTime, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.cpChart, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1).addContainerGap()));
    }

    private void bDisplayOptionsActionPerformed(ActionEvent evt) {
        DisplayOptionsDisplayer.display(this.displayOptions);
    }

    private void bPageDownActionPerformed(ActionEvent evt) {
        try {
            this.searchExecutor.next();
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void bBottomActionPerformed(ActionEvent evt) {
        try {
            this.searchExecutor.last();
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void bPageUpActionPerformed(ActionEvent evt) {
        try {
            this.searchExecutor.prev();
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void bTopActionPerformed(ActionEvent evt) {
        try {
            this.searchExecutor.first();
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void btQueryBookmarkedActionPerformed(ActionEvent evt) {
        try {
            if (this.btQueryBookmarked.isSelected() && !this.tfSearch.getText().isEmpty()) {
                final QuerySetNamePanel panel = new QuerySetNamePanel();
                DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(AlertEventsTopComponent.class, (String)"SetQueryName.dialog.title"), true, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int opt = (Integer)e.getSource();
                        if (DialogDescriptor.OK_OPTION.equals(opt)) {
                            SavedQueryData q = new SavedQueryData();
                            q.setName(panel.getTypedName());
                            q.setQuery(AlertEventsTopComponent.this.tfSearch.getText());
                            q.setType(SavedQueryDataType.SECURITY_EVENTS_QUERY);
                            q.setId(DigestUtils.md5Hex((String)String.format("%s%s", q.getQuery(), q.getType())));
                            try {
                                AlertEventsTopComponent.this.apiService.saveSavedQuery(q);
                            }
                            catch (ApiServiceException_Exception ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                });
                DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            } else if (this.queryData != null) {
                this.apiService.deleteSavedQuery(this.queryData.getId());
            }
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void bQueryBookmarksActionPerformed(ActionEvent evt) {
        ArrayList<SavedQueryData> queries;
        try {
            queries = this.apiService.getSecurityEventQueries();
        }
        catch (ApiServiceException_Exception ex) {
            queries = new ArrayList<SavedQueryData>();
            Exceptions.printStackTrace((Throwable)ex);
        }
        final SavedQueryDataDialog dialog = new SavedQueryDataDialog();
        dialog.setData(queries);
        dialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
        dialog.setVisible(true);
        dialog.setDefaultCloseOperation(2);
        dialog.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                SavedQueryData selectedQueryBookmark = dialog.getSelectedQueryBookmark();
                if (selectedQueryBookmark != null) {
                    AlertEventsTopComponent.this.queryData = selectedQueryBookmark;
                    AlertEventsTopComponent.this.tfSearch.setText(dialog.getSelectedQueryBookmark().getQuery());
                    AlertEventsTopComponent.this.btQueryBookmarked.setSelected(true);
                    AlertEventsTopComponent.this.startSearch();
                } else {
                    AlertEventsTopComponent.this.btQueryBookmarked.setSelected(false);
                }
            }
        });
    }

    private void bOpenAnalysisActionPerformed(ActionEvent evt) {
        AnalysisTopComponent analysisTopComponent = (AnalysisTopComponent)WindowManager.getDefault().findTopComponent("AlertAnalysisTopComponent");
        if (analysisTopComponent == null) {
            analysisTopComponent = new AnalysisTopComponent();
        }
        analysisTopComponent.updateDisplayOptions(this.displayOptions);
        analysisTopComponent.doSearch(this.previousQuery);
        analysisTopComponent.open();
        analysisTopComponent.requestActive();
    }

    public void componentOpened() {
        this.startAutoRefreshTimer();
        this.queryHistory.init();
        this.autoCompleteDecorator.autoComplete(this.tfSearch, this.getMappings());
    }

    public void componentClosed() {
        this.stopAutoRefreshTimer();
        if (this.searchExecutor != null) {
            this.searchExecutor.shutdown();
        }
    }

    private Set<String> getMappings() {
        HashSet<String> items = new HashSet<String>();
        try {
            Map mappings = this.apiService.getMappings();
            if (mappings != null) {
                for (String cat : mappings.keySet()) {
                    if (!cat.equalsIgnoreCase("who") && !cat.equalsIgnoreCase("what") && !cat.equalsIgnoreCase("where") && !cat.equalsIgnoreCase("when") && !cat.equalsIgnoreCase("extra")) continue;
                    for (String field : (List)mappings.get(cat)) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(cat);
                        sb.append(".");
                        sb.append(field);
                        items.add(sb.toString());
                    }
                }
            }
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return items;
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
        p.setProperty("tse_col_count", String.valueOf(this.tAlertEvents.getColumnModel().getColumnCount()));
        for (int i = 0; i < this.tAlertEvents.getColumnModel().getColumnCount(); ++i) {
            TableColumn tc = this.tAlertEvents.getColumnModel().getColumn(i);
            p.setProperty(String.format("tse_col%d_width", i), String.valueOf(tc.getWidth()));
        }
        p.setProperty("search_string", this.tfSearch.getText());
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
        String colCountString = p.getProperty("tse_col_count");
        LOGGER.fine(String.format("Version: %s, colCount: %s", version, colCountString));
        try {
            int colCount = colCountString != null ? Integer.valueOf(colCountString) : 0;
            for (int i = 0; i < colCount; ++i) {
                String s = p.getProperty("tse_col" + i + "_width");
                LOGGER.fine(String.format("tse_col_%d_width: %s", i, s));
                if (s == null) continue;
                this.tAlertEvents.getColumnModel().getColumn(i).setPreferredWidth(Integer.valueOf(s));
            }
            this.tfSearch.setText(p.getProperty("search_string"));
        }
        catch (NumberFormatException ex) {
            LOGGER.warning(String.format("Error converting to number: %s", ex.getMessage()));
        }
        this.tfSearchChangeFont();
    }

    private void tfSearchChangeFont() {
        String text = NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.tfSearch.text");
        if (text.equals(this.tfSearch.getText())) {
            Font font = new Font("Dialog", 2, 12);
            this.tfSearch.setFont(font);
            this.tfSearch.setForeground(Color.LIGHT_GRAY);
        } else {
            Font font = new Font("Dialog", 0, 12);
            this.tfSearch.setFont(font);
            this.tfSearch.setForeground(Color.BLACK);
        }
    }

    private void selectLastItemInTableAndScroll() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int rowCount = AlertEventsTopComponent.this.tAlertEvents.getRowCount() - 1;
                AlertEventsTopComponent.this.tAlertEvents.setRowSelectionInterval(rowCount, 0);
                AlertEventsTopComponent.this.tAlertEvents.changeSelection(rowCount, 0, false, false);
                AlertEventsTopComponent.this.tAlertEvents.scrollRectToVisible(new Rectangle(AlertEventsTopComponent.this.tAlertEvents.getCellRect(rowCount, 0, true)));
                AlertEventsTopComponent.this.lSL.valueChanged(new ListSelectionEvent(AlertEventsTopComponent.this.tAlertEvents, rowCount, 0, false));
            }
        });
    }

    private void updateCountSearchStatus() {
        if (this.searchExecutor != null) {
            List<String> errors = this.searchExecutor.getSearchContext().getSearchResults().getErrors();
            long totalDuration = this.searchExecutor.getSearchContext().getSearchResults().getTotalDuration();
            if (!errors.isEmpty()) {
                this.lSearchStatus.setIcon(new ImageIcon(this.getClass().getResource("/delete.png")));
                StringBuilder sb = new StringBuilder();
                for (String err : errors) {
                    sb.append(err);
                    sb.append(", ");
                }
                if (sb.toString().length() > 2) {
                    sb.replace(sb.toString().length() - 2, sb.toString().length(), "");
                }
                String error = NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.lSearchStatus.failed.text", (Object[])new Object[]{totalDuration, sb.toString()});
                this.lSearchStatus.setToolTipText(error);
            } else {
                this.lSearchStatus.setIcon(null);
                this.lSearchStatus.setToolTipText("");
                this.bSearch.setForeground(Color.black);
            }
            this.lSearchStatus.setText(NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.lSearchStatus.text.label", (Object[])new Object[]{totalDuration, this.searchExecutor.getSearchContext().getSearchResults().getTotalHits()}));
        }
    }

    private void selectItemInTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AlertEventsTopComponent.this.tAlertEvents.getRowCount() > 0) {
                    if (AlertEventsTopComponent.this.selectLast) {
                        AlertEventsTopComponent.this.selectLastItemInTableAndScroll();
                        AlertEventsTopComponent.this.selectLast = false;
                    } else if (!AlertEventsTopComponent.this.tAlertEvents.isRowSelected(0)) {
                        AlertEventsTopComponent.this.tAlertEvents.setRowSelectionInterval(0, 0);
                        AlertEventsTopComponent.this.tAlertEvents.changeSelection(0, 0, false, false);
                        AlertEventsTopComponent.this.lSL.valueChanged(new ListSelectionEvent(AlertEventsTopComponent.this.tAlertEvents, 0, 0, false));
                    }
                }
            }
        });
    }

    private void updateSearchTime() {
        this.lQueryTime.setText(NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.lQueryTime.text.label", (Object[])new Object[]{this.isoTimeFormat.print(this.displayOptions.getTimeStart()), this.isoTimeFormat.print(this.displayOptions.getTimeFinish())}));
    }

    public void doSearch(String query) {
        this.tfSearch.setText(query);
        this.startSearch();
    }

    public void doSearch(String query, long start, long finish) {
        this.displayOptions.setTimeStart(start);
        this.displayOptions.setTimeFinish(finish);
        this.doSearch(query);
    }

    public String getTag() {
        return this.tag;
    }

    public DisplayOptions getDisplayOptions() {
        return this.displayOptions;
    }

    public void startSearch() {
        if (this.countChart != null) {
            this.countChart.getChartPanel().removeChartMouseListener(this.chartMouseListener);
            this.countChart = null;
        }
        this.cpChart.setCollapsed(true);
        this.tableModel.clearData();
        this.startTimeOfCreatingATable = System.currentTimeMillis();
        if (this.searchExecutor != null) {
            this.searchExecutor.shutdown();
        }
        this.bPageUp.setEnabled(false);
        this.bPageDown.setEnabled(false);
        this.bTop.setEnabled(false);
        this.bBottom.setEnabled(false);
        this.lQueryTime.setText(NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.lQueryTime.text.CalculatingTimestamps"));
        this.lSearchStatus.setText(NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.lQueryTime.text.PreparingSearch"));
        this.displayOptions.adjustTime();
        if (this.tfSearch.getText().equals(NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.tfSearch.text"))) {
            this.tfSearch.setText("");
            this.normal();
        }
        this.jTabbedPane1.setEnabledAt(0, this.displayOptions.isShowOverview());
        if (!this.displayOptions.isShowOverview()) {
            this.jTabbedPane1.setSelectedIndex(1);
        }
        try {
            LOGGER.info(String.format("START SEARCH: s: %s f: %s", new DateTime(this.displayOptions.getTimeStart()), new DateTime(this.displayOptions.getTimeFinish())));
            this.lLoading.setBusy(true);
            this.searchExecutor = new SearchExecutor(this.tfSearch.getText(), this.displayOptions.getTimeStart(), this.displayOptions.getTimeFinish(), this.displayOptions.getIndexSplit(), this.displayOptions.getPageSize(), !this.tbDesc.isSelected(), this);
            this.searchExecutor.startSearch();
            this.updateSearchTime();
            this.setDisplayName(TopComponentTitleShortener.shortenTitle(this.searchExecutor.ifQueryIsEmptySetToDefault(this.tfSearch.getText())));
            this.startAutoRefreshTimer();
            this.previousQuery = this.tfSearch.getText();
            if (!this.bOpenAnalysis.isEnabled()) {
                this.bOpenAnalysis.setEnabled(true);
            }
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (this.displayOptions.isShowOverview()) {
            this.overviewPanel.update(this.searchExecutor.ifQueryIsEmptySetToDefault(this.tfSearch.getText()), this.displayOptions);
        }
        this.updateUndoQuery();
    }

    private void fetch(DateRange dr) {
        try {
            this.searchExecutor.fetch(dr);
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private ChartPanel createChart(TimeTableXYDataset dataset) {
        if (this.countChart == null) {
            MyStackedXYBarRenderer renderer = new MyStackedXYBarRenderer();
            this.countChart = new FrontCountBarChart(dataset, renderer);
            ChartPanel chartPanel = this.countChart.getChartPanel();
            chartPanel.getChart().removeLegend();
        } else {
            this.countChart.updateChart(dataset);
            this.pChart.invalidate();
            this.pChart.repaint();
        }
        return this.countChart.getChartPanel();
    }

    private TimeTableXYDataset createDataset() {
        long startCreating = System.currentTimeMillis();
        TimeTableXYDataset dataset = new TimeTableXYDataset();
        dataset.setDomainIsPointsInTime(true);
        Map<DateRange, SearchState> searchStateForDateRange = this.searchExecutor.getSearchContext().getSearchStateForDateRange();
        for (DateRange dr : searchStateForDateRange.keySet()) {
            SearchState ss = searchStateForDateRange.get(dr);
            if (ss.getTotalHits() == null) continue;
            long totalHits = ss.getTotalHits();
            if (ss.getTotalHits() == -1L) {
                long m;
                totalHits = m = this.searchExecutor.getAverageCountValueForGraph();
            }
            dataset.add((TimePeriod)new SimpleTimePeriod(dr.getStartTimeStamp(), dr.getFinishTimeStamp()), (double)totalHits, (Comparable)((Object)""));
        }
        LOGGER.info(String.format("CREATION OF DATASET IS FINISHED IN %d ms", System.currentTimeMillis() - startCreating));
        return dataset;
    }

    private void toggleButtonDescSetSelected(boolean isDescSelected) {
        if (isDescSelected) {
            this.tbDesc.setSelected(true);
            this.tbDesc.setText(NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.desc"));
        } else {
            this.tbDesc.setSelected(false);
            this.tbDesc.setText(NbBundle.getMessage(AlertEventsTopComponent.class, (String)"AlertEventsTopComponent.asc"));
        }
        this.tbDesc.repaint();
    }
}

