/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.netbeans.core.startup.TopLogging;
import org.netbeans.core.startup.logging.NbLogging;
import org.openide.util.NbBundle;
import org.xml.sax.SAXParseException;

public final class NbFormatter
extends Formatter {
    private static String lineSeparator = System.getProperty("line.separator");
    public static final Formatter FORMATTER = new NbFormatter();
    private static final Map<Throwable, Integer> catchIndex = Collections.synchronizedMap(new WeakHashMap());

    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        this.print(sb, record, new HashSet<Throwable>());
        String r = sb.toString();
        if (NbLogging.DEBUG != null) {
            NbLogging.DEBUG.print("received: " + r);
        }
        if (NbLogging.unwantedMessages != null && NbLogging.unwantedMessages.matcher(r).find()) {
            new Exception().printStackTrace(NbLogging.DEBUG);
        }
        return r;
    }

    private void print(StringBuilder sb, LogRecord record, Set<Throwable> beenThere) {
        String message = this.formatMessage(record);
        if (message != null && message.indexOf(10) != -1 && record.getThrown() == null) {
            sb.append(message);
            if (message.charAt(message.length() - 1) != '\n') {
                sb.append(lineSeparator);
            }
            return;
        }
        if ("stderr".equals(record.getLoggerName()) && record.getLevel() == Level.INFO) {
            sb.append(message);
            return;
        }
        sb.append(record.getLevel().getName());
        NbFormatter.addLoggerName(sb, record);
        if (message != null) {
            sb.append(": ");
            sb.append(message);
        }
        sb.append(lineSeparator);
        if (record.getThrown() != null && record.getLevel().intValue() != 1973) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                NbFormatter.printStackTrace(record.getThrown(), pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
            LogRecord[] arr = NbFormatter.extractDelegates(sb, record.getThrown(), beenThere);
            if (arr != null) {
                for (LogRecord r : arr) {
                    this.print(sb, r, beenThere);
                }
            }
            this.specialProcessing(sb, record.getThrown(), beenThere);
        }
    }

    private static void addLoggerName(StringBuilder sb, LogRecord record) {
        String name = record.getLoggerName();
        if (!"".equals(name)) {
            sb.append(" [");
            sb.append(name);
            sb.append(']');
        }
    }

    private static LogRecord[] extractDelegates(StringBuilder sb, Throwable t, Set<Throwable> beenThere) {
        if (!beenThere.add(t)) {
            sb.append("warning: cyclic dependency between annotated throwables");
            return null;
        }
        if (t instanceof Callable) {
            Object rec = null;
            try {
                rec = ((Callable)((Object)t)).call();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (rec instanceof LogRecord[]) {
                return rec;
            }
        }
        if (t == null) {
            return null;
        }
        return NbFormatter.extractDelegates(sb, t.getCause(), beenThere);
    }

    private void specialProcessing(StringBuilder sb, Throwable t, Set<Throwable> beenThere) {
        if (t instanceof MissingResourceException) {
            String k;
            MissingResourceException mre = (MissingResourceException)t;
            String cn = mre.getClassName();
            if (cn != null) {
                LogRecord rec = new LogRecord(Level.CONFIG, null);
                rec.setResourceBundle(NbBundle.getBundle(TopLogging.class));
                rec.setMessage("EXC_MissingResourceException_class_name");
                rec.setParameters(new Object[]{cn});
                this.print(sb, rec, beenThere);
            }
            if ((k = mre.getKey()) != null) {
                LogRecord rec = new LogRecord(Level.CONFIG, null);
                rec.setResourceBundle(NbBundle.getBundle(TopLogging.class));
                rec.setMessage("EXC_MissingResourceException_key");
                rec.setParameters(new Object[]{k});
                this.print(sb, rec, beenThere);
            }
        }
        if (t instanceof SAXParseException) {
            SAXParseException spe = (SAXParseException)t;
            String pubid = spe.getPublicId();
            String sysid = spe.getSystemId();
            if (pubid != null || sysid != null) {
                Object[] param;
                String msg;
                int col = spe.getColumnNumber();
                int line = spe.getLineNumber();
                if (col != -1 || line != -1) {
                    msg = "EXC_sax_parse_col_line";
                    param = new Object[]{String.valueOf(pubid), String.valueOf(sysid), col, line};
                } else {
                    msg = "EXC_sax_parse";
                    param = new Object[]{String.valueOf(pubid), String.valueOf(sysid)};
                }
                LogRecord rec = new LogRecord(Level.CONFIG, null);
                rec.setResourceBundle(NbBundle.getBundle(TopLogging.class));
                rec.setMessage(msg);
                rec.setParameters(param);
                this.print(sb, rec, beenThere);
            }
        }
    }

    public static void printStackTrace(Throwable t, PrintWriter pw) {
        NbFormatter.doPrintStackTrace(pw, t, null);
    }

    private static void doPrintStackTrace(PrintWriter pw, Throwable t, Throwable higher) {
        int end;
        String suffix;
        Throwable lower;
        block10: {
            try {
                if (t.getClass().getMethod("printStackTrace", PrintWriter.class).getDeclaringClass() != Throwable.class) {
                    t.printStackTrace(pw);
                    return;
                }
            }
            catch (NoSuchMethodException e) {
                if ($assertionsDisabled) break block10;
                throw new AssertionError((Object)e);
            }
        }
        if ((lower = t.getCause()) != null) {
            NbFormatter.doPrintStackTrace(pw, lower, t);
            pw.print("Caused: ");
        }
        String summary = t.toString();
        if (lower != null && summary.endsWith(suffix = ": " + lower)) {
            summary = summary.substring(0, summary.length() - suffix.length());
        }
        pw.println(summary);
        StackTraceElement[] trace = t.getStackTrace();
        if (higher != null) {
            int higherEnd;
            StackTraceElement[] higherTrace = higher.getStackTrace();
            for (end = trace.length; end > 0 && (higherEnd = end + higherTrace.length - trace.length) > 0 && higherTrace[higherEnd - 1].equals(trace[end - 1]); --end) {
            }
        }
        Integer caughtIndex = catchIndex.get(t);
        for (int i = 0; i < end; ++i) {
            if (caughtIndex != null && i == caughtIndex) {
                pw.print("[catch] at ");
            } else {
                pw.print("\tat ");
            }
            pw.println(trace[i]);
        }
    }

    static void registerCatchIndex(Throwable t, int index) {
        catchIndex.put(t, index);
    }
}

