/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export;

import java.awt.Color;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.type.NamedEnum;
import net.sf.jasperreports.engine.util.ClassUtils;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.export.CommonExportConfiguration;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.annotations.ExporterProperty;

public class PropertiesDefaultsConfigurationFactory<C extends CommonExportConfiguration> {
    private final JasperReportsContext jasperReportsContext;

    public PropertiesDefaultsConfigurationFactory(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public C getConfiguration(Class<C> configurationInterface) {
        return this.getProxy(configurationInterface, new PropertiesDefaultsInvocationHandler());
    }

    private final C getProxy(Class<?> clazz, InvocationHandler handler) {
        ArrayList allInterfaces = new ArrayList();
        if (clazz.isInterface()) {
            allInterfaces.add(clazz);
        } else {
            List<Class<?>> lcInterfaces = ClassUtils.getInterfaces(clazz);
            allInterfaces.addAll(lcInterfaces);
        }
        CommonExportConfiguration proxy = (CommonExportConfiguration)Proxy.newProxyInstance(ExporterConfiguration.class.getClassLoader(), allInterfaces.toArray(new Class[allInterfaces.size()]), handler);
        return (C)proxy;
    }

    protected Object getPropertyValue(Method method) {
        Object value = null;
        ExporterProperty exporterProperty = method.getAnnotation(ExporterProperty.class);
        if (exporterProperty != null) {
            value = PropertiesDefaultsConfigurationFactory.getPropertyValue(this.jasperReportsContext, exporterProperty, method.getReturnType());
        }
        return value;
    }

    public static Object getPropertyValue(JasperReportsContext jasperReportsContext, ExporterProperty exporterProperty, Class<?> type) {
        Object value = null;
        String propertyName = exporterProperty.value();
        JRPropertiesUtil propertiesUtil = JRPropertiesUtil.getInstance(jasperReportsContext);
        if (String[].class.equals(type)) {
            List<JRPropertiesUtil.PropertySuffix> properties = propertiesUtil.getProperties(propertyName);
            if (properties != null && !properties.isEmpty()) {
                String[] values = new String[properties.size()];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = properties.get(i).getValue();
                }
                value = values;
            }
        } else if (JRPropertiesUtil.PropertySuffix[].class.equals(type)) {
            List<JRPropertiesUtil.PropertySuffix> properties = propertiesUtil.getProperties(propertyName);
            if (properties != null && !properties.isEmpty()) {
                value = properties.toArray(new JRPropertiesUtil.PropertySuffix[properties.size()]);
            }
        } else if (Map.class.equals(type)) {
            List<JRPropertiesUtil.PropertySuffix> properties = propertiesUtil.getProperties(propertyName);
            if (properties != null && !properties.isEmpty()) {
                HashMap<String, String> values = new HashMap<String, String>();
                for (JRPropertiesUtil.PropertySuffix propertySuffix : properties) {
                    values.put(propertySuffix.getSuffix(), propertySuffix.getValue());
                }
                value = values;
            }
        } else {
            Object strValue = propertiesUtil.getProperty(propertyName);
            if (String.class.equals(type)) {
                value = strValue;
            } else if (Character.class.equals(type)) {
                value = JRPropertiesUtil.asCharacter((String)strValue);
            } else if (Integer.class.equals(type)) {
                if (strValue == null) {
                    if (!exporterProperty.nullDefault()) {
                        value = exporterProperty.intDefault();
                    }
                } else {
                    value = JRPropertiesUtil.asInteger((String)strValue);
                }
            } else if (Long.class.equals(type)) {
                if (strValue == null) {
                    if (!exporterProperty.nullDefault()) {
                        value = exporterProperty.longDefault();
                    }
                } else {
                    value = JRPropertiesUtil.asLong((String)strValue);
                }
            } else if (Float.class.equals(type)) {
                if (strValue == null) {
                    if (!exporterProperty.nullDefault()) {
                        value = Float.valueOf(exporterProperty.floatDefault());
                    }
                } else {
                    value = Float.valueOf(JRPropertiesUtil.asFloat((String)strValue));
                }
            } else if (Boolean.class.equals(type)) {
                if (strValue == null) {
                    if (!exporterProperty.nullDefault()) {
                        value = exporterProperty.booleanDefault();
                    }
                } else {
                    value = JRPropertiesUtil.asBoolean((String)strValue);
                }
            } else if (Color.class.equals(type)) {
                if (strValue == null && !exporterProperty.nullDefault() && ((String)(strValue = exporterProperty.stringDefault())).trim().length() == 0) {
                    throw new JRRuntimeException("export.common.properties.empty.string.default.not.supported", new Object[]{propertyName});
                }
                if (strValue != null) {
                    value = JRColorUtil.getColor((String)strValue, null);
                }
            } else if (NamedEnum.class.isAssignableFrom(type)) {
                if (strValue == null && !exporterProperty.nullDefault()) {
                    strValue = exporterProperty.stringDefault();
                }
                if (strValue != null) {
                    try {
                        Method byNameMethod = type.getMethod("getByName", String.class);
                        value = byNameMethod.invoke(null, strValue);
                    }
                    catch (NoSuchMethodException e) {
                        throw new JRRuntimeException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new JRRuntimeException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new JRRuntimeException(e);
                    }
                }
            } else {
                throw new JRRuntimeException("export.common.properties.type.not.supported", new Object[]{type});
            }
        }
        return value;
    }

    class PropertiesDefaultsInvocationHandler
    implements InvocationHandler {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return PropertiesDefaultsConfigurationFactory.this.getPropertyValue(method);
        }
    }
}

