/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.vorbis;

import de.jarnbjo.util.io.BitInputStream;
import de.jarnbjo.vorbis.Floor;
import de.jarnbjo.vorbis.IdentificationHeader;
import de.jarnbjo.vorbis.Mapping;
import de.jarnbjo.vorbis.MdctFloat;
import de.jarnbjo.vorbis.Mode;
import de.jarnbjo.vorbis.Residue;
import de.jarnbjo.vorbis.SetupHeader;
import de.jarnbjo.vorbis.Util;
import de.jarnbjo.vorbis.VorbisFormatException;
import de.jarnbjo.vorbis.VorbisStream;
import java.io.IOException;

class AudioPacket {
    private int modeNumber;
    private Mode mode;
    private Mapping mapping;
    private int n;
    private boolean blockFlag;
    private boolean previousWindowFlag;
    private boolean nextWindowFlag;
    private int windowCenter;
    private int leftWindowStart;
    private int leftWindowEnd;
    private int leftN;
    private int rightWindowStart;
    private int rightWindowEnd;
    private int rightN;
    private float[] window;
    private float[][] pcm;
    private int[][] pcmInt;
    private Floor[] channelFloors;
    private boolean[] noResidues;
    private static final float[][] windows = new float[8][];

    protected AudioPacket(VorbisStream vorbis, BitInputStream source) throws VorbisFormatException, IOException {
        int i;
        int i2;
        SetupHeader sHeader = vorbis.getSetupHeader();
        IdentificationHeader iHeader = vorbis.getIdentificationHeader();
        Mode[] modes = sHeader.getModes();
        Mapping[] mappings = sHeader.getMappings();
        Residue[] residues = sHeader.getResidues();
        int channels = iHeader.getChannels();
        if (source.getInt(1) != 0) {
            throw new VorbisFormatException("Packet type mismatch when trying to create an audio packet.");
        }
        this.modeNumber = source.getInt(Util.ilog(modes.length - 1));
        try {
            this.mode = modes[this.modeNumber];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new VorbisFormatException("Reference to invalid mode in audio packet.");
        }
        this.mapping = mappings[this.mode.getMapping()];
        int[] magnitudes = this.mapping.getMagnitudes();
        int[] angles = this.mapping.getAngles();
        this.blockFlag = this.mode.getBlockFlag();
        int blockSize0 = iHeader.getBlockSize0();
        int blockSize1 = iHeader.getBlockSize1();
        int n = this.n = this.blockFlag ? blockSize1 : blockSize0;
        if (this.blockFlag) {
            this.previousWindowFlag = source.getBit();
            this.nextWindowFlag = source.getBit();
        }
        this.windowCenter = this.n / 2;
        if (this.blockFlag && !this.previousWindowFlag) {
            this.leftWindowStart = this.n / 4 - blockSize0 / 4;
            this.leftWindowEnd = this.n / 4 + blockSize0 / 4;
            this.leftN = blockSize0 / 2;
        } else {
            this.leftWindowStart = 0;
            this.leftWindowEnd = this.n / 2;
            this.leftN = this.windowCenter;
        }
        if (this.blockFlag && !this.nextWindowFlag) {
            this.rightWindowStart = this.n * 3 / 4 - blockSize0 / 4;
            this.rightWindowEnd = this.n * 3 / 4 + blockSize0 / 4;
            this.rightN = blockSize0 / 2;
        } else {
            this.rightWindowStart = this.windowCenter;
            this.rightWindowEnd = this.n;
            this.rightN = this.n / 2;
        }
        this.window = this.getComputedWindow();
        this.channelFloors = new Floor[channels];
        this.noResidues = new boolean[channels];
        this.pcm = new float[channels][this.n];
        this.pcmInt = new int[channels][this.n];
        boolean allFloorsEmpty = true;
        for (i2 = 0; i2 < channels; ++i2) {
            Floor decodedFloor;
            int submapNumber = this.mapping.getMux()[i2];
            int floorNumber = this.mapping.getSubmapFloors()[submapNumber];
            this.channelFloors[i2] = decodedFloor = sHeader.getFloors()[floorNumber].decodeFloor(vorbis, source);
            boolean bl = this.noResidues[i2] = decodedFloor == null;
            if (decodedFloor == null) continue;
            allFloorsEmpty = false;
        }
        if (allFloorsEmpty) {
            return;
        }
        for (i2 = 0; i2 < magnitudes.length; ++i2) {
            if (this.noResidues[magnitudes[i2]] && this.noResidues[angles[i2]]) continue;
            this.noResidues[magnitudes[i2]] = false;
            this.noResidues[angles[i2]] = false;
        }
        Residue[] decodedResidues = new Residue[this.mapping.getSubmaps()];
        for (i = 0; i < this.mapping.getSubmaps(); ++i) {
            int ch = 0;
            boolean[] doNotDecodeFlags = new boolean[channels];
            for (int j = 0; j < channels; ++j) {
                if (this.mapping.getMux()[j] != i) continue;
                doNotDecodeFlags[ch++] = this.noResidues[j];
            }
            int residueNumber = this.mapping.getSubmapResidues()[i];
            Residue residue = residues[residueNumber];
            residue.decodeResidue(vorbis, source, this.mode, ch, doNotDecodeFlags, this.pcm);
        }
        for (i = this.mapping.getCouplingSteps() - 1; i >= 0; --i) {
            double newA = 0.0;
            double newM = 0.0;
            float[] magnitudeVector = this.pcm[magnitudes[i]];
            float[] angleVector = this.pcm[angles[i]];
            for (int j = 0; j < magnitudeVector.length; ++j) {
                float a = angleVector[j];
                float m = magnitudeVector[j];
                if (a > 0.0f) {
                    angleVector[j] = m > 0.0f ? m - a : m + a;
                    continue;
                }
                magnitudeVector[j] = m > 0.0f ? m + a : m - a;
                angleVector[j] = m;
            }
        }
        for (i = 0; i < channels; ++i) {
            if (this.channelFloors[i] == null) continue;
            this.channelFloors[i].computeFloor(this.pcm[i]);
        }
        for (i = 0; i < channels; ++i) {
            MdctFloat mdct = this.blockFlag ? iHeader.getMdct1() : iHeader.getMdct0();
            mdct.imdct(this.pcm[i], this.window, this.pcmInt[i]);
        }
    }

    private float[] getComputedWindow() {
        int ix = (this.blockFlag ? 4 : 0) + (this.previousWindowFlag ? 2 : 0) + (this.nextWindowFlag ? 1 : 0);
        float[] w = windows[ix];
        if (w == null) {
            float x;
            int i;
            w = new float[this.n];
            for (i = 0; i < this.leftN; ++i) {
                x = (float)(((double)i + 0.5) / (double)this.leftN * Math.PI / 2.0);
                x = (float)Math.sin(x);
                x *= x;
                x = (float)((double)x * 1.5707963705062866);
                w[i + this.leftWindowStart] = x = (float)Math.sin(x);
            }
            i = this.leftWindowEnd;
            while (i < this.rightWindowStart) {
                w[i++] = 1.0f;
            }
            for (i = 0; i < this.rightN; ++i) {
                x = (float)(((double)(this.rightN - i) - 0.5) / (double)this.rightN * Math.PI / 2.0);
                x = (float)Math.sin(x);
                x *= x;
                x = (float)((double)x * 1.5707963705062866);
                w[i + this.rightWindowStart] = x = (float)Math.sin(x);
            }
            AudioPacket.windows[ix] = w;
        }
        return w;
    }

    protected int getNumberOfSamples() {
        return this.rightWindowStart - this.leftWindowStart;
    }

    protected int getPcm(AudioPacket previousPacket, int[][] buffer) {
        int i;
        int channels = this.pcm.length;
        for (i = 0; i < channels; ++i) {
            int j1 = 0;
            int j2 = previousPacket.rightWindowStart;
            int[] ppcm = previousPacket.pcmInt[i];
            int[] tpcm = this.pcmInt[i];
            int[] target = buffer[i];
            for (int j = this.leftWindowStart; j < this.leftWindowEnd; ++j) {
                int val;
                if ((val = ppcm[j2++] + tpcm[j]) > Short.MAX_VALUE) {
                    val = Short.MAX_VALUE;
                }
                if (val < Short.MIN_VALUE) {
                    val = Short.MIN_VALUE;
                }
                target[j1++] = val;
            }
        }
        if (this.leftWindowEnd + 1 < this.rightWindowStart) {
            for (i = 0; i < channels; ++i) {
                System.arraycopy(this.pcmInt[i], this.leftWindowEnd, buffer[i], this.leftWindowEnd - this.leftWindowStart, this.rightWindowStart - this.leftWindowEnd);
            }
        }
        return this.rightWindowStart - this.leftWindowStart;
    }

    protected void getPcm(AudioPacket previousPacket, byte[] buffer) {
        int channels = this.pcm.length;
        for (int i = 0; i < channels; ++i) {
            int val;
            int j;
            int ix = 0;
            int j2 = previousPacket.rightWindowStart;
            int[] ppcm = previousPacket.pcmInt[i];
            int[] tpcm = this.pcmInt[i];
            for (j = this.leftWindowStart; j < this.leftWindowEnd; ++j) {
                if ((val = ppcm[j2++] + tpcm[j]) > Short.MAX_VALUE) {
                    val = Short.MAX_VALUE;
                }
                if (val < Short.MIN_VALUE) {
                    val = Short.MIN_VALUE;
                }
                buffer[ix + i * 2 + 1] = (byte)(val & 0xFF);
                buffer[ix + i * 2] = (byte)(val >> 8 & 0xFF);
                ix += channels * 2;
            }
            ix = (this.leftWindowEnd - this.leftWindowStart) * channels * 2;
            for (j = this.leftWindowEnd; j < this.rightWindowStart; ++j) {
                val = tpcm[j];
                if (val > Short.MAX_VALUE) {
                    val = Short.MAX_VALUE;
                }
                if (val < Short.MIN_VALUE) {
                    val = Short.MIN_VALUE;
                }
                buffer[ix + i * 2 + 1] = (byte)(val & 0xFF);
                buffer[ix + i * 2] = (byte)(val >> 8 & 0xFF);
                ix += channels * 2;
            }
        }
    }

    protected float[] getWindow() {
        return this.window;
    }

    protected int getLeftWindowStart() {
        return this.leftWindowStart;
    }

    protected int getLeftWindowEnd() {
        return this.leftWindowEnd;
    }

    protected int getRightWindowStart() {
        return this.rightWindowStart;
    }

    protected int getRightWindowEnd() {
        return this.rightWindowEnd;
    }

    public int[][] getPcm() {
        return this.pcmInt;
    }

    public float[][] getFreqencyDomain() {
        return this.pcm;
    }
}

