/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.jmf;

import de.jarnbjo.jmf.FlacTrack;
import de.jarnbjo.jmf.TheoraTrack;
import de.jarnbjo.jmf.VorbisTrack;
import de.jarnbjo.ogg.EndOfOggStreamException;
import de.jarnbjo.ogg.LogicalOggStream;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;

public class OggTrack
implements Track {
    private TrackListener listener;
    private LogicalOggStream source;
    private boolean enabled = true;
    private int channels;
    private int sampleRate;
    private long currentBytePos;
    private Format format;
    private static final long VORBIS_HEADER = 32485493869344257L;

    protected OggTrack(LogicalOggStream source) {
        this.source = source;
    }

    public static OggTrack createInstance(LogicalOggStream source) throws IOException {
        if (source.getFormat() == "audio/x-vorbis") {
            byte[] data = source.getNextOggPacket();
            source.reset();
            System.out.println("VorbisTrack");
            return new VorbisTrack(source, data);
        }
        if (source.getFormat() == "video/x-theora") {
            byte[] data = source.getNextOggPacket();
            source.reset();
            System.out.println("TheoraTrack");
            return new TheoraTrack(source, data);
        }
        if (source.getFormat() == "audio/x-flac") {
            byte[] data = source.getNextOggPacket();
            data = source.getNextOggPacket();
            source.reset();
            System.out.println("FlacTrack");
            return new FlacTrack(source, data);
        }
        System.out.println("OggTrack");
        return new OggTrack(source);
    }

    public Time getMediaTime() {
        return Time.TIME_UNKNOWN;
    }

    public Format getFormat() {
        return this.format;
    }

    public Time getStartTime() {
        return Time.TIME_UNKNOWN;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Time mapFrameToTime(int frameNumber) {
        return Time.TIME_UNKNOWN;
    }

    public int mapTimeToFrame(Time t) {
        return Integer.MAX_VALUE;
    }

    public synchronized void readFrame(Buffer buffer) {
        try {
            byte[] packet = this.source.getNextOggPacket();
            byte[] byteArray = (byte[])buffer.getData();
            if (byteArray == null || packet.length > byteArray.length) {
                buffer.setData((Object)packet);
            } else {
                System.arraycopy(packet, 0, byteArray, 0, packet.length);
            }
            buffer.setOffset(0);
            buffer.setLength(packet.length);
        }
        catch (EndOfOggStreamException e) {
            buffer.setEOM(true);
            buffer.setOffset(0);
            buffer.setLength(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setEnabled(boolean t) {
        this.enabled = t;
    }

    public void setTrackListener(TrackListener listener) {
        this.listener = listener;
    }

    public Time getDuration() {
        return Duration.DURATION_UNKNOWN;
    }
}

