/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.jmf;

import de.jarnbjo.jmf.OggJmfPage;
import de.jarnbjo.ogg.EndOfOggStreamException;
import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.ogg.LogicalOggStreamImpl;
import de.jarnbjo.ogg.OggFormatException;
import de.jarnbjo.ogg.OggPage;
import de.jarnbjo.ogg.PhysicalOggStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;

public class OggJmfStream
implements PhysicalOggStream {
    private boolean closed = false;
    private PullSourceStream source;
    private long[] pageOffsets;
    private long numberOfSamples = -1L;
    private HashMap logicalStreams = new HashMap();

    public OggJmfStream(PullSourceStream source) throws OggFormatException, FileNotFoundException, IOException {
        this.source = source;
        if (!(source instanceof Seekable)) {
            throw new OggFormatException("The source stream must be seekable.");
        }
        ArrayList<Long> po = new ArrayList<Long>();
        int pageNumber = 0;
        try {
            while (true) {
                long startPos = ((Seekable)source).tell();
                po.add(new Long(((Seekable)source).tell()));
                OggPage op = this.getNextPage(true);
                ((Seekable)source).seek(((Seekable)source).tell() + (long)op.getTotalLength());
                LogicalOggStreamImpl los = (LogicalOggStreamImpl)this.getLogicalStream(op.getStreamSerialNumber());
                if (los == null) {
                    los = new LogicalOggStreamImpl(this, op.getStreamSerialNumber());
                    this.logicalStreams.put(new Integer(op.getStreamSerialNumber()), los);
                    ((Seekable)source).seek(startPos);
                    op = this.getNextPage();
                    los.checkFormat(op);
                }
                los.addPageNumberMapping(pageNumber);
                los.addGranulePosition(op.getAbsoluteGranulePosition());
                ++pageNumber;
            }
        }
        catch (EndOfOggStreamException e) {
        }
        catch (IOException e) {
            throw e;
        }
        ((Seekable)source).seek(0L);
        this.pageOffsets = new long[po.size()];
        int i = 0;
        Iterator iter = po.iterator();
        while (iter.hasNext()) {
            this.pageOffsets[i++] = (Long)iter.next();
        }
    }

    public Collection getLogicalStreams() {
        return this.logicalStreams.values();
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public void close() throws IOException {
        this.closed = true;
    }

    private OggPage getNextPage() throws EndOfOggStreamException, IOException, OggFormatException {
        return this.getNextPage(false);
    }

    private OggPage getNextPage(boolean skipData) throws EndOfOggStreamException, IOException, OggFormatException {
        return OggJmfPage.create(this.source, skipData);
    }

    public OggPage getOggPage(int index) throws IOException {
        ((Seekable)this.source).seek(this.pageOffsets[index]);
        return OggJmfPage.create(this.source);
    }

    public LogicalOggStream getLogicalStream(int serialNumber) {
        return (LogicalOggStream)this.logicalStreams.get(new Integer(serialNumber));
    }

    public void setTime(long granulePosition) throws IOException {
        Iterator iter = this.logicalStreams.values().iterator();
        while (iter.hasNext()) {
            LogicalOggStream los = (LogicalOggStream)iter.next();
            los.setTime(granulePosition);
        }
    }

    public boolean isSeekable() {
        return true;
    }
}

