/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.securityevents.widget;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import rs.co.ast.aspen.api.service.TermTimeHistogram;
import rs.co.ast.aspen.gui.module.securityevents.DisplayOptions;
import rs.co.ast.aspen.gui.module.securityevents.widget.ReloadPanel;
import rs.co.ast.aspen.gui.module.securityevents.widget.Widget;

public class WidgetUpdateWorker
extends SwingWorker<List<TermTimeHistogram>, Void> {
    private static final Logger LOGGER = Logger.getLogger(WidgetUpdateWorker.class.getName());
    private final Object params;
    private final ProgressHandle ph;
    private final Widget widget;
    private final DisplayOptions displayOptions;
    private final String progressText;
    private ReloadPanel reloadPanel;
    private long startTime = 0L;

    public WidgetUpdateWorker(Object params, String ph, Widget widget, DisplayOptions displayOptions) {
        this.params = params;
        this.progressText = ph;
        this.ph = ProgressHandleFactory.createHandle((String)ph);
        this.widget = widget;
        this.displayOptions = displayOptions;
    }

    @Override
    protected List<TermTimeHistogram> doInBackground() throws Exception {
        this.ph.start();
        this.startTime = System.currentTimeMillis();
        this.widget.setLoadingPanel();
        return this.widget.getTimeHistogram(this.params);
    }

    @Override
    protected void done() {
        super.done();
        try {
            LOGGER.info(String.format("FETCHING OF TimeHistogram IS FINISHED IN %d ms", System.currentTimeMillis() - this.startTime));
            List list = (List)this.get();
            this.widget.update(list, this.displayOptions.getIntervalObj().getClazz());
        }
        catch (InterruptedException | ExecutionException ex) {
            try {
                if (this.reloadPanel == null) {
                    this.reloadPanel = new ReloadPanel();
                }
                this.reloadPanel.getbReload().addActionListener(ActionListener2 -> {
                    this.widget.setQueuePanel();
                    ExecutorService executor = Executors.newSingleThreadExecutor();
                    executor.execute(new WidgetUpdateWorker(this.params, this.progressText, this.widget, this.displayOptions));
                    executor.shutdown();
                });
                this.widget.setReloadPanel(this.reloadPanel);
                LOGGER.info(ex.getLocalizedMessage());
            }
            catch (Throwable throwable) {
                this.ph.finish();
                LOGGER.info(String.format("CREATION OF WIDGET IS FINISHED IN %d ms", System.currentTimeMillis() - this.startTime));
                throw throwable;
            }
            this.ph.finish();
            LOGGER.info(String.format("CREATION OF WIDGET IS FINISHED IN %d ms", System.currentTimeMillis() - this.startTime));
        }
        this.ph.finish();
        LOGGER.info(String.format("CREATION OF WIDGET IS FINISHED IN %d ms", System.currentTimeMillis() - this.startTime));
    }
}

