/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.securityevents;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.apache.commons.codec.digest.DigestUtils;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.calendar.SingleDaySelectionModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.SavedQueryData;
import rs.co.ast.aspen.api.service.SavedQueryDataType;
import rs.co.ast.aspen.gui.module.securityevents.IntervalObject;
import rs.co.ast.aspen.gui.module.securityevents.LastNHoursModel;
import rs.co.ast.aspen.gui.module.securityevents.QuerySetNamePanel;
import rs.co.ast.aspen.gui.module.securityevents.SavedQueryDataDialog;

public class FullscreenDisplayOptionsPanel
extends JPanel {
    private static final long MS_IN_A_DAY = 86400000L;
    private String query;
    private RequestProcessor req = null;
    private ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private JButton bQueryBookmarks;
    private JButton btQueryBookmarked;
    private JComboBox cbInterval;
    private JComboBox cbLastNHours;
    private JComboBox cbPageSize;
    private JXDatePicker dtpTimeFinish;
    private JXDatePicker dtpTimeStart;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JRadioButton rbLastNHours;
    private JRadioButton rbStartFinishTime;
    private JSpinner sAutoRefresh;
    private JTextField tfQuery;

    public FullscreenDisplayOptionsPanel(IntervalObject[] intervals, List<Integer> items) {
        this.initComponents();
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rbStartFinishTime);
        bg.add(this.rbLastNHours);
        this.rbStartFinishTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FullscreenDisplayOptionsPanel.this.cbLastNHours.setEnabled(false);
                FullscreenDisplayOptionsPanel.this.dtpTimeStart.setEnabled(true);
                FullscreenDisplayOptionsPanel.this.dtpTimeFinish.setEnabled(true);
            }
        });
        this.rbLastNHours.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FullscreenDisplayOptionsPanel.this.cbLastNHours.setEnabled(true);
                FullscreenDisplayOptionsPanel.this.dtpTimeStart.setEnabled(false);
                FullscreenDisplayOptionsPanel.this.dtpTimeFinish.setEnabled(false);
            }
        });
        this.cbLastNHours.setModel(new LastNHoursModel(items));
        this.cbLastNHours.setSelectedIndex(0);
        this.dtpTimeStart.setFormats(new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSXXX"});
        this.dtpTimeStart.getMonthView().setSelectionModel((DateSelectionModel)new SingleDaySelectionModel());
        this.dtpTimeFinish.setFormats(new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSXXX"});
        this.dtpTimeFinish.getMonthView().setSelectionModel((DateSelectionModel)new SingleDaySelectionModel());
        this.dtpTimeStart.setTimeZone(TimeZone.getDefault());
        this.dtpTimeFinish.setTimeZone(TimeZone.getDefault());
    }

    public boolean isLastNHoursSelected() {
        return this.rbLastNHours.isSelected();
    }

    public int getLastNHours() {
        return (Integer)this.cbLastNHours.getModel().getSelectedItem();
    }

    public int getLastNHoursIndex() {
        return this.cbLastNHours.getSelectedIndex();
    }

    public void setLastNHoursIndex(int index) {
        this.cbLastNHours.setSelectedIndex(index);
    }

    public void setLastNHoursSelected(boolean isSelected) {
        this.cbLastNHours.setEnabled(isSelected);
        this.dtpTimeStart.setEnabled(!isSelected);
        this.dtpTimeFinish.setEnabled(!isSelected);
        this.rbLastNHours.setSelected(isSelected);
        this.rbStartFinishTime.setSelected(!isSelected);
    }

    private void initComponents() {
        this.cbInterval = new JComboBox();
        this.jLabel7 = new JLabel();
        this.jLabel1 = new JLabel();
        this.dtpTimeStart = new JXDatePicker();
        this.dtpTimeFinish = new JXDatePicker();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.sAutoRefresh = new JSpinner();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.cbPageSize = new JComboBox();
        this.jLabel6 = new JLabel();
        this.rbStartFinishTime = new JRadioButton();
        this.rbLastNHours = new JRadioButton();
        this.cbLastNHours = new JComboBox();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel8 = new JLabel();
        this.tfQuery = new JTextField();
        this.bQueryBookmarks = new JButton();
        this.btQueryBookmarked = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(FullscreenDisplayOptionsPanel.class, (String)"FullscreenDisplayOptionsPanel.jLabel7.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(FullscreenDisplayOptionsPanel.class, (String)"FullscreenDisplayOptionsPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(FullscreenDisplayOptionsPanel.class, (String)"FullscreenDisplayOptionsPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(FullscreenDisplayOptionsPanel.class, (String)"FullscreenDisplayOptionsPanel.jLabel3.text"));
        this.sAutoRefresh.setModel(new SpinnerNumberModel(0, 0, 60, 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(FullscreenDisplayOptionsPanel.class, (String)"FullscreenDisplayOptionsPanel.jLabel4.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(FullscreenDisplayOptionsPanel.class, (String)"FullscreenDisplayOptionsPanel.jLabel5.text"));
        this.cbPageSize.setModel(new DefaultComboBoxModel<String>(new String[]{"10", "50", "100", "200", "500", "1000"}));
        this.cbPageSize.setSelectedIndex(2);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(FullscreenDisplayOptionsPanel.class, (String)"FullscreenDisplayOptionsPanel.jLabel6.text"));
        this.rbStartFinishTime.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.rbStartFinishTime, (String)NbBundle.getMessage(FullscreenDisplayOptionsPanel.class, (String)"FullscreenDisplayOptionsPanel.rbStartFinishTime.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.rbLastNHours, (String)NbBundle.getMessage(FullscreenDisplayOptionsPanel.class, (String)"FullscreenDisplayOptionsPanel.rbLastNHours.text"));
        this.cbLastNHours.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "4", "8", "12", "24", "48"}));
        this.cbLastNHours.setEnabled(false);
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(FullscreenDisplayOptionsPanel.class, (String)"FullscreenDisplayOptionsPanel.jLabel10.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel11, (String)NbBundle.getMessage(FullscreenDisplayOptionsPanel.class, (String)"FullscreenDisplayOptionsPanel.jLabel11.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(FullscreenDisplayOptionsPanel.class, (String)"FullscreenDisplayOptionsPanel.jLabel8.text"));
        this.tfQuery.setText(NbBundle.getMessage(FullscreenDisplayOptionsPanel.class, (String)"FullscreenDisplayOptionsPanel.tfQuery.text"));
        this.bQueryBookmarks.setIcon(new ImageIcon(this.getClass().getResource("/folder_star.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bQueryBookmarks, (String)NbBundle.getMessage(FullscreenDisplayOptionsPanel.class, (String)"FullscreenDisplayOptionsPanel.bQueryBookmarks.text"));
        this.bQueryBookmarks.setToolTipText(NbBundle.getMessage(FullscreenDisplayOptionsPanel.class, (String)"FullscreenDisplayOptionsPanel.bQueryBookmarks.toolTipText"));
        this.bQueryBookmarks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FullscreenDisplayOptionsPanel.this.bQueryBookmarksActionPerformed(evt);
            }
        });
        this.btQueryBookmarked.setIcon(new ImageIcon(this.getClass().getResource("/star.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btQueryBookmarked, (String)NbBundle.getMessage(FullscreenDisplayOptionsPanel.class, (String)"FullscreenDisplayOptionsPanel.btQueryBookmarked.text"));
        this.btQueryBookmarked.setToolTipText(NbBundle.getMessage(FullscreenDisplayOptionsPanel.class, (String)"FullscreenDisplayOptionsPanel.btQueryBookmarked.toolTipText"));
        this.btQueryBookmarked.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FullscreenDisplayOptionsPanel.this.btQueryBookmarkedActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.rbLastNHours).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbLastNHours, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel11).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sAutoRefresh, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel8)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.bQueryBookmarks, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btQueryBookmarked, -2, 30, -2)).addGroup(layout.createSequentialGroup().addGap(99, 99, 99).addComponent(this.cbPageSize, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6))))).addGap(12, 12, 12)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.rbStartFinishTime).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.dtpTimeStart, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.dtpTimeFinish, -1, -1, Short.MAX_VALUE).addContainerGap()))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(16, 16, 16).addComponent(this.jLabel10, -1, -1, Short.MAX_VALUE).addGap(412, 412, 412)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tfQuery).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.dtpTimeFinish, -2, -1, -2).addComponent(this.jLabel2).addComponent((Component)this.dtpTimeStart, -2, -1, -2).addComponent(this.rbStartFinishTime)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rbLastNHours).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbLastNHours, -2, -1, -2).addComponent(this.jLabel11))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.sAutoRefresh, -2, -1, -2).addComponent(this.jLabel4)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.cbPageSize, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btQueryBookmarked).addComponent(this.bQueryBookmarks, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jLabel8))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tfQuery, -2, -1, -2).addContainerGap()));
    }

    private void btQueryBookmarkedActionPerformed(ActionEvent evt) {
        if (!this.tfQuery.getText().isEmpty()) {
            final QuerySetNamePanel panel = new QuerySetNamePanel();
            DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(FullscreenDisplayOptionsPanel.class, (String)"SetQueryName.dialog.title"), true, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int opt = (Integer)e.getSource();
                    if (DialogDescriptor.OK_OPTION.equals(opt)) {
                        SavedQueryData q = new SavedQueryData();
                        q.setName(panel.getTypedName());
                        q.setQuery(FullscreenDisplayOptionsPanel.this.tfQuery.getText());
                        q.setType(SavedQueryDataType.SECURITY_EVENTS_QUERY);
                        q.setId(DigestUtils.md5Hex((String)String.format("%s%s", q.getQuery(), q.getType())));
                        try {
                            FullscreenDisplayOptionsPanel.this.apiService.saveSavedQuery(q);
                        }
                        catch (ApiServiceException_Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            });
            DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        }
    }

    private void bQueryBookmarksActionPerformed(ActionEvent evt) {
        ArrayList<SavedQueryData> queries;
        try {
            queries = this.apiService.getSecurityEventQueries();
        }
        catch (ApiServiceException_Exception ex) {
            queries = new ArrayList<SavedQueryData>();
            Exceptions.printStackTrace((Throwable)ex);
        }
        final SavedQueryDataDialog dialog = new SavedQueryDataDialog();
        dialog.setData(queries);
        dialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
        dialog.setVisible(true);
        dialog.setModal(true);
        dialog.setDefaultCloseOperation(2);
        dialog.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                SavedQueryData selectedQueryBookmark = dialog.getSelectedQueryBookmark();
                if (selectedQueryBookmark != null) {
                    FullscreenDisplayOptionsPanel.this.tfQuery.setText(dialog.getSelectedQueryBookmark().getQuery());
                }
            }
        });
    }

    public long getTimeStart() {
        return this.dtpTimeStart.getDate().getTime();
    }

    public long getTimeFinish() {
        return this.dtpTimeFinish.getDate().getTime() + 86400000L - 1L;
    }

    public void setTimeStart(long time) {
        this.dtpTimeStart.setDate(new Date(time));
    }

    public void setTimeFinish(long time) {
        this.dtpTimeFinish.setDate(new Date(time));
    }

    public int getAutoRefresh() {
        return (Integer)this.sAutoRefresh.getValue();
    }

    public void setAutoRefresh(int autoRefresh) {
        this.sAutoRefresh.setValue(autoRefresh);
    }

    public int getPageSize() {
        return Integer.valueOf((String)this.cbPageSize.getSelectedItem());
    }

    public void setPageSize(int pageSize) {
        this.cbPageSize.setSelectedItem(String.valueOf(pageSize));
    }

    public String getQuery() {
        this.query = this.tfQuery.getText();
        return this.query;
    }

    public void setQuery(String query) {
        this.tfQuery.setText(query);
        this.query = query;
    }
}

