/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.pus;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.util.ShapeUtils;
import org.jfree.data.general.SeriesException;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.NodePopupFactory;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.ModuleVersionUtils;
import rs.co.ast.aspen.api.service.PusProcess;
import rs.co.ast.aspen.api.service.PusReport;
import rs.co.ast.aspen.api.service.PusReports;
import rs.co.ast.aspen.gui.module.pus.GraphKey;
import rs.co.ast.aspen.gui.module.pus.HasId;
import rs.co.ast.aspen.gui.module.pus.NodeNode;
import rs.co.ast.aspen.gui.module.pus.NodePopupMenu;
import rs.co.ast.aspen.gui.module.pus.ProcessNode;
import rs.co.ast.aspen.gui.module.pus.PusNodeWrapper;
import rs.co.ast.aspen.gui.module.pus.PusProcessWrapper;
import rs.co.ast.aspen.gui.module.pus.PusReportsWrapper;
import rs.co.ast.aspen.gui.module.pus.RootNode;
import rs.co.ast.aspen.gui.module.pus.UpdateState;
import rs.co.ast.aspen.gui.module.pus.VerticalLayout;
import rs.co.ast.aspen.gui.module.pus.VisibleNodesModel;

@TopComponent.Description(preferredID="PUSMonitorTopComponent", iconBase="rs/co/ast/aspen/gui/module/pus/chart_organisation.png", persistenceType=0)
public final class PUSMonitorTopComponent
extends TopComponent
implements ExplorerManager.Provider,
LookupListener,
PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(PUSMonitorTopComponent.class.getName());
    public static final Color[] COLORS = new Color[]{new Color(102, 194, 165), new Color(141, 160, 203), new Color(253, 180, 98), new Color(252, 141, 98), new Color(251, 128, 114), new Color(56, 111, 101), new Color(102, 194, 165), new Color(252, 141, 98), new Color(141, 160, 203), new Color(231, 138, 195), new Color(166, 216, 84), new Color(255, 217, 47), new Color(229, 196, 148), new Color(255, 102, 152), new Color(255, 179, 102), new Color(255, 255, 102), new Color(152, 255, 102), new Color(102, 152, 255), new Color(102, 102, 102), new Color(0, 0, 79)};
    private int MAX_GRAPH_AGE = 3600;
    private static final float GRAPH_SHAPE_SIZE = 0.6f;
    private static final int GRAPH_HEIGHT = 200;
    private static final int DEFAULT_REFRESH_RATE = 10000;
    private ExplorerManager explorerManager = new ExplorerManager();
    private OutlineView outlineView = new OutlineView();
    private Map<GraphKey, JFreeChart> charts = new HashMap<GraphKey, JFreeChart>();
    private Map<GraphKey, Datasets> datasetsStore = new HashMap<GraphKey, Datasets>();
    private Timer timer;
    private static final int FIRST_REFRESH_DELAY = 500;
    private Lookup.Result<AbstractNode> lr;
    private ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private VisibleNodesModel visibleNodesModel = (VisibleNodesModel)Lookup.getDefault().lookup(VisibleNodesModel.class);
    private PusReports reports;
    private ChartPanel prevChartPanel = null;
    private UpdateState state = new UpdateState();
    final Map<String, Boolean> processNodeVisibleStateMap = new HashMap<String, Boolean>();
    private Map<String, ChartPanel> chartPanels = new LinkedHashMap<String, ChartPanel>();
    private List<String> chartPanelsPositions = new LinkedList<String>();
    private transient NodeAdapter nodeListener = new NodeAdapter(){

        public void childrenAdded(NodeMemberEvent ev) {
            for (final Node n : ev.getNode().getChildren().getNodes()) {
                if (!(n instanceof HasId)) continue;
                HasId h = (HasId)n;
                if (PUSMonitorTopComponent.this.state.getIndex() >= PUSMonitorTopComponent.this.state.getNodesToExpand().size() || !h.getId().equals(PUSMonitorTopComponent.this.state.getNodesToExpand().get(PUSMonitorTopComponent.this.state.getIndex()))) continue;
                PUSMonitorTopComponent.this.state.getPrevNode().removeNodeListener((NodeListener)this);
                n.addNodeListener((NodeListener)this);
                if (PUSMonitorTopComponent.this.state.getIndex() == PUSMonitorTopComponent.this.state.getNodesToExpand().size() - 1) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                PUSMonitorTopComponent.this.explorerManager.setSelectedNodes(new Node[]{n});
                                PUSMonitorTopComponent.this.state.setIndex(0);
                            }
                            catch (PropertyVetoException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    });
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PUSMonitorTopComponent.this.outlineView.expandNode(n);
                        }
                    });
                }
                PUSMonitorTopComponent.this.state.setIndex(PUSMonitorTopComponent.this.state.getIndex() + 1);
                PUSMonitorTopComponent.this.state.setPrevNode(n);
                break;
            }
            if (PUSMonitorTopComponent.this.state.getNodesToExpand().isEmpty()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PUSMonitorTopComponent.this.outlineView.expandNode(PUSMonitorTopComponent.this.getExplorerManager().getRootContext().getChildren().getNodeAt(0));
                    }
                });
            }
        }
    };
    private JComboBox<String> cbMaxGraphAge;
    private JComboBox cbRefreshFrequency;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JSplitPane jSplitPane1;
    private JPanel pGraphs;
    private JScrollPane spGraphs;
    private JScrollPane spTreeTableView;
    private JTextField tfLastUpdate;

    public PUSMonitorTopComponent() {
        LOGGER.info(String.format("%s version: %s", ModuleVersionUtils.getModuleDisplayName((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.PUS), ModuleVersionUtils.getModuleVersion((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.PUS)));
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)this.getActionMap()));
        this.initComponents();
        this.setName(NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"CTL_PUSMonitorTopComponent"));
        this.setToolTipText(NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"HINT_PUSMonitorTopComponent"));
        this.pGraphs.setLayout(new VerticalLayout());
        this.timer = new Timer(10000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Updater().execute();
            }
        });
        this.timer.setRepeats(true);
        this.cbRefreshFrequency.setModel(new DefaultComboBoxModel<RefreshFrequency>(RefreshFrequency.values()));
        this.cbMaxGraphAge.setModel(new DefaultComboBoxModel<MaxGraphAge>(MaxGraphAge.values()));
        this.spGraphs.getVerticalScrollBar().setUnitIncrement(16);
        this.visibleNodesModel.addPropertyChangeListener(this);
        this.outlineView.setNodePopupFactory((NodePopupFactory)new NodePopupMenu());
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.spTreeTableView = this.outlineView;
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.cbRefreshFrequency = new JComboBox();
        this.spGraphs = new JScrollPane();
        this.pGraphs = new JPanel();
        this.jLabel2 = new JLabel();
        this.tfLastUpdate = new JTextField();
        this.jLabel3 = new JLabel();
        this.cbMaxGraphAge = new JComboBox();
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.setLeftComponent(this.spTreeTableView);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"PUSMonitorTopComponent.jLabel1.text"));
        this.cbRefreshFrequency.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbRefreshFrequency.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PUSMonitorTopComponent.this.cbRefreshFrequencyActionPerformed(evt);
            }
        });
        this.spGraphs.setVerticalScrollBarPolicy(22);
        this.spGraphs.setAutoscrolls(true);
        GroupLayout pGraphsLayout = new GroupLayout(this.pGraphs);
        this.pGraphs.setLayout(pGraphsLayout);
        pGraphsLayout.setHorizontalGroup(pGraphsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 726, Short.MAX_VALUE));
        pGraphsLayout.setVerticalGroup(pGraphsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 408, Short.MAX_VALUE));
        this.spGraphs.setViewportView(this.pGraphs);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"PUSMonitorTopComponent.jLabel2.text", (Object[])new Object[0]));
        this.tfLastUpdate.setEditable(false);
        this.tfLastUpdate.setText(NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"PUSMonitorTopComponent.tfLastUpdate.text", (Object[])new Object[0]));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"PUSMonitorTopComponent.jLabel3.text"));
        this.cbMaxGraphAge.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbMaxGraphAge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PUSMonitorTopComponent.this.cbMaxGraphAgeActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spGraphs).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbRefreshFrequency, -2, 95, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbMaxGraphAge, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfLastUpdate).addGap(13, 13, 13)))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.tfLastUpdate, -2, -1, -2)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbRefreshFrequency, -2, 24, -2).addComponent(this.jLabel1)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbMaxGraphAge, -2, -1, -2).addComponent(this.jLabel3))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spGraphs)));
        this.jSplitPane1.setRightComponent(this.jPanel1);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -1, 967, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1).addContainerGap()));
    }

    private void cbRefreshFrequencyActionPerformed(ActionEvent evt) {
        RefreshFrequency rf = (RefreshFrequency)((Object)this.cbRefreshFrequency.getSelectedItem());
        if (rf != null) {
            this.setTimer(rf.getMs());
            ComboBoxModel<String> model = this.cbMaxGraphAge.getModel();
            switch (rf.ordinal()) {
                case 0: {
                    if (((MaxGraphAge)((Object)this.cbMaxGraphAge.getSelectedItem())).getSec() <= MaxGraphAge.FOUR_HOURS.getSec()) break;
                    model.setSelectedItem((Object)MaxGraphAge.FOUR_HOURS);
                    break;
                }
                case 1: {
                    if (((MaxGraphAge)((Object)this.cbMaxGraphAge.getSelectedItem())).getSec() <= MaxGraphAge.EIGHT_HOURS.getSec()) break;
                    model.setSelectedItem((Object)MaxGraphAge.EIGHT_HOURS);
                    break;
                }
                case 2: {
                    if (((MaxGraphAge)((Object)this.cbMaxGraphAge.getSelectedItem())).getSec() <= MaxGraphAge.TWELVE_HOURS.getSec()) break;
                    model.setSelectedItem((Object)MaxGraphAge.TWELVE_HOURS);
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    model.setSelectedItem((Object)MaxGraphAge.FOUR_HOURS);
                }
            }
        }
    }

    private void cbMaxGraphAgeActionPerformed(ActionEvent evt) {
        MaxGraphAge ma = (MaxGraphAge)((Object)this.cbMaxGraphAge.getSelectedItem());
        if (ma != null) {
            this.MAX_GRAPH_AGE = ma.getSec();
            ComboBoxModel model = this.cbRefreshFrequency.getModel();
            switch (ma.ordinal()) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    if (((RefreshFrequency)((Object)model.getSelectedItem())).getMs() >= RefreshFrequency.THIRTY_SECONDS.getMs()) break;
                    model.setSelectedItem((Object)RefreshFrequency.THIRTY_SECONDS);
                    break;
                }
                case 4: {
                    if (((RefreshFrequency)((Object)model.getSelectedItem())).getMs() >= RefreshFrequency.ONE_MINUTE.getMs()) break;
                    model.setSelectedItem((Object)RefreshFrequency.ONE_MINUTE);
                    break;
                }
                case 5: 
                case 6: {
                    if (((RefreshFrequency)((Object)model.getSelectedItem())).getMs() >= RefreshFrequency.FIVE_MINUTES.getMs()) break;
                    model.setSelectedItem((Object)RefreshFrequency.FIVE_MINUTES);
                    break;
                }
                default: {
                    model.setSelectedItem((Object)RefreshFrequency.TEN_SECONDS);
                }
            }
        }
    }

    public void componentOpened() {
        this.charts.clear();
        this.datasetsStore.clear();
        this.pGraphs.removeAll();
        this.tfLastUpdate.setText(null);
        this.timer.setInitialDelay(500);
        this.lr = Utilities.actionsGlobalContext().lookupResult(AbstractNode.class);
        this.lr.addLookupListener((LookupListener)this);
        try {
            this.reports = this.apiService.getPUSReports();
            if (this.visibleNodesModel.getProcessNodeVisibleStateMap().isEmpty()) {
                this.visibleNodesModel.setNodesVisibleStateModel(this.reports);
            }
            PusReportsWrapper reportsWrapper = this.getReportsWrapper(this.reports);
            this.updateTree(reportsWrapper);
            this.updateDisplay(reportsWrapper);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PUSMonitorTopComponent.this.outlineView.expandNode(PUSMonitorTopComponent.this.getExplorerManager().getRootContext().getChildren().getNodeAt(0));
                }
            });
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.timer.start();
    }

    public void componentClosed() {
        this.timer.stop();
        this.charts.clear();
        this.datasetsStore.clear();
        this.lr.removeLookupListener((LookupListener)this);
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
        RefreshFrequency rf = (RefreshFrequency)((Object)this.cbRefreshFrequency.getSelectedItem());
        if (rf != null) {
            p.setProperty("refresh", String.valueOf(rf.getMs()));
        }
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
        String v = p.getProperty("refresh");
        if (v != null) {
            try {
                int ms = Integer.valueOf(v);
                for (RefreshFrequency rf : RefreshFrequency.values()) {
                    if (rf.getMs() != ms) continue;
                    this.cbRefreshFrequency.setSelectedItem((Object)rf);
                    this.setTimer(ms);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    private void updateDatasets(Datasets datasets, PusProcessWrapper process) {
        if (datasets.eps == null) {
            datasets.eps = new TimeSeriesCollection();
        }
        if (datasets.latency == null) {
            datasets.latency = new TimeSeriesCollection();
        }
        if (datasets.iqbl == null) {
            datasets.iqbl = new TimeSeriesCollection();
        }
        long lastOnGraph = 0L;
        TimeSeries tsEpp = datasets.eps.getSeries((Comparable)((Object)(this.getNumberAxisTitle(process) != null ? this.getNumberAxisTitle(process) : NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"series.title.eps"))));
        if (tsEpp == null) {
            tsEpp = new TimeSeries((Comparable)((Object)(this.getNumberAxisTitle(process) != null ? this.getNumberAxisTitle(process) : NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"series.title.eps"))));
            tsEpp.setMaximumItemAge((long)this.MAX_GRAPH_AGE);
            datasets.eps.addSeries(tsEpp);
        } else {
            lastOnGraph = tsEpp.getNextTimePeriod().getFirstMillisecond();
            tsEpp.setMaximumItemAge((long)this.MAX_GRAPH_AGE);
        }
        TimeSeries tsMean = datasets.latency.getSeries((Comparable)((Object)NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"series.title.latency")));
        if (tsMean == null) {
            tsMean = new TimeSeries((Comparable)((Object)NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"series.title.latency")));
            tsMean.setMaximumItemAge((long)this.MAX_GRAPH_AGE);
            datasets.latency.addSeries(tsMean);
        } else {
            tsMean.setMaximumItemAge((long)this.MAX_GRAPH_AGE);
        }
        TimeSeries tsIQBL = datasets.iqbl.getSeries((Comparable)((Object)(this.getIQBLAxisTitle(process) != null ? this.getIQBLAxisTitle(process) : NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"series.title.iqbl"))));
        if (!this.getIQBLAxisTitle(process).equals("N/A")) {
            if (tsIQBL == null) {
                tsIQBL = new TimeSeries((Comparable)((Object)(this.getIQBLAxisTitle(process) != null ? this.getIQBLAxisTitle(process) : NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"series.title.iqbl"))));
                tsIQBL.setMaximumItemAge((long)this.MAX_GRAPH_AGE);
                datasets.iqbl.addSeries(tsIQBL);
            } else {
                tsIQBL.setMaximumItemAge((long)this.MAX_GRAPH_AGE);
            }
        }
        for (PusReport pr : process.getReports()) {
            if (pr.getFinish() < lastOnGraph) continue;
            long length = (pr.getFinish() - pr.getStart()) / 1000L;
            float eps = pr.getCount();
            if (!process.getName().equalsIgnoreCase("Database Health")) {
                eps = length == 0L ? 0.0f : (float)Math.floor((float)pr.getCount() / (float)length);
            }
            try {
                tsEpp.add(RegularTimePeriod.createInstance(Second.class, (Date)new Date(pr.getFinish()), (TimeZone)TimeZone.getDefault(), (Locale)Locale.getDefault()), (double)eps);
            }
            catch (SeriesException seriesException) {
                // empty catch block
            }
            try {
                if (pr.getProcessName().equalsIgnoreCase("scheduler")) {
                    tsMean.add(RegularTimePeriod.createInstance(Second.class, (Date)new Date(pr.getFinish()), (TimeZone)TimeZone.getDefault(), (Locale)Locale.getDefault()), (double)((float)pr.getMeanLatency() / 1000.0f));
                } else if (process.getName().equalsIgnoreCase("Database Health")) {
                    tsMean.add(RegularTimePeriod.createInstance(Second.class, (Date)new Date(pr.getFinish()), (TimeZone)TimeZone.getDefault(), (Locale)Locale.getDefault()), (double)((float)pr.getMeanLatency() / 1.0E9f));
                } else {
                    tsMean.add(RegularTimePeriod.createInstance(Second.class, (Date)new Date(pr.getFinish()), (TimeZone)TimeZone.getDefault(), (Locale)Locale.getDefault()), (double)((float)pr.getMeanLatency() / 1000000.0f));
                }
            }
            catch (SeriesException seriesException) {
                // empty catch block
            }
            try {
                tsIQBL.add(RegularTimePeriod.createInstance(Second.class, (Date)new Date(pr.getFinish()), (TimeZone)TimeZone.getDefault(), (Locale)Locale.getDefault()), (double)pr.getMeanIQBL());
            }
            catch (SeriesException seriesException) {
                // empty catch block
            }
            lastOnGraph = pr.getFinish();
        }
    }

    private JFreeChart createChart(PusNodeWrapper node, PusProcessWrapper process) {
        GraphKey key = new GraphKey(node.getName(), process.getName());
        Datasets datasets = this.datasetsStore.get(key);
        if (datasets == null) {
            datasets = new Datasets(this);
            this.datasetsStore.put(key, datasets);
        }
        this.updateDatasets(datasets, process);
        DateAxis timeAxis = new DateAxis(null);
        timeAxis.setLowerMargin(0.01);
        timeAxis.setUpperMargin(0.01);
        String numberAxisTitle = this.getNumberAxisTitle(process);
        NumberAxis epsAxis = new NumberAxis(numberAxisTitle);
        epsAxis.setNumberFormatOverride(DecimalFormat.getInstance());
        epsAxis.setAutoRangeIncludesZero(true);
        NumberAxis latencyAxis = new NumberAxis(NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"series.title.latency"));
        latencyAxis.setNumberFormatOverride((NumberFormat)new DecimalFormat("#,###.## ms"));
        latencyAxis.setAutoRangeIncludesZero(false);
        String iqblAxisTitle = this.getIQBLAxisTitle(process);
        NumberAxis iqblAxis = new NumberAxis(iqblAxisTitle);
        iqblAxis.setAutoRangeIncludesZero(true);
        iqblAxis.setNumberFormatOverride((NumberFormat)new DecimalFormat("0.###E0"));
        XYPlot plot = new XYPlot();
        XYLineAndShapeRenderer epsRenderer = new XYLineAndShapeRenderer(true, true);
        epsRenderer.setAutoPopulateSeriesPaint(false);
        epsRenderer.setAutoPopulateSeriesShape(false);
        epsRenderer.setSeriesPaint(0, (Paint)COLORS[5]);
        epsRenderer.setSeriesShape(0, ShapeUtils.createDiagonalCross((float)0.6f, (float)0.6f));
        epsRenderer.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
        DeviationRenderer latencyRenderer = new DeviationRenderer();
        latencyRenderer.setAutoPopulateSeriesPaint(false);
        latencyRenderer.setAutoPopulateSeriesShape(false);
        latencyRenderer.setSeriesPaint(0, (Paint)COLORS[6]);
        latencyRenderer.setSeriesShape(0, ShapeUtils.createDiagonalCross((float)0.6f, (float)0.6f));
        latencyRenderer.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
        XYLineAndShapeRenderer iqblRenderer = new XYLineAndShapeRenderer();
        iqblRenderer.setAutoPopulateSeriesPaint(false);
        iqblRenderer.setAutoPopulateSeriesShape(false);
        iqblRenderer.setSeriesPaint(0, (Paint)COLORS[7]);
        iqblRenderer.setSeriesShape(0, ShapeUtils.createDiagonalCross((float)0.6f, (float)0.6f));
        iqblRenderer.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
        plot.setDomainAxis((ValueAxis)timeAxis);
        plot.setRangeAxis(0, (ValueAxis)epsAxis);
        plot.setRangeAxis(1, (ValueAxis)latencyAxis);
        plot.setRangeAxis(2, (ValueAxis)iqblAxis);
        plot.setDataset(0, (XYDataset)datasets.eps);
        plot.setDataset(1, (XYDataset)datasets.latency);
        plot.setDataset(2, (XYDataset)datasets.iqbl);
        plot.setRenderer(0, (XYItemRenderer)epsRenderer);
        plot.setRenderer(1, (XYItemRenderer)latencyRenderer);
        if (!iqblAxis.getLabel().equals("N/A")) {
            plot.setRenderer(2, (XYItemRenderer)iqblRenderer);
        }
        plot.mapDatasetToRangeAxis(0, 0);
        plot.mapDatasetToRangeAxis(1, 1);
        plot.mapDatasetToRangeAxis(2, 2);
        JFreeChart chart = new JFreeChart(String.format("%s:%s", node.getName(), process.getName()), JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        new StandardChartTheme("JFree").apply(chart);
        epsAxis.setLabelPaint((Paint)COLORS[5]);
        latencyAxis.setLabelPaint((Paint)COLORS[6]);
        iqblAxis.setLabelPaint((Paint)COLORS[7]);
        chart.getTitle().setFont(new Font("Sans Serif", 1, 20));
        return chart;
    }

    private String getIQBLAxisTitle(PusProcessWrapper process) {
        String processName = process.getName().toLowerCase();
        if (processName.equalsIgnoreCase("Database Health")) {
            return NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"series.title.redIndices");
        }
        if (processName.equalsIgnoreCase("Correlation Context Maintenance Service")) {
            return NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"series.title.contextObjects");
        }
        if (processName.contains("correlator")) {
            return NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"series.title.correlatorsQueue");
        }
        if (processName.contains("database persister")) {
            return NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"series.title.persisterQueue");
        }
        if (processName.contains("listener udp")) {
            return NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"series.title.listenerUDP");
        }
        if (processName.contains("listener tcp")) {
            return NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"series.title.tcpListenerQueue");
        }
        if (processName.contains("parser")) {
            return NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"series.title.parserQueue");
        }
        if (processName.contains("syslog listener")) {
            return NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"series.title.syslogListener");
        }
        if (processName.equals("threats crawler")) {
            return NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"series.title.threatIndicators");
        }
        if (processName.equals("scheduler")) {
            return NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"series.title.scheduler");
        }
        return NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"series.title.iqbl");
    }

    private String getNumberAxisTitle(PusProcessWrapper process) {
        if (process.getName().contains("Correlator")) {
            return NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"series.title.rps");
        }
        if (process.getName().equalsIgnoreCase("Database Health")) {
            return NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"series.title.activeIndices");
        }
        if (process.getName().equalsIgnoreCase("Threats Crawler")) {
            return NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"series.title.downloadedIOCs");
        }
        return NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"series.title.eps");
    }

    private void updateTree(PusReportsWrapper reports) {
        RootNode root = new RootNode(reports.getNodes());
        root.addNodeListener((NodeListener)this.nodeListener);
        this.state.setPrevNode((Node)root);
        this.explorerManager.setRootContext((Node)root);
    }

    private void updateDisplay(PusReportsWrapper reports) {
        this.tfLastUpdate.setText(new SimpleDateFormat("HH:mm:ss.S").format(new Date()));
        for (PusNodeWrapper node : reports.getNodes()) {
            for (PusProcessWrapper process : node.getProcesses()) {
                this.updateCharts(node, process);
            }
        }
    }

    private void updateCharts(PusNodeWrapper node, PusProcessWrapper process) {
        GraphKey key = new GraphKey(node.getName(), process.getName());
        JFreeChart g = this.charts.get(key);
        if (g == null) {
            g = this.createChart(node, process);
            this.charts.put(key, g);
            ChartPanel cp = new ChartPanel(g);
            Dimension d = cp.getSize();
            d.height = 200;
            cp.setMinimumSize(d);
            cp.setPreferredSize(d);
            cp.setMaximumSize(d);
            cp.setSize(d);
            this.chartPanels.put(process.getName(), cp);
            if (this.visibleNodesModel.getNodeVisibility(process.getName())) {
                this.pGraphs.add((Component)cp);
                this.pGraphs.revalidate();
                this.chartPanelsPositions.add(process.getName());
            }
        } else {
            this.chartPanelsPositions.clear();
            this.pGraphs.removeAll();
            for (String processKey : this.chartPanels.keySet()) {
                if (!this.visibleNodesModel.getNodeVisibility(processKey)) continue;
                this.pGraphs.add((Component)this.chartPanels.get(processKey));
                this.chartPanelsPositions.add(processKey);
            }
            this.pGraphs.revalidate();
            Datasets datasets = this.datasetsStore.get(key);
            if (datasets == null) {
                datasets = new Datasets(this);
                this.datasetsStore.put(key, datasets);
            }
            this.updateDatasets(datasets, process);
        }
    }

    public void resultChanged(LookupEvent ev) {
        Lookup.Result lookupResult = (Lookup.Result)ev.getSource();
        Collection instances = lookupResult.allInstances();
        for (Object o : instances) {
            if (o instanceof ProcessNode) {
                Component component;
                PusProcess proc = ((ProcessNode)o).getPusProcess();
                PusReport r = (PusReport)proc.getReports().get(0);
                ArrayList<String> nodesToExpand = new ArrayList<String>();
                nodesToExpand.add(r.getNodeName());
                nodesToExpand.add(r.getProcessName());
                this.state.setNodesToExpand(nodesToExpand);
                this.spGraphs.getHorizontalScrollBar().setValue(0);
                if (this.chartPanelsPositions.isEmpty()) continue;
                int pos = this.findProcessIndex(proc);
                if (pos != -1) {
                    this.spGraphs.getVerticalScrollBar().setValue(200 * pos);
                } else {
                    pos = 0;
                }
                if (this.prevChartPanel != null) {
                    this.prevChartPanel.setBorder((Border)new EmptyBorder(1, 1, 1, 1));
                }
                if ((component = this.pGraphs.getComponent(pos)) == null) continue;
                ChartPanel chartPanel = (ChartPanel)this.pGraphs.getComponent(pos);
                chartPanel.setBorder((Border)new LineBorder(Color.darkGray));
                this.prevChartPanel = chartPanel;
                continue;
            }
            if (!(o instanceof NodeNode) && !(o instanceof RootNode)) continue;
            this.state.setNodesToExpand(Collections.EMPTY_LIST);
            if (this.prevChartPanel == null) continue;
            this.prevChartPanel.setBorder((Border)new EmptyBorder(1, 1, 1, 1));
        }
    }

    private int findProcessIndex(PusProcess process) {
        return this.chartPanelsPositions.indexOf(process.getName());
    }

    private PusReportsWrapper getReportsWrapper(PusReports reports) {
        List nodes = reports.getNodes();
        ArrayList<PusNodeWrapper> nodesWrapper = new ArrayList<PusNodeWrapper>();
        nodes.stream().map(n -> {
            ArrayList<PusProcessWrapper> pusProcessWrapppers = new ArrayList<PusProcessWrapper>();
            n.getProcesses().stream().map(pp -> new PusProcessWrapper((PusProcess)pp, this.visibleNodesModel.getNodeVisibility(pp.getName()))).forEachOrdered(ppw -> pusProcessWrapppers.add((PusProcessWrapper)ppw));
            PusNodeWrapper pnw = new PusNodeWrapper(n.getName(), pusProcessWrapppers);
            return pnw;
        }).forEachOrdered(pnw -> nodesWrapper.add((PusNodeWrapper)pnw));
        return new PusReportsWrapper(nodesWrapper);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("nodeChecked")) {
            PusReportsWrapper reportsWrapper = this.getReportsWrapper(this.reports);
            this.updateDisplay(reportsWrapper);
        } else if (evt.getPropertyName().equals("allNodesChecked")) {
            PusReportsWrapper reportsWrapper = this.getReportsWrapper(this.reports);
            this.updateTree(reportsWrapper);
            this.updateDisplay(reportsWrapper);
        }
    }

    private void setTimer(int delay) {
        this.timer.setInitialDelay(delay);
        this.timer.setDelay(delay);
        this.timer.restart();
    }

    private static enum RefreshFrequency {
        TEN_SECONDS(10000),
        THIRTY_SECONDS(30000),
        ONE_MINUTE(60000),
        FIVE_MINUTES(300000);

        private final int ms;
        private static final String[] suffix;

        private RefreshFrequency(int ms) {
            this.ms = ms;
        }

        public String toString() {
            int i = 0;
            int v = this.ms / 1000;
            while (v >= 60) {
                v /= 60;
                ++i;
            }
            return NbBundle.getMessage(PUSMonitorTopComponent.class, (String)("freq_" + suffix[i]), (Object)v);
        }

        public int getMs() {
            return this.ms;
        }

        static {
            suffix = new String[]{"seconds", "minutes", "hours"};
        }
    }

    private static enum MaxGraphAge {
        ONE_HOUR(3600),
        TWO_HOUR(7200),
        FOUR_HOURS(14400),
        EIGHT_HOURS(28800),
        TWELVE_HOURS(43200),
        TWENTY_FOUR_HOURS(86400),
        FORTY_EIGHT_HOURS(172800);

        private final int sec;

        private MaxGraphAge(int sec) {
            this.sec = sec;
        }

        public String toString() {
            int i = 0;
            int v = this.sec;
            while (v >= 60) {
                v /= 60;
                ++i;
            }
            return NbBundle.getMessage(PUSMonitorTopComponent.class, (String)"max_graph_age", (Object)v);
        }

        public int getSec() {
            return this.sec;
        }
    }

    private class Datasets {
        public TimeSeriesCollection eps;
        public TimeSeriesCollection latency;
        public TimeSeriesCollection iqbl;

        private Datasets(PUSMonitorTopComponent pUSMonitorTopComponent) {
        }
    }

    public class Updater
    extends SwingWorker<PusReports, Void> {
        @Override
        protected PusReports doInBackground() throws Exception {
            ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
            if (apiService != null) {
                try {
                    return apiService.getPUSReports();
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return null;
        }

        @Override
        protected void done() {
            try {
                PUSMonitorTopComponent.this.reports = (PusReports)this.get();
                if (PUSMonitorTopComponent.this.reports != null) {
                    PusReportsWrapper reportsWrapper = PUSMonitorTopComponent.this.getReportsWrapper(PUSMonitorTopComponent.this.reports);
                    PUSMonitorTopComponent.this.updateTree(reportsWrapper);
                    PUSMonitorTopComponent.this.updateDisplay(reportsWrapper);
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

