/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.threats;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import rs.co.ast.aspen.gui.module.threats.AnalysisTableModel;
import rs.co.ast.aspen.gui.module.threats.InMemoryDatabase;
import rs.co.ast.aspen.gui.module.threats.ThreatTableModel;

public final class SQLCountAction
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e) {
        SwingWorker<List<Map<String, String>>, Void> worker = new SwingWorker<List<Map<String, String>>, Void>(this){
            private ThreatTableModel tableModel = (ThreatTableModel)Lookup.getDefault().lookup(ThreatTableModel.class);
            private AnalysisTableModel analysisTableModel = (AnalysisTableModel)Lookup.getDefault().lookup(AnalysisTableModel.class);

            @Override
            protected List<Map<String, String>> doInBackground() throws Exception {
                List<Map<String, String>> results = null;
                InMemoryDatabase memDB = (InMemoryDatabase)Lookup.getDefault().lookup(InMemoryDatabase.class);
                String countColumn = this.tableModel.getNewlyAddedColumn();
                if (countColumn != null) {
                    ArrayList<String> columns = new ArrayList<String>();
                    columns.add(countColumn);
                    results = memDB.executeCountQuery(columns);
                }
                return results;
            }

            @Override
            protected void done() {
                try {
                    List data = (List)this.get();
                    this.analysisTableModel.setData(data);
                }
                catch (InterruptedException | ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
        worker.execute();
    }
}

