/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.rawlogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.util.Lookup;
import rs.co.ast.aspen.gui.rawlogs.query.RawLogQueryHistory;

public class AutoCompleteDecorator {
    private static final Logger logger = Logger.getLogger(AutoCompleteDecorator.class.getName());
    private RawLogQueryHistory queryHistory = (RawLogQueryHistory)Lookup.getDefault().lookup(RawLogQueryHistory.class);
    private DefaultComboBoxModel model = new DefaultComboBoxModel();
    private JComboBox cbInput = new JComboBox(this.model){

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(super.getPreferredSize().width, 0);
        }
    };
    private boolean guessing = false;

    public void autoComplete(final JTextField tb, final Set<String> items) {
        AutoCompleteDecorator.setAdjusting(this.cbInput, false);
        for (String cat : items) {
            this.cbInput.addItem(cat);
        }
        this.cbInput.setEditable(true);
        this.cbInput.setSelectedItem(null);
        this.cbInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!AutoCompleteDecorator.isAdjusting(AutoCompleteDecorator.this.cbInput) && AutoCompleteDecorator.this.cbInput.getSelectedItem() != null) {
                    tb.setText(AutoCompleteDecorator.this.cbInput.getSelectedItem().toString());
                    AutoCompleteDecorator.this.guessing = false;
                }
            }
        });
        tb.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                AutoCompleteDecorator.setAdjusting(AutoCompleteDecorator.this.cbInput, true);
                if (e.getKeyCode() == 39 && AutoCompleteDecorator.this.cbInput.getSelectedIndex() != -1) {
                    tb.setText(AutoCompleteDecorator.this.cbInput.getSelectedItem().toString());
                }
                if (e.getKeyCode() == 10 || e.getKeyCode() == 38 || e.getKeyCode() == 40) {
                    e.setSource(AutoCompleteDecorator.this.cbInput);
                    AutoCompleteDecorator.this.cbInput.dispatchEvent(e);
                    if (e.getKeyCode() == 10 && AutoCompleteDecorator.this.cbInput.getSelectedItem() != null) {
                        tb.setText(AutoCompleteDecorator.this.cbInput.getSelectedItem().toString());
                        AutoCompleteDecorator.this.cbInput.setPopupVisible(false);
                        AutoCompleteDecorator.this.guessing = false;
                    }
                }
                if (e.getKeyCode() == 27) {
                    AutoCompleteDecorator.this.cbInput.setPopupVisible(false);
                    AutoCompleteDecorator.this.guessing = false;
                    AutoCompleteDecorator.this.cbInput.setSelectedIndex(-1);
                }
                AutoCompleteDecorator.setAdjusting(AutoCompleteDecorator.this.cbInput, false);
            }
        });
        tb.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateList();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateList();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateList();
            }

            private void updateList() {
                AutoCompleteDecorator.setAdjusting(AutoCompleteDecorator.this.cbInput, true);
                AutoCompleteDecorator.this.model.removeAllElements();
                Set<String> queries = AutoCompleteDecorator.this.queryHistory.getQueries();
                String input = tb.getText();
                if (!input.isEmpty() && !queries.contains(input)) {
                    AutoCompleteDecorator.this.model.addElement(tb.getText());
                }
                if (!input.isEmpty()) {
                    queries.stream().filter(query -> query.toLowerCase().contains(input.toLowerCase())).forEachOrdered(query -> AutoCompleteDecorator.this.model.addElement(query));
                    items.stream().filter(cat -> cat.toLowerCase().contains(input.toLowerCase())).forEachOrdered(cat -> AutoCompleteDecorator.this.model.addElement(cat));
                } else {
                    queries.forEach(q -> AutoCompleteDecorator.this.model.addElement(q));
                    items.forEach(i -> AutoCompleteDecorator.this.model.addElement(i));
                }
                AutoCompleteDecorator.this.cbInput.hidePopup();
                try {
                    if (tb.isFocusOwner()) {
                        AutoCompleteDecorator.this.cbInput.setPopupVisible(AutoCompleteDecorator.this.model.getSize() > 0);
                        AutoCompleteDecorator.this.cbInput.setSelectedIndex(-1);
                    }
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    // empty catch block
                }
                AutoCompleteDecorator.this.guessing = AutoCompleteDecorator.this.model.getSize() > 1;
                AutoCompleteDecorator.setAdjusting(AutoCompleteDecorator.this.cbInput, false);
            }
        });
        tb.setLayout(new BorderLayout());
        tb.add((Component)this.cbInput, "South");
    }

    private static boolean isAdjusting(JComboBox cbInput) {
        if (cbInput.getClientProperty("is_adjusting") instanceof Boolean) {
            return (Boolean)cbInput.getClientProperty("is_adjusting");
        }
        return false;
    }

    private static void setAdjusting(JComboBox cbInput, boolean adjusting) {
        cbInput.putClientProperty("is_adjusting", adjusting);
    }

    public boolean isGuessing() {
        return this.guessing;
    }

    public JComboBox getCbInput() {
        return this.cbInput;
    }
}

