/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.alertevents.simplecorrelator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.SecurityEvent;
import rs.co.ast.aspen.gui.module.alertevents.AlertEventWrapper;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.Action;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.ActionCheckBoxNodeData;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.ActionComboBoxNodeData;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.ActionProperty;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.ActionSpinnerNodeData;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.ActionTextFieldComboBoxNodeData;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.ActionTreeCellEditor;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.ActionTreeCellRenderer;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.ConditionTreeNode;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.EventField;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.OperationTreeNode;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.ParamsTabelModel;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.ParamsTabelPanel;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.SimpleCorrelatorScriptEditorPanel;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.SimpleCorrelatorTabelPanel;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.SimpleCorrelatorTableModel;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.SimpleCorrelatorTreeTransferHandler;

public class SimpleCorrelatorPanel
extends JPanel {
    private static final DateTimeFormatter ISO_TIME_FORMAT = ISODateTimeFormat.dateTime();
    private static final String NEW_LINE_AND_TREE_TABS = "\n\t\t\t";
    public static final String WHAT = "what.";
    public static final String WHO = "who.";
    public static final String WHERE = "where.";
    public static final String WHEN = "when.";
    public static final String EXTRA = "extra.";
    public static final String EVENT = "event";
    private static final String PARAMS = "params";
    private static final String WRITE_TO_DATAMAP = "writeToDataMap";
    private static final String IS_FIRST = "isFirst";
    private static final String GENERATE_SECURITY_EVENT = "generateSecurityEventFromParent";
    private static final String GENERATE_RICHER_SECURITY_EVENT = "generateRicherSecurityEventFromParent";
    private static final String GENERATE_SECURITY_EVENT_FROM_CONTEXT = "var event = generateSecurityEventFromContext";
    private static final String GENERATE_RICHER_SECURITY_EVENT_FROM_CONTEXT = "var event = generateRicherSecurityEventFromContext";
    private static final String IF_GENERATE_SECURITY_EVENT = String.format("if(%s.fired) %s", "isFirst", "generateSecurityEventFromParent");
    private static final String NOTIFICATION_SEND = "Notification.send";
    private static final String DATA_MAP_MAP = "DataMap.map";
    private static final String CONTEXT = "Context.get";
    private static final String WRITE_CONTEX_EVENT_TO_DATA_MAP = "writeContextEventToDataMap";
    private static final String TRIGGER = "Trigger";
    private static final String TRIGGER_MODULE_NAME = "TriggerModuleName";
    public static final String PK = NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.dataMap.primaryKey");
    public static final String SK = NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.dataMap.secondaryKey");
    private final AlertEventWrapper securityEvent;
    private SimpleCorrelatorTabelPanel sctp = new SimpleCorrelatorTabelPanel();
    private Map<String, List<ConditionTreeNode>> conditionsMap = new HashMap<String, List<ConditionTreeNode>>();
    private String scriptTemplate = null;
    private String triggerTemplate = null;
    private static Map<String, Boolean> paramsMap = new HashMap<String, Boolean>();
    private final DefaultMutableTreeNode conditionRoot;
    private final DefaultMutableTreeNode actionRoot;
    private final DefaultTreeModel conditionTreeModel;
    private final DefaultTreeModel actionTreeModel;
    private final List<EventField> eventFields = new ArrayList<EventField>();
    private ParamsTabelPanel paramsTabelPanel = new ParamsTabelPanel();
    private Map<String, DefaultMutableTreeNode> actionTreeNodesMap = new HashMap<String, DefaultMutableTreeNode>();
    private SimpleCorrelatorScriptEditorPanel scriptEditorPanel = new SimpleCorrelatorScriptEditorPanel();
    private final RSyntaxTextArea taScriptText = this.scriptEditorPanel.getTaScriptText();
    private JButton bAnd;
    private JButton bNot;
    private JButton bOr;
    private JButton bRemove;
    private JLabel jLabel3;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane5;
    private JSplitPane jSplitPane1;
    private JTree jtrAction;
    private JTree jtrCondition;
    private JMenu mAdd;
    private JMenuItem mAnd;
    private JMenu mChangeLogicalOperation;
    private JMenuItem mChangeToAnd;
    private JMenuItem mChangeToNot;
    private JMenuItem mChangeToOr;
    private JMenuItem mEdit;
    private JMenuItem mEditA;
    private JMenuItem mNot;
    private JMenuItem mOr;
    private JMenuItem mRemove;
    private JPanel pAction;
    private JPanel pScriptEditor;
    private JPanel pScriptName;
    private JPopupMenu pmTree;
    private JPopupMenu pmTreeA;
    private JSplitPane spConditon;
    private JScrollPane spTabelParams;
    private JScrollPane spTable;
    private JTabbedPane tabbedPanel;
    private JTextField tfScriptName;

    public SimpleCorrelatorPanel(AlertEventWrapper se) {
        this.initComponents();
        this.securityEvent = se;
        this.actionRoot = (DefaultMutableTreeNode)this.jtrAction.getModel().getRoot();
        this.conditionRoot = (DefaultMutableTreeNode)this.jtrCondition.getModel().getRoot();
        this.conditionTreeModel = (DefaultTreeModel)this.jtrCondition.getModel();
        this.actionTreeModel = (DefaultTreeModel)this.jtrAction.getModel();
        paramsMap.clear();
        this.spTable.setViewportView(this.sctp);
        this.setEventFields(this.securityEvent.getEvent());
        this.sctp.getTableModel().setTabelData(this.eventFields);
        this.paramsTabelPanel.getTabelModel().setTabelData(this.eventFields);
        this.setActionTabEnabled(false);
        this.pScriptEditor.add(this.scriptEditorPanel);
        this.jtrCondition.setDragEnabled(true);
        this.jtrCondition.setDropMode(DropMode.ON_OR_INSERT);
        this.jtrCondition.setTransferHandler(new SimpleCorrelatorTreeTransferHandler());
        this.jtrCondition.getSelectionModel().setSelectionMode(2);
        this.jtrCondition.setSelectionRow(0);
        this.addTreeNode(new DefaultMutableTreeNode((Object)OperationTreeNode.AND));
        this.jtrCondition.expandRow(0);
        this.jtrCondition.setSelectionRow(1);
        this.conditionTreeModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                SimpleCorrelatorPanel.this.jtrCondition.expandPath(e.getTreePath());
                SimpleCorrelatorPanel.this.setScriptText();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                SimpleCorrelatorPanel.this.addTreeConditionToConditionMap(e);
                SimpleCorrelatorPanel.this.jtrCondition.expandPath(e.getTreePath());
                SimpleCorrelatorPanel.this.setScriptText();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                SimpleCorrelatorPanel.this.jtrCondition.setSelectionPath(e.getTreePath());
                SimpleCorrelatorPanel.this.setScriptText();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                SimpleCorrelatorPanel.this.jtrCondition.expandPath(e.getTreePath());
                SimpleCorrelatorPanel.this.setScriptText();
            }
        });
        this.jtrAction.setCellRenderer(new ActionTreeCellRenderer());
        this.jtrAction.setCellEditor(new ActionTreeCellEditor());
        this.jtrAction.setEditable(true);
        this.actionTreeModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                Object[] children;
                for (Object dNode : children = e.getChildren()) {
                    Object userObject = ((DefaultMutableTreeNode)dNode).getUserObject();
                    if (!(userObject instanceof ActionCheckBoxNodeData) || !userObject.toString().equals(SimpleCorrelatorPanel.DATA_MAP_MAP)) continue;
                    if (((ActionCheckBoxNodeData)userObject).isSelected()) {
                        SimpleCorrelatorPanel.this.spTabelParams.setViewportView(SimpleCorrelatorPanel.this.paramsTabelPanel);
                        continue;
                    }
                    SimpleCorrelatorPanel.this.spTabelParams.setViewportView(null);
                }
                SimpleCorrelatorPanel.this.jtrAction.expandPath(e.getTreePath());
                SimpleCorrelatorPanel.this.setScriptText();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                Object[] children;
                for (Object object : children = e.getChildren()) {
                    this.addTreeNodesToActionNodesMap((DefaultMutableTreeNode)object);
                }
                SimpleCorrelatorPanel.this.jtrAction.expandPath(e.getTreePath());
                SimpleCorrelatorPanel.this.setScriptText();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                Object[] children;
                for (Object child : children = e.getChildren()) {
                    this.deleteTreeNodesFromActionNodesMap((DefaultMutableTreeNode)child);
                }
                SimpleCorrelatorPanel.this.jtrAction.setSelectionPath(e.getTreePath());
                SimpleCorrelatorPanel.this.setScriptText();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                SimpleCorrelatorPanel.this.setScriptText();
            }

            private void deleteTreeNodesFromActionNodesMap(DefaultMutableTreeNode node) {
                if (node.getChildCount() > 0) {
                    for (int i = 0; i < node.getChildCount(); ++i) {
                        this.deleteTreeNodesFromActionNodesMap((DefaultMutableTreeNode)node.getChildAt(i));
                    }
                }
                if (node.getUserObject() instanceof ActionProperty) {
                    ActionProperty userObject = (ActionProperty)node.getUserObject();
                    SimpleCorrelatorPanel.this.actionTreeNodesMap.remove(userObject.getProperty());
                } else {
                    SimpleCorrelatorPanel.this.actionTreeNodesMap.remove(node.toString());
                }
            }

            private void addTreeNodesToActionNodesMap(DefaultMutableTreeNode node) {
                if (node.getUserObject() instanceof ActionProperty) {
                    ActionProperty userObject = (ActionProperty)node.getUserObject();
                    SimpleCorrelatorPanel.this.actionTreeNodesMap.put(userObject.getProperty(), node);
                } else {
                    SimpleCorrelatorPanel.this.actionTreeNodesMap.put(node.toString(), node);
                }
                if (node.getChildCount() > 0) {
                    for (int i = 0; i < node.getChildCount(); ++i) {
                        this.addTreeNodesToActionNodesMap((DefaultMutableTreeNode)node.getChildAt(i));
                    }
                }
            }
        });
        this.paramsTabelPanel.getTabelModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getColumn() < 2) {
                    SimpleCorrelatorPanel.this.paramsTabelPanel.getTabelModel().getData().forEach(item -> {
                        if (e.getColumn() == 0 && item.isPrimaryKey()) {
                            this.changeKey((ParamsTabelModel.Item)item, PK + "=");
                        }
                        if (e.getColumn() == 1 && item.isSecondaryKey()) {
                            this.changeKey((ParamsTabelModel.Item)item, SK + "=");
                        }
                    });
                }
                if (e.getColumn() == 2) {
                    DefaultMutableTreeNode paramsNode = null;
                    if (SimpleCorrelatorPanel.this.actionTreeNodesMap.containsKey(SimpleCorrelatorPanel.PARAMS)) {
                        paramsNode = SimpleCorrelatorPanel.this.actionTreeNodesMap.get(SimpleCorrelatorPanel.PARAMS);
                    }
                    int firstRow = e.getFirstRow();
                    ParamsTabelModel.Item row = SimpleCorrelatorPanel.this.paramsTabelPanel.getTabelModel().getData().get(firstRow);
                    if (row.isParams()) {
                        if (!SimpleCorrelatorPanel.this.actionTreeNodesMap.containsKey(row.getField()) && paramsNode != null) {
                            DefaultMutableTreeNode node = new DefaultMutableTreeNode(row, false);
                            SimpleCorrelatorPanel.this.actionTreeModel.insertNodeInto(node, paramsNode, paramsNode.getChildCount());
                        }
                    } else if (SimpleCorrelatorPanel.this.actionTreeNodesMap.containsKey(row.getField()) && paramsNode != null) {
                        DefaultMutableTreeNode rowNode = SimpleCorrelatorPanel.this.actionTreeNodesMap.get(row.getField());
                        SimpleCorrelatorPanel.this.actionTreeModel.removeNodeFromParent(rowNode);
                    }
                }
                if (e.getColumn() == 3) {
                    SimpleCorrelatorPanel.this.setScriptText();
                }
            }

            private void changeKey(ParamsTabelModel.Item item, String key) {
                if (SimpleCorrelatorPanel.this.actionTreeNodesMap.containsKey(key)) {
                    DefaultMutableTreeNode node = SimpleCorrelatorPanel.this.actionTreeNodesMap.get(key);
                    if (node.getUserObject() instanceof ActionProperty) {
                        ActionProperty userObject = (ActionProperty)node.getUserObject();
                        userObject.setItem(item);
                    }
                    SimpleCorrelatorPanel.this.actionTreeModel.nodeChanged(node);
                }
            }
        });
        JCheckBox cbGenSEonFirst = this.paramsTabelPanel.getCbGenSEonFirst();
        cbGenSEonFirst.addActionListener(e -> {
            if (cbGenSEonFirst.isSelected()) {
                if (!this.actionTreeNodesMap.containsKey(IS_FIRST)) {
                    DefaultMutableTreeNode writeToDataMap = this.actionTreeNodesMap.get(WRITE_TO_DATAMAP);
                    DefaultMutableTreeNode node = new DefaultMutableTreeNode(IS_FIRST);
                    this.actionTreeModel.insertNodeInto(node, writeToDataMap, writeToDataMap.getChildCount());
                    this.addGenerateSecurityEvent(IF_GENERATE_SECURITY_EVENT, false, true);
                }
            } else if (this.actionTreeNodesMap.containsKey(IS_FIRST)) {
                DefaultMutableTreeNode isFirstNode = this.actionTreeNodesMap.get(IS_FIRST);
                this.actionTreeModel.removeNodeFromParent(isFirstNode);
                if (this.actionTreeNodesMap.containsKey(IF_GENERATE_SECURITY_EVENT)) {
                    DefaultMutableTreeNode ifGenerateSecurityEvent = this.actionTreeNodesMap.get(IF_GENERATE_SECURITY_EVENT);
                    this.actionTreeModel.removeNodeFromParent(ifGenerateSecurityEvent);
                }
            }
        });
        this.sctp.getTableModel().addTableModelListener(e -> {
            if (e.getColumn() == 3) {
                Object rowValueAt = this.sctp.getTableModel().getRowValueAt(e.getFirstRow());
                SimpleCorrelatorTableModel.Item s = (SimpleCorrelatorTableModel.Item)rowValueAt;
                ConditionTreeNode c = new ConditionTreeNode(s);
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(c, false);
                this.addTreeNode(node);
            }
        });
        this.tfScriptName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.validateConditionText();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.validateConditionText();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.validateConditionText();
            }

            private void validateConditionText() {
                if (!SimpleCorrelatorPanel.this.tfScriptName.getText().isEmpty()) {
                    SimpleCorrelatorPanel.this.tfScriptName.setBorder(UIManager.getBorder("TextField.border"));
                } else {
                    SimpleCorrelatorPanel.this.tfScriptName.setBorder(new LineBorder(Color.red, 1));
                }
                SimpleCorrelatorPanel.this.setScriptText();
            }
        });
    }

    private void populateActionTree() throws MissingResourceException {
        this.addGenerateSecurityEvent(GENERATE_SECURITY_EVENT, true, false);
        this.addGenerateRicherSecurityEvent(GENERATE_RICHER_SECURITY_EVENT, true, false);
        this.addSendNotificantionToActionTree(this.actionRoot, false);
        this.addDataMapMaptoActionTree();
        this.addContextToActionTree();
    }

    private void initComponents() {
        this.pmTree = new JPopupMenu();
        this.mRemove = new JMenuItem();
        this.mEdit = new JMenuItem();
        this.mAdd = new JMenu();
        this.mAnd = new JMenuItem();
        this.mOr = new JMenuItem();
        this.mNot = new JMenuItem();
        this.mChangeLogicalOperation = new JMenu();
        this.mChangeToAnd = new JMenuItem();
        this.mChangeToOr = new JMenuItem();
        this.mChangeToNot = new JMenuItem();
        this.pmTreeA = new JPopupMenu();
        this.mEditA = new JMenuItem();
        this.jSplitPane1 = new JSplitPane();
        this.tabbedPanel = new JTabbedPane();
        this.spConditon = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel3 = new JPanel();
        this.bAnd = new JButton();
        this.bOr = new JButton();
        this.bRemove = new JButton();
        this.jScrollPane5 = new JScrollPane();
        this.jtrCondition = new JTree();
        this.pScriptName = new JPanel();
        this.jLabel3 = new JLabel();
        this.tfScriptName = new JTextField();
        this.bNot = new JButton();
        this.spTable = new JScrollPane();
        this.pAction = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jtrAction = new JTree();
        this.spTabelParams = new JScrollPane();
        this.pScriptEditor = new JPanel();
        Mnemonics.setLocalizedText((AbstractButton)this.mRemove, (String)NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.mRemove.text"));
        this.mRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleCorrelatorPanel.this.mRemoveActionPerformed(evt);
            }
        });
        this.pmTree.add(this.mRemove);
        Mnemonics.setLocalizedText((AbstractButton)this.mEdit, (String)NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.mEdit.text"));
        this.mEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleCorrelatorPanel.this.mEditActionPerformed(evt);
            }
        });
        this.pmTree.add(this.mEdit);
        Mnemonics.setLocalizedText((AbstractButton)this.mAdd, (String)NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.mAdd.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.mAnd, (String)NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.mAnd.text"));
        this.mAnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleCorrelatorPanel.this.mAndActionPerformed(evt);
            }
        });
        this.mAdd.add(this.mAnd);
        Mnemonics.setLocalizedText((AbstractButton)this.mOr, (String)NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.mOr.text"));
        this.mOr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleCorrelatorPanel.this.mOrActionPerformed(evt);
            }
        });
        this.mAdd.add(this.mOr);
        Mnemonics.setLocalizedText((AbstractButton)this.mNot, (String)NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.mNot.text"));
        this.mNot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleCorrelatorPanel.this.mNotActionPerformed(evt);
            }
        });
        this.mAdd.add(this.mNot);
        this.pmTree.add(this.mAdd);
        Mnemonics.setLocalizedText((AbstractButton)this.mChangeLogicalOperation, (String)NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.mChangeLogicalOperation.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.mChangeToAnd, (String)NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.mChangeToAnd.text"));
        this.mChangeToAnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleCorrelatorPanel.this.mChangeToAndActionPerformed(evt);
            }
        });
        this.mChangeLogicalOperation.add(this.mChangeToAnd);
        Mnemonics.setLocalizedText((AbstractButton)this.mChangeToOr, (String)NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.mChangeToOr.text"));
        this.mChangeToOr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleCorrelatorPanel.this.mChangeToOrActionPerformed(evt);
            }
        });
        this.mChangeLogicalOperation.add(this.mChangeToOr);
        Mnemonics.setLocalizedText((AbstractButton)this.mChangeToNot, (String)NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.mChangeToNot.text"));
        this.mChangeToNot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleCorrelatorPanel.this.mChangeToNotActionPerformed(evt);
            }
        });
        this.mChangeLogicalOperation.add(this.mChangeToNot);
        this.pmTree.add(this.mChangeLogicalOperation);
        Mnemonics.setLocalizedText((AbstractButton)this.mEditA, (String)NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.mEditA.text"));
        this.mEditA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleCorrelatorPanel.this.mEditAActionPerformed(evt);
            }
        });
        this.pmTreeA.add(this.mEditA);
        this.spConditon.setOrientation(0);
        Mnemonics.setLocalizedText((AbstractButton)this.bAnd, (String)NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.bAnd.text"));
        this.bAnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleCorrelatorPanel.this.bAndActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bOr, (String)NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.bOr.text"));
        this.bOr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleCorrelatorPanel.this.bOrActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bRemove, (String)NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.bRemove.text"));
        this.bRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleCorrelatorPanel.this.bRemoveActionPerformed(evt);
            }
        });
        this.jtrCondition.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.jtrCondition.border.title")));
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("if");
        this.jtrCondition.setModel(new DefaultTreeModel(treeNode1));
        this.jtrCondition.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SimpleCorrelatorPanel.this.jtrConditionMouseClicked(evt);
            }
        });
        this.jtrCondition.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SimpleCorrelatorPanel.this.jtrConditionKeyPressed(evt);
            }
        });
        this.jScrollPane5.setViewportView(this.jtrCondition);
        this.pScriptName.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.pScriptName.border.title")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.jLabel3.text"));
        this.tfScriptName.setText(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.tfScriptName.text"));
        this.tfScriptName.setBorder(new LineBorder(new Color(255, 176, 179)));
        this.tfScriptName.setMinimumSize(new Dimension(50, 24));
        this.tfScriptName.setPreferredSize(new Dimension(50, 24));
        this.tfScriptName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                SimpleCorrelatorPanel.this.tfScriptNameKeyTyped(evt);
            }
        });
        GroupLayout pScriptNameLayout = new GroupLayout(this.pScriptName);
        this.pScriptName.setLayout(pScriptNameLayout);
        pScriptNameLayout.setHorizontalGroup(pScriptNameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pScriptNameLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3, -2, 101, -2).addContainerGap(-1, Short.MAX_VALUE)).addGroup(pScriptNameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pScriptNameLayout.createSequentialGroup().addGap(114, 114, 114).addComponent(this.tfScriptName, -1, 222, Short.MAX_VALUE).addContainerGap())));
        pScriptNameLayout.setVerticalGroup(pScriptNameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addGroup(pScriptNameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pScriptNameLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.tfScriptName, -2, 24, -2))));
        Mnemonics.setLocalizedText((AbstractButton)this.bNot, (String)NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.bNot.text"));
        this.bNot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleCorrelatorPanel.this.bNotActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pScriptName, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane5).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.bAnd).addGap(18, 18, 18).addComponent(this.bOr).addGap(18, 18, 18).addComponent(this.bNot).addGap(18, 18, 18).addComponent(this.bRemove).addContainerGap(44, Short.MAX_VALUE)))));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addComponent(this.pScriptName, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bAnd).addComponent(this.bOr).addComponent(this.bRemove).addComponent(this.bNot)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane5, -1, 228, Short.MAX_VALUE)));
        this.jScrollPane1.setViewportView(this.jPanel3);
        this.spConditon.setLeftComponent(this.jScrollPane1);
        this.spConditon.setRightComponent(this.spTable);
        this.tabbedPanel.addTab(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.spConditon.TabConstraints.tabTitle"), this.spConditon);
        this.jtrAction.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.jtrAction.border.title")));
        treeNode1 = new DefaultMutableTreeNode("Actions");
        this.jtrAction.setModel(new DefaultTreeModel(treeNode1));
        this.jtrAction.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SimpleCorrelatorPanel.this.jtrActionMouseClicked(evt);
            }
        });
        this.jtrAction.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SimpleCorrelatorPanel.this.jtrActionKeyPressed(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jtrAction);
        this.spTabelParams.setBorder(null);
        GroupLayout pActionLayout = new GroupLayout(this.pAction);
        this.pAction.setLayout(pActionLayout);
        pActionLayout.setHorizontalGroup(pActionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pActionLayout.createSequentialGroup().addComponent(this.jScrollPane2, -1, 362, Short.MAX_VALUE).addGap(1, 1, 1)).addComponent(this.spTabelParams));
        pActionLayout.setVerticalGroup(pActionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pActionLayout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 320, -2).addGap(18, 18, 18).addComponent(this.spTabelParams, -1, 351, Short.MAX_VALUE)));
        this.tabbedPanel.addTab(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.pAction.TabConstraints.tabTitle"), this.pAction);
        this.jSplitPane1.setLeftComponent(this.tabbedPanel);
        this.pScriptEditor.setMinimumSize(new Dimension(350, 716));
        this.pScriptEditor.setPreferredSize(new Dimension(700, 716));
        this.pScriptEditor.setLayout(new BorderLayout());
        this.jSplitPane1.setRightComponent(this.pScriptEditor);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 1291, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1));
    }

    public String getScriptName() {
        return this.tfScriptName.getText().replaceAll(" ", "_");
    }

    private void setEventFields(SecurityEvent event) {
        this.eventFields.clear();
        if (event != null) {
            if (event.getWhat() != null) {
                Collections.sort(event.getWhat().getEntry(), (o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getKey(), o2.getKey()));
                event.getWhat().getEntry().forEach(e -> this.eventFields.add(new EventField(WHAT, e.getKey(), e.getValue())));
            }
            if (event.getWho() != null) {
                Collections.sort(event.getWho().getEntry(), (o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getKey(), o2.getKey()));
                event.getWho().getEntry().forEach(e -> this.eventFields.add(new EventField(WHO, e.getKey(), e.getValue())));
            }
            if (event.getWhere() != null) {
                Collections.sort(event.getWhere().getEntry(), (o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getKey(), o2.getKey()));
                event.getWhere().getEntry().forEach(e -> this.eventFields.add(new EventField(WHERE, e.getKey(), e.getValue())));
            }
            if (event.getWhen() != null) {
                Collections.sort(event.getWhen().getEntry(), (o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getKey(), o2.getKey()));
                event.getWhen().getEntry().forEach(e -> {
                    try {
                        DateTime dateTime = new DateTime((Object)Long.valueOf(e.getValue()));
                        String hourOfDay = String.valueOf(dateTime.getHourOfDay());
                        this.eventFields.add(new EventField(WHEN, e.getKey(), hourOfDay));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                });
            }
            if (event.getExtra() != null) {
                Collections.sort(event.getExtra().getEntry(), (o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getKey(), o2.getKey()));
                event.getExtra().getEntry().forEach(e -> this.eventFields.add(new EventField(EXTRA, e.getKey(), e.getValue())));
            }
        }
    }

    public String getScriptText() {
        return this.taScriptText.getText();
    }

    public void setPanelEnabled(Container container, Boolean isEnabled) {
        Component[] components;
        container.setEnabled(isEnabled);
        for (Component component : components = container.getComponents()) {
            if (component instanceof Container) {
                this.setPanelEnabled((Container)component, isEnabled);
            }
            component.setEnabled(isEnabled);
        }
    }

    private void setActionTabEnabled(boolean enabled) {
        if (this.actionTreeNodesMap.isEmpty() && enabled) {
            this.populateActionTree();
        }
        this.tabbedPanel.setEnabledAt(1, enabled);
    }

    private String loadScriptTamplate() {
        if (this.scriptTemplate == null) {
            InputStream is = this.getClass().getResourceAsStream("/scripts/correlation_script.txt");
            this.scriptTemplate = new BufferedReader(new InputStreamReader(is)).lines().collect(Collectors.joining("\n"));
        }
        return this.scriptTemplate;
    }

    private String loadTriggerTamplate() {
        if (this.triggerTemplate == null) {
            InputStream is = this.getClass().getResourceAsStream("/scripts/trigger_tamplate.txt");
            this.triggerTemplate = new BufferedReader(new InputStreamReader(is)).lines().collect(Collectors.joining("\n"));
        }
        return this.triggerTemplate;
    }

    private void setScriptText() {
        DefaultMutableTreeNode trModulName = this.actionTreeNodesMap.get("TriggerModuleName=");
        if (trModulName != null) {
            ActionProperty userObject = (ActionProperty)trModulName.getUserObject();
            userObject.setText("'" + this.getScriptName() + "_ACTION'");
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        StringBuilder sb3 = new StringBuilder();
        String scriptExitCondition = this.exitIfConditionText(sb);
        String variables = "";
        if (this.actionTreeNodesMap.containsKey(IS_FIRST)) {
            variables = String.format("var %s = {};", IS_FIRST);
        }
        String scriptCondition = this.ifConditionText(this.conditionRoot, sb1);
        String scriptAction = this.actionText(this.actionRoot, sb2);
        String trigger = "";
        if (this.actionTreeNodesMap.containsKey(CONTEXT) && this.actionTreeNodesMap.containsKey(TRIGGER)) {
            DefaultMutableTreeNode triggerNode = this.actionTreeNodesMap.get(TRIGGER);
            DefaultMutableTreeNode contexNode = this.actionTreeNodesMap.get(CONTEXT);
            if (((ActionCheckBoxNodeData)contexNode.getUserObject()).isSelected()) {
                trigger = String.format(this.loadTriggerTamplate(), this.getScriptName(), this.actionText(triggerNode, sb3));
            }
        }
        String scriptText = String.format(this.loadScriptTamplate(), this.getScriptName(), scriptExitCondition, variables, scriptCondition, scriptAction, trigger);
        this.taScriptText.setText(scriptText);
        this.scriptEditorPanel.validateScriptSyntax(scriptText);
    }

    private void addTreeConditionToConditionMap(TreeModelEvent e) {
        Object[] children;
        for (Object childNode : children = e.getChildren()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)childNode;
            if (!(node.getUserObject() instanceof ConditionTreeNode)) continue;
            ConditionTreeNode c = (ConditionTreeNode)node.getUserObject();
            if (this.conditionsMap.containsKey(c.getKey())) {
                condList = this.conditionsMap.get(c.getKey());
                if (!condList.contains(c)) {
                    condList.add(c);
                }
                this.conditionsMap.put(c.getKey(), condList);
            } else {
                condList = new ArrayList<ConditionTreeNode>();
                condList.add(c);
                this.conditionsMap.put(c.getKey(), (ArrayList)condList);
            }
            this.setActionTabEnabled(true);
        }
    }

    private void deleteTreeNodeConditionFromConditionMap(DefaultMutableTreeNode node) {
        if (node.getUserObject() instanceof ConditionTreeNode) {
            ConditionTreeNode cd = (ConditionTreeNode)node.getUserObject();
            List<ConditionTreeNode> condList = this.conditionsMap.get(cd.getKey());
            condList.remove(cd);
            if (condList.isEmpty()) {
                this.conditionsMap.remove(cd.getKey());
            }
            if (this.conditionsMap.isEmpty()) {
                this.setActionTabEnabled(false);
            }
        }
        if (node.getAllowsChildren()) {
            int childCount = node.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
                this.deleteTreeNodeConditionFromConditionMap(childNode);
            }
        }
    }

    private void addTreeNode(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode parent;
        DefaultMutableTreeNode lastSelectedPath = (DefaultMutableTreeNode)this.jtrCondition.getLastSelectedPathComponent();
        if (lastSelectedPath != null && lastSelectedPath.getAllowsChildren()) {
            if (!lastSelectedPath.isRoot() && !lastSelectedPath.getUserObject().equals((Object)OperationTreeNode.NOT)) {
                this.conditionTreeModel.insertNodeInto(node, lastSelectedPath, lastSelectedPath.getChildCount());
            } else if ((lastSelectedPath.isRoot() || lastSelectedPath.getUserObject().equals((Object)OperationTreeNode.NOT)) && lastSelectedPath.getChildCount() < 1) {
                this.conditionTreeModel.insertNodeInto(node, lastSelectedPath, lastSelectedPath.getChildCount());
            }
        } else if (!(lastSelectedPath == null || lastSelectedPath.getAllowsChildren() || (parent = (DefaultMutableTreeNode)lastSelectedPath.getParent()) == null || parent.isRoot() || parent.getUserObject().equals((Object)OperationTreeNode.NOT) && parent.getChildCount() >= 1)) {
            this.conditionTreeModel.insertNodeInto(node, parent, parent.getChildCount());
        }
    }

    private void deleteTreeNode(JTree tree) {
        DefaultMutableTreeNode lastSelectedPath = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
        DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
        if (tree.equals(this.jtrAction)) {
            if (lastSelectedPath != null && lastSelectedPath.getParent() != null && lastSelectedPath.getChildCount() > 0) {
                treeModel.removeNodeFromParent(lastSelectedPath);
            }
        } else if (tree.equals(this.jtrCondition) && lastSelectedPath != null && lastSelectedPath.getParent() != null) {
            this.deleteTreeNodeConditionFromConditionMap(lastSelectedPath);
            treeModel.removeNodeFromParent(lastSelectedPath);
        }
    }

    private String exitIfConditionText(StringBuilder sb) {
        this.conditionsMap.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            if (!value.isEmpty()) {
                sb.append("if(event.").append(key).append(" == null) return event;\n\t\t");
            }
        });
        return sb.toString();
    }

    private String ifConditionText(DefaultMutableTreeNode node, StringBuilder sb) {
        String parent = "";
        int childCount = node.getChildCount();
        if (node.getUserObject() instanceof OperationTreeNode) {
            OperationTreeNode obj = (OperationTreeNode)((Object)node.getUserObject());
            parent = obj.getOperationScriptText();
        } else {
            sb.append(node);
        }
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
            DefaultMutableTreeNode nextChildNode = null;
            try {
                nextChildNode = (DefaultMutableTreeNode)node.getChildAt(i + 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            if (node.getUserObject() instanceof OperationTreeNode && node.getUserObject().equals((Object)OperationTreeNode.NOT) && (nextChildNode == null || !nextChildNode.getAllowsChildren() || nextChildNode.getChildCount() != 0)) {
                sb.append(parent);
            }
            if (i == 0) {
                sb.append("(");
            }
            if (!childNode.getAllowsChildren()) {
                sb.append(childNode);
            } else {
                this.ifConditionText(childNode, sb);
            }
            if (node.getAllowsChildren() && i != childCount - 1) {
                if (childCount > 1) {
                    sb.append(NEW_LINE_AND_TREE_TABS);
                }
                if (nextChildNode == null || !nextChildNode.getAllowsChildren() || nextChildNode.getChildCount() != 0) {
                    sb.append(parent);
                }
            }
            if (i != childCount - 1) continue;
            sb.append(")");
        }
        return sb.toString();
    }

    private String actionText(DefaultMutableTreeNode node, StringBuilder sb) {
        int childCount = node.getChildCount();
        if (!(node.isRoot() || node.getUserObject().equals(PARAMS) || node.getUserObject().equals(TRIGGER))) {
            sb.append(node);
        }
        for (int i = 0; i < childCount; ++i) {
            Object userObject;
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
            if (childNode.getUserObject().equals(PARAMS) && childNode.getChildCount() < 1) {
                sb.append("{}");
            }
            if (childNode.getChildCount() > 0 && !childNode.getUserObject().equals(TRIGGER)) {
                if (childNode.getUserObject() instanceof ActionCheckBoxNodeData) {
                    if (!((ActionCheckBoxNodeData)childNode.getUserObject()).isSelected()) continue;
                    this.actionText(childNode, sb);
                    continue;
                }
                this.actionText(childNode, sb);
                continue;
            }
            if (i == 0) {
                if (node.getUserObject().equals(PARAMS)) {
                    sb.append(NEW_LINE_AND_TREE_TABS).append("{").append(NEW_LINE_AND_TREE_TABS);
                } else {
                    sb.append("(");
                }
            }
            if ((userObject = childNode.getUserObject()) instanceof ParamsTabelModel.Item) {
                sb.append(((ParamsTabelModel.Item)userObject).getTextForScript());
            }
            if (userObject instanceof ActionProperty) {
                this.appendQuotes(sb, (ActionProperty)userObject);
            }
            if (userObject instanceof Action) {
                sb.append(((Action)userObject).getScriptText());
            }
            if (userObject.equals(IS_FIRST)) {
                sb.append(userObject);
            }
            if (i != childCount - 1) {
                sb.append(",");
                if (node.getUserObject().equals(PARAMS)) {
                    sb.append(NEW_LINE_AND_TREE_TABS);
                }
            }
            if (userObject.equals(TRIGGER)) {
                sb.deleteCharAt(sb.length() - 1);
            }
            if (i != childCount - 1) continue;
            if (node.getUserObject().equals(PARAMS)) {
                sb.append(NEW_LINE_AND_TREE_TABS).append("});").append(NEW_LINE_AND_TREE_TABS);
                continue;
            }
            if (node.getUserObject().equals(WRITE_TO_DATAMAP)) {
                sb.append("),");
                continue;
            }
            sb.append(");").append(NEW_LINE_AND_TREE_TABS);
        }
        return sb.toString();
    }

    private void appendQuotes(StringBuilder sb, ActionProperty ac) {
        String s = ac.getText();
        try {
            Integer number = Integer.valueOf(s);
            sb.append(" ").append(number.toString()).append(" ");
        }
        catch (NumberFormatException ex) {
            if (!ac.isEditable() || ac.getText() != null && ac.getText().startsWith("event.")) {
                sb.append(" ").append(s).append(" ");
            }
            sb.append(" '").append(s).append("' ");
        }
    }

    private void editTreeNode(DefaultMutableTreeNode selectedNode) {
        String messageText;
        String newValue;
        String newValue2;
        Object userObject = selectedNode.getUserObject();
        if (userObject instanceof ActionProperty && ((ActionProperty)userObject).isEditable() && (newValue2 = JOptionPane.showInputDialog(this.jtrAction, "Enter value for " + ((ActionProperty)userObject).getProperty().replace("=", ""), ((ActionProperty)userObject).getText())) != null && !newValue2.startsWith(" ") && !newValue2.isEmpty()) {
            ((ActionProperty)userObject).setText(newValue2);
            this.actionTreeModel.nodeChanged(selectedNode);
        }
        if (userObject instanceof ConditionTreeNode && (newValue = JOptionPane.showInputDialog(this.jtrCondition, String.format(messageText = NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.jtrCondition.EnterConditionParam"), ((ConditionTreeNode)userObject).getKey()), ((ConditionTreeNode)userObject).getValue())) != null && !newValue.startsWith(" ") && !newValue.isEmpty()) {
            ((ConditionTreeNode)userObject).setValue(newValue);
            this.conditionTreeModel.nodeChanged(selectedNode);
        }
    }

    private void editTreeNode(DefaultMutableTreeNode selectedNode, String actionComand) {
        if (selectedNode.getUserObject() instanceof OperationTreeNode) {
            if (actionComand.equalsIgnoreCase(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.mChangeToAnd.text"))) {
                selectedNode.setUserObject((Object)OperationTreeNode.AND);
            }
            if (actionComand.equalsIgnoreCase(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.mChangeToOr.text"))) {
                selectedNode.setUserObject((Object)OperationTreeNode.OR);
            }
            if (actionComand.equalsIgnoreCase(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.mChangeToNot.text"))) {
                if (selectedNode.getChildCount() > 1) {
                    JOptionPane.showMessageDialog(this.jtrCondition, NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.jtrCondition.changeToNotErorMessage"));
                } else {
                    selectedNode.setUserObject((Object)OperationTreeNode.NOT);
                }
            }
            this.conditionTreeModel.nodeChanged(selectedNode);
        }
    }

    private void addGenerateSecurityEvent(String generateSecurityEvent, boolean editable, boolean selected) {
        if (!this.actionTreeNodesMap.containsKey(generateSecurityEvent)) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(new ActionCheckBoxNodeData(generateSecurityEvent, editable).setSelected(selected));
            ActionProperty eventProp = new ActionProperty(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.generateSecurityEvent.event"), EVENT, false);
            node.add(new DefaultMutableTreeNode(eventProp));
            ActionProperty textProp = new ActionProperty(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.generateSecurityEvent.text"), this.getScriptName(), true);
            node.add(new DefaultMutableTreeNode(textProp, false));
            ActionSpinnerNodeData priorityProp = new ActionSpinnerNodeData(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.generateSecurityEvent.priority"), 2, 1, 5);
            node.add(new DefaultMutableTreeNode(priorityProp, false));
            if (this.actionRoot != null) {
                this.actionTreeModel.insertNodeInto(node, this.actionRoot, this.actionRoot.getChildCount());
            }
        }
    }

    private void addGenerateRicherSecurityEvent(String generateRicherSecurityEvent, boolean editable, boolean selected) {
        if (!this.actionTreeNodesMap.containsKey(generateRicherSecurityEvent)) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(new ActionCheckBoxNodeData(generateRicherSecurityEvent, editable).setSelected(selected));
            ActionProperty eventProp = new ActionProperty(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.generateSecurityEvent.event"), EVENT, false);
            node.add(new DefaultMutableTreeNode(eventProp));
            ActionProperty textProp = new ActionProperty(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.generateSecurityEvent.text"), this.getScriptName(), true);
            node.add(new DefaultMutableTreeNode(textProp, false));
            ActionSpinnerNodeData priorityProp = new ActionSpinnerNodeData(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.generateSecurityEvent.priority"), 2, 1, 5);
            node.add(new DefaultMutableTreeNode(priorityProp, false));
            ActionProperty titleProp = new ActionProperty(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.generateSecurityEvent.title"), this.getScriptName(), true);
            node.add(new DefaultMutableTreeNode(titleProp, false));
            ActionProperty descProp = new ActionProperty(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.generateSecurityEvent.desc"), this.getScriptName(), true);
            node.add(new DefaultMutableTreeNode(descProp, false));
            if (this.actionRoot != null) {
                this.actionTreeModel.insertNodeInto(node, this.actionRoot, this.actionRoot.getChildCount());
            }
        }
    }

    private void addSendNotificantionToActionTree(DefaultMutableTreeNode root, boolean selected) throws MissingResourceException {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new ActionCheckBoxNodeData(NOTIFICATION_SEND, true).setSelected(selected));
        ActionProperty destinationProp = new ActionProperty(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.Notification.send.destination"), NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.Notification.send.destination.example"), true);
        node.add(new DefaultMutableTreeNode(destinationProp, false));
        ActionSpinnerNodeData severityProp = new ActionSpinnerNodeData(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.Notification.send.severity"), 2, 1, 100);
        node.add(new DefaultMutableTreeNode(severityProp, false));
        ActionProperty subjectProp = new ActionProperty(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.Notification.send.subject"), NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.Notification.send.subject.example"), true);
        node.add(new DefaultMutableTreeNode(subjectProp, false));
        ActionProperty textProp = new ActionProperty(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.Notification.send.text"), NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.Notification.send.text.example"), true);
        node.add(new DefaultMutableTreeNode(textProp, false));
        ActionProperty metaProp = new ActionProperty(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.Notification.send.meta"), "{}", false);
        node.add(new DefaultMutableTreeNode(metaProp));
        if (this.actionRoot != null) {
            this.actionTreeModel.insertNodeInto(node, root, root.getChildCount());
        }
    }

    private void addDataMapMaptoActionTree() throws MissingResourceException {
        if (!this.actionTreeNodesMap.containsKey(DATA_MAP_MAP)) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(new ActionCheckBoxNodeData(DATA_MAP_MAP, true));
            ActionProperty mapNameProp = new ActionProperty(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.dataMap.mapName"), this.getScriptName(), true);
            node.add(new DefaultMutableTreeNode(mapNameProp, false));
            List<ParamsTabelModel.Item> data = this.paramsTabelPanel.getTabelModel().getData();
            ActionProperty primaryKeyProp = new ActionProperty(PK, true, null);
            data.forEach(e -> {
                if (e.isPrimaryKey()) {
                    primaryKeyProp.setItem((ParamsTabelModel.Item)e);
                    primaryKeyProp.setChanged(false);
                }
            });
            node.add(new DefaultMutableTreeNode(primaryKeyProp, false));
            ActionProperty ifNullProp = new ActionProperty(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.dataMap.initalValue"), "\"{}\"", false);
            node.add(new DefaultMutableTreeNode(ifNullProp, false));
            DefaultMutableTreeNode returnDataMapper = new DefaultMutableTreeNode(WRITE_TO_DATAMAP);
            node.add(returnDataMapper);
            ActionProperty secondaryKeyProp = new ActionProperty(SK, true, null);
            data.forEach(e -> {
                if (e.isSecondaryKey()) {
                    secondaryKeyProp.setItem((ParamsTabelModel.Item)e);
                    secondaryKeyProp.setChanged(false);
                }
            });
            returnDataMapper.add(new DefaultMutableTreeNode(secondaryKeyProp, false));
            DefaultMutableTreeNode params = new DefaultMutableTreeNode(PARAMS);
            node.add(params);
            data.forEach(e -> {
                if (e.isParams()) {
                    params.add(new DefaultMutableTreeNode(e, false));
                }
            });
            if (this.actionRoot != null) {
                this.actionTreeModel.insertNodeInto(node, this.actionRoot, this.actionRoot.getChildCount());
            }
        }
    }

    private void addContextToActionTree() throws MissingResourceException {
        if (!this.actionTreeNodesMap.containsKey(CONTEXT)) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(new ActionCheckBoxNodeData(CONTEXT, true));
            String[] fields = this.getFieldsArray();
            ActionTextFieldComboBoxNodeData variableID = new ActionTextFieldComboBoxNodeData("Context Id ", this.getScriptName(), fields, 0);
            node.add(new DefaultMutableTreeNode(variableID, false));
            String[] m = new String[]{"SLIDING", "FIXED"};
            node.add(new DefaultMutableTreeNode(new ActionComboBoxNodeData("Mode ", m)));
            ActionSpinnerNodeData numOfEventsThreshold = new ActionSpinnerNodeData("Number of events threshold ", 5, 1, 500);
            node.add(new DefaultMutableTreeNode(numOfEventsThreshold, false));
            ActionSpinnerNodeData timeThreshold = new ActionSpinnerNodeData("Time Threshold (in seconds) ", 300, 300, 3600).setStepSize(10);
            node.add(new DefaultMutableTreeNode(timeThreshold, false));
            String[] f = new String[]{"true", "false"};
            node.add(new DefaultMutableTreeNode(new ActionComboBoxNodeData("Fire On Expire ", f)));
            ActionProperty reference = new ActionProperty("Reference", "event.getId()", false);
            node.add(new DefaultMutableTreeNode(reference, false));
            ActionProperty triggerModuleName = new ActionProperty(TRIGGER_MODULE_NAME, "\"" + this.getScriptName() + "_ACTION\"", false);
            node.add(new DefaultMutableTreeNode(triggerModuleName, false));
            ActionProperty customData = new ActionProperty("Custom Data", "\"\"", false);
            node.add(new DefaultMutableTreeNode(customData, false));
            ActionProperty eventProp = new ActionProperty(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.generateSecurityEvent.event"), EVENT, false);
            node.add(new DefaultMutableTreeNode(eventProp));
            DefaultMutableTreeNode trigger = new DefaultMutableTreeNode(TRIGGER);
            node.add(trigger);
            this.addGenerateSecurityEventFromContext(trigger);
            this.addGenerateRicherSecurityEventFromContext(trigger);
            this.addSendNotificantionToActionTree(trigger, false);
            this.addWriteContexEventToDataMap(trigger);
            this.createEventFromContextEventVariations(trigger);
            if (this.actionRoot != null) {
                this.actionTreeModel.insertNodeInto(node, this.actionRoot, this.actionRoot.getChildCount());
            }
        }
    }

    private String[] getFieldsArray() {
        String[] fields = new String[this.eventFields.size()];
        for (int i = 0; i < this.eventFields.size(); ++i) {
            fields[i] = "event." + this.eventFields.get(i).getFullField();
        }
        return fields;
    }

    private void addGenerateSecurityEventFromContext(DefaultMutableTreeNode trigger) throws MissingResourceException {
        DefaultMutableTreeNode genSecEveFromContext = new DefaultMutableTreeNode(new ActionCheckBoxNodeData(GENERATE_SECURITY_EVENT_FROM_CONTEXT, true).setSelected(true));
        ActionProperty textProp = new ActionProperty(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.generateSecurityEvent.text"), this.getScriptName(), true);
        genSecEveFromContext.add(new DefaultMutableTreeNode(textProp, false));
        ActionSpinnerNodeData priorityProp = new ActionSpinnerNodeData(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.generateSecurityEvent.priority"), 2, 1, 5);
        genSecEveFromContext.add(new DefaultMutableTreeNode(priorityProp, false));
        ActionProperty ctxProp = new ActionProperty("Context", "ctx", false);
        genSecEveFromContext.add(new DefaultMutableTreeNode(ctxProp));
        trigger.add(genSecEveFromContext);
    }

    private void addGenerateRicherSecurityEventFromContext(DefaultMutableTreeNode trigger) throws MissingResourceException {
        DefaultMutableTreeNode genSecEveFromContext = new DefaultMutableTreeNode(new ActionCheckBoxNodeData(GENERATE_RICHER_SECURITY_EVENT_FROM_CONTEXT, true));
        ActionProperty textProp = new ActionProperty(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.generateSecurityEvent.text"), this.getScriptName(), true);
        genSecEveFromContext.add(new DefaultMutableTreeNode(textProp, false));
        ActionSpinnerNodeData priorityProp = new ActionSpinnerNodeData(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.generateSecurityEvent.priority"), 2, 1, 5);
        genSecEveFromContext.add(new DefaultMutableTreeNode(priorityProp, false));
        ActionProperty ctxProp = new ActionProperty("Context", "ctx", false);
        genSecEveFromContext.add(new DefaultMutableTreeNode(ctxProp));
        ActionProperty titleProp = new ActionProperty(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.generateSecurityEvent.title"), this.getScriptName(), true);
        genSecEveFromContext.add(new DefaultMutableTreeNode(titleProp, false));
        ActionProperty descProp = new ActionProperty(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.generateSecurityEvent.desc"), this.getScriptName(), true);
        genSecEveFromContext.add(new DefaultMutableTreeNode(descProp, false));
        trigger.add(genSecEveFromContext);
    }

    private void createEventFromContextEventVariations(DefaultMutableTreeNode trigger) throws MissingResourceException {
        DefaultMutableTreeNode createEventFromContextEventVariations = new DefaultMutableTreeNode(new ActionCheckBoxNodeData("createEventFromContextEventVariations", true));
        ActionProperty ctxProp = new ActionProperty("Context", "ctx", false);
        createEventFromContextEventVariations.add(new DefaultMutableTreeNode(ctxProp));
        ActionProperty textProp = new ActionProperty(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.generateSecurityEvent.text"), this.getScriptName(), true);
        createEventFromContextEventVariations.add(new DefaultMutableTreeNode(textProp, false));
        ActionSpinnerNodeData priorityProp = new ActionSpinnerNodeData(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.generateSecurityEvent.priority"), 2, 1, 5);
        createEventFromContextEventVariations.add(new DefaultMutableTreeNode(priorityProp, false));
        ActionSpinnerNodeData maxReferencesProp = new ActionSpinnerNodeData("Max References", 100, 1, 100);
        createEventFromContextEventVariations.add(new DefaultMutableTreeNode(maxReferencesProp, false));
        trigger.add(createEventFromContextEventVariations);
    }

    private void addWriteContexEventToDataMap(DefaultMutableTreeNode trigger) throws MissingResourceException {
        DefaultMutableTreeNode writeContextEventToDataMap = new DefaultMutableTreeNode(new ActionCheckBoxNodeData(WRITE_CONTEX_EVENT_TO_DATA_MAP, true));
        ActionProperty mapNameProp = new ActionProperty(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.dataMap.mapName"), this.getScriptName(), true);
        writeContextEventToDataMap.add(new DefaultMutableTreeNode(mapNameProp, false));
        ActionProperty eventProp = new ActionProperty(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.generateSecurityEvent.event"), EVENT, false);
        writeContextEventToDataMap.add(new DefaultMutableTreeNode(eventProp));
        ActionProperty ctxProp = new ActionProperty("Context", "ctx", false);
        writeContextEventToDataMap.add(new DefaultMutableTreeNode(ctxProp));
        trigger.add(writeContextEventToDataMap);
    }

    public boolean isScriptValid() {
        return this.scriptEditorPanel.isScriptValid();
    }

    private void bAndActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode((Object)OperationTreeNode.AND);
        this.addTreeNode(node);
    }

    private void bOrActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode((Object)OperationTreeNode.OR);
        this.addTreeNode(node);
    }

    private void bRemoveActionPerformed(ActionEvent evt) {
        this.deleteTreeNode(this.jtrCondition);
    }

    private void tfScriptNameKeyTyped(KeyEvent evt) {
        char c = evt.getKeyChar();
        if (!Character.isAlphabetic(c) && Character.getType(c) != 23 && !Character.isDigit(c)) {
            evt.consume();
        }
    }

    private void jtrActionMouseClicked(MouseEvent evt) {
        DefaultMutableTreeNode lastPathComponent;
        TreePath pathForLocation;
        if (evt.getButton() == 1 && evt.getClickCount() == 2 && (pathForLocation = this.jtrAction.getPathForLocation(evt.getX(), evt.getY())) != null) {
            lastPathComponent = (DefaultMutableTreeNode)pathForLocation.getLastPathComponent();
            this.editTreeNode(lastPathComponent);
        }
        if (evt.getButton() == 3 && (pathForLocation = this.jtrAction.getPathForLocation(evt.getX(), evt.getY())) != null) {
            this.jtrAction.setSelectionPath(pathForLocation);
            lastPathComponent = (DefaultMutableTreeNode)pathForLocation.getLastPathComponent();
            if (lastPathComponent.getLevel() == 1) {
                this.mEditA.setEnabled(false);
            } else {
                this.mEditA.setEnabled(false);
            }
            if (lastPathComponent.getUserObject() instanceof ActionProperty) {
                ActionProperty userObject = (ActionProperty)lastPathComponent.getUserObject();
                if (userObject.isEditable()) {
                    this.mEditA.setEnabled(true);
                } else {
                    this.mEditA.setEnabled(false);
                }
            }
            this.pmTreeA.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void jtrActionKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 113) {
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.jtrAction.getLastSelectedPathComponent();
            this.editTreeNode(selectedNode);
        }
    }

    private void jtrConditionKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.deleteTreeNode(this.jtrCondition);
        }
        if (evt.getKeyCode() == 113) {
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.jtrCondition.getLastSelectedPathComponent();
            this.editTreeNode(selectedNode);
        }
    }

    private void jtrConditionMouseClicked(MouseEvent evt) {
        DefaultMutableTreeNode lastPathComponent;
        TreePath pathForLocation;
        if (evt.getButton() == 1 && evt.getClickCount() == 2 && (pathForLocation = this.jtrCondition.getPathForLocation(evt.getX(), evt.getY())) != null) {
            lastPathComponent = (DefaultMutableTreeNode)pathForLocation.getLastPathComponent();
            this.editTreeNode(lastPathComponent);
        }
        if (evt.getButton() == 3 && (pathForLocation = this.jtrCondition.getPathForLocation(evt.getX(), evt.getY())) != null) {
            this.jtrCondition.setSelectionPath(pathForLocation);
            lastPathComponent = (DefaultMutableTreeNode)this.jtrCondition.getLastSelectedPathComponent();
            if (!lastPathComponent.getAllowsChildren()) {
                this.mChangeLogicalOperation.setEnabled(false);
                this.mAdd.setEnabled(false);
                this.mEdit.setEnabled(true);
                this.mRemove.setEnabled(true);
            } else if (lastPathComponent.isRoot()) {
                this.mChangeLogicalOperation.setEnabled(false);
                this.mEdit.setEnabled(false);
                this.mRemove.setEnabled(false);
                if (lastPathComponent.getChildCount() >= 1) {
                    this.mAdd.setEnabled(false);
                } else {
                    this.mAdd.setEnabled(true);
                }
            } else {
                this.mChangeLogicalOperation.setEnabled(true);
                this.mEdit.setEnabled(false);
                this.mRemove.setEnabled(true);
                this.mAdd.setEnabled(true);
            }
            this.pmTree.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void mRemoveActionPerformed(ActionEvent evt) {
        this.deleteTreeNode(this.jtrCondition);
    }

    private void mEditActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode selectionPath = (DefaultMutableTreeNode)this.jtrCondition.getLastSelectedPathComponent();
        this.editTreeNode(selectionPath);
    }

    private void mAndActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode((Object)OperationTreeNode.AND);
        this.addTreeNode(node);
    }

    private void mOrActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode((Object)OperationTreeNode.OR);
        this.addTreeNode(node);
    }

    private void mEditAActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode selectionPath = (DefaultMutableTreeNode)this.jtrAction.getLastSelectedPathComponent();
        this.editTreeNode(selectionPath);
    }

    private void mChangeToAndActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode selectionPath = (DefaultMutableTreeNode)this.jtrCondition.getLastSelectedPathComponent();
        this.editTreeNode(selectionPath, evt.getActionCommand());
    }

    private void bNotActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode((Object)OperationTreeNode.NOT);
        this.addTreeNode(node);
    }

    private void mNotActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode((Object)OperationTreeNode.NOT);
        this.addTreeNode(node);
    }

    private void mChangeToOrActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode selectionPath = (DefaultMutableTreeNode)this.jtrCondition.getLastSelectedPathComponent();
        this.editTreeNode(selectionPath, evt.getActionCommand());
    }

    private void mChangeToNotActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode selectionPath = (DefaultMutableTreeNode)this.jtrCondition.getLastSelectedPathComponent();
        this.editTreeNode(selectionPath, evt.getActionCommand());
    }
}

