/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.alertevents.export.strategies;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.fill.JRFillInterruptedException;
import net.sf.jasperreports.export.ExportInterruptedException;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import org.joda.time.DateTime;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.DateRange;
import rs.co.ast.aspen.api.service.SearchState;
import rs.co.ast.aspen.api.service.SecurityEventsSearchResults;
import rs.co.ast.aspen.gui.module.alertevents.DisplayOptionsPanel;
import rs.co.ast.aspen.gui.module.alertevents.export.FetchResult;
import rs.co.ast.aspen.gui.module.alertevents.export.PDFDataSource;
import rs.co.ast.aspen.gui.module.alertevents.export.strategies.ExportStrategy;

public class XLSXExportStrategy
extends ExportStrategy {
    public XLSXExportStrategy(String query, String exportPath, long startTime, long finishTime, long indexSplit) throws ApiServiceException_Exception {
        super(query, exportPath, startTime, finishTime, indexSplit, "xlsx");
    }

    @Override
    public SwingWorker<byte[], Void> search(final String fileName, final SearchState searchState, final DateRange dateRange) {
        return new SwingWorker<byte[], Void>(){

            @Override
            protected byte[] doInBackground() throws Exception {
                byte[] file = null;
                SecurityEventsSearchResults result = XLSXExportStrategy.this.fetch(searchState, dateRange);
                ExportStrategy.logger.info(String.format("FETCH - s: %s - f: %s, o: %d, d: %d, t: %d", new DateTime(dateRange.getStartTimeStamp()), new DateTime(dateRange.getFinishTimeStamp()), result.getSearchState().getOffset(), result.getContainer().getSecurityEvents().size(), result.getSearchState().getTotalHits()));
                if (!result.getContainer().getErrors().isEmpty()) {
                    ExportStrategy.logger.warning(String.format("FETCH ERRORS - %s", result.getContainer().getErrors()));
                    XLSXExportStrategy.this.fileSkippedSupport.fireFileSkippedEvent(fileName, dateRange, searchState);
                    return null;
                }
                try {
                    PDFDataSource ds = new PDFDataSource(new FetchResult(result.getContainer().getSecurityEvents(), searchState.getLastSearchDuration(), searchState.getTotalHits()));
                    ds.addProgressValueChangeListener(XLSXExportStrategy.this.progressValueChangedListener);
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    parameters.put("startTime", new DateTime(dateRange.getStartTimeStamp()).toString());
                    parameters.put("finishTime", new DateTime(dateRange.getFinishTimeStamp()).toString());
                    parameters.put("totalHits", Integer.toString(result.getContainer().getSecurityEvents().size()));
                    parameters.put("query", XLSXExportStrategy.this.query);
                    InputStream is = this.getClass().getResourceAsStream("/reports/SecurityEventsReport.jasper");
                    if (is != null) {
                        JasperPrint print = JasperFillManager.fillReport((InputStream)is, parameters, (JRDataSource)ds);
                        ByteArrayOutputStream reportBytes = new ByteArrayOutputStream();
                        JRXlsxExporter xls = new JRXlsxExporter();
                        xls.setExporterInput((ExporterInput)new SimpleExporterInput(print));
                        xls.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput((OutputStream)reportBytes));
                        xls.exportReport();
                        file = reportBytes.toByteArray();
                    } else {
                        XLSXExportStrategy.this.workFinishedSupport.fireWorkFinishedEvent(false, NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.export.error.template_notfound.message"));
                        this.cancel(true);
                    }
                }
                catch (JRFillInterruptedException | ExportInterruptedException throwable) {
                }
                catch (JRException jRException) {
                    // empty catch block
                }
                return file;
            }

            @Override
            protected void done() {
                try {
                    byte[] file = (byte[])this.get();
                    if (file == null) {
                        return;
                    }
                    XLSXExportStrategy.this.taskMonitor.completeFetch(fileName);
                    XLSXExportStrategy.this.fileCreatedSupport.fireFileCreatedEvent(fileName, file, true);
                }
                catch (InterruptedException | ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
    }
}

