/*
 * Decompiled with CFR 0.152.
 */
package com.github.zafarkhaja.semver.compiling;

import com.github.zafarkhaja.semver.util.Stream;

public abstract class Token<E extends Token> {
    public final Type<E> type;
    public final String lexeme;
    public final int position;

    protected Token(Type<E> type, String lexeme, int position) {
        this.type = type;
        this.lexeme = lexeme == null ? "" : lexeme;
        this.position = position;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Token)) {
            return false;
        }
        Token token = (Token)other;
        return this.type.equals(token.type) && this.lexeme.equals(token.lexeme) && this.position == token.position;
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + this.type.hashCode();
        hash = 71 * hash + this.lexeme.hashCode();
        hash = 71 * hash + this.position;
        return hash;
    }

    public String toString() {
        return String.format("%s(%s) at position %d", this.type.name(), this.lexeme, this.position);
    }

    public static interface Type<E extends Token>
    extends Stream.ElementType<E> {
        public String name();
    }
}

