/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.securityevents.simplecorrelator;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.gui.module.securityevents.simplecorrelator.EventField;

public class SimpleCorrelatorTableModel
extends AbstractTableModel {
    private final List<Item> data = new ArrayList<Item>();
    private final String[] columnNames = new String[]{NbBundle.getMessage(SimpleCorrelatorTableModel.class, (String)"SimpleCorrelationTableModel.tableTitle.key"), NbBundle.getMessage(SimpleCorrelatorTableModel.class, (String)"SimpleCorrelationTableModel.tableTitle.operation"), NbBundle.getMessage(SimpleCorrelatorTableModel.class, (String)"SimpleCorrelationTableModel.tableTitle.value"), " "};
    private final Class[] columnClass = new Class[]{String.class, Operation.class, String.class, JButton.class};

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnClass[columnIndex];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Item row = this.data.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return row.getKey();
            }
            case 1: {
                return row.getOperation();
            }
            case 2: {
                return row.getValue();
            }
            case 3: {
                return rowIndex;
            }
        }
        return null;
    }

    public Object getRowValueAt(int rowIndex) {
        Item row = this.data.get(rowIndex);
        return row;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Item row = this.data.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                row.setKey((String)aValue);
                break;
            }
            case 1: {
                row.setOperation((Operation)((Object)aValue));
                break;
            }
            case 2: {
                row.setValue((String)aValue);
                break;
            }
            case 3: {
                row.setRow(Integer.toString(rowIndex));
                break;
            }
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public void setTabelData(List<EventField> eventFields) {
        eventFields.forEach(e -> {
            if (e.getKey().equalsIgnoreCase("when.")) {
                this.data.add(new Item(this, "", e.getFullField(), e.getValue(), Operation.GETHOUROFTHEDAY));
            } else {
                this.data.add(new Item(this, "", e.getFullField(), e.getValue(), Operation.EQUALS));
            }
        });
        this.fireTableDataChanged();
    }

    public static enum Operation {
        EQUALS("===", NbBundle.getMessage(SimpleCorrelatorTableModel.class, (String)"SimpleCorrelationTableModel.Operation.Equals.tooltip")),
        NOTEQUL("!==", NbBundle.getMessage(SimpleCorrelatorTableModel.class, (String)"SimpleCorrelationTableModel.Operation.NotEquals.tooltip")),
        STARTSWITH("startsWith", NbBundle.getMessage(SimpleCorrelatorTableModel.class, (String)"SimpleCorrelationTableModel.Operation.StartsWtih.tooltip")),
        ENDSWITH("endsWith", NbBundle.getMessage(SimpleCorrelatorTableModel.class, (String)"SimpleCorrelationTableModel.Operation.EndsWith.tooltip")),
        CONTAINS("contains", NbBundle.getMessage(SimpleCorrelatorTableModel.class, (String)"SimpleCorrelationTableModel.Operation.Contains.tooltip")),
        GETHOUROFTHEDAY("getHourOfTheDay", NbBundle.getMessage(SimpleCorrelatorTableModel.class, (String)"SimpleCorrelationTableModel.Operation.GetHourOfTheDay.tooltip")),
        ISINLIST("isInList", NbBundle.getMessage(SimpleCorrelatorTableModel.class, (String)"SimpleCorrelationTableModel.Operation.IsInList.tooltip"));

        private final String operation;
        private final String toolTiptext;

        private Operation(String oper, String toolT) {
            this.operation = oper;
            this.toolTiptext = toolT;
        }

        public String getOperation() {
            return this.operation;
        }

        public String getToolTiptext() {
            return this.toolTiptext;
        }

        public String toString() {
            return this.operation;
        }
    }

    public class Item {
        private String row;
        private String key;
        private String value;
        private Operation operation;

        public Item(SimpleCorrelatorTableModel this$0, String row, String key, String value, Operation operation) {
            this.row = row;
            this.key = key;
            this.value = value;
            this.operation = operation;
        }

        public String getRow() {
            return this.row;
        }

        public void setRow(String row) {
            this.row = row;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public void setOperation(Operation operation) {
            this.operation = operation;
        }
    }
}

