/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.login;

import com.github.zafarkhaja.semver.Version;
import java.util.Optional;

public enum JavaVersion {
    JAVA_1_1(1, "1.1"),
    JAVA_1_2(2, "1.2"),
    JAVA_1_3(3, "1.3"),
    JAVA_1_4(4, "1.4"),
    JAVA_1_5(5, "1.5"),
    JAVA_1_6(6, "1.6"),
    JAVA_1_7(7, "1.7"),
    JAVA_1_8(8, "1.8"),
    JAVA_9(9, "9"),
    JAVA_10(10, "10"),
    JAVA_11(11, "11"),
    JAVA_12(12, "12"),
    JAVA_13(13, "13"),
    JAVA_14(14, "14"),
    JAVA_15(15, "15"),
    JAVA_16(16, "16"),
    JAVA_17(17, "17"),
    JAVA_18(18, "18"),
    JAVA_19(19, "19"),
    JAVA_20(20, "20"),
    JAVA_21(21, "21");

    private final String name;
    private final int version;
    private final Version semver;

    private JavaVersion(int version, String name) {
        this.name = name;
        this.version = version;
        this.semver = JavaVersion.toSemVer(name);
    }

    static Version toSemVer(String ver) {
        return Version.valueOf((String)ver);
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public Version getSemver() {
        return this.semver;
    }

    static Optional<JavaVersion> get(String versionStr) {
        if (versionStr == null) {
            return null;
        }
        return switch (versionStr) {
            case "1.1" -> Optional.of(JAVA_1_1);
            case "1.2" -> Optional.of(JAVA_1_2);
            case "1.3" -> Optional.of(JAVA_1_3);
            case "1.4" -> Optional.of(JAVA_1_4);
            case "1.5" -> Optional.of(JAVA_1_5);
            case "1.6" -> Optional.of(JAVA_1_6);
            case "1.7" -> Optional.of(JAVA_1_7);
            case "1.8" -> Optional.of(JAVA_1_8);
            case "9" -> Optional.of(JAVA_9);
            case "10" -> Optional.of(JAVA_10);
            case "11" -> Optional.of(JAVA_11);
            case "12" -> Optional.of(JAVA_12);
            case "13" -> Optional.of(JAVA_13);
            case "14" -> Optional.of(JAVA_14);
            case "15" -> Optional.of(JAVA_15);
            case "16" -> Optional.of(JAVA_16);
            case "17" -> Optional.of(JAVA_17);
            case "18" -> Optional.of(JAVA_18);
            case "19" -> Optional.of(JAVA_19);
            case "20" -> Optional.of(JAVA_20);
            case "21" -> Optional.of(JAVA_21);
            default -> Optional.empty();
        };
    }

    public boolean atLeast(JavaVersion requiredVersion) {
        return this.version >= requiredVersion.version;
    }

    public boolean atMost(JavaVersion requiredVersion) {
        return this.version <= requiredVersion.version;
    }

    public boolean isCompatible(JavaVersion requiredVersion) {
        return this.semver.isMajorVersionCompatible(requiredVersion.getSemver());
    }
}

