/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps.sourcestatistics;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.table.DefaultTableModel;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.HostsPerDomainAggObject;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.SumOfCountsPerHostnameTableModelV2;

public class HostsPerDomainTableModel
extends DefaultTableModel {
    private final List<String> columns = Stream.of(NbBundle.getMessage(HostsPerDomainTableModel.class, (String)"HostsPerDomainTableModel.columnName.domain"), NbBundle.getMessage(HostsPerDomainTableModel.class, (String)"HostsPerDomainTableModel.columnName.numberOfHostnames"), NbBundle.getMessage(HostsPerDomainTableModel.class, (String)"HostsPerDomainTableModel.columnName.firstActive"), NbBundle.getMessage(HostsPerDomainTableModel.class, (String)"HostsPerDomainTableModel.columnName.lastActive")).collect(Collectors.toList());
    private List<HostsPerDomainAggObject> originalData = new ArrayList<HostsPerDomainAggObject>();
    private List<HostsPerDomainAggObject> data = new ArrayList<HostsPerDomainAggObject>();
    private NumberFormat nf = NumberFormat.getNumberInstance(Locale.getDefault());

    @Override
    public Object getValueAt(int row, int column) {
        HostsPerDomainAggObject element = this.data.get(row);
        switch (this.columns.get(column)) {
            case "Domains": {
                return element.getDomain();
            }
            case "NumberOfHostnames": {
                return element.getCount();
            }
            case "FirstActive": {
                return element.getHumanFirstActive();
            }
            case "LastActive": {
                return element.getHumanLastActive();
            }
        }
        throw new IllegalArgumentException(NbBundle.getMessage(HostsPerDomainTableModel.class, (String)"TableModel.columnName.unknown"));
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public String getColumnName(int column) {
        return this.columns.get(column);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getRowCount() {
        return this.data == null ? 0 : this.data.size();
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Long.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
        }
        throw new IllegalArgumentException(NbBundle.getMessage(SumOfCountsPerHostnameTableModelV2.class, (String)"TableModel.columnName.unknown"));
    }

    public void update(List<HostsPerDomainAggObject> data) {
        this.data = data;
        this.originalData = data;
        this.fireTableDataChanged();
    }

    public void updateFiltered(List<HostsPerDomainAggObject> data) {
        this.data = data == null ? this.originalData : data;
        this.fireTableDataChanged();
    }

    public void filterTable(String filterText) {
        ArrayList<HostsPerDomainAggObject> filtered = new ArrayList<HostsPerDomainAggObject>();
        String[] keywords = filterText.split(" ");
        this.data.forEach(hsa -> {
            boolean found = true;
            for (String s : keywords) {
                if (hsa.toString().contains(s)) continue;
                found = false;
                break;
            }
            if (found) {
                filtered.add((HostsPerDomainAggObject)hsa);
            }
        });
        this.updateFiltered(filtered);
    }
}

