/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.securityevents;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import org.apache.commons.codec.digest.DigestUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.painter.BusyPainter;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.DateRange;
import rs.co.ast.aspen.api.service.ModuleVersionUtils;
import rs.co.ast.aspen.api.service.RawLog;
import rs.co.ast.aspen.api.service.RawLogSimWrapper;
import rs.co.ast.aspen.api.service.SavedQueryData;
import rs.co.ast.aspen.api.service.SavedQueryDataType;
import rs.co.ast.aspen.api.service.SearchState;
import rs.co.ast.aspen.api.service.SecurityEvent;
import rs.co.ast.aspen.gui.module.securityevents.AnalysisTopComponent;
import rs.co.ast.aspen.gui.module.securityevents.AutoCompleteDecorator;
import rs.co.ast.aspen.gui.module.securityevents.DisplayOptions;
import rs.co.ast.aspen.gui.module.securityevents.DisplayOptionsDisplayer;
import rs.co.ast.aspen.gui.module.securityevents.OverviewPanel;
import rs.co.ast.aspen.gui.module.securityevents.QuerySetNamePanel;
import rs.co.ast.aspen.gui.module.securityevents.SavedQueryDataDialog;
import rs.co.ast.aspen.gui.module.securityevents.SecurityEventDetailsTopComponent;
import rs.co.ast.aspen.gui.module.securityevents.SecurityEventSearchQueryUpdate;
import rs.co.ast.aspen.gui.module.securityevents.SecurityEventWrapper;
import rs.co.ast.aspen.gui.module.securityevents.SecurityEventsTableModel;
import rs.co.ast.aspen.gui.module.securityevents.SecurityEventsTableRenderer;
import rs.co.ast.aspen.gui.module.securityevents.query.QueryManager;
import rs.co.ast.aspen.gui.module.securityevents.query.SecurityEventQueryHistory;
import rs.co.ast.aspen.gui.module.securityevents.query.TopComponentTitleShortener;
import rs.co.ast.aspen.gui.module.securityevents.search.SearchExecutor;
import rs.co.ast.aspen.gui.module.securityevents.search.SkippedTaskInfo;
import rs.co.ast.aspen.gui.module.securityevents.search.TaskMonitor;
import rs.co.ast.chart.FrontCountBarChart;
import rs.co.ast.chart.MyStackedXYBarRenderer;

@TopComponent.Description(preferredID="SecurityEventsTopComponent", iconBase="alert_green.png", persistenceType=1)
public final class SecurityEventsTopComponent
extends TopComponent
implements PropertyChangeListener {
    private final int TIME_FRAME_SHIFT = 8;
    private int timeFrameShift = 8;
    private ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private SecurityEventQueryHistory queryHistory = (SecurityEventQueryHistory)Lookup.getDefault().lookup(SecurityEventQueryHistory.class);
    private SearchExecutor searchExecutor;
    private SecurityEventsTableModel tableModel = new SecurityEventsTableModel();
    private static final Logger LOGGER = Logger.getLogger(SecurityEventsTopComponent.class.getName());
    private InstanceContent instanceContent = new InstanceContent();
    private Lookup selectedEvent = new AbstractLookup((AbstractLookup.Content)this.instanceContent);
    private DisplayOptions displayOptions = new DisplayOptions();
    private final Timer autoRefreshTimer;
    private final OverviewPanel overviewPanel = new OverviewPanel();
    private SavedQueryData queryData;
    private boolean selectLast = false;
    private AutoCompleteDecorator autoCompleteDecorator = new AutoCompleteDecorator();
    private Lookup.Result<SecurityEventSearchQueryUpdate> lr = Utilities.actionsGlobalContext().lookupResult(SecurityEventSearchQueryUpdate.class);
    private DateTimeFormatter isoTimeFormat = ISODateTimeFormat.dateTime().withZone(DateTimeZone.getDefault());
    private String undoQuery = "";
    private String previousQuery = "previousQuery";
    private String tag = UUID.randomUUID().toString();
    private FrontCountBarChart countChart;
    private ChartMouseListener chartMouseListener;
    private JPopupMenu popupMenu = new JPopupMenu();
    private JMenuItem miPaste = new JMenuItem(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.miPaste.text"));
    private long startTimeOfCreatingATable = 0L;
    private final List<String> listOfCharactersToEscape = Arrays.asList("\\", "+", "-", "&&", "||", "!", "(", ")", "{", "}", "[", "]", "^", "\"", "~", "*", "?", ":");
    private final RequestProcessor rp = new RequestProcessor("TransmitFromSERawLogSimWrapper");
    private String user = null;
    public static final String PROP_QUERY_CHANGED = "queryChanged";
    private JButton bBottom;
    private JButton bDisplayOptions;
    private JButton bDuplicateComponent;
    private JButton bOpenAnalysis;
    private JButton bPageDown;
    private JButton bPageUp;
    private JButton bQueryBookmarks;
    private JButton bSearch;
    private JButton bTop;
    private JToggleButton btQueryBookmarked;
    private JXCollapsiblePane cpChart;
    private JPanel jPanel1;
    private JScrollPane jScrollPane;
    private JTabbedPane jTabbedPane1;
    private JXBusyLabel lLoading;
    private JLabel lNextTimeFrame;
    private JLabel lPreviousTimeFrame;
    private JLabel lQueryTime;
    private JLabel lSearchStatus;
    private JPanel pChart;
    private JPanel pResults;
    private JTable tSecurityEvents;
    private JToggleButton tbDesc;
    private JTextField tfSearch;
    private ListSelectionListener lSL = new ListSelectionListener(){
        private SecurityEventWrapper prevEvent = null;
        private RawLogSimWrapper prevLog = null;
        private TopComponent rawLogDetails = WindowManager.getDefault().findTopComponent("RawLogDetailsTopComponent");

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                SecurityEvent event = (SecurityEvent)SecurityEventsTopComponent.this.tableModel.getValueAt(SecurityEventsTopComponent.this.tSecurityEvents.getSelectedRow(), 0);
                boolean isRawLogDetailsOpened = this.rawLogDetails.isOpened();
                SecurityEventsTopComponent.this.rp.execute((Runnable)new SelectionRunnable(this.prevEvent, this.prevLog, event, isRawLogDetailsOpened));
            }
        }
    };

    public SecurityEventsTopComponent() {
        LOGGER.info(String.format("%s version: %s", ModuleVersionUtils.getModuleDisplayName((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.SECURITYEVENTS), ModuleVersionUtils.getModuleVersion((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.SECURITYEVENTS)));
        try {
            this.user = this.apiService.getSessionUsername();
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.displayOptions.load();
        this.displayOptions.setAutoRefresh(0);
        this.displayOptions.setDescOrder(true);
        this.displayOptions.setIsDescToggleButtonVisible(true);
        this.displayOptions.setTimeShift(8);
        this.initComponents();
        this.setName(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"CTL_SecurityEventsTopComponent"));
        this.setToolTipText(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"HINT_SecurityEventsTopComponent"));
        this.bSearch.setForeground(Color.red);
        this.setTimeShiftButtonNumber(8);
        this.lNextTimeFrame.setVisible(false);
        this.lPreviousTimeFrame.setVisible(false);
        ProxyLookup mainLookup = new ProxyLookup(new Lookup[]{this.selectedEvent, this.overviewPanel.getByPriorityPanel().getSecurityEventQueryUpdateLookup()});
        this.associateLookup((Lookup)mainLookup);
        this.lr.allInstances();
        this.lr.addLookupListener(new LookupListener(){
            SecurityEventSearchQueryUpdate prev = null;

            public void resultChanged(LookupEvent ev) {
                Lookup.Result lr = (Lookup.Result)ev.getSource();
                Collection instances = lr.allInstances();
                for (Object o : instances) {
                    SecurityEventSearchQueryUpdate squ;
                    if (!(o instanceof SecurityEventSearchQueryUpdate) || !SecurityEventsTopComponent.this.isVisible() || !SecurityEventsTopComponent.this.tag.equals((squ = (SecurityEventSearchQueryUpdate)o).getTag())) continue;
                    final StringBuilder query = new StringBuilder();
                    if (squ.isOverride()) {
                        query.append(squ.getQuery());
                    } else {
                        if (SecurityEventsTopComponent.this.tfSearch.getText().contains("AND") && squ.getQuery().contains("OR") || SecurityEventsTopComponent.this.tfSearch.getText().contains("OR") && squ.getQuery().contains("AND")) {
                            query.append("(");
                            query.append(SecurityEventsTopComponent.this.tfSearch.getText());
                            query.append(")");
                        } else {
                            query.append(SecurityEventsTopComponent.this.tfSearch.getText());
                        }
                        query.append(squ.getQuery());
                    }
                    if (this.prev != null && this.prev.equals(squ)) continue;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SecurityEventsTopComponent.this.tfSearch.setText(query.toString());
                            prev = squ;
                        }
                    });
                }
            }
        });
        this.lQueryTime.setCursor(new Cursor(12));
        this.lQueryTime.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String query = QueryManager.makeQueryTimeQuery(SecurityEventsTopComponent.this.displayOptions.getTimeStart(), SecurityEventsTopComponent.this.displayOptions.getTimeFinish(), SecurityEventsTopComponent.this.isoTimeFormat);
                SecurityEventsTopComponent.this.tfSearch.setText(query);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.tfSearch.setColumns(1);
        this.tfSearch.addMouseListener(new MouseListener(){
            private String text = NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.tfSearch.text");

            @Override
            public void mouseClicked(MouseEvent e) {
                if (this.text.equals(SecurityEventsTopComponent.this.tfSearch.getText())) {
                    SecurityEventsTopComponent.this.tfSearch.setText("");
                    SecurityEventsTopComponent.this.normal();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.tfSearch.addFocusListener(new FocusListener(){
            private String text = NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.tfSearch.text");

            @Override
            public void focusGained(FocusEvent e) {
                if (this.text.equals(SecurityEventsTopComponent.this.tfSearch.getText())) {
                    SecurityEventsTopComponent.this.tfSearch.setText("");
                    SecurityEventsTopComponent.this.normal();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.tfSearch.getDocument().addDocumentListener(new DocumentListener(){
            private SecurityEventWrapper prevSecurityEventWrapper;

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.fireQueryChanged(e);
                this.changeButtonColor();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.fireQueryChanged(e);
                this.changeButtonColor();
                SecurityEventsTopComponent.this.normal();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.fireQueryChanged(e);
                this.changeButtonColor();
            }

            private void changeButtonColor() {
                if (SecurityEventsTopComponent.this.previousQuery.equals(SecurityEventsTopComponent.this.tfSearch.getText())) {
                    SecurityEventsTopComponent.this.bSearch.setForeground(Color.black);
                } else {
                    SecurityEventsTopComponent.this.bSearch.setForeground(Color.red);
                }
            }

            private void fireQueryChanged(DocumentEvent e) {
                SecurityEventsTopComponent.this.displayOptions.setQuery(SecurityEventsTopComponent.this.tfSearch.getText());
                final SecurityEvent event = (SecurityEvent)SecurityEventsTopComponent.this.tableModel.getValueAt(SecurityEventsTopComponent.this.tSecurityEvents.getSelectedRow(), 0);
                if (event != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SecurityEventWrapper sew = new SecurityEventWrapper(event, SecurityEventsTopComponent.this.displayOptions, SecurityEventsTopComponent.this.tag);
                            sew.setQuery(SecurityEventsTopComponent.this.tfSearch.getText());
                            if (prevSecurityEventWrapper != null) {
                                SecurityEventsTopComponent.this.instanceContent.remove((Object)prevSecurityEventWrapper);
                            }
                            prevSecurityEventWrapper = sew;
                            SecurityEventsTopComponent.this.instanceContent.add((Object)prevSecurityEventWrapper);
                        }
                    });
                }
            }
        });
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SecurityEvent event = (SecurityEvent)SecurityEventsTopComponent.this.tableModel.getValueAt(SecurityEventsTopComponent.this.tSecurityEvents.getSelectedRow(), SecurityEventsTopComponent.this.tSecurityEvents.getSelectedColumn());
                String category = SecurityEventsTopComponent.this.tableModel.getColumnName(SecurityEventsTopComponent.this.tSecurityEvents.getSelectedColumn()).replace("<html><b>", "").replace("</b></html>", "");
                String query = QueryManager.copySecurityEventColumn(event, category);
                StringSelection selection = new StringSelection(query);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(selection, selection);
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(67, 2, false);
        this.tSecurityEvents.registerKeyboardAction(listener, "Copy", stroke, 0);
        this.tSecurityEvents.getTableHeader().setReorderingAllowed(false);
        this.tSecurityEvents.setDefaultRenderer(SecurityEvent.class, new SecurityEventsTableRenderer());
        this.tSecurityEvents.setSelectionMode(0);
        this.tSecurityEvents.setRowSelectionAllowed(true);
        this.tSecurityEvents.addKeyListener(new KeyListener(){
            private SecurityEventWrapper prevEvent = null;
            private RawLogSimWrapper prevLog = null;
            private TopComponent rawLogDetails = WindowManager.getDefault().findTopComponent("RawLogDetailsTopComponent");

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int row = SecurityEventsTopComponent.this.tSecurityEvents.getSelectedRow();
                if (row != -1) {
                    SecurityEvent event = (SecurityEvent)SecurityEventsTopComponent.this.tableModel.getValueAt(row, 0);
                    boolean isRawLogDetailsOpened = this.rawLogDetails.isOpened();
                    SecurityEventsTopComponent.this.rp.execute((Runnable)new SelectionRunnable(this.prevEvent, this.prevLog, event, isRawLogDetailsOpened));
                }
            }
        });
        this.tSecurityEvents.addMouseListener(new MouseListener(){
            private SecurityEventWrapper prevEvent = null;
            private RawLogSimWrapper prevLog = null;
            private TopComponent rawLogDetails = WindowManager.getDefault().findTopComponent("RawLogDetailsTopComponent");

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = SecurityEventsTopComponent.this.tSecurityEvents.rowAtPoint(e.getPoint());
                if (row != -1) {
                    SecurityEvent event = (SecurityEvent)SecurityEventsTopComponent.this.tableModel.getValueAt(row, 0);
                    boolean isRawLogDetailsOpened = this.rawLogDetails.isOpened();
                    SecurityEventsTopComponent.this.rp.execute((Runnable)new SelectionRunnable(this.prevEvent, this.prevLog, event, isRawLogDetailsOpened));
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TopComponent[] openedTopComponents;
                    Mode mode = WindowManager.getDefault().findMode("properties");
                    for (TopComponent tc : openedTopComponents = WindowManager.getDefault().getOpenedTopComponents(mode)) {
                        if (!(tc instanceof SecurityEventDetailsTopComponent)) continue;
                        tc.requestActive();
                        return;
                    }
                    SecurityEventDetailsTopComponent details = (SecurityEventDetailsTopComponent)WindowManager.getDefault().findTopComponent("SecurityEventDetailsTopComponent");
                    mode.dockInto((TopComponent)details);
                    details.open();
                    details.requestActive();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.tfSearch.addKeyListener(new KeyAdapter(){
            KeyStroke controlV = KeyStroke.getKeyStroke(86, 2);

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == this.controlV.getKeyCode()) {
                    SecurityEventsTopComponent.this.reformatQueryInClipboard();
                }
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SecurityEventsTopComponent.this.startSearch();
                        }
                    });
                } else {
                    SecurityEventsTopComponent.this.btQueryBookmarked.setSelected(false);
                }
            }
        });
        ActionListener undoListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SecurityEventsTopComponent.this.tfSearch.setText(SecurityEventsTopComponent.this.undoQuery);
            }
        };
        KeyStroke strokeUndo = KeyStroke.getKeyStroke(90, 2, false);
        this.tfSearch.registerKeyboardAction(undoListener, "Undo", strokeUndo, 0);
        KeyListener undoKeyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyChar()) {
                    case ' ': 
                    case '\"': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case '-': 
                    case ':': 
                    case '[': 
                    case ']': {
                        SecurityEventsTopComponent.this.updateUndoQuery();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        };
        this.tfSearch.addKeyListener(undoKeyListener);
        this.displayOptions.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SecurityEventsTopComponent.this.displayOptions.save();
                SecurityEventsTopComponent.this.toggleButtonDescSetSelected(SecurityEventsTopComponent.this.displayOptions.isDescOrder());
                if (SecurityEventsTopComponent.this.displayOptions.getAutoRefresh() == 0) {
                    SecurityEventsTopComponent.this.stopAutoRefreshTimer();
                } else {
                    SecurityEventsTopComponent.this.startAutoRefreshTimer();
                }
                SecurityEventsTopComponent.this.timeFrameShift = SecurityEventsTopComponent.this.displayOptions.getTimeShift();
                SecurityEventsTopComponent.this.setTimeShiftButtonNumber(SecurityEventsTopComponent.this.timeFrameShift);
                SecurityEventsTopComponent.this.startSearch();
            }
        });
        this.overviewPanel.addPropertyChangeListener(this);
        this.autoRefreshTimer = new Timer(this.displayOptions.getAutoRefresh(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SecurityEventsTopComponent.this.startSearch();
            }
        });
        this.tbDesc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SecurityEventsTopComponent.this.tbDesc.isSelected()) {
                    SecurityEventsTopComponent.this.displayOptions.setDescOrder(false);
                    SecurityEventsTopComponent.this.tbDesc.setText(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.asc"));
                } else {
                    SecurityEventsTopComponent.this.displayOptions.setDescOrder(true);
                    SecurityEventsTopComponent.this.tbDesc.setText(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.desc"));
                }
            }
        });
        this.jTabbedPane1.insertTab(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.pOverview.TabConstraints.tabTitle", (Object[])new Object[0]), null, this.overviewPanel, "", 0);
        this.cpChart.setLayout((LayoutManager)new BorderLayout());
        this.cpChart.add((Component)this.pChart, (Object)"Center");
        this.cpChart.setCollapsed(true);
        this.chartMouseListener = new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent event) {
                ChartEntity entity = event.getEntity();
                if (entity instanceof XYItemEntity) {
                    XYItemEntity item = (XYItemEntity)event.getEntity();
                    SecurityEventsTopComponent.this.countChart.getMyBarRenderer().resetSelectedItems();
                    SecurityEventsTopComponent.this.countChart.getMyBarRenderer().addSelectedItem(item.getItem());
                    List<DateRange> ranges = SecurityEventsTopComponent.this.searchExecutor.getSearchContext().getDateRanges();
                    DateRange dateRange = ranges.get(item.getItem());
                    SecurityEventsTopComponent.this.searchExecutor.setSelectedDateRange(dateRange);
                    SecurityEventsTopComponent.this.searchExecutor.getSearchContext().getSearchResults().getEvents().clear();
                    SecurityEventsTopComponent.this.fetch(dateRange);
                }
            }

            public void chartMouseMoved(ChartMouseEvent event) {
            }
        };
        this.lSearchStatus.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    if (SecurityEventsTopComponent.this.cpChart.isCollapsed()) {
                        SecurityEventsTopComponent.this.cpChart.setCollapsed(false);
                        SecurityEventsTopComponent.this.displayOptions.setChartManuallyOpened(true);
                    } else {
                        SecurityEventsTopComponent.this.cpChart.setCollapsed(true);
                        SecurityEventsTopComponent.this.displayOptions.setChartManuallyOpened(false);
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.tfSearch.add(this.popupMenu);
        this.tfSearch.setComponentPopupMenu(this.popupMenu);
        this.miPaste.addActionListener(e -> {
            this.reformatQueryInClipboard();
            this.tfSearch.paste();
        });
        this.popupMenu.add(this.miPaste);
        AbstractAction searchAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SecurityEventsTopComponent.this.startSearch();
            }
        };
        this.bSearch.setAction(searchAction);
        searchAction.putValue("AcceleratorKey", 116);
        this.bSearch.setText(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.bSearch.text"));
        this.bSearch.getActionMap().put("searchAction", searchAction);
        KeyStroke keyStrokeForSearch = KeyStroke.getKeyStroke(116, 0);
        this.bSearch.getInputMap(2).put(keyStrokeForSearch, "searchAction");
        this.lPreviousTimeFrame.setCursor(new Cursor(12));
        this.lPreviousTimeFrame.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ZonedDateTime zdtStart = ZonedDateTime.ofInstant(Instant.ofEpochMilli(SecurityEventsTopComponent.this.displayOptions.getTimeStart()), ZoneId.systemDefault()).minusHours(SecurityEventsTopComponent.this.timeFrameShift);
                long start = zdtStart.toInstant().toEpochMilli();
                long finish = SecurityEventsTopComponent.this.displayOptions.getTimeStart();
                SecurityEventsTopComponent.this.displayOptions.setNow(false);
                SecurityEventsTopComponent.this.displayOptions.setLastNHours(false);
                SecurityEventsTopComponent.this.doSearch(SecurityEventsTopComponent.this.tfSearch.getText(), start, finish);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.lNextTimeFrame.setCursor(new Cursor(12));
        this.lNextTimeFrame.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ZonedDateTime zdtFinish = ZonedDateTime.ofInstant(Instant.ofEpochMilli(SecurityEventsTopComponent.this.displayOptions.getTimeFinish()), ZoneId.systemDefault()).plusHours(SecurityEventsTopComponent.this.timeFrameShift);
                long start = SecurityEventsTopComponent.this.displayOptions.getTimeFinish();
                long finish = zdtFinish.toInstant().toEpochMilli();
                SecurityEventsTopComponent.this.displayOptions.setNow(false);
                SecurityEventsTopComponent.this.displayOptions.setLastNHours(false);
                SecurityEventsTopComponent.this.doSearch(SecurityEventsTopComponent.this.tfSearch.getText(), start, finish);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    private void setTimeShiftButtonNumber(int number) {
        this.lPreviousTimeFrame.setText(String.format(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.lPreviousTimeFrame.text"), number));
        this.lNextTimeFrame.setText(String.format(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.lNextTimeFrame.text"), number));
    }

    private void reformatQueryInClipboard() {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            String s = (String)cb.getData(DataFlavor.stringFlavor);
            s = s.replaceAll("\\n", ", ");
            StringSelection stringSelection = new StringSelection(s);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        }
        catch (UnsupportedFlavorException | IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "PROP_TOTAL_HITS": {
                this.updateCountSearchStatus();
                break;
            }
            case "PROP_EVENTS": {
                List events = (List)evt.getNewValue();
                this.tableModel.setData(events);
                LOGGER.info(String.format("CREATION OF A TABLE IS FINISHED IN %d ms", System.currentTimeMillis() - this.startTimeOfCreatingATable));
                this.selectItemInTable();
                break;
            }
            case "PROP_COUNT_TASK_FINISHED": {
                this.updateCountSearchStatus();
                this.pChart.removeAll();
                if (this.searchExecutor.getSearchContext().getDateRanges().size() > 1) {
                    this.pChart.add((Component)this.createChart(this.createDataset()));
                    if (this.cpChart.isCollapsed() && this.displayOptions.isChartManuallyOpened()) {
                        this.cpChart.setCollapsed(false);
                    }
                } else {
                    List<DateRange> ranges = this.searchExecutor.getSearchContext().getDateRanges();
                    this.searchExecutor.setSelectedDateRange(ranges.get(0));
                }
                this.fetch((DateRange)evt.getNewValue());
                break;
            }
            case "PROP_FETCH_TASK_FINISHED": {
                this.updateCountSearchStatus();
                try {
                    this.searchExecutor.count();
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                break;
            }
            case "PROP_COUNT_TASK_FINISHED_SUCCESS": {
                if (!this.searchExecutor.getSearchContext().getTaskMonitor().isAllCountTasksCompleted() || this.countChart == null) break;
                List<DateRange> dateRanges = this.searchExecutor.getSearchContext().getDateRanges();
                DateRange dt = (DateRange)evt.getNewValue();
                this.countChart.getMyBarRenderer().removeFailedItem(dateRanges.indexOf(dt));
                break;
            }
            case "PROP_COUNT_TASK_SKIPPED": {
                SkippedTaskInfo sti = (SkippedTaskInfo)evt.getNewValue();
                LOGGER.info(String.format("Date Range skipped: s: %s, f: %s", new DateTime(sti.getStartTimeStamp()), new DateTime(sti.getFinishTimeStamp())));
                if (this.searchExecutor.getSearchContext().getTaskMonitor().isAllCountTasksCompleted()) {
                    this.searchExecutor.submitSkippedTaskWithBackoff(TaskMonitor.BaseTaskName.COUNT.getBaseTaskName(), sti);
                } else {
                    this.searchExecutor.addTaskToSkippedTask(sti);
                }
                if (this.countChart == null) break;
                List<DateRange> dateRanges = this.searchExecutor.getSearchContext().getDateRanges();
                DateRange dt = sti.getDateRange();
                this.countChart.getMyBarRenderer().addFailedItem(dateRanges.indexOf(dt));
                break;
            }
            case "PROP_ALL_COUNT_TASKS_FINISHED": {
                LOGGER.info("PROP_ALL_COUNT_TASKS_FINISHED");
                List<SkippedTaskInfo> tasks = this.searchExecutor.getSearchContext().getSkippedTasks();
                for (SkippedTaskInfo ski : tasks) {
                    this.searchExecutor.submitSkippedTaskWithBackoff(TaskMonitor.BaseTaskName.COUNT.getBaseTaskName(), ski);
                }
                this.searchExecutor.getSearchContext().getSkippedTasks().clear();
                break;
            }
            case "PROP_ALL_SKIPPED_COUNT_TASKS_FINISHED": {
                LOGGER.info("PROP_ALL_SKIPPED_COUNT_TASKS_FINISHED");
            }
            case "PROP_ALL_FETCH_TASKS_FINISHED": {
                LOGGER.info("PROP_ALL_FETCH_TASKS_FINISHED");
                break;
            }
            case "PROP_ALL_TASKS_FINISHED": {
                this.updateCountSearchStatus();
                if (this.countChart != null) {
                    this.countChart.getChartPanel().addChartMouseListener(this.chartMouseListener);
                }
                this.lLoading.setBusy(false);
                LOGGER.info("ALL TASKS ARE COMPLETED");
                this.searchExecutor.getSearchContext().getSearchResults().setAccumulateTotalDuration(false);
                this.bPageUp.setEnabled(true);
                this.bPageDown.setEnabled(true);
                this.bTop.setEnabled(true);
                this.bBottom.setEnabled(true);
                if (this.displayOptions.isShowOverview()) {
                    this.setMappingsInOverviewPanel();
                }
                this.queryHistory.put(this.tfSearch.getText());
                break;
            }
            case "PROP_FETCH_TASK_FAILED": 
            case "PROP_COUNT_TASK_FAILED": {
                this.updateCountSearchStatus();
                List errors = (List)evt.getNewValue();
                LOGGER.info(String.format("TASK FAILED: %s", errors));
                this.lLoading.setBusy(false);
                this.searchExecutor.shutdown();
                this.bPageUp.setEnabled(true);
                this.bPageDown.setEnabled(true);
                this.bTop.setEnabled(true);
                this.bBottom.setEnabled(true);
                break;
            }
            case "PROP_FETCH_TASK_FINISHED_SUCCESS": {
                if (this.countChart == null || this.searchExecutor.getSearchContext().getTaskMonitor().isAllTasksCompleted()) break;
                LOGGER.info("PROP_FETCH_TASK_FINISHED_SUCCESS");
                DateRange dateRange = (DateRange)evt.getNewValue();
                List<DateRange> ranges = this.searchExecutor.getSearchContext().getDateRanges();
                int index = ranges.indexOf(dateRange);
                this.searchExecutor.setSelectedDateRange(ranges.get(index));
                this.countChart.getMyBarRenderer().addSelectedItem(index);
                this.countChart.updateChart(this.createDataset());
                this.countChart.getChartPanel().repaint();
                this.pChart.invalidate();
                this.pChart.repaint();
                break;
            }
            case "PROP_NEXT_PREV_MESSAGE": {
                JOptionPane.showMessageDialog((Component)((Object)this), evt.getNewValue());
                break;
            }
            case "PROP_FIRST_LAST_MESSAGE": {
                JOptionPane.showMessageDialog((Component)((Object)this), evt.getNewValue());
                break;
            }
            case "FILTER_OUT_QUERY": {
                StringBuilder query = new StringBuilder();
                if ((OverviewPanel.FilterParameters)evt.getNewValue() == null) break;
                OverviewPanel.FilterParameters parameters = (OverviewPanel.FilterParameters)evt.getNewValue();
                if (!this.tfSearch.getText().isEmpty()) {
                    query.append(this.appendFilterOutQuery(parameters.getEvents(), parameters.getField()));
                } else {
                    query.append(this.makeFilterOutQuery(parameters.getEvents(), parameters.getField()));
                }
                this.tfSearch.setText(query.toString());
            }
        }
    }

    private String escapeSpecialCharacters(String text) {
        for (String escape : this.listOfCharactersToEscape) {
            text = text.replace(escape, "\\" + escape);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\"").append(text).append("\"");
        text = sb.toString();
        return text;
    }

    private String appendFilterOutQuery(List<String> values, String field) {
        int i;
        String actualQuery = this.tfSearch.getText();
        if (actualQuery.length() >= 6000) {
            JOptionPane.showMessageDialog(null, "Query reached a maximum length value. It's not possible to append a new query.", "Query length exceeded", 2);
            return actualQuery;
        }
        StringBuilder sb = new StringBuilder();
        int startIndex = -1;
        int endIndex = -1;
        String[] split = field.split("\\.");
        Pattern pattern = Pattern.compile(split[0] + "\\." + split[1] + ":\\(");
        Matcher matcher = pattern.matcher(actualQuery);
        while (matcher.find()) {
            startIndex = matcher.end();
        }
        if (startIndex != -1) {
            for (i = startIndex; i < actualQuery.length(); ++i) {
                if (actualQuery.charAt(i) != ')') continue;
                endIndex = i;
            }
        }
        if (endIndex != -1) {
            sb.append(actualQuery.substring(0, endIndex));
            sb.append(", ");
            for (i = 0; i < values.size(); ++i) {
                String value = this.escapeSpecialCharacters(values.get(i));
                sb.append(value);
                if (i == values.size() - 1) continue;
                sb.append(", ");
            }
            sb.append(actualQuery.substring(endIndex));
        } else {
            sb.append(actualQuery);
            sb.append(" AND ");
            sb.append(this.makeFilterOutQuery(values, field));
        }
        return sb.toString();
    }

    private String makeFilterOutQuery(List<String> values, String field) {
        if (this.tfSearch.getText().length() >= 6000) {
            JOptionPane.showMessageDialog(null, "Query reached a maximum length. It's not possible to append a new query.", "Query length exceeded", 2);
            return this.tfSearch.getText();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("NOT ");
        sb.append(field);
        sb.append(":(");
        for (int i = 0; i < values.size(); ++i) {
            String value = this.escapeSpecialCharacters(values.get(i));
            sb.append(value);
            if (i == values.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    private void setMappingsInOverviewPanel() {
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        TreeSet what = new TreeSet((a, b) -> {
            int insensitive = String.CASE_INSENSITIVE_ORDER.compare(a, b);
            return insensitive == 0 ? a.compareTo((String)b) : insensitive;
        });
        TreeSet who = new TreeSet((a, b) -> {
            int insensitive = String.CASE_INSENSITIVE_ORDER.compare(a, b);
            return insensitive == 0 ? a.compareTo((String)b) : insensitive;
        });
        TreeSet where = new TreeSet((a, b) -> {
            int insensitive = String.CASE_INSENSITIVE_ORDER.compare(a, b);
            return insensitive == 0 ? a.compareTo((String)b) : insensitive;
        });
        TreeSet when = new TreeSet((a, b) -> {
            int insensitive = String.CASE_INSENSITIVE_ORDER.compare(a, b);
            return insensitive == 0 ? a.compareTo((String)b) : insensitive;
        });
        TreeSet extra = new TreeSet((a, b) -> {
            int insensitive = String.CASE_INSENSITIVE_ORDER.compare(a, b);
            return insensitive == 0 ? a.compareTo((String)b) : insensitive;
        });
        List<SecurityEvent> events = this.searchExecutor.getSearchContext().getSearchResults().getEvents();
        events.forEach(e -> {
            e.getWhat().getEntry().forEach(w -> what.add("what." + w.getKey()));
            e.getExtra().getEntry().forEach(w -> extra.add("extra." + w.getKey()));
            e.getWhen().getEntry().forEach(w -> when.add("when." + w.getKey()));
            e.getWhere().getEntry().forEach(w -> where.add("where." + w.getKey()));
            e.getWho().getEntry().forEach(w -> who.add("who." + w.getKey()));
        });
        fields.addAll(what);
        fields.addAll(who);
        fields.addAll(where);
        fields.addAll(when);
        fields.addAll(extra);
        this.overviewPanel.setMappingsInWidgetSettigsPanels(fields);
    }

    private void startAutoRefreshTimer() {
        if (this.displayOptions.getAutoRefresh() > 0) {
            this.autoRefreshTimer.setInitialDelay(this.displayOptions.getAutoRefresh() * 1000 * 60);
            this.autoRefreshTimer.setDelay(this.displayOptions.getAutoRefresh() * 1000 * 60);
            this.autoRefreshTimer.setRepeats(true);
            this.autoRefreshTimer.start();
        }
    }

    private void stopAutoRefreshTimer() {
        this.autoRefreshTimer.stop();
    }

    private void updateUndoQuery() {
        this.undoQuery = this.tfSearch.getText();
    }

    public void italic() {
        Font font = new Font("Dialog", 2, 12);
        this.tfSearch.setFont(font);
        this.tfSearch.setForeground(new Color(204, 204, 204));
    }

    public void normal() {
        Font font = new Font("Dialog", 0, 12);
        this.tfSearch.setFont(font);
        this.tfSearch.setForeground(Color.BLACK);
    }

    public void setAsc() {
        this.tbDesc.setSelected(false);
    }

    public boolean isAsc() {
        return this.tbDesc.isSelected();
    }

    private void initComponents() {
        this.pChart = new JPanel();
        this.tfSearch = new JTextField();
        this.bSearch = new JButton();
        this.bDisplayOptions = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.pResults = new JPanel();
        this.jScrollPane = new JScrollPane();
        this.tSecurityEvents = new JTable();
        this.bTop = new JButton();
        this.bPageUp = new JButton();
        this.bBottom = new JButton();
        this.bPageDown = new JButton();
        this.bQueryBookmarks = new JButton();
        this.btQueryBookmarked = new JToggleButton();
        this.tbDesc = new JToggleButton();
        this.lLoading = new JXBusyLabel();
        this.cpChart = new JXCollapsiblePane();
        this.bOpenAnalysis = new JButton();
        this.jPanel1 = new JPanel();
        this.lSearchStatus = new JLabel();
        this.lPreviousTimeFrame = new JLabel();
        this.lQueryTime = new JLabel();
        this.lNextTimeFrame = new JLabel();
        this.bDuplicateComponent = new JButton();
        this.pChart.setFont(new Font("Dialog", 0, 8));
        this.pChart.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
        this.pChart.setMinimumSize(new Dimension(0, 100));
        this.pChart.setPreferredSize(new Dimension(0, 100));
        this.pChart.setLayout(new BorderLayout());
        this.tfSearch.setFont(new Font("Dialog", 2, 12));
        this.tfSearch.setForeground(new Color(204, 204, 204));
        this.tfSearch.setText(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.tfSearch.text", (Object[])new Object[0]));
        this.bSearch.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.bSearch, (String)NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.bSearch.text"));
        this.bDisplayOptions.setIcon(new ImageIcon(this.getClass().getResource("/wrench_orange.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bDisplayOptions, (String)NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.bDisplayOptions.text"));
        this.bDisplayOptions.setToolTipText(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.bDisplayOptions.toolTipText"));
        this.bDisplayOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SecurityEventsTopComponent.this.bDisplayOptionsActionPerformed(evt);
            }
        });
        this.jTabbedPane1.setFont(new Font("Dialog", 0, 12));
        this.tSecurityEvents.setModel(this.tableModel);
        this.jScrollPane.setViewportView(this.tSecurityEvents);
        this.bTop.setIcon(new ImageIcon(this.getClass().getResource("/bullet_arrow_top.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bTop, (String)NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.bTop.text", (Object[])new Object[0]));
        this.bTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SecurityEventsTopComponent.this.bTopActionPerformed(evt);
            }
        });
        this.bPageUp.setIcon(new ImageIcon(this.getClass().getResource("/bullet_arrow_up.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bPageUp, (String)NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.bPageUp.text", (Object[])new Object[0]));
        this.bPageUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SecurityEventsTopComponent.this.bPageUpActionPerformed(evt);
            }
        });
        this.bBottom.setIcon(new ImageIcon(this.getClass().getResource("/bullet_arrow_bottom.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bBottom, (String)NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.bBottom.text", (Object[])new Object[0]));
        this.bBottom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SecurityEventsTopComponent.this.bBottomActionPerformed(evt);
            }
        });
        this.bPageDown.setIcon(new ImageIcon(this.getClass().getResource("/bullet_arrow_down.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bPageDown, (String)NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.bPageDown.text", (Object[])new Object[0]));
        this.bPageDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SecurityEventsTopComponent.this.bPageDownActionPerformed(evt);
            }
        });
        GroupLayout pResultsLayout = new GroupLayout(this.pResults);
        this.pResults.setLayout(pResultsLayout);
        pResultsLayout.setHorizontalGroup(pResultsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pResultsLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane, -1, 910, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pResultsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bBottom, GroupLayout.Alignment.TRAILING, -2, 30, -2).addComponent(this.bPageDown, GroupLayout.Alignment.TRAILING, -2, 30, -2).addComponent(this.bPageUp, GroupLayout.Alignment.TRAILING, -2, 30, -2).addComponent(this.bTop, GroupLayout.Alignment.TRAILING, -2, 30, -2)).addContainerGap()));
        pResultsLayout.setVerticalGroup(pResultsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pResultsLayout.createSequentialGroup().addContainerGap().addGroup(pResultsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pResultsLayout.createSequentialGroup().addComponent(this.bTop).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bPageUp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.bPageDown).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bBottom)).addComponent(this.jScrollPane, -1, 284, Short.MAX_VALUE)).addContainerGap()));
        this.jTabbedPane1.addTab(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.pResults.TabConstraints.tabTitle", (Object[])new Object[0]), this.pResults);
        this.bQueryBookmarks.setIcon(new ImageIcon(this.getClass().getResource("/folder_star.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bQueryBookmarks, (String)NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.bQueryBookmarks.text"));
        this.bQueryBookmarks.setToolTipText(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.bQueryBookmarks.toolTipText"));
        this.bQueryBookmarks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SecurityEventsTopComponent.this.bQueryBookmarksActionPerformed(evt);
            }
        });
        this.btQueryBookmarked.setIcon(new ImageIcon(this.getClass().getResource("/star.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btQueryBookmarked, (String)NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.btQueryBookmarked.text"));
        this.btQueryBookmarked.setToolTipText(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.btQueryBookmarked.toolTipText"));
        this.btQueryBookmarked.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SecurityEventsTopComponent.this.btQueryBookmarkedActionPerformed(evt);
            }
        });
        this.tbDesc.setFont(new Font("Dialog", 0, 12));
        this.tbDesc.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.tbDesc, (String)NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.tbDesc.text"));
        this.tbDesc.setMargin(new Insets(2, 2, 2, 2));
        Mnemonics.setLocalizedText((JLabel)this.lLoading, (String)NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.lLoading.text"));
        this.lLoading.setDirection(BusyPainter.Direction.RIGHT);
        this.cpChart.setCollapsed(true);
        this.bOpenAnalysis.setIcon(new ImageIcon(this.getClass().getResource("/chart_green.png")));
        this.bOpenAnalysis.setToolTipText(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.bOpenAnalysis.toolTipText"));
        this.bOpenAnalysis.setEnabled(false);
        this.bOpenAnalysis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SecurityEventsTopComponent.this.bOpenAnalysisActionPerformed(evt);
            }
        });
        this.lSearchStatus.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.lSearchStatus, (String)NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.lSearchStatus.text", (Object[])new Object[]{0, 0}));
        this.lPreviousTimeFrame.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.lPreviousTimeFrame, (String)NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.lPreviousTimeFrame.text", (Object[])new Object[0]));
        this.lPreviousTimeFrame.setToolTipText(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.lPreviousTimeFrame.toolTipText", (Object[])new Object[0]));
        this.lQueryTime.setFont(new Font("Dialog", 1, 12));
        this.lQueryTime.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lQueryTime, (String)NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.lQueryTime.text"));
        this.lNextTimeFrame.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.lNextTimeFrame, (String)NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.lNextTimeFrame.text", (Object[])new Object[0]));
        this.lNextTimeFrame.setToolTipText(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.lNextTimeFrame.toolTipText", (Object[])new Object[0]));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lSearchStatus, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lPreviousTimeFrame).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lQueryTime, -2, 427, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lNextTimeFrame, -2, 45, -2)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lSearchStatus, -2, 31, -2).addComponent(this.lQueryTime, -2, 31, -2).addComponent(this.lPreviousTimeFrame, -2, 31, -2).addComponent(this.lNextTimeFrame, GroupLayout.Alignment.TRAILING, -2, 31, -2));
        this.bDuplicateComponent.setIcon(new ImageIcon(this.getClass().getResource("/duplicate.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bDuplicateComponent, (String)NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.bDuplicateComponent.text"));
        this.bDuplicateComponent.setToolTipText(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.bDuplicateComponent.toolTipText"));
        this.bDuplicateComponent.setEnabled(false);
        this.bDuplicateComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SecurityEventsTopComponent.this.bDuplicateComponentActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent((Component)this.cpChart, -1, -1, Short.MAX_VALUE).addComponent(this.jTabbedPane1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent((Component)this.lLoading, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfSearch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tbDesc).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bSearch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bDuplicateComponent).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bOpenAnalysis, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bQueryBookmarks, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btQueryBookmarked, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bDisplayOptions, -2, 30, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.bDisplayOptions, -1, -1, Short.MAX_VALUE).addComponent(this.bQueryBookmarks, -1, -1, Short.MAX_VALUE).addComponent(this.btQueryBookmarked, -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfSearch).addComponent(this.tbDesc).addComponent(this.bSearch).addComponent(this.bDuplicateComponent))).addComponent((Component)this.lLoading, -2, -1, -2).addComponent(this.bOpenAnalysis)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.cpChart, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1).addContainerGap()));
    }

    private void bDisplayOptionsActionPerformed(ActionEvent evt) {
        DisplayOptionsDisplayer.display(this.displayOptions);
    }

    private void bPageDownActionPerformed(ActionEvent evt) {
        try {
            this.searchExecutor.next();
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void bBottomActionPerformed(ActionEvent evt) {
        try {
            this.searchExecutor.last();
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void bPageUpActionPerformed(ActionEvent evt) {
        try {
            this.searchExecutor.prev();
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void bTopActionPerformed(ActionEvent evt) {
        try {
            this.searchExecutor.first();
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void btQueryBookmarkedActionPerformed(ActionEvent evt) {
        try {
            if (this.btQueryBookmarked.isSelected() && !this.tfSearch.getText().isEmpty()) {
                final QuerySetNamePanel panel = new QuerySetNamePanel();
                DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SetQueryName.dialog.title"), true, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int opt = (Integer)e.getSource();
                        if (DialogDescriptor.OK_OPTION.equals(opt)) {
                            SavedQueryData q = new SavedQueryData();
                            q.setName(panel.getTypedName());
                            q.setQuery(SecurityEventsTopComponent.this.tfSearch.getText());
                            q.setType(SavedQueryDataType.SECURITY_EVENTS_QUERY);
                            q.setId(DigestUtils.md5Hex((String)String.format("%s%s", q.getQuery(), q.getType())));
                            try {
                                SecurityEventsTopComponent.this.apiService.saveSavedQuery(q);
                            }
                            catch (ApiServiceException_Exception ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                });
                DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            } else if (this.queryData != null) {
                this.apiService.deleteSavedQuery(this.queryData.getId());
            }
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void bQueryBookmarksActionPerformed(ActionEvent evt) {
        ArrayList<SavedQueryData> queries;
        try {
            queries = this.apiService.getSecurityEventQueries();
        }
        catch (ApiServiceException_Exception ex) {
            queries = new ArrayList<SavedQueryData>();
            Exceptions.printStackTrace((Throwable)ex);
        }
        final SavedQueryDataDialog dialog = new SavedQueryDataDialog();
        dialog.setData(queries);
        dialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
        dialog.setVisible(true);
        dialog.setDefaultCloseOperation(2);
        dialog.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                SavedQueryData selectedQueryBookmark = dialog.getSelectedQueryBookmark();
                if (selectedQueryBookmark != null) {
                    SecurityEventsTopComponent.this.queryData = selectedQueryBookmark;
                    SecurityEventsTopComponent.this.tfSearch.setText(dialog.getSelectedQueryBookmark().getQuery());
                    SecurityEventsTopComponent.this.btQueryBookmarked.setSelected(true);
                    SecurityEventsTopComponent.this.startSearch();
                } else {
                    SecurityEventsTopComponent.this.btQueryBookmarked.setSelected(false);
                }
            }
        });
    }

    private void bOpenAnalysisActionPerformed(ActionEvent evt) {
        AnalysisTopComponent analysisTopComponent = (AnalysisTopComponent)WindowManager.getDefault().findTopComponent("AnalysisTopComponent");
        if (analysisTopComponent == null) {
            analysisTopComponent = new AnalysisTopComponent();
        }
        analysisTopComponent.updateDisplayOptions(this.displayOptions);
        analysisTopComponent.doSearch(this.previousQuery);
        analysisTopComponent.open();
        analysisTopComponent.requestActive();
    }

    private void bDuplicateComponentActionPerformed(ActionEvent evt) {
        SecurityEventsTopComponent securityEventsDuplicateTopComponent = new SecurityEventsTopComponent();
        securityEventsDuplicateTopComponent.updateDisplayOptions(this.displayOptions, false);
        securityEventsDuplicateTopComponent.tfSearch.setText(this.tfSearch.getText());
        securityEventsDuplicateTopComponent.open();
        securityEventsDuplicateTopComponent.requestActive();
    }

    public void componentOpened() {
        this.startAutoRefreshTimer();
        this.queryHistory.init();
        this.autoCompleteDecorator.autoComplete(this.tfSearch, this.getMappings());
    }

    public void componentClosed() {
        this.stopAutoRefreshTimer();
        if (this.searchExecutor != null) {
            this.searchExecutor.shutdown();
        }
    }

    private Set<String> getMappings() {
        HashSet<String> items = new HashSet<String>();
        try {
            Map mappings = this.apiService.getMappings();
            if (mappings != null) {
                for (String cat : mappings.keySet()) {
                    if (!cat.equalsIgnoreCase("who") && !cat.equalsIgnoreCase("what") && !cat.equalsIgnoreCase("where") && !cat.equalsIgnoreCase("when") && !cat.equalsIgnoreCase("extra")) continue;
                    for (String field : (List)mappings.get(cat)) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(cat);
                        sb.append(".");
                        sb.append(field);
                        items.add(sb.toString());
                    }
                }
            }
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return items;
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
        p.setProperty("tse_col_count", String.valueOf(this.tSecurityEvents.getColumnModel().getColumnCount()));
        for (int i = 0; i < this.tSecurityEvents.getColumnModel().getColumnCount(); ++i) {
            TableColumn tc = this.tSecurityEvents.getColumnModel().getColumn(i);
            p.setProperty(String.format("tse_col%d_width", i), String.valueOf(tc.getWidth()));
        }
        p.setProperty("search_string", this.tfSearch.getText());
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
        String colCountString = p.getProperty("tse_col_count");
        LOGGER.fine(String.format("Version: %s, colCount: %s", version, colCountString));
        try {
            int colCount = colCountString != null ? Integer.valueOf(colCountString) : 0;
            for (int i = 0; i < colCount; ++i) {
                String s = p.getProperty("tse_col" + i + "_width");
                LOGGER.fine(String.format("tse_col_%d_width: %s", i, s));
                if (s == null) continue;
                this.tSecurityEvents.getColumnModel().getColumn(i).setPreferredWidth(Integer.valueOf(s));
            }
            this.tfSearch.setText(p.getProperty("search_string"));
        }
        catch (NumberFormatException ex) {
            LOGGER.warning(String.format("Error converting to number: %s", ex.getMessage()));
        }
        this.tfSearchChangeFont();
    }

    private void tfSearchChangeFont() {
        String text = NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.tfSearch.text");
        if (text.equals(this.tfSearch.getText())) {
            Font font = new Font("Dialog", 2, 12);
            this.tfSearch.setFont(font);
            this.tfSearch.setForeground(Color.LIGHT_GRAY);
        } else {
            Font font = new Font("Dialog", 0, 12);
            this.tfSearch.setFont(font);
            this.tfSearch.setForeground(Color.BLACK);
        }
    }

    private void selectLastItemInTableAndScroll() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int rowCount = SecurityEventsTopComponent.this.tSecurityEvents.getRowCount() - 1;
                SecurityEventsTopComponent.this.tSecurityEvents.setRowSelectionInterval(rowCount, 0);
                SecurityEventsTopComponent.this.tSecurityEvents.changeSelection(rowCount, 0, false, false);
                SecurityEventsTopComponent.this.tSecurityEvents.scrollRectToVisible(new Rectangle(SecurityEventsTopComponent.this.tSecurityEvents.getCellRect(rowCount, 0, true)));
                SecurityEventsTopComponent.this.lSL.valueChanged(new ListSelectionEvent(SecurityEventsTopComponent.this.tSecurityEvents, rowCount, 0, false));
            }
        });
    }

    private void updateCountSearchStatus() {
        if (this.searchExecutor != null) {
            List<String> errors = this.searchExecutor.getSearchContext().getSearchResults().getErrors();
            long totalDuration = this.searchExecutor.getSearchContext().getSearchResults().getTotalDuration();
            if (!errors.isEmpty()) {
                this.lSearchStatus.setIcon(new ImageIcon(this.getClass().getResource("/delete.png")));
                StringBuilder sb = new StringBuilder();
                for (String err : errors) {
                    sb.append(err);
                    sb.append(", ");
                }
                if (sb.toString().length() > 2) {
                    sb.replace(sb.toString().length() - 2, sb.toString().length(), "");
                }
                String error = NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.lSearchStatus.failed.text", (Object[])new Object[]{totalDuration, sb.toString()});
                this.lSearchStatus.setToolTipText(error);
            } else {
                this.lSearchStatus.setIcon(null);
                this.lSearchStatus.setToolTipText("");
                this.bSearch.setForeground(Color.black);
            }
            this.lSearchStatus.setText(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.lSearchStatus.text.label", (Object[])new Object[]{totalDuration, this.searchExecutor.getSearchContext().getSearchResults().getTotalHits()}));
        }
    }

    private void selectItemInTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SecurityEventsTopComponent.this.tSecurityEvents.getRowCount() > 0) {
                    if (SecurityEventsTopComponent.this.selectLast) {
                        SecurityEventsTopComponent.this.selectLastItemInTableAndScroll();
                        SecurityEventsTopComponent.this.selectLast = false;
                    } else if (!SecurityEventsTopComponent.this.tSecurityEvents.isRowSelected(0)) {
                        SecurityEventsTopComponent.this.tSecurityEvents.setRowSelectionInterval(0, 0);
                        SecurityEventsTopComponent.this.tSecurityEvents.changeSelection(0, 0, false, false);
                        SecurityEventsTopComponent.this.lSL.valueChanged(new ListSelectionEvent(SecurityEventsTopComponent.this.tSecurityEvents, 0, 0, false));
                    }
                }
            }
        });
    }

    private void updateSearchTime() {
        this.lNextTimeFrame.setVisible(true);
        this.lPreviousTimeFrame.setVisible(true);
        this.lQueryTime.setText(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.lQueryTime.text.label", (Object[])new Object[]{this.isoTimeFormat.print(this.displayOptions.getTimeStart()), this.isoTimeFormat.print(this.displayOptions.getTimeFinish())}));
    }

    public void doSearch(String query) {
        this.tfSearch.setText(query);
        this.startSearch();
    }

    public void doSearch(String query, long start, long finish) {
        this.displayOptions.setTimeStart(start);
        this.displayOptions.setTimeFinish(finish);
        this.doSearch(query);
    }

    public String getTag() {
        return this.tag;
    }

    public DisplayOptions getDisplayOptions() {
        return this.displayOptions;
    }

    public void updateDisplayOptions(DisplayOptions displayOptions, boolean fire) {
        if (this.displayOptions.isFireEvents() != fire) {
            this.displayOptions.toggleFireEvents();
        }
        this.displayOptions.setAutoRefresh(displayOptions.getAutoRefresh());
        this.displayOptions.setPageSize(displayOptions.getPageSize());
        this.displayOptions.setIndexSplit(displayOptions.getIndexSplit());
        this.displayOptions.setIntervalObj(displayOptions.getIntervalObj());
        this.displayOptions.setIntervals(displayOptions.getIntervals());
        this.displayOptions.setLastNHours(false);
        this.displayOptions.setLastNHoursSelectedIndex(displayOptions.getLastNHoursSelectedIndex());
        this.displayOptions.setNow(false);
        if (this.displayOptions.isNow()) {
            displayOptions.adjustTime();
        }
        this.displayOptions.setTimeStart(displayOptions.getTimeStart());
        this.displayOptions.setTimeFinish(displayOptions.getTimeFinish());
        this.displayOptions.setShowOverview(displayOptions.isShowOverview());
        this.displayOptions.setDescOrder(displayOptions.isDescOrder());
    }

    public void startSearch() {
        if (this.countChart != null) {
            this.countChart.getChartPanel().removeChartMouseListener(this.chartMouseListener);
            this.countChart = null;
        }
        this.cpChart.setCollapsed(true);
        this.tableModel.clearData();
        this.startTimeOfCreatingATable = System.currentTimeMillis();
        if (this.searchExecutor != null) {
            this.searchExecutor.shutdown();
        }
        this.bPageUp.setEnabled(false);
        this.bPageDown.setEnabled(false);
        this.bTop.setEnabled(false);
        this.bBottom.setEnabled(false);
        this.lQueryTime.setText(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.lQueryTime.text.CalculatingTimestamps"));
        this.lSearchStatus.setText(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.lQueryTime.text.PreparingSearch"));
        this.displayOptions.adjustTime();
        if (this.tfSearch.getText().equals(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.tfSearch.text"))) {
            this.tfSearch.setText("");
            this.normal();
        }
        this.jTabbedPane1.setEnabledAt(0, this.displayOptions.isShowOverview());
        if (!this.displayOptions.isShowOverview()) {
            this.jTabbedPane1.setSelectedIndex(1);
        }
        try {
            LOGGER.info(String.format("START SEARCH: s: %s f: %s", new DateTime(this.displayOptions.getTimeStart()), new DateTime(this.displayOptions.getTimeFinish())));
            this.lLoading.setBusy(true);
            this.searchExecutor = new SearchExecutor(this.tfSearch.getText(), this.displayOptions.getTimeStart(), this.displayOptions.getTimeFinish(), this.displayOptions.getIndexSplit(), this.displayOptions.getPageSize(), !this.tbDesc.isSelected(), this.user, this);
            this.searchExecutor.startSearch();
            this.updateSearchTime();
            this.setDisplayName(TopComponentTitleShortener.shortenTitle(this.searchExecutor.ifQueryIsEmptySetToDefault(this.tfSearch.getText())));
            this.startAutoRefreshTimer();
            this.previousQuery = this.tfSearch.getText();
            if (!this.bOpenAnalysis.isEnabled()) {
                this.bOpenAnalysis.setEnabled(true);
                this.bDuplicateComponent.setEnabled(true);
            }
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (this.displayOptions.isShowOverview()) {
            this.overviewPanel.update(this.searchExecutor.ifQueryIsEmptySetToDefault(this.tfSearch.getText()), this.displayOptions, this.user);
        }
        this.updateUndoQuery();
        this.setDefaultPageSizeIfItsNotPredefinedSize();
    }

    public void setDefaultPageSizeIfItsNotPredefinedSize() {
        if (this.displayOptions.getPageSize() > 1000) {
            this.displayOptions.setPageSizeWithoutSearch(100);
        }
    }

    private void fetch(DateRange dr) {
        try {
            this.searchExecutor.fetch(dr);
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private ChartPanel createChart(TimeTableXYDataset dataset) {
        if (this.countChart == null) {
            MyStackedXYBarRenderer renderer = new MyStackedXYBarRenderer();
            this.countChart = new FrontCountBarChart(dataset, renderer);
            ChartPanel chartPanel = this.countChart.getChartPanel();
            chartPanel.getChart().removeLegend();
        } else {
            this.countChart.updateChart(dataset);
            this.pChart.invalidate();
            this.pChart.repaint();
        }
        return this.countChart.getChartPanel();
    }

    private TimeTableXYDataset createDataset() {
        long startCreating = System.currentTimeMillis();
        TimeTableXYDataset dataset = new TimeTableXYDataset();
        dataset.setDomainIsPointsInTime(true);
        Map<DateRange, SearchState> searchStateForDateRange = this.searchExecutor.getSearchContext().getSearchStateForDateRange();
        for (DateRange dr : searchStateForDateRange.keySet()) {
            SearchState ss = searchStateForDateRange.get(dr);
            if (ss.getTotalHits() == null) continue;
            long totalHits = ss.getTotalHits();
            if (ss.getTotalHits() == -1L) {
                long m;
                totalHits = m = this.searchExecutor.getAverageCountValueForGraph();
            }
            dataset.add((TimePeriod)new SimpleTimePeriod(dr.getStartTimeStamp(), dr.getFinishTimeStamp()), (double)totalHits, (Comparable)((Object)""));
        }
        LOGGER.info(String.format("CREATION OF DATASET IS FINISHED IN %d ms", System.currentTimeMillis() - startCreating));
        return dataset;
    }

    private void toggleButtonDescSetSelected(boolean isDescSelected) {
        if (isDescSelected) {
            this.tbDesc.setSelected(true);
            this.tbDesc.setText(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.desc"));
        } else {
            this.tbDesc.setSelected(false);
            this.tbDesc.setText(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.asc"));
        }
        this.tbDesc.repaint();
    }

    private class SelectionRunnable
    implements Runnable {
        SecurityEventWrapper prevEvent = null;
        RawLogSimWrapper prevLog = null;
        SecurityEvent event = null;
        boolean isRawLogDetailsOpened;

        public SelectionRunnable(SecurityEventWrapper prevEvent, RawLogSimWrapper prevLog, SecurityEvent event, boolean isRawLogDetailsOpened) {
            this.prevEvent = prevEvent;
            this.prevLog = prevLog;
            this.event = event;
            this.isRawLogDetailsOpened = isRawLogDetailsOpened;
        }

        @Override
        public void run() {
            if (this.event != null) {
                SecurityEventWrapper sew = new SecurityEventWrapper(this.event, SecurityEventsTopComponent.this.displayOptions, SecurityEventsTopComponent.this.tag);
                sew.setQuery(SecurityEventsTopComponent.this.tfSearch.getText());
                if (this.prevEvent != null) {
                    SecurityEventsTopComponent.this.instanceContent.remove((Object)this.prevEvent);
                }
                SecurityEventsTopComponent.this.instanceContent.add((Object)sew);
                this.prevEvent = sew;
                if (this.isRawLogDetailsOpened) {
                    long start = this.event.getTimestamp() - 600000L;
                    long finish = this.event.getTimestamp() + 600000L;
                    try {
                        RawLog log = SecurityEventsTopComponent.this.apiService.getRawLog(this.event.getId(), start, finish);
                        RawLogSimWrapper rlsw = null;
                        if (log != null) {
                            rlsw = new RawLogSimWrapper(log, start, finish, SecurityEventsTopComponent.this.tag, SecurityEventsTopComponent.this.displayOptions.isLastNHours(), SecurityEventsTopComponent.this.displayOptions.getLastNHoursSelectedIndex(), SecurityEventsTopComponent.this.displayOptions.isNow());
                            rlsw.setQuery(SecurityEventsTopComponent.this.tfSearch.getText());
                        } else {
                            log = new RawLog();
                            log.setId(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.nodata"));
                            log.setSource(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.nodata"));
                            log.setText(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.nodata"));
                            log.setSource(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.nodata"));
                            rlsw = new RawLogSimWrapper(log, start, finish, SecurityEventsTopComponent.this.tag, SecurityEventsTopComponent.this.displayOptions.isLastNHours(), SecurityEventsTopComponent.this.displayOptions.getLastNHoursSelectedIndex(), SecurityEventsTopComponent.this.displayOptions.isNow());
                            rlsw.setQuery(SecurityEventsTopComponent.this.tfSearch.getText());
                        }
                        if (this.prevLog != null) {
                            SecurityEventsTopComponent.this.instanceContent.remove((Object)this.prevLog);
                        }
                        SecurityEventsTopComponent.this.instanceContent.add((Object)rlsw);
                        this.prevLog = rlsw;
                    }
                    catch (ApiServiceException_Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
    }
}

