/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.rawlogs.filetype;

import java.io.IOException;
import java.util.logging.Logger;
import org.netbeans.core.spi.multiview.text.MultiViewEditorElement;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.Lookup;
import rs.co.ast.aspen.gui.rawlogs.RawLogsTopComponent;

public class RawLogDataObject
extends MultiDataObject
implements OpenCookie {
    private static final Logger logger = Logger.getLogger(RawLogDataObject.class.getName());

    public static MultiViewEditorElement createEditor(Lookup lkp) {
        return new MultiViewEditorElement(lkp);
    }

    public RawLogDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException, IOException {
        super(pf, loader);
        this.registerEditor("text/x-rawlog", false);
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    public void open() {
        RawLogsTopComponent rltc = new RawLogsTopComponent();
        rltc.open();
        rltc.requestActive();
        try {
            long start = (Long)this.getPrimaryFile().getAttribute("start");
            logger.info(String.format("start %d", start));
            long finish = (Long)this.getPrimaryFile().getAttribute("finish");
            logger.info(String.format("finish %d", finish));
            boolean lastNHours = (Boolean)this.getPrimaryFile().getAttribute("lastNHours");
            logger.info(String.format("lastNHours %s", lastNHours));
            boolean now = (Boolean)this.getPrimaryFile().getAttribute("now");
            logger.info(String.format("now %s", now));
            int lastNHoursSelectedIndex = (Integer)this.getPrimaryFile().getAttribute("lastNHoursSelectedIndex");
            logger.info(String.format("lastNHoursSelectedIndex %d", lastNHoursSelectedIndex));
            boolean asc = (Boolean)this.getPrimaryFile().getAttribute("ASC");
            logger.info(String.format("ASC %s", asc));
            rltc.getDisplayOptions().toggleFireEvents();
            rltc.getDisplayOptions().setNow(now);
            rltc.getDisplayOptions().setLastNHours(lastNHours);
            rltc.getDisplayOptions().setLastNHoursSelectedIndex(lastNHoursSelectedIndex);
            rltc.getDisplayOptions().setTimeStart(start);
            rltc.getDisplayOptions().setTimeFinish(finish);
            rltc.getDisplayOptions().toggleFireEvents();
            if (asc) {
                rltc.setAsc();
            }
            rltc.doSearch((String)this.getPrimaryFile().getAttribute("query"), start, finish);
        }
        catch (NullPointerException ex) {
            rltc.doSearch((String)this.getPrimaryFile().getAttribute("query"));
        }
    }

    protected int associateLookup() {
        return 1;
    }
}

