/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.rawlogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.RawLog;
import rs.co.ast.aspen.api.service.RawLogSimWrapper;
import rs.co.ast.aspen.gui.rawlogs.RawLogsTopComponent;

public class RawLogDetailsTableModel
extends AbstractTableModel {
    private static final DateTimeFormatter dtf = ISODateTimeFormat.basicDateTime();
    private List<Item> items = new ArrayList<Item>();

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Item.class;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return NbBundle.getMessage(RawLogDetailsTableModel.class, (String)"RawLogDetailsTopComponent.table.col0.title");
            }
            case 1: {
                return NbBundle.getMessage(RawLogDetailsTableModel.class, (String)"RawLogDetailsTopComponent.table.col1.title");
            }
        }
        throw new IllegalArgumentException("Invalid column index");
    }

    public void setLog(RawLogSimWrapper rlsw) {
        this.items.clear();
        this.items.add(new Item(null, "id", rlsw.getRawLog().getId()));
        String timestamp = NbBundle.getMessage(RawLogsTopComponent.class, (String)"RawLogsTopComponent.nodata");
        if (rlsw.getRawLog().getTimestamp() != null) {
            timestamp = String.valueOf(rlsw.getRawLog().getTimestamp());
        }
        this.items.add(new Item(null, "timestamp", timestamp));
        this.items.add(new Item(null, "source", rlsw.getRawLog().getSource()));
        this.items.add(new Item(null, "text", rlsw.getRawLog().getText()));
        Collections.sort(this.items, new Comparator<Item>(this){

            @Override
            public int compare(Item o1, Item o2) {
                return String.CASE_INSENSITIVE_ORDER.compare(o1.getKey(), o2.getKey());
            }
        });
        if (rlsw.getRawLog() != null && rlsw.getRawLog().getMetaData() != null) {
            this.items.add(new Item("MetaData", null, null));
            List entries = rlsw.getRawLog().getMetaData().getEntry();
            Collections.sort(entries, new Comparator<RawLog.MetaData.Entry>(this){

                @Override
                public int compare(RawLog.MetaData.Entry o1, RawLog.MetaData.Entry o2) {
                    return String.CASE_INSENSITIVE_ORDER.compare(o1.getKey(), o2.getKey());
                }
            });
            for (RawLog.MetaData.Entry e : entries) {
                this.items.add(new Item("metaData", e.getKey(), e.getValue()));
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        if (this.items != null) {
            return this.items.size();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.items != null && !this.items.isEmpty() && rowIndex >= 0 && rowIndex < this.items.size()) {
            return this.items.get(rowIndex);
        }
        return null;
    }

    public static class Item {
        public String category;
        public String key;
        public String value;

        public Item(String category, String key, String value) {
            this.category = category;
            this.key = key;
            this.value = value;
        }

        public String getCategory() {
            return this.category;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

