/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.notifications;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.DeliveryPoint;
import rs.co.ast.aspen.api.service.DeliveryPointType;
import rs.co.ast.aspen.api.service.Destination;
import rs.co.ast.aspen.api.service.ModuleVersionUtils;
import rs.co.ast.aspen.gui.module.notifications.AddNewDeliveryPoint;
import rs.co.ast.aspen.gui.module.notifications.AddNewDestination;
import rs.co.ast.aspen.gui.module.notifications.DeliveryPointTableModel;
import rs.co.ast.aspen.gui.module.notifications.DeliveryPointTableRenderer;
import rs.co.ast.aspen.gui.module.notifications.DestinationTableModel;
import rs.co.ast.aspen.gui.module.notifications.DestinationTableRenderer;

@TopComponent.Description(preferredID="NotificationsTopComponent", iconBase="notification.png", persistenceType=0)
public final class NotificationsTopComponent
extends TopComponent {
    private static final Logger logger = Logger.getLogger(NotificationsTopComponent.class.getName());
    private ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private DestinationTableModel destinationTableModel = new DestinationTableModel();
    private DeliveryPointTableModel deliveryPointTableModel = new DeliveryPointTableModel();
    private List<Destination> allDestinations;
    private int prevRow = 0;
    private JButton bDeleteDeliveryPoint;
    private JButton bDeleteDestination;
    private JButton bNewDeliveryPoint;
    private JButton bNewDestination;
    private JButton bResetProperties;
    private JButton bUpdateProperties;
    private JCheckBox cbActive;
    private JComboBox cbType;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JLabel lData;
    private JLabel lDeliveryPointProperties;
    private JLabel lName;
    private JLabel lSeverity;
    private JLabel lType;
    private JTable tDeliveryPoint;
    private JTable tDestinations;
    private JTextField tfData;
    private JTextField tfName;
    private JTextField tfSeverity;

    public NotificationsTopComponent() {
        logger.setLevel(Level.ALL);
        logger.info(String.format("%s version: %s", ModuleVersionUtils.getModuleDisplayName((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.NOTIFICATIONS), ModuleVersionUtils.getModuleVersion((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.NOTIFICATIONS)));
        this.initComponents();
        this.setName(NbBundle.getMessage(NotificationsTopComponent.class, (String)"CTL_NotificationsTopComponent"));
        this.setToolTipText(NbBundle.getMessage(NotificationsTopComponent.class, (String)"HINT_NotificationsTopComponent"));
        this.disableButton();
        this.fillcbType();
        this.tDestinations.setDefaultRenderer(Destination.class, new DestinationTableRenderer());
        this.tDestinations.setSelectionMode(0);
        this.tDestinations.setRowSelectionAllowed(true);
        this.tDestinations.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Destination d = (Destination)NotificationsTopComponent.this.destinationTableModel.getValueAt(NotificationsTopComponent.this.tDestinations.getSelectedRow(), 0);
                if (d != null) {
                    NotificationsTopComponent.this.deliveryPointTableModel.setData(d.getDeliveryPoints());
                    NotificationsTopComponent.this.prevRow = NotificationsTopComponent.this.destinationTableModel.getObjectRowPosition(d);
                    NotificationsTopComponent.this.bDeleteDestination.setEnabled(true);
                } else {
                    NotificationsTopComponent.this.prevRow = 0;
                    NotificationsTopComponent.this.bDeleteDestination.setEnabled(false);
                }
                NotificationsTopComponent.this.bNewDeliveryPoint.setEnabled(true);
                NotificationsTopComponent.this.bDeleteDeliveryPoint.setEnabled(false);
                NotificationsTopComponent.this.bUpdateProperties.setEnabled(false);
                NotificationsTopComponent.this.bResetProperties.setEnabled(false);
                NotificationsTopComponent.this.resetProperties();
            }
        });
        this.tDeliveryPoint.setDefaultRenderer(DeliveryPoint.class, new DeliveryPointTableRenderer());
        this.tDeliveryPoint.setSelectionMode(0);
        this.tDeliveryPoint.setRowSelectionAllowed(true);
        this.tDeliveryPoint.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DeliveryPoint d = (DeliveryPoint)NotificationsTopComponent.this.deliveryPointTableModel.getValueAt(NotificationsTopComponent.this.tDeliveryPoint.getSelectedRow(), 0);
                if (d != null) {
                    NotificationsTopComponent.this.tfName.setText(d.getId());
                    NotificationsTopComponent.this.cbType.setSelectedItem(d.getType());
                    NotificationsTopComponent.this.tfData.setText(d.getData());
                    NotificationsTopComponent.this.tfSeverity.setText(String.valueOf(d.getMinSeverity()));
                    NotificationsTopComponent.this.cbActive.setSelected(d.isActive());
                    NotificationsTopComponent.this.bDeleteDeliveryPoint.setEnabled(true);
                }
                NotificationsTopComponent.this.bResetProperties.setEnabled(true);
            }
        });
        DocumentListener textChangeListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.doChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.doChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.doChange();
            }

            private void doChange() {
                NotificationsTopComponent.this.checkPropertiesChange();
            }
        };
        this.tfName.getDocument().addDocumentListener(textChangeListener);
        this.tfData.getDocument().addDocumentListener(textChangeListener);
        this.tfSeverity.getDocument().addDocumentListener(textChangeListener);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotificationsTopComponent.this.checkPropertiesChange();
            }
        };
        this.cbType.addActionListener(actionListener);
        this.cbActive.addActionListener(actionListener);
    }

    private void initComponents() {
        this.jSplitPane2 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tDestinations = new JTable();
        this.bNewDestination = new JButton();
        this.bDeleteDestination = new JButton();
        this.jPanel2 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel4 = new JPanel();
        this.bNewDeliveryPoint = new JButton();
        this.bDeleteDeliveryPoint = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.tDeliveryPoint = new JTable();
        this.jPanel3 = new JPanel();
        this.lDeliveryPointProperties = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.lName = new JLabel();
        this.lType = new JLabel();
        this.lData = new JLabel();
        this.lSeverity = new JLabel();
        this.tfName = new JTextField();
        this.tfData = new JTextField();
        this.tfSeverity = new JTextField();
        this.cbType = new JComboBox();
        this.cbActive = new JCheckBox();
        this.bUpdateProperties = new JButton();
        this.bResetProperties = new JButton();
        this.setPreferredSize(new Dimension(850, 515));
        this.jSplitPane2.setDividerLocation(250);
        this.jSplitPane2.setResizeWeight(0.5);
        this.jPanel1.setMinimumSize(new Dimension(250, 0));
        this.tDestinations.setModel(this.destinationTableModel);
        this.tDestinations.setColumnSelectionAllowed(true);
        this.tDestinations.setMinimumSize(new Dimension(250, 0));
        this.jScrollPane1.setViewportView(this.tDestinations);
        this.tDestinations.getColumnModel().getSelectionModel().setSelectionMode(0);
        if (this.tDestinations.getColumnModel().getColumnCount() > 0) {
            this.tDestinations.getColumnModel().getColumn(0).setHeaderValue(NbBundle.getMessage(NotificationsTopComponent.class, (String)"NotificationsTopComponent.tDestinations.columnModel.title0"));
        }
        Mnemonics.setLocalizedText((AbstractButton)this.bNewDestination, (String)NbBundle.getMessage(NotificationsTopComponent.class, (String)"NotificationsTopComponent.bNewDestination.text"));
        this.bNewDestination.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotificationsTopComponent.this.bNewDestinationActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bDeleteDestination, (String)NbBundle.getMessage(NotificationsTopComponent.class, (String)"NotificationsTopComponent.bDeleteDestination.text"));
        this.bDeleteDestination.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotificationsTopComponent.this.bDeleteDestinationActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.bNewDestination, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bDeleteDestination, -2, 75, -2).addGap(0, 84, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 434, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bDeleteDestination).addComponent(this.bNewDestination)).addGap(12, 12, 12)));
        this.jSplitPane2.setLeftComponent(this.jPanel1);
        this.jSplitPane1.setDividerLocation(250);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jPanel4.setMinimumSize(new Dimension(250, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.bNewDeliveryPoint, (String)NbBundle.getMessage(NotificationsTopComponent.class, (String)"NotificationsTopComponent.bNewDeliveryPoint.text"));
        this.bNewDeliveryPoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotificationsTopComponent.this.bNewDeliveryPointActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bDeleteDeliveryPoint, (String)NbBundle.getMessage(NotificationsTopComponent.class, (String)"NotificationsTopComponent.bDeleteDeliveryPoint.text"));
        this.bDeleteDeliveryPoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotificationsTopComponent.this.bDeleteDeliveryPointActionPerformed(evt);
            }
        });
        this.tDeliveryPoint.setModel(this.deliveryPointTableModel);
        this.tDeliveryPoint.setColumnSelectionAllowed(true);
        this.tDeliveryPoint.setMinimumSize(new Dimension(250, 0));
        this.jScrollPane2.setViewportView(this.tDeliveryPoint);
        this.tDeliveryPoint.getColumnModel().getSelectionModel().setSelectionMode(0);
        if (this.tDeliveryPoint.getColumnModel().getColumnCount() > 0) {
            this.tDeliveryPoint.getColumnModel().getColumn(0).setHeaderValue(NbBundle.getMessage(NotificationsTopComponent.class, (String)"NotificationsTopComponent.tDeliveryPoint.columnModel.title0"));
        }
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.bNewDeliveryPoint).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bDeleteDeliveryPoint)).addComponent(this.jScrollPane2, -1, 225, Short.MAX_VALUE)).addContainerGap()));
        jPanel4Layout.linkSize(0, this.bDeleteDeliveryPoint, this.bNewDeliveryPoint);
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 432, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bNewDeliveryPoint).addComponent(this.bDeleteDeliveryPoint)).addContainerGap()));
        this.jSplitPane1.setLeftComponent(this.jPanel4);
        this.lDeliveryPointProperties.setFont(new Font("Ubuntu", 1, 15));
        Mnemonics.setLocalizedText((JLabel)this.lDeliveryPointProperties, (String)NbBundle.getMessage(NotificationsTopComponent.class, (String)"NotificationsTopComponent.lDeliveryPointProperties.text"));
        Mnemonics.setLocalizedText((JLabel)this.lName, (String)NbBundle.getMessage(NotificationsTopComponent.class, (String)"NotificationsTopComponent.lName.text"));
        Mnemonics.setLocalizedText((JLabel)this.lType, (String)NbBundle.getMessage(NotificationsTopComponent.class, (String)"NotificationsTopComponent.lType.text"));
        Mnemonics.setLocalizedText((JLabel)this.lData, (String)NbBundle.getMessage(NotificationsTopComponent.class, (String)"NotificationsTopComponent.lData.text"));
        Mnemonics.setLocalizedText((JLabel)this.lSeverity, (String)NbBundle.getMessage(NotificationsTopComponent.class, (String)"NotificationsTopComponent.lSeverity.text"));
        this.tfName.setText(NbBundle.getMessage(NotificationsTopComponent.class, (String)"NotificationsTopComponent.tfName.text"));
        this.tfData.setText(NbBundle.getMessage(NotificationsTopComponent.class, (String)"NotificationsTopComponent.tfData.text"));
        this.tfSeverity.setText(NbBundle.getMessage(NotificationsTopComponent.class, (String)"NotificationsTopComponent.tfSeverity.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbActive, (String)NbBundle.getMessage(NotificationsTopComponent.class, (String)"NotificationsTopComponent.cbActive.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.bUpdateProperties, (String)NbBundle.getMessage(NotificationsTopComponent.class, (String)"NotificationsTopComponent.bUpdateProperties.text"));
        this.bUpdateProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotificationsTopComponent.this.bUpdatePropertiesActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bResetProperties, (String)NbBundle.getMessage(NotificationsTopComponent.class, (String)"NotificationsTopComponent.bResetProperties.text"));
        this.bResetProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotificationsTopComponent.this.bResetPropertiesActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGap(0, 159, Short.MAX_VALUE).addComponent(this.bUpdateProperties).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bResetProperties)).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lData).addComponent(this.lType).addComponent(this.lName).addComponent(this.lSeverity)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cbActive, -2, 243, Short.MAX_VALUE).addComponent(this.cbType, 0, -1, Short.MAX_VALUE).addComponent(this.tfData).addComponent(this.tfName).addComponent(this.tfSeverity))).addComponent(this.lDeliveryPointProperties, -2, 318, Short.MAX_VALUE).addComponent(this.jSeparator1)))).addContainerGap()));
        jPanel3Layout.linkSize(0, this.bResetProperties, this.bUpdateProperties);
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.lDeliveryPointProperties).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lName).addComponent(this.tfName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lType).addComponent(this.cbType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lData).addComponent(this.tfData, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lSeverity).addComponent(this.tfSeverity, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbActive).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 274, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bUpdateProperties).addComponent(this.bResetProperties)).addContainerGap()));
        this.jSplitPane1.setRightComponent(this.jPanel3);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jSplitPane1, -1, 573, Short.MAX_VALUE).addGap(0, 0, 0)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, GroupLayout.Alignment.TRAILING));
        this.jSplitPane2.setRightComponent(this.jPanel2);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane2, -1, 829, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane2, -1, 491, Short.MAX_VALUE).addContainerGap()));
    }

    private void bNewDeliveryPointActionPerformed(ActionEvent evt) {
        if (this.tDestinations.getSelectedRow() != -1) {
            final AddNewDeliveryPoint panel = new AddNewDeliveryPoint();
            DialogDescriptor d = new DialogDescriptor((Object)panel, NbBundle.getMessage(NotificationsTopComponent.class, (String)"AddNewDeliveryPoint.title"), true, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == DialogDescriptor.OK_OPTION) {
                        try {
                            Destination d = (Destination)NotificationsTopComponent.this.destinationTableModel.getValueAt(NotificationsTopComponent.this.tDestinations.getSelectedRow(), 0);
                            if (d != null) {
                                d.getDeliveryPoints().add(panel.newDeliveryPoint());
                                if (NotificationsTopComponent.this.apiService.updateDestination(d)) {
                                    new Updater().execute();
                                }
                            }
                        }
                        catch (ApiServiceException_Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            });
            DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
        }
    }

    private void bNewDestinationActionPerformed(ActionEvent evt) {
        final AddNewDestination panel = new AddNewDestination();
        DialogDescriptor d = new DialogDescriptor((Object)panel, NbBundle.getMessage(NotificationsTopComponent.class, (String)"AddNewDestination.title"), true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == DialogDescriptor.OK_OPTION) {
                    try {
                        if (NotificationsTopComponent.this.apiService.addNewDestination(panel.getDestinationName())) {
                            new Updater().execute();
                        }
                    }
                    catch (ApiServiceException_Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        });
        DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
    }

    private void bResetPropertiesActionPerformed(ActionEvent evt) {
        DeliveryPoint d = (DeliveryPoint)this.deliveryPointTableModel.getValueAt(this.tDeliveryPoint.getSelectedRow(), 0);
        if (d != null) {
            this.tfName.setText(d.getId());
            this.cbType.setSelectedItem(d.getType());
            this.tfData.setText(d.getData());
            this.tfSeverity.setText(String.valueOf(d.getMinSeverity()));
            this.cbActive.setSelected(d.isActive());
        }
        this.bUpdateProperties.setEnabled(false);
    }

    private void bDeleteDeliveryPointActionPerformed(ActionEvent evt) {
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(NotificationsTopComponent.class, (String)"DeleteDeliveryPointConfirmation.message"), NbBundle.getMessage(NotificationsTopComponent.class, (String)"DeleteDeliveryPointConfirmation.title"), 0);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) == NotifyDescriptor.YES_OPTION) {
            Destination d = (Destination)this.destinationTableModel.getValueAt(this.tDestinations.getSelectedRow(), 0);
            DeliveryPoint dp = (DeliveryPoint)this.deliveryPointTableModel.getValueAt(this.tDeliveryPoint.getSelectedRow(), 0);
            if (d != null && dp != null) {
                try {
                    d.getDeliveryPoints().remove(dp);
                    if (this.apiService.updateDestination(d)) {
                        new Updater().execute();
                    }
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void bDeleteDestinationActionPerformed(ActionEvent evt) {
        Destination dest;
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(NotificationsTopComponent.class, (String)"DeleteDestinationConfirmation.message"), NbBundle.getMessage(NotificationsTopComponent.class, (String)"DeleteDestinationConfirmation.title"), 0);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION && (dest = (Destination)this.destinationTableModel.getValueAt(this.tDestinations.getSelectedRow(), 0)) != null) {
            try {
                if (this.apiService.deleteDestination(dest.getId())) {
                    new Updater().execute();
                }
            }
            catch (ApiServiceException_Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void bUpdatePropertiesActionPerformed(ActionEvent evt) {
        try {
            Destination d = (Destination)this.destinationTableModel.getValueAt(this.tDestinations.getSelectedRow(), 0);
            DeliveryPoint dp = (DeliveryPoint)this.deliveryPointTableModel.getValueAt(this.tDeliveryPoint.getSelectedRow(), 0);
            dp.setActive(this.cbActive.isSelected());
            dp.setData(this.tfData.getText());
            dp.setMinSeverity(Integer.parseInt(this.tfSeverity.getText()));
            dp.setType((DeliveryPointType)this.cbType.getSelectedItem());
            dp.setId(this.tfName.getText());
            if (this.apiService.updateDestination(d)) {
                new Updater().execute();
            }
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void componentOpened() {
        new Updater().execute();
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    private void fillcbType() {
        for (DeliveryPointType t : DeliveryPointType.values()) {
            this.cbType.addItem(t);
        }
    }

    private void disableButton() {
        this.bDeleteDestination.setEnabled(false);
        this.bNewDeliveryPoint.setEnabled(false);
        this.bDeleteDeliveryPoint.setEnabled(false);
        this.bUpdateProperties.setEnabled(false);
        this.bResetProperties.setEnabled(false);
    }

    private void resetProperties() {
        this.tfName.setText("");
        this.cbType.setSelectedIndex(0);
        this.tfData.setText("");
        this.tfSeverity.setText("");
        this.cbActive.setSelected(false);
    }

    private boolean checkPropertiesChange() {
        DeliveryPoint dp = (DeliveryPoint)this.deliveryPointTableModel.getValueAt(this.tDeliveryPoint.getSelectedRow(), 0);
        if (dp != null) {
            int severity = 0;
            try {
                severity = this.tfSeverity.getText().isEmpty() ? 0 : Integer.parseInt(this.tfSeverity.getText());
            }
            catch (NumberFormatException ex) {
                severity = dp.getMinSeverity();
            }
            if (!dp.getId().equals(this.tfName.getText()) && !this.tfName.getText().isEmpty()) {
                this.bUpdateProperties.setEnabled(true);
                return true;
            }
            if (!dp.getData().equals(this.tfData.getText()) && !this.tfData.getText().isEmpty()) {
                this.bUpdateProperties.setEnabled(true);
                return true;
            }
            if (dp.getMinSeverity() != severity && !this.tfSeverity.getText().isEmpty()) {
                this.bUpdateProperties.setEnabled(true);
                return true;
            }
            if (!dp.getType().equals(this.cbType.getSelectedItem())) {
                this.bUpdateProperties.setEnabled(true);
                return true;
            }
            if (dp.isActive() != this.cbActive.isSelected()) {
                this.bUpdateProperties.setEnabled(true);
                return true;
            }
            this.bUpdateProperties.setEnabled(false);
            return false;
        }
        return false;
    }

    public class Updater
    extends SwingWorker<List<Destination>, Void> {
        @Override
        protected List<Destination> doInBackground() throws Exception {
            try {
                return NotificationsTopComponent.this.apiService.getDestinations();
            }
            catch (ApiServiceException_Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return new ArrayList<Destination>();
            }
        }

        @Override
        protected void done() {
            try {
                NotificationsTopComponent.this.allDestinations = (List)this.get();
                if (NotificationsTopComponent.this.allDestinations != null) {
                    NotificationsTopComponent.this.destinationTableModel.setData(NotificationsTopComponent.this.allDestinations);
                    NotificationsTopComponent.this.deliveryPointTableModel.setData(null);
                    Destination dest = (Destination)NotificationsTopComponent.this.tDestinations.getValueAt(NotificationsTopComponent.this.prevRow, 0);
                    NotificationsTopComponent.this.prevRow = NotificationsTopComponent.this.destinationTableModel.getObjectRowPosition(dest);
                    if (NotificationsTopComponent.this.prevRow == -1) {
                        NotificationsTopComponent.this.prevRow = 0;
                    }
                    int tmp = NotificationsTopComponent.this.prevRow;
                    if (NotificationsTopComponent.this.tDestinations.getRowCount() > 0) {
                        NotificationsTopComponent.this.tDestinations.setRowSelectionInterval(tmp, tmp);
                        NotificationsTopComponent.this.tDestinations.changeSelection(tmp, 0, false, false);
                        NotificationsTopComponent.this.tDestinations.repaint();
                    }
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

