/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.securityevents.search;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import rs.co.ast.aspen.api.service.DateRange;
import rs.co.ast.aspen.api.service.IndexDateRange;

public class TaskMonitor {
    public static final String PROP_ALL_TASKS_FINISHED = "PROP_ALL_TASKS_FINISHED";
    public static final String PROP_ALL_FETCH_TASKS_FINISHED = "PROP_ALL_FETCH_TASKS_FINISHED";
    public static final String PROP_ALL_COUNT_TASKS_FINISHED = "PROP_ALL_COUNT_TASKS_FINISHED";
    public static final String PROP_ALL_SKIPPED_COUNT_TASKS_FINISHED = "PROP_ALL_SKIPPED_COUNT_TASKS_FINISHED";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Map<String, Boolean> countTasksMonitor = new ConcurrentHashMap<String, Boolean>();
    private Map<String, Boolean> fetchTasksMonitor = new ConcurrentHashMap<String, Boolean>();
    private Map<String, Boolean> skippedTasksMonitor = new ConcurrentHashMap<String, Boolean>();
    private boolean allTasksCompleted = false;
    private boolean allCountTasksCompleted = false;
    private boolean allFetchTasksCompleted = false;
    private boolean allSkippedTasksCompleted = false;

    public void fill(List<IndexDateRange> indexDateIntervals) {
        for (IndexDateRange idr : indexDateIntervals) {
            for (DateRange dr : idr.getDateRanges()) {
                this.countTasksMonitor.put(this.generateSkippedTaskName(BaseTaskName.COUNT.getBaseTaskName(), dr.getStartTimeStamp(), dr.getFinishTimeStamp()), false);
                this.fetchTasksMonitor.put(this.generateSkippedTaskName(BaseTaskName.FETCH.getBaseTaskName(), dr.getStartTimeStamp(), dr.getFinishTimeStamp()), false);
            }
        }
    }

    private void completeCountTask(String taskName) {
        this.countTasksMonitor.put(taskName, true);
        if (this.skippedTasksMonitor.containsKey(taskName)) {
            this.skippedTasksMonitor.put(taskName, true);
        }
        this.checkAllTaskCompleted();
    }

    private void completeFetchTask(String taskName) {
        this.fetchTasksMonitor.put(taskName, true);
        if (this.skippedTasksMonitor.containsKey(taskName)) {
            this.skippedTasksMonitor.put(taskName, true);
        }
        this.checkAllTaskCompleted();
    }

    private void checkAllTaskCompleted() {
        if (this.areAllCountTasksFinished()) {
            if (!this.allCountTasksCompleted) {
                this.pcs.firePropertyChange(PROP_ALL_COUNT_TASKS_FINISHED, this.allCountTasksCompleted, true);
            }
            if (this.areAllFetchTasksFinished()) {
                this.allFetchTasksCompleted = true;
                this.pcs.firePropertyChange(PROP_ALL_FETCH_TASKS_FINISHED, this.allFetchTasksCompleted, true);
            }
            this.allCountTasksCompleted = true;
            if (this.areAllSkippedCountTasksFinished()) {
                this.pcs.firePropertyChange(PROP_ALL_SKIPPED_COUNT_TASKS_FINISHED, this.allSkippedTasksCompleted, true);
                this.allSkippedTasksCompleted = true;
            }
        }
        if (this.allCountTasksCompleted && this.allSkippedTasksCompleted && this.allFetchTasksCompleted) {
            this.pcs.firePropertyChange(PROP_ALL_TASKS_FINISHED, this.allTasksCompleted, true);
            this.allTasksCompleted = true;
        }
    }

    public void completeTask(BaseTaskName baseTaskName, long start, long finish) {
        String taskName = this.generateSkippedTaskName(baseTaskName.getBaseTaskName(), start, finish);
        switch (baseTaskName.ordinal()) {
            case 0: {
                this.completeCountTask(taskName);
                break;
            }
            case 1: {
                this.completeFetchTask(taskName);
            }
        }
    }

    public void putIntoSkippedTasks(BaseTaskName baseTaskName, long start, long finish) {
        String taskName = this.generateSkippedTaskName(baseTaskName.getBaseTaskName(), start, finish);
        this.skippedTasksMonitor.put(taskName, false);
        this.countTasksMonitor.put(taskName, true);
    }

    private boolean areAllCountTasksFinished() {
        for (Boolean finished : this.countTasksMonitor.values()) {
            if (finished.booleanValue()) continue;
            return false;
        }
        return true;
    }

    private boolean areAllSkippedCountTasksFinished() {
        for (Boolean finished : this.skippedTasksMonitor.values()) {
            if (finished.booleanValue()) continue;
            return false;
        }
        return true;
    }

    private boolean areAllFetchTasksFinished() {
        for (Boolean finished : this.fetchTasksMonitor.values()) {
            if (finished.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean isAllCountTasksCompleted() {
        return this.allCountTasksCompleted;
    }

    public boolean isAllFetchTasksCompleted() {
        return this.allFetchTasksCompleted;
    }

    public boolean isAllTasksCompleted() {
        return this.allTasksCompleted;
    }

    public boolean isAllSkippedTasksCompleted() {
        return this.allSkippedTasksCompleted;
    }

    public String generateSkippedTaskName(String baseTaskName, long start, long finish) {
        return "Skipped" + baseTaskName + "Task_" + String.valueOf(start) + "-" + String.valueOf(finish) + "_";
    }

    public boolean areThereSkippedTasks() {
        return !this.skippedTasksMonitor.isEmpty();
    }

    public void fireAllTasksCompleted() {
        this.pcs.firePropertyChange(PROP_ALL_TASKS_FINISHED, false, true);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.pcs.removePropertyChangeListener(listener);
    }

    public static enum BaseTaskName {
        COUNT("Count"),
        FETCH("Fetch");

        private String baseTaskName;

        private BaseTaskName(String baseTaskName) {
            this.baseTaskName = baseTaskName;
        }

        public String getBaseTaskName() {
            return this.baseTaskName;
        }
    }
}

