/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.rawlogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import rs.co.ast.aspen.api.service.ParsingDebugInfoAssignment;
import rs.co.ast.aspen.gui.rawlogs.AssignmentWrapper;

public class AssignmentsManager {
    private Map<String, Map<String, String>> allAssignments = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> copyOfAssignments;

    public void addAssignments(List<ParsingDebugInfoAssignment> assignments) {
        Map<String, Map<String, String>> newAssignments = new HashMap<String, Map<String, String>>();
        for (ParsingDebugInfoAssignment pdia : assignments) {
            String category = pdia.getAssignment().getCategory();
            Map<String, String> smap = newAssignments.get(category);
            Map<String, String> copySmap = this.allAssignments.get(category);
            if (smap == null) {
                smap = new HashMap<String, String>();
            }
            if (copySmap == null) {
                copySmap = new HashMap<String, String>();
            }
            smap.put(pdia.getAssignment().getKey(), pdia.getValue());
            newAssignments.put(category, smap);
            copySmap.put(pdia.getAssignment().getKey(), pdia.getValue());
            this.allAssignments.put(category, copySmap);
        }
        newAssignments = this.sortMap(newAssignments);
        this.copyOfAssignments = this.sortMap(this.allAssignments);
        this.copyOfAssignments = this.check4Change(newAssignments, this.copyOfAssignments);
    }

    public Map<String, Map<String, String>> getAllAssignments() {
        return this.allAssignments;
    }

    public List<AssignmentWrapper> getAssignmentWrappers() {
        return this.convertMap2List(this.copyOfAssignments);
    }

    public void reset() {
        this.allAssignments = new HashMap<String, Map<String, String>>();
    }

    private Map<String, Map<String, String>> check4Change(Map<String, Map<String, String>> newMap, Map<String, Map<String, String>> allassignments) {
        HashMap<String, Map<String, String>> newMapCopy = new HashMap<String, Map<String, String>>(allassignments);
        for (Map.Entry<String, Map<String, String>> entry : newMap.entrySet()) {
            String key = entry.getKey();
            Map<String, String> value = entry.getValue();
            for (Map.Entry<String, String> entry2 : value.entrySet()) {
                String key2 = entry2.getKey();
                String value2 = entry2.getValue();
                Map get = (Map)newMapCopy.get(key);
                get.remove(key2);
                get.put(String.format("<html><strong><i>%s</i></strong></html>", key2), String.format("<html><strong><i>%s</i></strong></html>", value2));
            }
        }
        return allassignments;
    }

    private List<AssignmentWrapper> convertMap2List(Map<String, Map<String, String>> map) {
        ArrayList<AssignmentWrapper> list = new ArrayList<AssignmentWrapper>();
        for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
            String key = entry.getKey();
            Map<String, String> value = entry.getValue();
            AssignmentWrapper awTitle = new AssignmentWrapper();
            awTitle.setTitle(true);
            awTitle.setCategory(String.format("<html><strong>%s</strong></html>", key));
            awTitle.setValue("");
            list.add(awTitle);
            Map<String, String> subMap = value;
            if (subMap == null) continue;
            for (Map.Entry<String, String> entry2 : subMap.entrySet()) {
                String key2 = entry2.getKey();
                String value2 = entry2.getValue();
                AssignmentWrapper awValue = new AssignmentWrapper();
                awValue.setTitle(false);
                awValue.setCategory(key2);
                awValue.setValue(value2);
                list.add(awValue);
            }
        }
        return list;
    }

    private Map<String, Map<String, String>> sortMap(Map<String, Map<String, String>> map) {
        LinkedHashMap<String, Map<String, String>> sortedMap = new LinkedHashMap<String, Map<String, String>>();
        LinkedList<String> list = new LinkedList<String>();
        list.add("what");
        list.add("who");
        list.add("where");
        list.add("when");
        list.add("extra");
        list.add("meta");
        for (String s : list) {
            for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
                String key = entry.getKey();
                HashMap<String, String> value = new HashMap<String, String>(entry.getValue());
                if (!key.equals(s)) continue;
                sortedMap.put(key, value);
            }
        }
        return sortedMap;
    }
}

